/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api.research;

import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchPage;

public class ResearchItem {
    public final String key;
    public final String category;
    public final AspectList tags;
    public String[] parents = null;
    public String[] parentsHidden = null;
    public String[] siblings = null;
    public final int displayColumn;
    public final int displayRow;
    public final ItemStack[] icon_item;
    public final ResourceLocation[] icon_resource;
    private int complexity;
    private boolean isSpecial;
    private boolean isSecondary;
    private boolean isRound;
    private boolean isStub;
    private boolean isVirtual;
    private boolean isHidden;
    private boolean isAutoUnlock;
    private boolean isFlipped;
    private ResearchPage[] pages = null;

    public ResearchItem(String key, String category) {
        this.key = key;
        this.category = category;
        this.tags = new AspectList();
        this.icon_resource = null;
        this.icon_item = null;
        this.displayColumn = 0;
        this.displayRow = 0;
        this.isVirtual = true;
    }

    public ResearchItem(String key, String category, AspectList tags, int col, int row, int complex, Object ... icon) {
        ResourceLocation[] t;
        this.key = key;
        this.category = category;
        this.tags = tags;
        if (icon[0] instanceof ResourceLocation) {
            t = new ResourceLocation[icon.length];
            System.arraycopy(icon, 0, t, 0, icon.length);
            this.icon_resource = t;
        } else {
            this.icon_resource = null;
        }
        if (icon[0] instanceof ItemStack) {
            t = new ItemStack[icon.length];
            System.arraycopy(icon, 0, t, 0, icon.length);
            this.icon_item = t;
        } else {
            this.icon_item = null;
        }
        this.displayColumn = col;
        this.displayRow = row;
        this.complexity = complex;
        if (this.complexity < 1) {
            this.complexity = 1;
        }
        if (this.complexity > 3) {
            this.complexity = 3;
        }
    }

    public ResearchItem setSpecial() {
        this.isSpecial = true;
        return this;
    }

    public ResearchItem setStub() {
        this.isStub = true;
        return this;
    }

    public ResearchItem setHidden() {
        this.isHidden = true;
        return this;
    }

    public ResearchItem setParents(String ... par) {
        this.parents = par;
        return this;
    }

    public ResearchItem setParentsHidden(String ... par) {
        this.parentsHidden = par;
        return this;
    }

    public ResearchItem setSiblings(String ... sib) {
        this.siblings = sib;
        return this;
    }

    public ResearchItem setPages(ResearchPage ... par) {
        this.pages = par;
        return this;
    }

    public ResearchPage[] getPages() {
        return this.pages;
    }

    public ResearchItem registerResearchItem() {
        ResearchCategories.addResearch(this);
        return this;
    }

    public String getName() {
        return StatCollector.func_74838_a((String)("tc.research_name." + this.key));
    }

    public String getText() {
        return StatCollector.func_74838_a((String)("tc.research_text." + this.key));
    }

    public boolean isSpecial() {
        return this.isSpecial;
    }

    public boolean isStub() {
        return this.isStub;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    public boolean isAutoUnlock() {
        return this.isAutoUnlock;
    }

    public ResearchItem setAutoUnlock() {
        this.isAutoUnlock = true;
        return this;
    }

    public boolean isRound() {
        return this.isRound;
    }

    public ResearchItem setRound() {
        this.isRound = true;
        return this;
    }

    public ResearchItem setSecondary() {
        this.isSecondary = true;
        return this;
    }

    public boolean isSecondary() {
        return this.isSecondary;
    }

    public int getComplexity() {
        return this.complexity;
    }

    public ResearchItem setFlipped() {
        this.isFlipped = true;
        return this;
    }

    public boolean isFlipped() {
        return this.isFlipped;
    }

    public ResearchItem setComplexity(int complexity) {
        this.complexity = complexity;
        return this;
    }

    public int getExperience() {
        if (this.tags != null && this.tags.visSize() > 0) {
            return Math.max(1, (int)Math.sqrt(this.tags.visSize()));
        }
        return 0;
    }

    public Aspect getResearchPrimaryTag() {
        Aspect aspect = null;
        int highest = 0;
        if (this.tags != null) {
            for (Aspect tag : this.tags.getAspects()) {
                if (this.tags.getAmount(tag) <= highest) continue;
                aspect = tag;
                highest = this.tags.getAmount(tag);
            }
        }
        return aspect;
    }
}

