/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.lib.models;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.vecmath.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import thaumcraft.client.lib.models.Material;
import thaumcraft.common.Thaumcraft;

class MaterialLibrary
extends Dictionary<String, Material> {
    static final Set<String> unknownCommands = new HashSet<String>();
    private final Dictionary<String, Material> materialLibrary = new Hashtable<String, Material>();
    private Material currentMaterial;

    @Override
    public int size() {
        return this.materialLibrary.size();
    }

    @Override
    public boolean isEmpty() {
        return this.materialLibrary.isEmpty();
    }

    @Override
    public Enumeration<String> keys() {
        return this.materialLibrary.keys();
    }

    @Override
    public Enumeration<Material> elements() {
        return this.materialLibrary.elements();
    }

    @Override
    public Material get(Object key) {
        return this.materialLibrary.get(key);
    }

    @Override
    public Material put(String key, Material value) {
        return this.materialLibrary.put(key, value);
    }

    @Override
    public Material remove(Object key) {
        return this.materialLibrary.remove(key);
    }

    public void loadFromStream(ResourceLocation loc) throws IOException {
        String currentLine;
        IResource res = Minecraft.func_71410_x().func_110442_L().func_110536_a(loc);
        InputStreamReader lineStream = new InputStreamReader(res.func_110527_b(), Charsets.UTF_8);
        BufferedReader lineReader = new BufferedReader(lineStream);
        while ((currentLine = lineReader.readLine()) != null) {
            ResourceLocation texture;
            if (currentLine.length() == 0 || currentLine.startsWith("#")) continue;
            String[] fields = currentLine.split(" ", 2);
            String keyword = fields[0];
            String data = fields[1];
            if (keyword.equalsIgnoreCase("newmtl")) {
                this.pushMaterial(data);
                continue;
            }
            if (keyword.equalsIgnoreCase("Ka")) {
                this.currentMaterial.AmbientColor = this.parseVector3f(data);
                continue;
            }
            if (keyword.equalsIgnoreCase("Kd")) {
                this.currentMaterial.DiffuseColor = this.parseVector3f(data);
                continue;
            }
            if (keyword.equalsIgnoreCase("Ks")) {
                this.currentMaterial.SpecularColor = this.parseVector3f(data);
                continue;
            }
            if (keyword.equalsIgnoreCase("Ns")) {
                this.currentMaterial.SpecularCoefficient = this.parseFloat(data);
                continue;
            }
            if (keyword.equalsIgnoreCase("Tr")) {
                this.currentMaterial.Transparency = this.parseFloat(data);
                continue;
            }
            if (keyword.equalsIgnoreCase("illum")) {
                this.currentMaterial.IlluminationModel = this.parseInt(data);
                continue;
            }
            if (keyword.equalsIgnoreCase("map_Ka")) {
                this.currentMaterial.AmbientTextureMap = data;
                texture = new ResourceLocation(data);
                if (!texture.func_110623_a().contains("item")) {
                    Thaumcraft.modelRegistrationHelper.registerItemSprite(texture);
                    continue;
                }
                Thaumcraft.modelRegistrationHelper.registerBlockSprite(texture);
                continue;
            }
            if (keyword.equalsIgnoreCase("map_Kd")) {
                this.currentMaterial.DiffuseTextureMap = data;
                texture = new ResourceLocation(data);
                if (!texture.func_110623_a().contains("item")) {
                    Thaumcraft.modelRegistrationHelper.registerItemSprite(texture);
                    continue;
                }
                Thaumcraft.modelRegistrationHelper.registerBlockSprite(texture);
                continue;
            }
            if (keyword.equalsIgnoreCase("map_Ks")) {
                this.currentMaterial.SpecularTextureMap = data;
                continue;
            }
            if (keyword.equalsIgnoreCase("map_Ns")) {
                this.currentMaterial.SpecularHighlightTextureMap = data;
                continue;
            }
            if (keyword.equalsIgnoreCase("map_d")) {
                this.currentMaterial.AlphaTextureMap = data;
                continue;
            }
            if (keyword.equalsIgnoreCase("map_bump")) {
                this.currentMaterial.BumpMap = data;
                continue;
            }
            if (keyword.equalsIgnoreCase("bump")) {
                this.currentMaterial.BumpMap = data;
                continue;
            }
            if (keyword.equalsIgnoreCase("disp")) {
                this.currentMaterial.DisplacementMap = data;
                continue;
            }
            if (keyword.equalsIgnoreCase("decal")) {
                this.currentMaterial.StencilDecalMap = data;
                continue;
            }
            if (unknownCommands.contains(keyword)) continue;
            unknownCommands.add(keyword);
        }
    }

    private float parseFloat(String data) {
        return Float.parseFloat(data);
    }

    private int parseInt(String data) {
        return Integer.parseInt(data);
    }

    private Vector3f parseVector3f(String data) {
        String[] parts = data.split(" ");
        return new Vector3f(Float.parseFloat(parts[0]), Float.parseFloat(parts[1]), Float.parseFloat(parts[2]));
    }

    private void pushMaterial(String materialName) {
        this.currentMaterial = new Material(materialName);
        this.materialLibrary.put(this.currentMaterial.Name, this.currentMaterial);
    }
}

