/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.lib.models.block;

import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.client.renderers.models.block.CustomCrystalModel;
import thaumcraft.client.renderers.models.block.CustomPillarModel;
import thaumcraft.client.renderers.models.block.CustomTaintFibreModel;
import thaumcraft.client.renderers.models.block.CustomTubeModel;

@SideOnly(value=Side.CLIENT)
public class BlockModelLoader
implements ICustomModelLoader {
    private IResourceManager resourceManager;

    public void func_110549_a(IResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public boolean accepts(ResourceLocation l) {
        return l.func_110624_b().equalsIgnoreCase("Thaumcraft") && l.func_110623_a().startsWith("models/block/builtin/");
    }

    public IModel loadModel(ResourceLocation l) {
        String r = l.func_110623_a().substring("models/block/builtin/".length());
        if (r.equals("tube")) {
            return new CustomTubeModel(this.resourceManager);
        }
        if (r.equals("pillar_normal")) {
            return new CustomPillarModel(this.resourceManager, CustomPillarModel.T_NORMAL);
        }
        if (r.equals("pillar_ancient")) {
            return new CustomPillarModel(this.resourceManager, CustomPillarModel.T_ANCIENT);
        }
        if (r.equals("pillar_eldritch")) {
            return new CustomPillarModel(this.resourceManager, CustomPillarModel.T_ELDRITCH);
        }
        if (r.startsWith("crystal")) {
            return new CustomCrystalModel(this.resourceManager);
        }
        if (r.equals("taint_fibre")) {
            return new CustomTaintFibreModel(this.resourceManager);
        }
        throw new RuntimeException("A builtin model '" + r + "' is not defined.");
    }
}

