/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.renderers.models.block;

import com.google.common.base.Function;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.common.property.IExtendedBlockState;
import thaumcraft.client.lib.models.MeshLoader;
import thaumcraft.client.lib.models.MeshModel;
import thaumcraft.client.lib.models.MeshPart;
import thaumcraft.client.lib.models.block.SmartBlockModel;
import thaumcraft.codechicken.lib.vec.Vector3;
import thaumcraft.common.blocks.world.ore.BlockCrystal;

public class CustomCrystalModel
implements IModel {
    public static final ResourceLocation TEXTURE = new ResourceLocation("Thaumcraft:blocks/crystal");
    ResourceLocation model = new ResourceLocation("Thaumcraft", "models/obj/crystal.obj");
    MeshModel sourceMesh;
    ResourceLocation tex = TEXTURE;

    public CustomCrystalModel(IResourceManager resourceManager) {
        try {
            this.sourceMesh = new MeshLoader().loadFromResource(this.model);
            for (MeshPart mp : this.sourceMesh.parts) {
                mp.tintIndex = 0;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }

    public Collection<ResourceLocation> getTextures() {
        return Arrays.asList(this.tex);
    }

    public IFlexibleBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        return new BakedModel(format, bakedTextureGetter);
    }

    public IModelState getDefaultState() {
        return null;
    }

    public class BakedModel
    extends SmartBlockModel {
        public BakedModel(VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            super(false, false, (TextureAtlasSprite)bakedTextureGetter.apply((Object)CustomCrystalModel.this.tex), format, bakedTextureGetter);
        }

        public IBakedModel handleBlockState(IBlockState state) {
            if (state instanceof IExtendedBlockState) {
                IExtendedBlockState es = (IExtendedBlockState)state;
                MeshModel mm = CustomCrystalModel.this.sourceMesh.clone();
                int m = state.func_177230_c().func_176201_c(state) + 1;
                SimpleBakedModel.Builder b = new SimpleBakedModel.Builder((IBakedModel)this, null);
                b.func_177646_a(this.func_177554_e());
                if (!(((Boolean)es.getValue(BlockCrystal.UP)).booleanValue() && ((Boolean)es.getValue(BlockCrystal.DOWN)).booleanValue() && ((Boolean)es.getValue(BlockCrystal.EAST)).booleanValue() && ((Boolean)es.getValue(BlockCrystal.WEST)).booleanValue() && ((Boolean)es.getValue(BlockCrystal.NORTH)).booleanValue() && ((Boolean)es.getValue(BlockCrystal.SOUTH)).booleanValue())) {
                    MeshModel mod;
                    List<Integer> c;
                    if (((Boolean)es.getValue(BlockCrystal.UP)).booleanValue()) {
                        c = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7);
                        Collections.shuffle(c, new Random(1 + (Integer)es.getValue(BlockCrystal.SEED) * 1000));
                        mm.parts.clear();
                        for (int a = 0; a < m; ++a) {
                            mm.parts.add(CustomCrystalModel.this.sourceMesh.parts.get(c.get(a)));
                        }
                        mod = mm.clone();
                        mod.rotate(Math.toRadians(180.0), new Vector3(1.0, 0.0, 0.0), new Vector3(0.0, 1.0, 1.0));
                        for (BakedQuad quad : mod.bakeModel(this.func_177554_e())) {
                            b.func_177648_a(quad);
                        }
                    }
                    if (((Boolean)es.getValue(BlockCrystal.DOWN)).booleanValue()) {
                        c = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7);
                        Collections.shuffle(c, new Random(2 + (Integer)es.getValue(BlockCrystal.SEED) * 2000));
                        mm.parts.clear();
                        for (int a = 0; a < m; ++a) {
                            mm.parts.add(CustomCrystalModel.this.sourceMesh.parts.get(c.get(a)));
                        }
                        for (BakedQuad quad : mm.bakeModel(this.func_177554_e())) {
                            b.func_177648_a(quad);
                        }
                    }
                    if (((Boolean)es.getValue(BlockCrystal.EAST)).booleanValue()) {
                        c = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7);
                        Collections.shuffle(c, new Random(3 + (Integer)es.getValue(BlockCrystal.SEED) * 3000));
                        mm.parts.clear();
                        for (int a = 0; a < m; ++a) {
                            mm.parts.add(CustomCrystalModel.this.sourceMesh.parts.get(c.get(a)));
                        }
                        mod = mm.clone();
                        mod.rotate(Math.toRadians(90.0), new Vector3(1.0, 0.0, 0.0), new Vector3(0.0, 0.0, 0.0));
                        mod.rotate(Math.toRadians(270.0), new Vector3(0.0, 1.0, 0.0), new Vector3(1.0, 1.0, 0.0));
                        for (BakedQuad quad : mod.bakeModel(this.func_177554_e())) {
                            b.func_177648_a(quad);
                        }
                    }
                    if (((Boolean)es.getValue(BlockCrystal.WEST)).booleanValue()) {
                        c = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7);
                        Collections.shuffle(c, new Random(4 + (Integer)es.getValue(BlockCrystal.SEED) * 4000));
                        mm.parts.clear();
                        for (int a = 0; a < m; ++a) {
                            mm.parts.add(CustomCrystalModel.this.sourceMesh.parts.get(c.get(a)));
                        }
                        mod = mm.clone();
                        mod.rotate(Math.toRadians(90.0), new Vector3(1.0, 0.0, 0.0), new Vector3(0.0, 0.0, 0.0));
                        mod.rotate(Math.toRadians(90.0), new Vector3(0.0, 1.0, 0.0), new Vector3(0.0, 1.0, 1.0));
                        for (BakedQuad quad : mod.bakeModel(this.func_177554_e())) {
                            b.func_177648_a(quad);
                        }
                    }
                    if (((Boolean)es.getValue(BlockCrystal.NORTH)).booleanValue()) {
                        c = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7);
                        Collections.shuffle(c, new Random(5 + (Integer)es.getValue(BlockCrystal.SEED) * 5000));
                        mm.parts.clear();
                        for (int a = 0; a < m; ++a) {
                            mm.parts.add(CustomCrystalModel.this.sourceMesh.parts.get(c.get(a)));
                        }
                        mod = mm.clone();
                        mod.rotate(Math.toRadians(90.0), new Vector3(1.0, 0.0, 0.0), new Vector3(0.0, 1.0, 0.0));
                        for (BakedQuad quad : mod.bakeModel(this.func_177554_e())) {
                            b.func_177648_a(quad);
                        }
                    }
                    if (((Boolean)es.getValue(BlockCrystal.SOUTH)).booleanValue()) {
                        c = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7);
                        Collections.shuffle(c, new Random(6 + (Integer)es.getValue(BlockCrystal.SEED) * 6000));
                        mm.parts.clear();
                        for (int a = 0; a < m; ++a) {
                            mm.parts.add(CustomCrystalModel.this.sourceMesh.parts.get(c.get(a)));
                        }
                        MeshModel mod2 = mm.clone();
                        mod2.rotate(Math.toRadians(90.0), new Vector3(1.0, 0.0, 0.0), new Vector3(0.0, 0.0, 0.0));
                        mod2.rotate(Math.toRadians(180.0), new Vector3(0.0, 1.0, 0.0), new Vector3(1.0, 1.0, 1.0));
                        for (BakedQuad quad : mod2.bakeModel(this.func_177554_e())) {
                            b.func_177648_a(quad);
                        }
                    }
                }
                return b.func_177645_b();
            }
            return this;
        }

        public IBakedModel handleItemState(ItemStack stack) {
            return this;
        }
    }
}

