/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.renderers.models.block;

import com.google.common.base.Function;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.vecmath.Vector2f;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.client.lib.models.MeshLoader;
import thaumcraft.client.lib.models.MeshModel;
import thaumcraft.client.lib.models.block.SmartBlockModel;
import thaumcraft.common.blocks.devices.BlockTube;

@SideOnly(value=Side.CLIENT)
public class CustomTubeModel
implements IModel {
    public static final ResourceLocation TA = new ResourceLocation("Thaumcraft:blocks/tube");
    ResourceLocation model = new ResourceLocation("Thaumcraft", "models/obj/tube.obj");
    MeshModel sourceMesh;

    public CustomTubeModel(IResourceManager resourceManager) {
        try {
            this.sourceMesh = new MeshLoader().loadFromResource(this.model);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }

    public Collection<ResourceLocation> getTextures() {
        return Arrays.asList(TA);
    }

    public IFlexibleBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        return new BakedModel(format, bakedTextureGetter);
    }

    public IModelState getDefaultState() {
        return null;
    }

    public class BakedModel
    extends SmartBlockModel {
        public BakedModel(VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            super(false, false, (TextureAtlasSprite)bakedTextureGetter.apply((Object)TA), format, bakedTextureGetter);
        }

        public IBakedModel handleBlockState(IBlockState state) {
            SimpleBakedModel.Builder b = new SimpleBakedModel.Builder((IBakedModel)this, null);
            Boolean[] cons = new Boolean[]{false, false, false, false, false, false};
            if (state instanceof IExtendedBlockState) {
                cons = (Boolean[])((IExtendedBlockState)state).getValue(BlockTube.CONNECTIONS);
            }
            MeshModel mesh = new MeshModel();
            mesh.positions = CustomTubeModel.this.sourceMesh.positions;
            mesh.normals = CustomTubeModel.this.sourceMesh.normals;
            int i = 0;
            for (Vector2f v : CustomTubeModel.this.sourceMesh.texCoords) {
                float n = 0.0f;
                float m = 0.0f;
                if (i >= 4 && i < 28) {
                    if (state.func_177229_b((IProperty)BlockTube.TYPE) == BlockTube.TubeType.RESTRICT) {
                        m = 0.125f;
                    }
                    if (state.func_177229_b((IProperty)BlockTube.TYPE) == BlockTube.TubeType.BUFFER) {
                        m = 0.25f;
                    }
                    if (state.func_177229_b((IProperty)BlockTube.TYPE) == BlockTube.TubeType.FILTER) {
                        m = 0.375f;
                    }
                }
                if (i < 4 && state.func_177229_b((IProperty)BlockTube.TYPE) == BlockTube.TubeType.FILTER) {
                    n = 0.1875f;
                }
                mesh.addTexCoords(v.x + n, v.y + m);
                ++i;
            }
            if (state.func_177229_b((IProperty)BlockTube.TYPE) != BlockTube.TubeType.BUFFER) {
                if (state.func_177229_b((IProperty)BlockTube.TYPE) == BlockTube.TubeType.FILTER) {
                    mesh.addPart(CustomTubeModel.this.sourceMesh.parts.get(0), 1);
                } else {
                    mesh.addPart(CustomTubeModel.this.sourceMesh.parts.get(0));
                }
            } else {
                mesh.addPart(CustomTubeModel.this.sourceMesh.parts.get(7));
            }
            int c = 1;
            for (Boolean bb : cons) {
                if (bb.booleanValue()) {
                    mesh.addPart(CustomTubeModel.this.sourceMesh.parts.get(c));
                }
                ++c;
            }
            b.func_177646_a(this.func_177554_e());
            for (BakedQuad quad : mesh.bakeModel(this.func_177554_e())) {
                b.func_177648_a(quad);
            }
            return b.func_177645_b();
        }

        public IBakedModel handleItemState(ItemStack stack) {
            return this;
        }
    }
}

