/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.blocks;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.blocks.BlockTC;
import thaumcraft.common.blocks.IBlockEnabled;
import thaumcraft.common.blocks.IBlockFacing;
import thaumcraft.common.blocks.IBlockFacingHorizontal;
import thaumcraft.common.lib.utils.BlockStateUtils;
import thaumcraft.common.lib.utils.InventoryUtils;

public class BlockTCDevice
extends BlockTC
implements ITileEntityProvider {
    protected final Class tileClass;
    protected static boolean keepInventory = false;
    protected static boolean spillEssentia = true;

    public BlockTCDevice(Material mat, Class tc) {
        super(mat);
        this.func_149711_c(2.0f);
        this.func_149752_b(20.0f);
        this.tileClass = tc;
        this.field_149758_A = true;
        IBlockState bs = this.field_176227_L.func_177621_b();
        if (this instanceof IBlockFacingHorizontal) {
            bs.func_177226_a((IProperty)IBlockFacingHorizontal.FACING, (Comparable)EnumFacing.NORTH);
        } else if (this instanceof IBlockFacing) {
            bs.func_177226_a((IProperty)IBlockFacing.FACING, (Comparable)EnumFacing.UP);
        }
        if (this instanceof IBlockEnabled) {
            bs.func_177226_a((IProperty)IBlockEnabled.ENABLED, (Comparable)Boolean.valueOf(true));
        }
        this.func_180632_j(bs);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        try {
            return (TileEntity)this.tileClass.newInstance();
        }
        catch (InstantiationException e) {
            Thaumcraft.log.catching((Throwable)e);
        }
        catch (IllegalAccessException e) {
            Thaumcraft.log.catching((Throwable)e);
        }
        return null;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.updateState(worldIn, pos, state);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        int ess;
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity != null && tileentity instanceof IInventory && !keepInventory) {
            InventoryUtils.dropItems(worldIn, pos);
        }
        if (tileentity != null && tileentity instanceof IEssentiaTransport && spillEssentia && !worldIn.field_72995_K && (ess = ((IEssentiaTransport)tileentity).getEssentiaAmount(EnumFacing.UP)) > 0) {
            AuraHelper.pollute(worldIn, pos, ess, true);
        }
        super.func_180663_b(worldIn, pos, state);
        worldIn.func_175713_t(pos);
    }

    public void func_176204_a(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        this.updateState(worldIn, pos, state);
    }

    public boolean func_180648_a(World worldIn, BlockPos pos, IBlockState state, int eventID, int eventParam) {
        super.func_180648_a(worldIn, pos, state, eventID, eventParam);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(eventID, eventParam);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState bs = this.func_176223_P();
        if (this instanceof IBlockFacingHorizontal) {
            bs = bs.func_177226_a((IProperty)IBlockFacingHorizontal.FACING, (Comparable)(placer.func_70093_af() ? placer.func_174811_aO() : placer.func_174811_aO().func_176734_d()));
        }
        if (this instanceof IBlockFacing) {
            bs = bs.func_177226_a((IProperty)IBlockFacing.FACING, (Comparable)(placer.func_70093_af() ? BlockPistonBase.func_180695_a((World)worldIn, (BlockPos)pos, (EntityLivingBase)placer).func_176734_d() : BlockPistonBase.func_180695_a((World)worldIn, (BlockPos)pos, (EntityLivingBase)placer)));
        }
        if (this instanceof IBlockEnabled) {
            bs = bs.func_177226_a((IProperty)IBlockEnabled.ENABLED, (Comparable)Boolean.valueOf(true));
        }
        return bs;
    }

    protected void updateState(World worldIn, BlockPos pos, IBlockState state) {
        if (this instanceof IBlockEnabled) {
            boolean flag;
            boolean bl = flag = !worldIn.func_175640_z(pos);
            if (flag != (Boolean)state.func_177229_b((IProperty)IBlockEnabled.ENABLED)) {
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)IBlockEnabled.ENABLED, (Comparable)Boolean.valueOf(flag)), 3);
            }
        }
    }

    public void updateFacing(World world, BlockPos pos, EnumFacing face) {
        if (this instanceof IBlockFacing || this instanceof IBlockFacingHorizontal) {
            if (face == BlockStateUtils.getFacing(world.func_180495_p(pos))) {
                return;
            }
            if (this instanceof IBlockFacingHorizontal && face.func_176736_b() >= 0) {
                world.func_180501_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)IBlockFacingHorizontal.FACING, (Comparable)face), 3);
            }
            if (this instanceof IBlockFacing) {
                world.func_180501_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)IBlockFacing.FACING, (Comparable)face), 3);
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState bs = this.func_176223_P();
        try {
            if (this instanceof IBlockFacingHorizontal) {
                bs = bs.func_177226_a((IProperty)IBlockFacingHorizontal.FACING, (Comparable)BlockStateUtils.getFacing(meta));
            }
            if (this instanceof IBlockFacing) {
                bs = bs.func_177226_a((IProperty)IBlockFacing.FACING, (Comparable)BlockStateUtils.getFacing(meta));
            }
            if (this instanceof IBlockEnabled) {
                bs = bs.func_177226_a((IProperty)IBlockEnabled.ENABLED, (Comparable)Boolean.valueOf(BlockStateUtils.isEnabled(meta)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bs;
    }

    public int func_176201_c(IBlockState state) {
        int i;
        int b0 = 0;
        int n = this instanceof IBlockFacingHorizontal ? b0 | ((EnumFacing)state.func_177229_b((IProperty)IBlockFacingHorizontal.FACING)).func_176745_a() : (i = this instanceof IBlockFacing ? b0 | ((EnumFacing)state.func_177229_b((IProperty)IBlockFacing.FACING)).func_176745_a() : b0);
        if (this instanceof IBlockEnabled && !((Boolean)state.func_177229_b((IProperty)IBlockEnabled.ENABLED)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    protected BlockState func_180661_e() {
        ArrayList<Object> ip = new ArrayList<Object>();
        if (this instanceof IBlockFacingHorizontal) {
            ip.add(IBlockFacingHorizontal.FACING);
        }
        if (this instanceof IBlockFacing) {
            ip.add(IBlockFacing.FACING);
        }
        if (this instanceof IBlockEnabled) {
            ip.add(IBlockEnabled.ENABLED);
        }
        return ip.size() == 0 ? super.func_180661_e() : new BlockState((Block)this, ip.toArray(new IProperty[ip.size()]));
    }
}

