/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.blocks.devices;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.blocks.ILabelable;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.blocks.BlockTCDevice;
import thaumcraft.common.blocks.devices.BlockJarItem;
import thaumcraft.common.lib.CustomSoundType;
import thaumcraft.common.tiles.devices.TileJarBrain;
import thaumcraft.common.tiles.essentia.TileJarFillable;
import thaumcraft.common.tiles.essentia.TileJarFillableVoid;

public class BlockJar
extends BlockTCDevice
implements ILabelable {
    public static final PropertyEnum TYPE = PropertyEnum.func_177709_a((String)"type", JarType.class);

    public BlockJar() {
        super(Material.field_151592_s, null);
        this.func_149711_c(0.3f);
        this.func_149672_a(new CustomSoundType("jar", 1.0f, 1.0f));
        this.func_149647_a(Thaumcraft.tabTC);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)TYPE, (Comparable)((Object)JarType.NORMAL)));
    }

    @Override
    public boolean defineVariantsForItemBlock() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.TRANSLUCENT;
    }

    @Override
    public TileEntity func_149915_a(World world, int metadata) {
        if (metadata == 0) {
            return new TileJarFillable();
        }
        if (metadata == 1) {
            return new TileJarFillableVoid();
        }
        if (metadata == 2) {
            return new TileJarBrain();
        }
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(meta);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)JarType.values()[meta]));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((JarType)((Object)state.func_177229_b((IProperty)TYPE))).ordinal();
    }

    @Override
    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{TYPE});
    }

    @Override
    public String getStateName(IBlockState state, boolean fullName) {
        JarType type = (JarType)((Object)state.func_177229_b((IProperty)TYPE));
        return "jar_" + type.func_176610_l();
    }

    @Override
    public IProperty[] getProperties() {
        return new IProperty[]{TYPE};
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te;
        if (!worldIn.field_72995_K && (te = worldIn.func_175625_s(pos)) != null && te instanceof TileJarBrain) {
            int var2;
            for (int xp = ((TileJarBrain)te).xp; xp > 0; xp -= var2) {
                var2 = EntityXPOrb.func_70527_a((int)xp);
                worldIn.func_72838_d((Entity)new EntityXPOrb(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, var2));
            }
        }
        spillEssentia = false;
        super.func_180663_b(worldIn, pos, state);
        spillEssentia = true;
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileJarFillable) {
            this.spawnFilledJar(worldIn, pos, state, (TileJarFillable)te);
        } else {
            super.func_180653_a(worldIn, pos, state, chance, fortune);
        }
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te) {
        if (te instanceof TileJarFillable) {
            this.spawnFilledJar(worldIn, pos, state, (TileJarFillable)te);
        } else {
            super.func_180657_a(worldIn, player, pos, state, (TileEntity)null);
        }
    }

    private void spawnFilledJar(World world, BlockPos pos, IBlockState state, TileJarFillable te) {
        ItemStack drop = new ItemStack(BlocksTC.jar, 1, this.func_176201_c(state));
        if (te.amount > 0) {
            ((BlockJarItem)drop.func_77973_b()).setAspects(drop, new AspectList().add(te.aspect, te.amount));
        }
        if (te.aspectFilter != null) {
            if (!drop.func_77942_o()) {
                drop.func_77982_d(new NBTTagCompound());
            }
            drop.func_77978_p().func_74778_a("AspectFilter", te.aspectFilter.getTag());
        }
        BlockJar.func_180635_a((World)world, (BlockPos)pos, (ItemStack)drop);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase ent, ItemStack stack) {
        int l = MathHelper.func_76128_c((double)((double)(ent.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileJarFillable) {
            if (l == 0) {
                ((TileJarFillable)tile).facing = 2;
            }
            if (l == 1) {
                ((TileJarFillable)tile).facing = 5;
            }
            if (l == 2) {
                ((TileJarFillable)tile).facing = 3;
            }
            if (l == 3) {
                ((TileJarFillable)tile).facing = 4;
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float fx, float fy, float fz) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileJarBrain) {
            ((TileJarBrain)te).eatDelay = 40;
            if (!world.field_72995_K) {
                int var6 = world.field_73012_v.nextInt(Math.min(((TileJarBrain)te).xp + 1, 64));
                if (var6 > 0) {
                    int var2;
                    ((TileJarBrain)te).xp -= var6;
                    for (int xp = var6; xp > 0; xp -= var2) {
                        var2 = EntityXPOrb.func_70527_a((int)xp);
                        world.func_72838_d((Entity)new EntityXPOrb(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, var2));
                    }
                    world.func_175689_h(pos);
                    te.func_70296_d();
                }
            } else {
                world.func_72980_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, "thaumcraft:jar", 0.2f, 1.0f, false);
            }
        }
        if (te != null && te instanceof TileJarFillable && player.func_70093_af() && ((TileJarFillable)te).aspectFilter != null && side.ordinal() == ((TileJarFillable)te).facing) {
            ((TileJarFillable)te).aspectFilter = null;
            if (world.field_72995_K) {
                world.func_72980_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, "thaumcraft:page", 1.0f, 1.0f, false);
            } else {
                world.func_72838_d((Entity)new EntityItem(world, (double)((float)pos.func_177958_n() + 0.5f + (float)side.func_82601_c() / 3.0f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f + (float)side.func_82599_e() / 3.0f), new ItemStack(ItemsTC.label)));
            }
        } else if (te != null && te instanceof TileJarFillable && player.func_70093_af() && player.func_70694_bm() == null) {
            if (((TileJarFillable)te).aspectFilter == null) {
                ((TileJarFillable)te).aspect = null;
            }
            if (world.field_72995_K) {
                world.func_72980_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, "thaumcraft:jar", 0.4f, 1.0f, false);
                world.func_72980_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, "game.neutral.swim", 0.5f, 1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.3f, false);
            } else {
                AuraHelper.pollute(world, pos, ((TileJarFillable)te).amount, true);
            }
            ((TileJarFillable)te).amount = 0;
            te.func_70296_d();
        }
        return true;
    }

    @Override
    public boolean applyLabel(EntityPlayer player, BlockPos pos, EnumFacing side, ItemStack labelstack) {
        TileEntity te = player.field_70170_p.func_175625_s(pos);
        if (te != null && te instanceof TileJarFillable && ((TileJarFillable)te).aspectFilter == null) {
            if (((TileJarFillable)te).amount == 0 && ((IEssentiaContainerItem)player.func_70694_bm().func_77973_b()).getAspects(player.func_70694_bm()) == null) {
                return false;
            }
            if (((TileJarFillable)te).amount == 0 && ((IEssentiaContainerItem)player.func_70694_bm().func_77973_b()).getAspects(player.func_70694_bm()) != null) {
                ((TileJarFillable)te).aspect = ((IEssentiaContainerItem)player.func_70694_bm().func_77973_b()).getAspects(player.func_70694_bm()).getAspects()[0];
            }
            this.func_180633_a(player.field_70170_p, pos, player.field_70170_p.func_180495_p(pos), (EntityLivingBase)player, null);
            ((TileJarFillable)te).aspectFilter = ((TileJarFillable)te).aspect;
            player.field_70170_p.func_175689_h(pos);
            te.func_70296_d();
            player.field_70170_p.func_72908_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, "thaumcraft:jar", 0.4f, 1.0f);
            return true;
        }
        return false;
    }

    public void func_180654_a(IBlockAccess world, BlockPos pos) {
        this.func_149676_a(0.1875f, 0.0f, 0.1875f, 0.8125f, 0.75f, 0.8125f);
        super.func_180654_a(world, pos);
    }

    public float getEnchantPowerBonus(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileJarBrain) {
            return 2.0f;
        }
        return super.getEnchantPowerBonus(world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(World world, BlockPos pos, IBlockState state, Random rand) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileJarBrain && ((TileJarBrain)tile).xp >= ((TileJarBrain)tile).xpMax) {
            Thaumcraft.proxy.getFX().wispFX5((float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.8f, (float)pos.func_177952_p() + 0.5f, (float)pos.func_177958_n() + 0.3f + world.field_73012_v.nextFloat() * 0.4f, (float)pos.func_177956_o() + 0.8f, (float)pos.func_177952_p() + 0.3f + world.field_73012_v.nextFloat() * 0.4f, 0.5f, true, -0.025f, Aspect.DEATH.getColor());
        }
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_180641_l(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileJarBrain) {
            float r = (float)((TileJarBrain)tile).xp / (float)((TileJarBrain)tile).xpMax;
            return MathHelper.func_76141_d((float)(r * 14.0f)) + (((TileJarBrain)tile).xp > 0 ? 1 : 0);
        }
        if (tile != null && tile instanceof TileJarFillable) {
            float r = (float)((TileJarFillable)tile).amount / (float)((TileJarFillable)tile).maxAmount;
            return MathHelper.func_76141_d((float)(r * 14.0f)) + (((TileJarFillable)tile).amount > 0 ? 1 : 0);
        }
        return super.func_180641_l(world, pos);
    }

    public static enum JarType implements IStringSerializable
    {
        NORMAL,
        VOID,
        BRAIN;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

