/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.blocks.devices;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.api.wands.IWand;
import thaumcraft.codechicken.lib.raytracer.ExtendedMOP;
import thaumcraft.codechicken.lib.raytracer.IndexedCuboid6;
import thaumcraft.codechicken.lib.raytracer.RayTracer;
import thaumcraft.codechicken.lib.vec.BlockCoord;
import thaumcraft.codechicken.lib.vec.Cuboid6;
import thaumcraft.codechicken.lib.vec.Vector3;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.blocks.BlockTCDevice;
import thaumcraft.common.items.tools.ItemResonator;
import thaumcraft.common.tiles.essentia.TileTube;
import thaumcraft.common.tiles.essentia.TileTubeBuffer;
import thaumcraft.common.tiles.essentia.TileTubeFilter;
import thaumcraft.common.tiles.essentia.TileTubeOneway;
import thaumcraft.common.tiles.essentia.TileTubeRestrict;
import thaumcraft.common.tiles.essentia.TileTubeValve;

public class BlockTube
extends BlockTCDevice {
    public static final PropertyEnum TYPE = PropertyEnum.func_177709_a((String)"type", TubeType.class);
    private RayTracer rayTracer = new RayTracer();
    public static final IUnlistedProperty<Boolean[]> CONNECTIONS = new IUnlistedProperty<Boolean[]>(){

        public String getName() {
            return "connections";
        }

        public boolean isValid(Boolean[] value) {
            return true;
        }

        public Class<Boolean[]> getType() {
            return Boolean[].class;
        }

        public String valueToString(Boolean[] value) {
            return value.toString();
        }
    };

    public BlockTube() {
        super(Material.field_151573_f, TileTube.class);
        this.func_149711_c(0.5f);
        this.func_149752_b(5.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)TYPE, (Comparable)((Object)TubeType.NORMAL)));
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        switch (meta) {
            case 0: {
                return new TileTube();
            }
            case 1: {
                return new TileTubeValve();
            }
            case 2: {
                return new TileTubeRestrict();
            }
            case 3: {
                return new TileTubeOneway();
            }
            case 4: {
                return new TileTubeFilter();
            }
            case 5: {
                return new TileTubeBuffer();
            }
        }
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(meta);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)TubeType.values()[meta]));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((TubeType)((Object)state.func_177229_b((IProperty)TYPE))).ordinal();
    }

    @Override
    protected BlockState func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{TYPE}, new IUnlistedProperty[]{CONNECTIONS});
    }

    @Override
    public String getStateName(IBlockState state, boolean fullName) {
        TubeType type = (TubeType)((Object)state.func_177229_b((IProperty)TYPE));
        return "tube_" + type.func_176610_l();
    }

    @Override
    public IProperty[] getProperties() {
        return new IProperty[]{TYPE};
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state instanceof IExtendedBlockState) {
            Boolean[] cons = new Boolean[]{false, false, false, false, false, false};
            TileEntity t = world.func_175625_s(pos);
            if (t != null && t instanceof IEssentiaTransport) {
                IEssentiaTransport tube = (IEssentiaTransport)t;
                int a = 0;
                for (EnumFacing face : EnumFacing.field_82609_l) {
                    if (tube.isConnectable(face) && ThaumcraftApiHelper.getConnectableTile(world, pos, face) != null) {
                        cons[a] = true;
                    }
                    ++a;
                }
            }
            return ((IExtendedBlockState)state).withProperty(CONNECTIONS, (Object)cons);
        }
        return state;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180646_a(World world, BlockPos pos) {
        boolean noDoodads = Minecraft.func_71410_x().field_71439_g == null || Minecraft.func_71410_x().field_71439_g.func_71045_bC() == null || !(Minecraft.func_71410_x().field_71439_g.func_71045_bC().func_77973_b() instanceof IWand) && !(Minecraft.func_71410_x().field_71439_g.func_71045_bC().func_77973_b() instanceof ItemResonator);
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileTube) {
            MovingObjectPosition hit = RayTracer.retraceBlock(world, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, pos);
            LinkedList<IndexedCuboid6> cuboids = new LinkedList<IndexedCuboid6>();
            ((TileTube)tile).addTraceableCuboids(cuboids);
            if (hit != null && hit.subHit >= 0 && hit.subHit <= 6 && !noDoodads) {
                for (IndexedCuboid6 cc : cuboids) {
                    if ((Integer)cc.data != hit.subHit) continue;
                    Vector3 v = new Vector3(pos);
                    Cuboid6 c = cc.sub(v);
                    this.func_149676_a((float)c.min.x, (float)c.min.y, (float)c.min.z, (float)c.max.x, (float)c.max.y, (float)c.max.z);
                    break;
                }
            } else {
                this.func_180654_a((IBlockAccess)world, pos);
            }
        }
        return super.func_180646_a(world, pos);
    }

    public void func_180654_a(IBlockAccess world, BlockPos pos) {
        float minx = 0.375f;
        float maxx = 0.625f;
        float miny = 0.3125f;
        float maxy = 0.6875f;
        float minz = 0.3125f;
        float maxz = 0.6875f;
        EnumFacing fd = null;
        block8: for (int side = 0; side < 6; ++side) {
            fd = EnumFacing.field_82609_l[side];
            TileEntity te = ThaumcraftApiHelper.getConnectableTile(world, pos, fd);
            if (te == null) continue;
            switch (side) {
                case 0: {
                    miny = 0.0f;
                    continue block8;
                }
                case 1: {
                    maxy = 1.0f;
                    continue block8;
                }
                case 2: {
                    minz = 0.0f;
                    continue block8;
                }
                case 3: {
                    maxz = 1.0f;
                    continue block8;
                }
                case 4: {
                    minx = 0.0f;
                    continue block8;
                }
                case 5: {
                    maxx = 1.0f;
                }
            }
        }
        this.func_149676_a(minx, miny, minz, maxx, maxy, maxz);
    }

    public void func_180638_a(World world, BlockPos pos, IBlockState state, AxisAlignedBB axisalignedbb, List arraylist, Entity par7Entity) {
        float minx = 0.375f;
        float maxx = 0.625f;
        float miny = 0.375f;
        float maxy = 0.625f;
        float minz = 0.375f;
        float maxz = 0.625f;
        EnumFacing fd = null;
        block8: for (int side = 0; side < 6; ++side) {
            fd = EnumFacing.field_82609_l[side];
            TileEntity te = ThaumcraftApiHelper.getConnectableTile(world, pos, fd);
            if (te == null) continue;
            switch (side) {
                case 0: {
                    miny = 0.0f;
                    continue block8;
                }
                case 1: {
                    maxy = 1.0f;
                    continue block8;
                }
                case 2: {
                    minz = 0.0f;
                    continue block8;
                }
                case 3: {
                    maxz = 1.0f;
                    continue block8;
                }
                case 4: {
                    minx = 0.0f;
                    continue block8;
                }
                case 5: {
                    maxx = 1.0f;
                }
            }
        }
        this.func_149676_a(minx, miny, minz, maxx, maxy, maxz);
        super.func_180638_a(world, pos, state, axisalignedbb, arraylist, par7Entity);
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_180641_l(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileTubeBuffer) {
            float f = ((TileTubeBuffer)te).aspects.visSize();
            ((TileTubeBuffer)te).getClass();
            float r = f / 8.0f;
            return MathHelper.func_76141_d((float)(r * 14.0f)) + (((TileTubeBuffer)te).aspects.visSize() > 0 ? 1 : 0);
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180662_a(IBlockAccess worldIn, BlockPos pos, int renderPass) {
        TileEntity te;
        if (renderPass == 1 && (te = worldIn.func_175625_s(pos)) != null && te instanceof TileTubeFilter && ((TileTubeFilter)te).aspectFilter != null) {
            return ((TileTubeFilter)te).aspectFilter.getColor();
        }
        return super.func_180662_a(worldIn, pos, renderPass);
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && te instanceof TileTubeFilter && ((TileTubeFilter)te).aspectFilter != null && !worldIn.field_72995_K) {
            worldIn.func_72838_d((Entity)new EntityItem(worldIn, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), new ItemStack(ItemsTC.label)));
        }
        if (te != null && te instanceof TileTube && ((TileTube)te).getEssentiaAmount(EnumFacing.UP) > 0) {
            if (!worldIn.field_72995_K) {
                AuraHelper.pollute(worldIn, pos, ((TileTube)te).getEssentiaAmount(EnumFacing.UP), true);
            } else {
                worldIn.func_72980_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, "random.fizz", 0.1f, 1.0f + worldIn.field_73012_v.nextFloat() * 0.1f, false);
                for (int a = 0; a < 5; ++a) {
                    Thaumcraft.proxy.getFX().drawVentParticles((double)pos.func_177958_n() + 0.33 + (double)worldIn.field_73012_v.nextFloat() * 0.33, (double)pos.func_177956_o() + 0.33 + (double)worldIn.field_73012_v.nextFloat() * 0.33, (double)pos.func_177952_p() + 0.33 + (double)worldIn.field_73012_v.nextFloat() * 0.33, 0.0, 0.0, 0.0, Aspect.FLUX.getColor());
                }
            }
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te;
        if (state.func_177229_b((IProperty)TYPE) == TubeType.VALVE) {
            if (player.func_70694_bm() != null && (player.func_70694_bm().func_77973_b() instanceof IWand || player.func_70694_bm().func_77973_b() instanceof ItemResonator || player.func_70694_bm().func_77973_b() == Item.func_150898_a((Block)this))) {
                return false;
            }
            te = world.func_175625_s(pos);
            if (te instanceof TileTubeValve) {
                ((TileTubeValve)te).allowFlow = !((TileTubeValve)te).allowFlow;
                world.func_175689_h(pos);
                te.func_70296_d();
                if (!world.field_72995_K) {
                    world.func_72908_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), "thaumcraft:squeek", 0.7f, 0.9f + world.field_73012_v.nextFloat() * 0.2f);
                }
                return true;
            }
        }
        if (state.func_177229_b((IProperty)TYPE) == TubeType.FILTER) {
            te = world.func_175625_s(pos);
            if (te != null && te instanceof TileTubeFilter && player.func_70093_af() && ((TileTubeFilter)te).aspectFilter != null) {
                ((TileTubeFilter)te).aspectFilter = null;
                world.func_175689_h(pos);
                te.func_70296_d();
                if (world.field_72995_K) {
                    world.func_72980_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), "thaumcraft:page", 1.0f, 1.0f, false);
                }
                return true;
            }
            if (te != null && te instanceof TileTubeFilter && player.func_70694_bm() != null && ((TileTubeFilter)te).aspectFilter == null && player.func_70694_bm().func_77973_b() instanceof IEssentiaContainerItem) {
                if (((IEssentiaContainerItem)player.func_70694_bm().func_77973_b()).getAspects(player.func_70694_bm()) != null) {
                    ((TileTubeFilter)te).aspectFilter = ((IEssentiaContainerItem)player.func_70694_bm().func_77973_b()).getAspects(player.func_70694_bm()).getAspects()[0];
                    world.func_175689_h(pos);
                    te.func_70296_d();
                    if (world.field_72995_K) {
                        world.func_72980_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), "thaumcraft:page", 1.0f, 1.0f, false);
                    }
                }
                return true;
            }
        }
        return super.func_180639_a(world, pos, state, player, side, hitX, hitY, hitZ);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onBlockHighlight(DrawBlockHighlightEvent event) {
        if (event.target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && event.player.field_70170_p.func_180495_p(event.target.func_178782_a()).func_177230_c() == this && event.player.func_71045_bC() != null && (event.player.func_71045_bC().func_77973_b() instanceof IWand || event.player.func_71045_bC().func_77973_b() instanceof ItemResonator)) {
            RayTracer.retraceBlock(event.player.field_70170_p, event.player, event.target.func_178782_a());
        }
    }

    public MovingObjectPosition func_180636_a(World world, BlockPos pos, Vec3 start, Vec3 end) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null || !(tile instanceof TileTube) && !(tile instanceof TileTubeBuffer)) {
            return super.func_180636_a(world, pos, start, end);
        }
        LinkedList<IndexedCuboid6> cuboids = new LinkedList<IndexedCuboid6>();
        if (tile instanceof TileTube) {
            ((TileTube)tile).addTraceableCuboids(cuboids);
        } else if (tile instanceof TileTubeBuffer) {
            ((TileTubeBuffer)tile).addTraceableCuboids(cuboids);
        }
        ArrayList<ExtendedMOP> list = new ArrayList<ExtendedMOP>();
        this.rayTracer.rayTraceCuboids(new Vector3(start), new Vector3(end), cuboids, new BlockCoord(pos), this, list);
        return list.size() > 0 ? (MovingObjectPosition)list.get(0) : super.func_180636_a(world, pos, start, end);
    }

    public static enum TubeType implements IStringSerializable
    {
        NORMAL,
        VALVE,
        RESTRICT,
        ONEWAY,
        FILTER,
        BUFFER;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

