/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.blocks.world;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thaumcraft.common.blocks.BlockTC;
import thaumcraft.common.lib.utils.Utils;

public class BlockLoot
extends BlockTC {
    public static final PropertyEnum TYPE = PropertyEnum.func_177709_a((String)"type", LootType.class);
    Random rand = new Random();

    public BlockLoot(Material mat) {
        super(mat);
        this.func_149711_c(0.15f);
        this.func_149752_b(0.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)TYPE, (Comparable)((Object)LootType.COMMON)));
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    protected boolean func_149700_E() {
        return true;
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public AxisAlignedBB func_180646_a(World w, BlockPos pos) {
        if (this.func_149688_o() == Material.field_151576_e) {
            this.func_149676_a(0.125f, 0.0625f, 0.125f, 0.875f, 0.8125f, 0.875f);
        } else {
            this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
        }
        return super.func_180646_a(w, pos);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)LootType.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((LootType)((Object)state.func_177229_b((IProperty)TYPE))).ordinal();
        return meta;
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{TYPE});
    }

    @Override
    public IProperty[] getProperties() {
        return new IProperty[]{TYPE};
    }

    @Override
    public String getStateName(IBlockState state, boolean fullName) {
        LootType type = (LootType)((Object)state.func_177229_b((IProperty)TYPE));
        return (fullName ? (this.func_149688_o() == Material.field_151576_e ? "loot_urn" : "loot_crate") + "_" : "") + type.func_176610_l();
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        int md = this.func_176201_c(state);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int q = 1 + md + this.rand.nextInt(3);
        for (int a = 0; a < q; ++a) {
            ItemStack is = Utils.generateLoot(md, this.rand);
            if (is == null) continue;
            ret.add(is.func_77946_l());
        }
        return ret;
    }

    public static enum LootType implements IStringSerializable
    {
        COMMON,
        UNCOMMON,
        RARE;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

