/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.blocks.world.taint;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import thaumcraft.api.ThaumcraftMaterials;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.common.blocks.BlockTC;
import thaumcraft.common.blocks.world.taint.BlockTaintFibre;
import thaumcraft.common.blocks.world.taint.ITaintBlock;
import thaumcraft.common.config.Config;
import thaumcraft.common.lib.CustomSoundType;
import thaumcraft.common.lib.utils.Utils;

public class BlockTaintLog
extends BlockTC
implements ITaintBlock {
    public static final PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", LogType.class);
    public static final PropertyEnum AXIS = PropertyEnum.func_177709_a((String)"axis", EnumFacing.Axis.class);

    public BlockTaintLog() {
        super(ThaumcraftMaterials.MATERIAL_TAINT);
        this.setHarvestLevel("axe", 0);
        this.func_149711_c(3.0f);
        this.func_149752_b(100.0f);
        this.func_149672_a(new CustomSoundType("gore", 0.5f, 0.8f));
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VARIANT, (Comparable)((Object)LogType.TAINTWOOD)).func_177226_a((IProperty)AXIS, (Comparable)EnumFacing.Axis.Y));
        this.func_149675_a(true);
    }

    @Override
    public void die(World world, BlockPos pos, IBlockState blockState) {
        world.func_175656_a(pos, BlocksTC.taintDust.func_176223_P().func_177226_a((IProperty)BlockFluidBase.LEVEL, (Comparable)Integer.valueOf(3)));
        Utils.resetBiomeAt(world, pos, world.field_73012_v.nextInt(50) == 0);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        if (!world.field_72995_K) {
            if (AuraHelper.getAura(world, pos, Aspect.FLUX) < Config.AURABASE / 25 && random.nextInt(10) == 0) {
                this.die(world, pos, state);
            } else {
                BlockTaintFibre.spreadFibres(world, pos);
            }
        }
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, int metadata, EntityLivingBase entity) {
        return super.func_180642_a(world, pos, side, hitX, hitY, hitZ, metadata, entity).func_177226_a((IProperty)AXIS, (Comparable)side.func_176740_k());
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, this.func_180651_a(state));
    }

    @Override
    public int func_180651_a(IBlockState state) {
        int baseMeta = ((LogType)((Object)state.func_177229_b((IProperty)VARIANT))).ordinal();
        return baseMeta * 3;
    }

    public IBlockState func_176203_a(int meta) {
        int axis = meta % 3;
        int type = (meta - axis) / 3;
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)LogType.values()[type])).func_177226_a((IProperty)AXIS, (Comparable)EnumFacing.Axis.values()[axis]);
    }

    public int func_176201_c(IBlockState state) {
        int baseMeta = ((LogType)((Object)state.func_177229_b((IProperty)VARIANT))).ordinal();
        return baseMeta * 3 + ((EnumFacing.Axis)state.func_177229_b((IProperty)AXIS)).ordinal();
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{AXIS, VARIANT});
    }

    @Override
    public IProperty[] getProperties() {
        return new IProperty[]{VARIANT};
    }

    @Override
    public String getStateName(IBlockState state, boolean fullName) {
        return ((LogType)((Object)state.func_177229_b((IProperty)VARIANT))).func_176610_l() + (fullName ? "_log" : "");
    }

    public boolean canSustainLeaves(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean isWood(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        int b0 = 4;
        int i = b0 + 1;
        if (worldIn.func_175707_a(pos.func_177982_a(-i, -i, -i), pos.func_177982_a(i, i, i))) {
            for (BlockPos blockpos1 : BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-b0, -b0, -b0), (BlockPos)pos.func_177982_a(b0, b0, b0))) {
                IBlockState iblockstate1 = worldIn.func_180495_p(blockpos1);
                if (!iblockstate1.func_177230_c().isLeaves((IBlockAccess)worldIn, blockpos1)) continue;
                iblockstate1.func_177230_c().beginLeavesDecay(worldIn, blockpos1);
            }
        }
    }

    public static enum LogType implements IStringSerializable
    {
        TAINTWOOD(0);

        private static final LogType[] META_LOOKUP;
        private final int meta;

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }

        private LogType(int meta) {
            this.meta = meta;
        }

        public int getMetadata() {
            return this.meta;
        }

        public static LogType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = new LogType[LogType.values().length];
            LogType[] var0 = LogType.values();
            int var1 = var0.length;
            for (int var2 = 0; var2 < var1; ++var2) {
                LogType var3;
                LogType.META_LOOKUP[var3.getMetadata()] = var3 = var0[var2];
            }
        }
    }
}

