/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.entities.IEldritchMob;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.api.research.ResearchPage;
import thaumcraft.api.research.ScanBlock;
import thaumcraft.api.research.ScanBlockState;
import thaumcraft.api.research.ScanEntity;
import thaumcraft.api.research.ScanItem;
import thaumcraft.api.research.ScanningManager;
import thaumcraft.api.wands.IWand;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.entities.construct.EntityOwnedConstruct;
import thaumcraft.common.entities.monster.EntityBrainyZombie;
import thaumcraft.common.entities.monster.boss.EntityThaumcraftBoss;
import thaumcraft.common.lib.aura.EntityAuraNode;
import thaumcraft.common.lib.crafting.InfusionRunicAugmentRecipe;

public class ConfigResearch {
    public static ItemStack wand = null;
    public static String[] TCCategories = new String[]{"BASICS", "THAUMATURGY", "ALCHEMY", "ARTIFICE", "GOLEMANCY", "ELDRITCH"};
    public static HashMap<String, Object> recipes = new HashMap();

    public static void init() {
        wand = new ItemStack(ItemsTC.wand);
        ((IWand)wand.func_77973_b()).setCap(wand, ConfigItems.WAND_CAP_IRON);
        ((IWand)wand.func_77973_b()).setRod(wand, ConfigItems.WAND_ROD_WOOD);
        ConfigResearch.initCategories();
        ConfigResearch.initBasicResearch();
        ConfigResearch.initThaumaturgyResearch();
        ConfigResearch.initAlchemyResearch();
        ConfigResearch.initArtificeResearch();
        ConfigResearch.initGolemancyResearch();
        ConfigResearch.initEldritchResearch();
    }

    private static void initCategories() {
        ResearchCategories.registerCategory("BASICS", null, new ResourceLocation("thaumcraft", "textures/items/thaumonomicon_cheat.png"), new ResourceLocation("thaumcraft", "textures/gui/gui_research_back_1.jpg"), new ResourceLocation("thaumcraft", "textures/gui/gui_research_back_over.png"));
        ResearchCategories.registerCategory("THAUMATURGY", null, new ResourceLocation("thaumcraft", "textures/research/r_thaumaturgy.png"), new ResourceLocation("thaumcraft", "textures/gui/gui_research_back_2.jpg"), new ResourceLocation("thaumcraft", "textures/gui/gui_research_back_over.png"));
        ResearchCategories.registerCategory("ALCHEMY", null, new ResourceLocation("thaumcraft", "textures/research/r_crucible.png"), new ResourceLocation("thaumcraft", "textures/gui/gui_research_back_3.jpg"), new ResourceLocation("thaumcraft", "textures/gui/gui_research_back_over.png"));
        ResearchCategories.registerCategory("ARTIFICE", null, new ResourceLocation("thaumcraft", "textures/research/r_artifice.png"), new ResourceLocation("thaumcraft", "textures/gui/gui_research_back_4.jpg"), new ResourceLocation("thaumcraft", "textures/gui/gui_research_back_over.png"));
        ResearchCategories.registerCategory("GOLEMANCY", "BASICGOLEMANCY", new ResourceLocation("thaumcraft", "textures/research/r_golemancy.png"), new ResourceLocation("thaumcraft", "textures/gui/gui_research_back_5.jpg"), new ResourceLocation("thaumcraft", "textures/gui/gui_research_back_over.png"));
        ResearchCategories.registerCategory("ELDRITCH", "ELDRITCHMINOR", new ResourceLocation("thaumcraft", "textures/research/r_eldritch.png"), new ResourceLocation("thaumcraft", "textures/gui/gui_research_back_6.jpg"), new ResourceLocation("thaumcraft", "textures/gui/gui_research_back_over.png"));
    }

    private static void initThaumaturgyResearch() {
        new ResearchItem("BASICTHAUMATURGY", "THAUMATURGY", new AspectList(), 0, 0, 0, wand).setPages(new ResearchPage("tc.research_page.BASICTHAUMATURGY.1"), new ResearchPage("tc.research_page.BASICTHAUMATURGY.2"), new ResearchPage((IRecipe)recipes.get("WandCapIron")), new ResearchPage((IRecipe)recipes.get("WandBasic"))).setAutoUnlock().setStub().setRound().registerResearchItem();
        new ResearchItem("NODETAPPER1", "THAUMATURGY", new AspectList().add(Aspect.AURA, 6).add(Aspect.ENERGY, 3).add(Aspect.MOTION, 3).add(Aspect.EXCHANGE, 3), -4, 0, 2, new ResourceLocation("thaumcraft", "textures/research/r_nodetap1.png")).setPages(new ResearchPage("tc.research_page.NODETAPPER1.1")).setParents("BASICTHAUMATURGY").setRound().registerResearchItem();
        new ResearchItem("NODETAPPER2", "THAUMATURGY", new AspectList().add(Aspect.AURA, 6).add(Aspect.ENERGY, 3).add(Aspect.MOTION, 3).add(Aspect.EXCHANGE, 3), -6, -1, 2, new ResourceLocation("thaumcraft", "textures/research/r_nodetap2.png")).setPages(new ResearchPage("tc.research_page.NODETAPPER2.1")).setParents("NODETAPPER1").setRound().registerResearchItem();
        new ResearchItem("AURAMANIP1", "THAUMATURGY", new AspectList().add(Aspect.AURA, 6).add(Aspect.EXCHANGE, 3).add(Aspect.WATER, 3).add(Aspect.AVERSION, 3), -8, 0, 3, new ItemStack(BlocksTC.auraTotem, 1, 1)).setPages(new ResearchPage("tc.research_page.AURAMANIP1.1"), new ResearchPage((InfusionRecipe)recipes.get("TotemPush")), new ResearchPage("tc.research_page.AURAMANIP1.2"), new ResearchPage((IArcaneRecipe)recipes.get("PoleInner")), new ResearchPage("tc.research_page.AURAMANIP1.3"), new ResearchPage((IArcaneRecipe)recipes.get("PoleOuter"))).setParents("NODETAPPER2", "INFUSION").setSpecial().registerResearchItem();
        new ResearchItem("AURAMANIP2", "THAUMATURGY", new AspectList().add(Aspect.AURA, 6).add(Aspect.EXCHANGE, 3).add(Aspect.WATER, 3).add(Aspect.DESIRE, 3), -9, -1, 3, new ItemStack(BlocksTC.auraTotem, 1, 0)).setPages(new ResearchPage("tc.research_page.AURAMANIP2.1"), new ResearchPage((InfusionRecipe)recipes.get("TotemPull"))).setParents("AURAMANIP1").setSecondary().registerResearchItem();
        new ResearchItem("AURAPOLESTABLE", "THAUMATURGY", new AspectList().add(Aspect.AURA, 6).add(Aspect.ORDER, 3).add(Aspect.MOTION, 3), -9, 1, 2, new ItemStack(BlocksTC.auraTotem, 1, 4)).setPages(new ResearchPage("tc.research_page.AURAPOLESTABLE.1"), new ResearchPage((IArcaneRecipe)recipes.get("PoleStable"))).setParents("AURAMANIP1").setSecondary().registerResearchItem();
        new ResearchItem("NODEMAGNET", "THAUMATURGY", new AspectList().add(Aspect.AURA, 6).add(Aspect.MOTION, 6).add(Aspect.MECHANISM, 3).add(Aspect.DESIRE, 8), -11, 0, 3, new ItemStack(ItemsTC.turretPlacer, 1, 2)).setPages(new ResearchPage("tc.research_page.NODEMAGNET.1"), new ResearchPage((InfusionRecipe)recipes.get("NodeMagnet")), new ResearchPage("tc.research_page.NODEMAGNET.2"), new ResearchPage("tc.research_page.NODEMAGNET.3").setRequisite("!NODEMAGNETDANGER")).setHidden().setSpecial().setParents("AURAMANIP2", "AURAPOLESTABLE", "MINDBIOTHAUMIC", "CRYSTALFARMER").registerResearchItem();
        ThaumcraftApi.addWarpToResearch("NODEMAGNET", 3);
        new ResearchItem("FOCUSFIRE", "THAUMATURGY", new AspectList().add(Aspect.FIRE, 6).add(Aspect.AIR, 3).add(Aspect.ENERGY, 3), 3, 0, 1, new ItemStack(ItemsTC.focusFire)).setPages(new ResearchPage("tc.research_page.FOCUSFIRE.1"), new ResearchPage("tc.research_page.FOCUSFIRE.2"), new ResearchPage((IArcaneRecipe)recipes.get("FocusFire"))).setParents("BASICTHAUMATURGY").registerResearchItem();
        new ResearchItem("FOCUSSHOCK", "THAUMATURGY", new AspectList().add(Aspect.AIR, 6).add(Aspect.FIRE, 3).add(Aspect.ENERGY, 3), 5, -2, 1, new ItemStack(ItemsTC.focusShock)).setPages(new ResearchPage("tc.research_page.FOCUSSHOCK.1"), new ResearchPage((IArcaneRecipe)recipes.get("FocusShock"))).setParents("FOCUSFIRE").registerResearchItem();
        new ResearchItem("FOCUSFROST", "THAUMATURGY", new AspectList().add(Aspect.WATER, 6).add(Aspect.COLD, 3).add(Aspect.ENERGY, 3), 6, -1, 1, new ItemStack(ItemsTC.focusFrost)).setPages(new ResearchPage("tc.research_page.FOCUSFROST.1"), new ResearchPage((IArcaneRecipe)recipes.get("FocusFrost"))).setParents("FOCUSFIRE").registerResearchItem();
        new ResearchItem("FOCUSEXCAVATION", "THAUMATURGY", new AspectList().add(Aspect.EARTH, 6).add(Aspect.ENTROPY, 3).add(Aspect.ENERGY, 3), 6, 1, 2, new ItemStack(ItemsTC.focusExcavation)).setPages(new ResearchPage("tc.research_page.FOCUSEXCAVATION.1"), new ResearchPage((IArcaneRecipe)recipes.get("FocusExcavation"))).setParents("FOCUSFIRE").registerResearchItem();
        new ResearchItem("FOCUSTRADE", "THAUMATURGY", new AspectList().add(Aspect.EXCHANGE, 6).add(Aspect.EARTH, 3).add(Aspect.ENERGY, 3), 5, 2, 2, new ItemStack(ItemsTC.focusEqualTrade)).setPages(new ResearchPage("tc.research_page.FOCUSTRADE.1"), new ResearchPage((IArcaneRecipe)recipes.get("FocusTrade"))).setParents("FOCUSFIRE").registerResearchItem();
        new ResearchItem("FOCUSPORTABLEHOLE", "THAUMATURGY", new AspectList().add(Aspect.MOTION, 3).add(Aspect.ENTROPY, 3).add(Aspect.ELDRITCH, 6).add(Aspect.AIR, 3), 6, 3, 2, new ItemStack(ItemsTC.focusHole)).setPages(new ResearchPage("tc.research_page.FOCUSPORTABLEHOLE.1"), new ResearchPage((InfusionRecipe)recipes.get("FocusPortableHole"))).setHidden().setParents("FOCUSTRADE", "FOCUSEXCAVATION", "INFUSION").registerResearchItem();
        new ResearchItem("FOCUSHELLBAT", "THAUMATURGY", new AspectList().add(Aspect.MOTION, 3).add(Aspect.BEAST, 6).add(Aspect.FIRE, 3).add(Aspect.ENERGY, 3), 3, -2, 2, new ItemStack(ItemsTC.focusHellbat)).setPages(new ResearchPage("tc.research_page.FOCUSHELLBAT.1"), new ResearchPage((InfusionRecipe)recipes.get("FocusHellbat"))).setHidden().setParents("FOCUSFIRE", "INFUSION", "!BAT").registerResearchItem();
        ScanningManager.addScannableThing(new ScanEntity("!BAT", EntityBat.class, true));
        ThaumcraftApi.addWarpToResearch("FOCUSHELLBAT", 2);
        ThaumcraftApi.addWarpToItem(new ItemStack(ItemsTC.focusHellbat), 1);
        new ResearchItem("VAMPBAT", "THAUMATURGY", new AspectList().add(Aspect.DESIRE, 5).add(Aspect.LIFE, 5).add(Aspect.ENERGY, 5), 4, -3, 1, new ResourceLocation("thaumcraft", "textures/foci/vampirebats.png")).setPages(new ResearchPage("focus.upgrade.vampirebats.text")).setSecondary().setParents("FOCUSHELLBAT").setParentsHidden("FOCALMANIPULATION").registerResearchItem();
        ThaumcraftApi.addWarpToResearch("VAMPBAT", 2);
        new ResearchItem("FOCUSPOUCH", "THAUMATURGY", new AspectList().add(Aspect.VOID, 6).add(Aspect.TOOL, 3), -2, -2, 1, new ItemStack(ItemsTC.focusPouch)).setPages(new ResearchPage("tc.research_page.FOCUSPOUCH.1"), new ResearchPage((IArcaneRecipe)recipes.get("FocusPouch"))).setParents("BASICTHAUMATURGY").setSecondary().registerResearchItem();
        new ResearchItem("CAP_iron", "THAUMATURGY").setAutoUnlock().registerResearchItem();
        new ResearchItem("CAP_gold", "THAUMATURGY", new AspectList().add(Aspect.METAL, 3).add(Aspect.DESIRE, 3).add(Aspect.TOOL, 3), 0, 2, 1, new ItemStack(ItemsTC.wandCaps, 1, 1)).setPages(new ResearchPage("tc.research_page.CAP_gold.1"), new ResearchPage((IArcaneRecipe)recipes.get("WandCapGold"))).setParents("BASICTHAUMATURGY").registerResearchItem();
        new ResearchItem("CAP_brass", "THAUMATURGY", new AspectList().add(Aspect.METAL, 3).add(Aspect.ENERGY, 3).add(Aspect.TOOL, 3), 0, 4, 1, new ItemStack(ItemsTC.wandCaps, 1, 2)).setPages(new ResearchPage("tc.research_page.CAP_brass.1"), new ResearchPage((IArcaneRecipe)recipes.get("WandCapBrass"))).setParents("CAP_gold", "METALLURGY").registerResearchItem();
        new ResearchItem("CAP_thaumium", "THAUMATURGY", new AspectList().add(Aspect.METAL, 6).add(Aspect.ENERGY, 6).add(Aspect.TOOL, 3).add(Aspect.AURA, 3), 0, 6, 2, new ItemStack(ItemsTC.wandCaps, 1, 3)).setPages(new ResearchPage("tc.research_page.CAP_thaumium.1"), new ResearchPage((IArcaneRecipe)recipes.get("WandCapThaumiumInert")), new ResearchPage((InfusionRecipe)recipes.get("WandCapThaumium"))).setParents("CAP_brass", "METALLURGY", "INFUSION").registerResearchItem();
        new ResearchItem("ROD_wood", "THAUMATURGY").setAutoUnlock().registerResearchItem();
        new ResearchItem("ROD_greatwood", "THAUMATURGY", new AspectList().add(Aspect.TOOL, 3).add(Aspect.PLANT, 6).add(Aspect.ENERGY, 3), -3, 2, 1, new ItemStack(ItemsTC.wandRods, 1, 0)).setPages(new ResearchPage("tc.research_page.ROD_greatwood.1"), new ResearchPage((IArcaneRecipe)recipes.get("WandRodGreatwood"))).setParents("BASICTHAUMATURGY").registerResearchItem();
        new ResearchItem("PRIMALRODS", "THAUMATURGY", new AspectList().add(Aspect.TOOL, 3).add(Aspect.AIR, 6).add(Aspect.FIRE, 6).add(Aspect.EARTH, 6).add(Aspect.WATER, 6).add(Aspect.ORDER, 6).add(Aspect.ENTROPY, 6).add(Aspect.ENERGY, 3), -5, 3, 3, new ItemStack(ItemsTC.wandRods, 1, 2), new ItemStack(ItemsTC.wandRods, 1, 3), new ItemStack(ItemsTC.wandRods, 1, 4), new ItemStack(ItemsTC.wandRods, 1, 5), new ItemStack(ItemsTC.wandRods, 1, 6), new ItemStack(ItemsTC.wandRods, 1, 7)).setPages(new ResearchPage("tc.research_page.PRIMALRODS.1"), new ResearchPage((InfusionRecipe)recipes.get("WandRodReed")), new ResearchPage("tc.research_page.PRIMALRODS.2"), new ResearchPage((InfusionRecipe)recipes.get("WandRodBlaze")), new ResearchPage("tc.research_page.PRIMALRODS.3"), new ResearchPage((InfusionRecipe)recipes.get("WandRodObsidian")), new ResearchPage("tc.research_page.PRIMALRODS.4"), new ResearchPage((InfusionRecipe)recipes.get("WandRodIce")), new ResearchPage("tc.research_page.PRIMALRODS.5"), new ResearchPage((InfusionRecipe)recipes.get("WandRodQuartz")), new ResearchPage("tc.research_page.PRIMALRODS.6"), new ResearchPage((InfusionRecipe)recipes.get("WandRodBone"))).setParents("ROD_greatwood", "INFUSION").setSiblings("ROD_reed", "ROD_blaze", "ROD_obsidian", "ROD_ice", "ROD_quartz", "ROD_bone").registerResearchItem();
        new ResearchItem("ROD_silverwood", "THAUMATURGY", new AspectList().add(Aspect.TOOL, 6).add(Aspect.PLANT, 6).add(Aspect.ENERGY, 9), -3, 4, 3, new ItemStack(ItemsTC.wandRods, 1, 1)).setPages(new ResearchPage("tc.research_page.ROD_silverwood.1"), new ResearchPage((InfusionRecipe)recipes.get("WandRodSilverwood"))).setParents("ROD_greatwood", "INFUSION").registerResearchItem();
        ArrayList<ShapedArcaneRecipe> scer = new ArrayList<ShapedArcaneRecipe>();
        AspectList al1 = new AspectList();
        AspectList al2 = new AspectList();
        AspectList al3 = new AspectList();
        int cost = ConfigItems.WAND_CAP_IRON.getCraftCost() * ConfigItems.WAND_ROD_WOOD.getCraftCost() * 12;
        for (Aspect as : Aspect.getPrimalAspects()) {
            al1.add(as, cost);
        }
        ItemStack sceptre1 = new ItemStack(ItemsTC.wand);
        ((IWand)sceptre1.func_77973_b()).setCap(sceptre1, ConfigItems.WAND_CAP_IRON);
        ((IWand)sceptre1.func_77973_b()).setRod(sceptre1, ConfigItems.WAND_ROD_WOOD);
        sceptre1.func_77983_a("sceptre", (NBTBase)new NBTTagByte(1));
        ShapedArcaneRecipe r1 = new ShapedArcaneRecipe("SCEPTRE", sceptre1, al1, " TF", " RT", "T  ", Character.valueOf('T'), ConfigItems.WAND_CAP_IRON.getItem(), Character.valueOf('R'), ConfigItems.WAND_ROD_WOOD.getItem(), Character.valueOf('F'), new ItemStack(ItemsTC.primalCharm));
        scer.add(r1);
        cost = ConfigItems.WAND_CAP_GOLD.getCraftCost() * ConfigItems.WAND_ROD_GREATWOOD.getCraftCost() * 12;
        for (Aspect as : Aspect.getPrimalAspects()) {
            al2.add(as, cost);
        }
        ItemStack sceptre2 = new ItemStack(ItemsTC.wand);
        ((IWand)sceptre2.func_77973_b()).setCap(sceptre2, ConfigItems.WAND_CAP_GOLD);
        ((IWand)sceptre2.func_77973_b()).setRod(sceptre2, ConfigItems.WAND_ROD_GREATWOOD);
        sceptre2.func_77983_a("sceptre", (NBTBase)new NBTTagByte(1));
        ShapedArcaneRecipe r2 = new ShapedArcaneRecipe("SCEPTRE", sceptre2, al2, " TF", " RT", "T  ", Character.valueOf('T'), ConfigItems.WAND_CAP_GOLD.getItem(), Character.valueOf('R'), ConfigItems.WAND_ROD_GREATWOOD.getItem(), Character.valueOf('F'), new ItemStack(ItemsTC.primalCharm));
        scer.add(r2);
        cost = ConfigItems.WAND_CAP_THAUMIUM.getCraftCost() * ConfigItems.WAND_ROD_SILVERWOOD.getCraftCost() * 12;
        for (Aspect as : Aspect.getPrimalAspects()) {
            al3.add(as, cost);
        }
        ItemStack sceptre3 = new ItemStack(ItemsTC.wand);
        ((IWand)sceptre3.func_77973_b()).setCap(sceptre3, ConfigItems.WAND_CAP_THAUMIUM);
        ((IWand)sceptre3.func_77973_b()).setRod(sceptre3, ConfigItems.WAND_ROD_SILVERWOOD);
        sceptre3.func_77983_a("sceptre", (NBTBase)new NBTTagByte(1));
        ShapedArcaneRecipe r3 = new ShapedArcaneRecipe("SCEPTRE", sceptre3, al3, " TF", " RT", "T  ", Character.valueOf('T'), ConfigItems.WAND_CAP_THAUMIUM.getItem(), Character.valueOf('R'), ConfigItems.WAND_ROD_SILVERWOOD.getItem(), Character.valueOf('F'), new ItemStack(ItemsTC.primalCharm));
        scer.add(r3);
        new ResearchItem("SCEPTRE", "THAUMATURGY", new AspectList().add(Aspect.TOOL, 6).add(Aspect.CRAFT, 6).add(Aspect.PLANT, 6).add(Aspect.ENERGY, 9), -2, 6, 3, sceptre3).setPages(new ResearchPage("tc.research_page.SCEPTRE.1"), new ResearchPage(scer.toArray(new IArcaneRecipe[0]))).setParents("ROD_silverwood").registerResearchItem();
        new ResearchItem("ROD_greatwood_staff", "THAUMATURGY", new AspectList().add(Aspect.TOOL, 3).add(Aspect.PLANT, 6).add(Aspect.ENERGY, 3), -4, 6, 1, new ItemStack(ItemsTC.wandRods, 1, 8)).setPages(new ResearchPage("tc.research_page.ROD_greatwood_staff.1"), new ResearchPage("tc.research_page.ROD_greatwood_staff.2"), new ResearchPage((IArcaneRecipe)recipes.get("WandRodGreatwoodStaff"))).setParents("ROD_silverwood").registerResearchItem();
        new ResearchItem("PRIMALSTAVES", "THAUMATURGY", new AspectList().add(Aspect.TOOL, 3).add(Aspect.AIR, 6).add(Aspect.FIRE, 6).add(Aspect.EARTH, 6).add(Aspect.WATER, 6).add(Aspect.ORDER, 6).add(Aspect.ENTROPY, 6).add(Aspect.ENERGY, 3), -6, 4, 3, new ItemStack(ItemsTC.wandRods, 1, 10), new ItemStack(ItemsTC.wandRods, 1, 11), new ItemStack(ItemsTC.wandRods, 1, 12), new ItemStack(ItemsTC.wandRods, 1, 13), new ItemStack(ItemsTC.wandRods, 1, 14), new ItemStack(ItemsTC.wandRods, 1, 15)).setPages(new ResearchPage("tc.research_page.PRIMALSTAVES.1"), new ResearchPage((IArcaneRecipe)recipes.get("WandRodReedStaff")), new ResearchPage((IArcaneRecipe)recipes.get("WandRodBlazeStaff")), new ResearchPage((IArcaneRecipe)recipes.get("WandRodObsidianStaff")), new ResearchPage((IArcaneRecipe)recipes.get("WandRodIceStaff")), new ResearchPage((IArcaneRecipe)recipes.get("WandRodQuartzStaff")), new ResearchPage((IArcaneRecipe)recipes.get("WandRodBoneStaff"))).setParents("PRIMALRODS", "ROD_greatwood_staff", "INFUSION").setSecondary().setSiblings("ROD_reed_staff", "ROD_blaze_staff", "ROD_obsidian_staff", "ROD_ice_staff", "ROD_quartz_staff", "ROD_bone_staff").registerResearchItem();
        new ResearchItem("ROD_silverwood_staff", "THAUMATURGY", new AspectList().add(Aspect.TOOL, 6).add(Aspect.PLANT, 6).add(Aspect.ENERGY, 9), -3, 8, 3, new ItemStack(ItemsTC.wandRods, 1, 9)).setPages(new ResearchPage("tc.research_page.ROD_silverwood_staff.1"), new ResearchPage((IArcaneRecipe)recipes.get("WandRodSilverwoodStaff"))).setSecondary().setParents("ROD_silverwood", "ROD_greatwood_staff").setFlipped().registerResearchItem();
        new ResearchItem("WANDPED", "THAUMATURGY", new AspectList().add(Aspect.AURA, 6).add(Aspect.ENERGY, 3).add(Aspect.EXCHANGE, 3).add(Aspect.ENERGY, 3), -4, -2, 2, new ItemStack(BlocksTC.rechargePedestal)).setPages(new ResearchPage("tc.research_page.WANDPED.1"), new ResearchPage((InfusionRecipe)recipes.get("WandPed"))).setParents("INFUSION", "NODETAPPER1").registerResearchItem();
        new ResearchItem("WORKBENCHCHARGER", "THAUMATURGY", new AspectList().add(Aspect.AURA, 3).add(Aspect.MECHANISM, 3).add(Aspect.ENERGY, 6), -3, -4, 2, new ItemStack(BlocksTC.arcaneWorkbenchCharger)).setPages(new ResearchPage("tc.research_page.WORKBENCHCHARGER.1"), new ResearchPage((IArcaneRecipe)recipes.get("WorkbenchCharger"))).setParents("WANDPED").setParentsHidden("ROD_greatwood").setSecondary().registerResearchItem();
        new ResearchItem("VISAMULET", "THAUMATURGY", new AspectList().add(Aspect.AURA, 3).add(Aspect.ENERGY, 6).add(Aspect.ENERGY, 3).add(Aspect.VOID, 3), -5, -4, 2, new ItemStack(ItemsTC.amuletVis, 1, 1)).setPages(new ResearchPage("tc.research_page.VISAMULET.1"), new ResearchPage((InfusionRecipe)recipes.get("VisAmulet")), new ResearchPage("tc.research_page.VISAMULET.2")).setParents("WANDPED").registerResearchItem();
        new ResearchItem("FOCALMANIPULATION", "THAUMATURGY", new AspectList().add(Aspect.ENERGY, 8).add(Aspect.TOOL, 8).add(Aspect.CRAFT, 5).add(Aspect.CRYSTAL, 5).add(Aspect.ENERGY, 5), 1, -3, 2, new ItemStack(BlocksTC.wandWorkbench)).setPages(new ResearchPage("tc.research_page.FOCALMANIPULATION.1"), new ResearchPage((IArcaneRecipe)recipes.get("FocalManipulator")), new ResearchPage("tc.research_page.FOCALMANIPULATION.2")).setParentsHidden("FOCUSFROST", "FOCUSSHOCK", "FOCUSTRADE", "FOCUSEXCAVATION").setParents("FOCUSFIRE").registerResearchItem();
    }

    private static void initArtificeResearch() {
        new ResearchItem("BASICARTIFACE", "ARTIFICE", new AspectList(), 0, 1, 0, new ItemStack(ItemsTC.primalCharm)).setPages(new ResearchPage("tc.research_page.BASICARTIFACE.1"), new ResearchPage((IArcaneRecipe)recipes.get("PrimalCharm")), new ResearchPage((IRecipe)recipes.get("MundaneAmulet")), new ResearchPage((IRecipe)recipes.get("MundaneRing")), new ResearchPage((IRecipe)recipes.get("MundaneBelt")), new ResearchPage((IArcaneRecipe)recipes.get("MirrorGlass"))).setStub().setRound().setAutoUnlock().registerResearchItem();
        new ResearchItem("ARCANESTONE", "ARTIFICE", new AspectList(), -2, 0, 0, new ItemStack(BlocksTC.stone)).setPages(new ResearchPage("tc.research_page.ARCANESTONE.1"), new ResearchPage((IArcaneRecipe)recipes.get("ArcaneStone1")), new ResearchPage((IRecipe)recipes.get("ArcaneStone2")), new ResearchPage((IRecipe)recipes.get("ArcaneStone3")), new ResearchPage((IRecipe)recipes.get("ArcaneStone4")), new ResearchPage((IRecipe)recipes.get("ArcaneStone5")), new ResearchPage((IRecipe)recipes.get("ArcaneStone6"))).setStub().setAutoUnlock().setRound().setSiblings("BASICARTIFACE").registerResearchItem();
        new ResearchItem("ENCHFABRIC", "ARTIFICE", new AspectList(), -2, 2, 0, new ItemStack(ItemsTC.fabric)).setPages(new ResearchPage("tc.research_page.ENCHFABRIC.1"), new ResearchPage((IArcaneRecipe)recipes.get("EnchantedFabric")), new ResearchPage("tc.research_page.ENCHFABRIC.2"), new ResearchPage((IArcaneRecipe)recipes.get("RobeChest")), new ResearchPage((IArcaneRecipe)recipes.get("RobeLegs")), new ResearchPage((IArcaneRecipe)recipes.get("RobeBoots"))).setStub().setAutoUnlock().setRound().setSiblings("BASICARTIFACE").registerResearchItem();
        new ResearchItem("TABLE", "ARTIFICE", new AspectList(), 0, -3, 0, new ItemStack(BlocksTC.tableWood)).setPages(new ResearchPage("tc.research_page.TABLE.1"), new ResearchPage((IRecipe)recipes.get("TableWood")), new ResearchPage((IRecipe)recipes.get("TableStone"))).setStub().setAutoUnlock().setRound().setSiblings("BASICARTIFACE").registerResearchItem();
        new ResearchItem("ARCTABLE", "ARTIFICE", new AspectList(), -1, -4, 0, new ItemStack(BlocksTC.arcaneWorkbench)).setPages(new ResearchPage("tc.research_page.ARCTABLE.1"), new ResearchPage((List)recipes.get("ArcTable"))).setStub().setAutoUnlock().setRound().setSiblings("TABLE").registerResearchItem();
        new ResearchItem("RESTABLE", "ARTIFICE", new AspectList(), 1, -4, 0, new ItemStack(BlocksTC.researchTable)).setPages(new ResearchPage("tc.research_page.RESTABLE.1"), new ResearchPage((List)recipes.get("ResTable"))).setStub().setAutoUnlock().setRound().setSiblings("TABLE").registerResearchItem();
        new ResearchItem("THAUMOMETER", "ARTIFICE", new AspectList(), 2, 2, 0, new ItemStack(ItemsTC.thaumometer)).setPages(new ResearchPage("tc.research_page.THAUMOMETER.1"), new ResearchPage((IRecipe)recipes.get("Thaumometer"))).setStub().setAutoUnlock().setRound().setSiblings("BASICARTIFACE").registerResearchItem();
        new ResearchItem("PAVEBARRIER", "ARTIFICE", new AspectList().add(Aspect.EARTH, 3).add(Aspect.ENTROPY, 3).add(Aspect.MOTION, 3), -4, -2, 1, new ItemStack(BlocksTC.pavingStone, 1, 0)).setPages(new ResearchPage("tc.research_page.PAVEBARRIER.1"), new ResearchPage((IArcaneRecipe)recipes.get("PaveBarrier")), new ResearchPage("tc.research_page.PAVEBARRIER.2")).setParents("ARCANESTONE").registerResearchItem();
        new ResearchItem("PAVETRAVEL", "ARTIFICE", new AspectList().add(Aspect.EARTH, 3).add(Aspect.AIR, 3).add(Aspect.MOTION, 3), -3, -2, 1, new ItemStack(BlocksTC.pavingStone, 1, 1)).setPages(new ResearchPage("tc.research_page.PAVETRAVEL.1"), new ResearchPage((IArcaneRecipe)recipes.get("PaveTravel"))).setParents("ARCANESTONE").registerResearchItem();
        new ResearchItem("LEVITATOR", "ARTIFICE", new AspectList().add(Aspect.MOTION, 3).add(Aspect.FLIGHT, 3).add(Aspect.AIR, 3), -3, -4, 1, new ItemStack(BlocksTC.levitator)).setPages(new ResearchPage("tc.research_page.LEVITATOR.1"), new ResearchPage((IArcaneRecipe)recipes.get("Levitator")), new ResearchPage("tc.research_page.LEVITATOR.1")).setParents("NITOR", "PAVETRAVEL", "!volatus").registerResearchItem();
        new ResearchItem("REDSTONERELAY", "ARTIFICE", new AspectList().add(Aspect.ENERGY, 6).add(Aspect.AVERSION, 3).add(Aspect.ORDER, 3), 2, -2, 1, new ItemStack(BlocksTC.redstoneRelay)).setPages(new ResearchPage("tc.research_page.REDSTONERELAY.1"), new ResearchPage((IArcaneRecipe)recipes.get("RedstoneRelay")), new ResearchPage("tc.research_page.REDSTONERELAY.2")).setParents("BASICARTIFACE").setFlipped().setSecondary().registerResearchItem();
        new ResearchItem("HOVERHARNESS", "ARTIFICE", new AspectList().add(Aspect.FLIGHT, 6).add(Aspect.AIR, 6).add(Aspect.MECHANISM, 3), -5, -5, 3, new ItemStack(ItemsTC.thaumostaticHarness)).setPages(new ResearchPage("tc.research_page.HOVERHARNESS.1"), new ResearchPage((InfusionRecipe)recipes.get("HoverHarness")), new ResearchPage("tc.research_page.HOVERHARNESS.2")).setHidden().setParents("LEVITATOR", "!volatus").setParentsHidden("INFUSION").registerResearchItem();
        new ResearchItem("HOVERGIRDLE", "ARTIFICE", new AspectList().add(Aspect.FLIGHT, 6).add(Aspect.AIR, 3).add(Aspect.MOTION, 6), -6, -6, 3, new ItemStack(ItemsTC.girdleHover)).setPages(new ResearchPage("tc.research_page.HOVERGIRDLE.1"), new ResearchPage((InfusionRecipe)recipes.get("HoverGirdle"))).setParents("HOVERHARNESS").setSecondary().registerResearchItem();
        new ResearchItem("GOGGLES", "ARTIFICE", new AspectList().add(Aspect.SENSES, 3).add(Aspect.AURA, 3).add(Aspect.ENERGY, 3), 4, 2, 1, new ItemStack(ItemsTC.goggles)).setPages(new ResearchPage("tc.research_page.GOGGLES.1"), new ResearchPage((IArcaneRecipe)recipes.get("Goggles"))).setParents("THAUMOMETER").registerResearchItem();
        new ResearchItem("DIOPTRA", "ARTIFICE", new AspectList().add(Aspect.SENSES, 3).add(Aspect.AURA, 3).add(Aspect.ENERGY, 3).add(Aspect.EARTH, 3), 6, 3, 2, new ItemStack(BlocksTC.dioptra)).setPages(new ResearchPage("tc.research_page.DIOPTRA.1"), new ResearchPage((IArcaneRecipe)recipes.get("Dioptra"))).setParents("GOGGLES").registerResearchItem();
        new ResearchItem("ARCANEEAR", "ARTIFICE", new AspectList().add(Aspect.SENSES, 3).add(Aspect.MECHANISM, 3).add(Aspect.AIR, 3), 6, 0, 1, new ItemStack(BlocksTC.arcaneEar)).setPages(new ResearchPage("tc.research_page.ARCANEEAR.1"), new ResearchPage((IArcaneRecipe)recipes.get("ArcaneEar"))).setParents("GOGGLES").registerResearchItem();
        new ResearchItem("BELLOWS", "ARTIFICE", new AspectList().add(Aspect.AIR, 6).add(Aspect.MECHANISM, 3).add(Aspect.MOTION, 3), 2, 0, 1, new ItemStack(BlocksTC.bellows, 1, 0)).setPages(new ResearchPage("tc.research_page.BELLOWS.1"), new ResearchPage((IArcaneRecipe)recipes.get("Bellows")), new ResearchPage("tc.research_page.BELLOWS.2")).setParents("BASICARTIFACE").setSecondary().registerResearchItem().setFlipped();
        new ResearchItem("INFERNALFURNACE", "ARTIFICE", new AspectList().add(Aspect.FIRE, 6).add(Aspect.METAL, 3).add(Aspect.CRAFT, 3).add(Aspect.AURA, 3), 4, -1, 2, new ResourceLocation("thaumcraft", "textures/research/r_infernalfurnace.png")).setPages(new ResearchPage("tc.research_page.INFERNALFURNACE.1"), new ResearchPage((List)recipes.get("InfernalFurnace")), new ResearchPage("tc.research_page.INFERNALFURNACE.2")).setParents("BASICARTIFACE", "NITOR", "ALUMENTUM").registerResearchItem();
        ThaumcraftApi.addWarpToResearch("INFERNALFURNACE", 2);
        new ResearchItem("INFUSION", "ARTIFICE", new AspectList().add(Aspect.ENERGY, 6).add(Aspect.MECHANISM, 3).add(Aspect.CRAFT, 6), 0, 4, 2, new ItemStack(BlocksTC.infusionMatrix)).setPages(new ResearchPage("tc.research_page.INFUSION.1"), new ResearchPage((IArcaneRecipe)recipes.get("InfusionMatrix")), new ResearchPage((IArcaneRecipe)recipes.get("ArcanePedestal")), new ResearchPage("tc.research_page.INFUSION.2"), new ResearchPage((List)recipes.get("InfusionAltar")), new ResearchPage("tc.research_page.INFUSION.3"), new ResearchPage("tc.research_page.INFUSION.4"), new ResearchPage("tc.research_page.INFUSION.5"), new ResearchPage("tc.research_page.INFUSION.ANCIENT").setRequisite("!ORBLOCK1"), new ResearchPage((List)recipes.get("InfusionAltarAncient")).setRequisite("!ORBLOCK1"), new ResearchPage((IArcaneRecipe)recipes.get("AncientPedestal")).setRequisite("!ORBLOCK1"), new ResearchPage("tc.research_page.INFUSION.ELDRITCH").setRequisite("!ORBLOCK2"), new ResearchPage((List)recipes.get("InfusionAltarEldritch")).setRequisite("!ORBLOCK2"), new ResearchPage((IArcaneRecipe)recipes.get("EldritchPedestal")).setRequisite("!ORBLOCK2")).setParents("BASICARTIFACE", "DISTILESSENTIA").registerResearchItem();
        new ResearchItem("INFUSIONBOOST", "ARTIFICE", new AspectList().add(Aspect.ENERGY, 6).add(Aspect.AIR, 3).add(Aspect.WATER, 3).add(Aspect.EXCHANGE, 3), 0, 6, 2, new ItemStack(BlocksTC.stone, 1, 8), new ItemStack(BlocksTC.stone, 1, 9)).setPages(new ResearchPage("tc.research_page.INFUSIONBOOST.1"), new ResearchPage((IArcaneRecipe)recipes.get("MatrixSpeed")), new ResearchPage((IArcaneRecipe)recipes.get("MatrixCost"))).setSecondary().setHidden().setParents("INFUSION", "ALUMENTUM", "NITOR", "ELDRITCHMINOR").registerResearchItem();
        new ResearchItem("RUNICARMOR", "ARTIFICE", new AspectList().add(Aspect.PROTECT, 6).add(Aspect.AIR, 3).add(Aspect.ENERGY, 3).add(Aspect.MIND, 3), -3, 6, 3, new ItemStack(ItemsTC.amuletRunic)).setPages(new ResearchPage("tc.research_page.RUNICARMOR.1"), new ResearchPage("tc.research_page.RUNICARMOR.2"), new ResearchPage((InfusionRecipe)recipes.get("RunicRing")), new ResearchPage((InfusionRecipe)recipes.get("RunicAmulet")), new ResearchPage((InfusionRecipe)recipes.get("RunicGirdle"))).setParents("INFUSION").registerResearchItem();
        new ResearchItem("RUNICSPECIAL", "ARTIFICE", new AspectList().add(Aspect.ORDER, 3).add(Aspect.PROTECT, 3).add(Aspect.ENERGY, 6), -2, 7, 2, new ItemStack(ItemsTC.ringRunic, 1, 2)).setPages(new ResearchPage("tc.research_page.RUNICSPECIAL.1"), new ResearchPage((InfusionRecipe)recipes.get("RunicRingCharged")), new ResearchPage("tc.research_page.RUNICSPECIAL.2"), new ResearchPage((InfusionRecipe)recipes.get("RunicRingHealing")), new ResearchPage("tc.research_page.RUNICSPECIAL.3"), new ResearchPage((InfusionRecipe)recipes.get("RunicGirdleKinetic")), new ResearchPage("tc.research_page.RUNICSPECIAL.4"), new ResearchPage((InfusionRecipe)recipes.get("RunicAmuletEmergency"))).setParents("RUNICARMOR").setSecondary().registerResearchItem();
        ArrayList<InfusionRunicAugmentRecipe> raug = new ArrayList<InfusionRunicAugmentRecipe>();
        for (int a = 0; a <= 4; ++a) {
            ItemStack in = new ItemStack(ItemsTC.clothChest);
            if (a > 0) {
                in.func_77983_a("RS.HARDEN", (NBTBase)new NBTTagByte((byte)a));
            }
            raug.add(new InfusionRunicAugmentRecipe(in));
        }
        new ResearchItem("RUNICAUGMENTATION", "ARTIFICE", new AspectList().add(Aspect.ORDER, 3).add(Aspect.PROTECT, 3).add(Aspect.EXCHANGE, 4).add(Aspect.DESIRE, 4), -4, 7, 1, new ResourceLocation("thaumcraft", "textures/research/r_runicupg.png")).setPages(new ResearchPage("tc.research_page.RUNICAUGMENTATION.1"), new ResearchPage(raug.toArray(new InfusionRecipe[0])), new ResearchPage("tc.research_page.RUNICAUGMENTATION.2")).setParents("RUNICARMOR").registerResearchItem();
        ArrayList<IArcaneRecipe> banners = new ArrayList<IArcaneRecipe>();
        for (int a = 0; a < 16; ++a) {
            banners.add((IArcaneRecipe)recipes.get("Banner_" + a));
        }
        ItemStack is = new ItemStack(BlocksTC.banner, 1, 0);
        is.func_77982_d(new NBTTagCompound());
        is.func_77978_p().func_74774_a("color", (byte)10);
        new ResearchItem("BANNERS", "ARTIFICE", new AspectList(), 0, -5, 1, is).setPages(new ResearchPage("tc.research_page.BANNERS.1"), new ResearchPage(banners.toArray(new IArcaneRecipe[0]))).setSiblings("TABLE").setStub().setAutoUnlock().setRound().registerResearchItem();
        new ResearchItem("BOOTSTRAVELLER", "ARTIFICE", new AspectList().add(Aspect.MOTION, 3).add(Aspect.EARTH, 3).add(Aspect.FLIGHT, 3).add(Aspect.WATER, 3), -4, 3, 2, new ItemStack(ItemsTC.travellerBoots)).setPages(new ResearchPage("tc.research_page.BOOTSTRAVELLER.1"), new ResearchPage((InfusionRecipe)recipes.get("BootsTraveller"))).setParents("ENCHFABRIC", "INFUSION").registerResearchItem();
        ScanningManager.addScannableThing(new ScanBlockState("!TELEPORT", BlocksTC.eldritch.func_176203_a(6), false));
        ScanningManager.addScannableThing(new ScanBlock("!TELEPORT", (Block)Blocks.field_150427_aO));
        ScanningManager.addScannableThing(new ScanBlock("!TELEPORT", Blocks.field_150384_bq));
        ScanningManager.addScannableThing(new ScanBlock("!TELEPORT", Blocks.field_150378_br));
        ScanningManager.addScannableThing(new ScanItem("!TELEPORT", new ItemStack(Items.field_151079_bi)));
        ScanningManager.addScannableThing(new ScanEntity("!TELEPORT", EntityEnderman.class, true));
        if (Config.allowMirrors) {
            new ResearchItem("MIRROR", "ARTIFICE", new AspectList().add(Aspect.MOTION, 6).add(Aspect.ELDRITCH, 3).add(Aspect.DARKNESS, 3).add(Aspect.CRYSTAL, 3), -1, 9, 2, new ItemStack(BlocksTC.mirror)).setPages(new ResearchPage("tc.research_page.MIRROR.1"), new ResearchPage("tc.research_page.MIRROR.2"), new ResearchPage((InfusionRecipe)recipes.get("Mirror")), new ResearchPage("tc.research_page.MIRROR.3")).setHidden().setParents("INFUSION", "!TELEPORT").registerResearchItem();
            new ResearchItem("MIRRORHAND", "ARTIFICE", new AspectList().add(Aspect.TOOL, 6).add(Aspect.ELDRITCH, 3).add(Aspect.CRYSTAL, 3).add(Aspect.MOTION, 3), -2, 10, 2, new ItemStack(ItemsTC.handMirror)).setPages(new ResearchPage("tc.research_page.MIRRORHAND.1"), new ResearchPage((InfusionRecipe)recipes.get("MirrorHand"))).setSecondary().setParents("MIRROR").registerResearchItem();
            new ResearchItem("MIRRORESSENTIA", "ARTIFICE", new AspectList().add(Aspect.MOTION, 6).add(Aspect.ELDRITCH, 3).add(Aspect.WATER, 3).add(Aspect.ENERGY, 3), 0, 10, 2, new ItemStack(BlocksTC.mirrorEssentia)).setPages(new ResearchPage("tc.research_page.MIRRORESSENTIA.1"), new ResearchPage((InfusionRecipe)recipes.get("MirrorEssentia")), new ResearchPage("tc.research_page.MIRRORESSENTIA.2")).setSecondary().setParents("MIRROR").registerResearchItem();
        }
        new ResearchItem("ARCANELAMP", "ARTIFICE", new AspectList().add(Aspect.LIGHT, 3).add(Aspect.SENSES, 3).add(Aspect.DARKNESS, 3), -6, -1, 1, new ItemStack(BlocksTC.lampArcane)).setPages(new ResearchPage("tc.research_page.ARCANELAMP.1"), new ResearchPage((IArcaneRecipe)recipes.get("ArcaneLamp")), new ResearchPage("tc.research_page.ARCANELAMP.2").setRequisite("ARCANEBORE")).setSecondary().setParents("BASICARTIFACE", "NITOR", "!lux").registerResearchItem();
        new ResearchItem("LAMPGROWTH", "ARTIFICE", new AspectList().add(Aspect.LIGHT, 3).add(Aspect.PLANT, 6).add(Aspect.LIFE, 3).add(Aspect.TOOL, 3), -7, -2, 2, new ItemStack(BlocksTC.lampGrowth)).setPages(new ResearchPage("tc.research_page.LAMPGROWTH.1"), new ResearchPage((InfusionRecipe)recipes.get("LampGrowth"))).setHidden().setParentsHidden("INFUSION").setParents("ARCANELAMP", "!herba").registerResearchItem();
        new ResearchItem("LAMPFERTILITY", "ARTIFICE", new AspectList().add(Aspect.BEAST, 6).add(Aspect.LIFE, 6).add(Aspect.LIGHT, 3).add(Aspect.DESIRE, 6), -7, 0, 2, new ItemStack(BlocksTC.lampFertility)).setPages(new ResearchPage("tc.research_page.LAMPFERTILITY.1"), new ResearchPage((InfusionRecipe)recipes.get("LampFertility"))).setHidden().setParentsHidden("INFUSION").setParents("ARCANELAMP", "!victus", "!desiderium").registerResearchItem();
        new ResearchItem("BONEBOW", "ARTIFICE", new AspectList().add(Aspect.AVERSION, 3).add(Aspect.FLIGHT, 3).add(Aspect.UNDEAD, 3), -9, -1, 1, new ItemStack(ItemsTC.boneBow)).setPages(new ResearchPage("tc.research_page.BONEBOW.1"), new ResearchPage((IArcaneRecipe)recipes.get("BoneBow"))).setHidden().setParents("!BONE", "!BOW").registerResearchItem();
        ScanningManager.addScannableThing(new ScanItem("!BONE", new ItemStack(Items.field_151103_aS)));
        ScanningManager.addScannableThing(new ScanItem("!BOW", new ItemStack((Item)Items.field_151031_f, 1, Short.MAX_VALUE)));
        ArrayList<IArcaneRecipe> rcbb = new ArrayList<IArcaneRecipe>();
        for (int a = 0; a < 6; ++a) {
            rcbb.add((IArcaneRecipe)recipes.get("PrimalArrow_" + a));
        }
        new ResearchItem("PRIMALARROW", "ARTIFICE", new AspectList().add(Aspect.AVERSION, 3).add(Aspect.AIR, 3).add(Aspect.FIRE, 3).add(Aspect.WATER, 3).add(Aspect.EARTH, 3).add(Aspect.ORDER, 3).add(Aspect.ENTROPY, 3), -9, 0, 2, new ItemStack(ItemsTC.primalArrows, 1, Short.MAX_VALUE)).setPages(new ResearchPage("tc.research_page.PRIMALARROW.1"), new ResearchPage(rcbb.toArray(new IArcaneRecipe[0])), new ResearchPage("tc.research_page.PRIMALARROW.2"), new ResearchPage("tc.research_page.PRIMALARROW.3")).setHidden().setParents("!ARROW").registerResearchItem();
        ScanningManager.addScannableThing(new ScanItem("!ARROW", new ItemStack(Items.field_151032_g)));
        new ResearchItem("ELEMENTALTOOLS", "ARTIFICE", new AspectList().add(Aspect.TOOL, 6).add(Aspect.AVERSION, 6).add(Aspect.AIR, 3).add(Aspect.FIRE, 3).add(Aspect.WATER, 3).add(Aspect.EARTH, 3).add(Aspect.ORDER, 3).add(Aspect.ENTROPY, 3), 4, 6, 2, new ItemStack(ItemsTC.elementalAxe), new ItemStack(ItemsTC.elementalPick), new ItemStack(ItemsTC.elementalSword), new ItemStack(ItemsTC.elementalShovel), new ItemStack(ItemsTC.elementalHoe)).setPages(new ResearchPage("tc.research_page.ELEMENTALTOOLS.1"), new ResearchPage((InfusionRecipe)recipes.get("ElementalAxe")), new ResearchPage("tc.research_page.ELEMENTALTOOLS.2"), new ResearchPage("tc.research_page.ELEMENTALTOOLS.3"), new ResearchPage((InfusionRecipe)recipes.get("ElementalPick")), new ResearchPage("tc.research_page.ELEMENTALTOOLS.4"), new ResearchPage("tc.research_page.ELEMENTALTOOLS.5"), new ResearchPage((InfusionRecipe)recipes.get("ElementalSword")), new ResearchPage("tc.research_page.ELEMENTALTOOLS.6"), new ResearchPage((InfusionRecipe)recipes.get("ElementalShovel")), new ResearchPage("tc.research_page.ELEMENTALTOOLS.7"), new ResearchPage("tc.research_page.ELEMENTALTOOLS.8"), new ResearchPage((InfusionRecipe)recipes.get("ElementalHoe"))).setParents("METALLURGY", "INFUSION").registerResearchItem();
        new ResearchItem("JARBRAIN", "ARTIFICE", new AspectList().add(Aspect.DESIRE, 3).add(Aspect.MIND, 3).add(Aspect.UNDEAD, 3).add(Aspect.DESIRE, 3), -6, 6, 2, new ItemStack(BlocksTC.jar, 1, 2)).setPages(new ResearchPage("tc.research_page.JARBRAIN.1"), new ResearchPage((InfusionRecipe)recipes.get("JarBrain"))).setParents("INFUSION", "!BRAIN").setHidden().registerResearchItem();
        ScanningManager.addScannableThing(new ScanEntity("!BRAIN", EntityBrainyZombie.class, true));
        ScanningManager.addScannableThing(new ScanItem("!BRAIN", new ItemStack(ItemsTC.brain)));
        ThaumcraftApi.addWarpToResearch("JARBRAIN", 3);
        ThaumcraftApi.addWarpToItem(new ItemStack(BlocksTC.jar, 1, 1), 1);
        new ResearchItem("ARMORFORTRESS", "ARTIFICE", new AspectList().add(Aspect.METAL, 3).add(Aspect.PROTECT, 5).add(Aspect.CRAFT, 5), -6, 3, 2, new ItemStack(ItemsTC.fortressHelm)).setPages(new ResearchPage("tc.research_page.ARMORFORTRESS.1"), new ResearchPage("tc.research_page.ARMORFORTRESS.2"), new ResearchPage((InfusionRecipe)recipes.get("ThaumiumFortressHelm")), new ResearchPage((InfusionRecipe)recipes.get("ThaumiumFortressChest")), new ResearchPage((InfusionRecipe)recipes.get("ThaumiumFortressLegs"))).setParents("METALLURGY", "BOOTSTRAVELLER", "!praemunio").registerResearchItem();
        new ResearchItem("HELMGOGGLES", "ARTIFICE", new AspectList().add(Aspect.SENSES, 5).add(Aspect.AURA, 3).add(Aspect.PROTECT, 3), -7, 2, 2, new ItemStack(ItemsTC.goggles)).setPages(new ResearchPage("tc.research_page.HELMGOGGLES.1"), new ResearchPage((InfusionRecipe)recipes.get("HelmGoggles"))).setParentsHidden("GOGGLES").setParents("ARMORFORTRESS").setHidden().setSecondary().registerResearchItem();
        new ResearchItem("MASKGRINNINGDEVIL", "ARTIFICE", new AspectList().add(Aspect.LIFE, 5).add(Aspect.MIND, 5).add(Aspect.PROTECT, 3), -8, 2, 2, new ResourceLocation("thaumcraft", "textures/research/r_mask0.png")).setPages(new ResearchPage("tc.research_page.MASKGRINNINGDEVIL.1"), new ResearchPage((InfusionRecipe)recipes.get("MaskGrinningDevil"))).setParents("ARMORFORTRESS").setHidden().setSecondary().registerResearchItem();
        new ResearchItem("MASKANGRYGHOST", "ARTIFICE", new AspectList().add(Aspect.ENTROPY, 5).add(Aspect.DEATH, 5).add(Aspect.PROTECT, 3), -8, 4, 2, new ResourceLocation("thaumcraft", "textures/research/r_mask1.png")).setPages(new ResearchPage("tc.research_page.MASKANGRYGHOST.1"), new ResearchPage((InfusionRecipe)recipes.get("MaskAngryGhost"))).setParents("ARMORFORTRESS").setHidden().setSecondary().registerResearchItem();
        new ResearchItem("MASKSIPPINGFIEND", "ARTIFICE", new AspectList().add(Aspect.UNDEAD, 5).add(Aspect.LIFE, 5).add(Aspect.PROTECT, 3), -7, 4, 2, new ResourceLocation("thaumcraft", "textures/research/r_mask2.png")).setPages(new ResearchPage("tc.research_page.MASKSIPPINGFIEND.1"), new ResearchPage((InfusionRecipe)recipes.get("MaskSippingFiend"))).setParents("ARMORFORTRESS").setHidden().setSecondary().registerResearchItem();
        ThaumcraftApi.addWarpToResearch("MASKANGRYGHOST", 1);
        ThaumcraftApi.addWarpToResearch("MASKSIPPINGFIEND", 1);
    }

    private static void initAlchemyResearch() {
        new ResearchItem("PHIAL", "ALCHEMY", new AspectList(), 0, -2, 0, new ItemStack(ItemsTC.phial, 1, 0)).setPages(new ResearchPage("tc.research_page.PHIAL.1"), new ResearchPage((IRecipe)recipes.get("Phial"))).setStub().setRound().setAutoUnlock().setSiblings("CRUCIBLE").registerResearchItem();
        ArrayList<CrucibleRecipe> cruc = new ArrayList<CrucibleRecipe>();
        for (int a = 0; a < 6; ++a) {
            cruc.add((CrucibleRecipe)recipes.get("BalancedShard_" + a));
        }
        new ResearchItem("CRUCIBLE", "ALCHEMY", new AspectList(), 0, 0, 0, new ItemStack(BlocksTC.crucible)).setPages(new ResearchPage("tc.research_page.CRUCIBLE.1"), new ResearchPage("tc.research_page.CRUCIBLE.2"), new ResearchPage("tc.research_page.CRUCIBLE.3"), new ResearchPage((List)recipes.get("Crucible")), new ResearchPage("tc.research_page.CRUCIBLE.4"), new ResearchPage(cruc.toArray(new CrucibleRecipe[0])), new ResearchPage("tc.research_page.CRUCIBLE.5"), new ResearchPage(new ItemStack(ItemsTC.shard, 1, 7)), new ResearchPage((IArcaneRecipe)recipes.get("Filter")), new ResearchPage((IArcaneRecipe)recipes.get("MorphicResonator"))).setStub().setRound().setAutoUnlock().registerResearchItem();
        new ResearchItem("NITOR", "ALCHEMY", new AspectList().add(Aspect.LIGHT, 3).add(Aspect.FIRE, 1), 2, -2, 1, new ItemStack(BlocksTC.nitor, 1, Short.MAX_VALUE)).setPages(new ResearchPage("tc.research_page.NITOR.1"), new ResearchPage((CrucibleRecipe)recipes.get("Nitor"))).setParents("CRUCIBLE").registerResearchItem();
        new ResearchItem("ALUMENTUM", "ALCHEMY", new AspectList().add(Aspect.ENERGY, 3).add(Aspect.FIRE, 1), 2, 2, 1, new ItemStack(ItemsTC.alumentum)).setPages(new ResearchPage("tc.research_page.ALUMENTUM.1"), new ResearchPage((CrucibleRecipe)recipes.get("Alumentum"))).setParents("CRUCIBLE").registerResearchItem();
        new ResearchItem("ALCHEMICALDUPLICATION", "ALCHEMY", new AspectList().add(Aspect.WATER, 3).add(Aspect.DESIRE, 6).add(Aspect.ENERGY, 3), -4, 2, 1, new ResourceLocation("thaumcraft", "textures/research/r_alchmult.png")).setPages(new ResearchPage("tc.research_page.ALCHEMICALDUPLICATION.1"), new ResearchPage((CrucibleRecipe)recipes.get("AltGunpowder")), new ResearchPage((CrucibleRecipe)recipes.get("AltSlime")), new ResearchPage((CrucibleRecipe)recipes.get("AltClay")), new ResearchPage((CrucibleRecipe)recipes.get("AltGlowstone")), new ResearchPage((CrucibleRecipe)recipes.get("AltInk"))).setParents("TALLOW").setSecondary().registerResearchItem();
        new ResearchItem("ALCHEMICALMANUFACTURE", "ALCHEMY", new AspectList().add(Aspect.WATER, 3).add(Aspect.CRAFT, 6).add(Aspect.ENERGY, 3), -4, -2, 1, new ResourceLocation("thaumcraft", "textures/research/r_alchman.png")).setPages(new ResearchPage("tc.research_page.ALCHEMICALMANUFACTURE.1"), new ResearchPage((CrucibleRecipe)recipes.get("AltWeb")), new ResearchPage((CrucibleRecipe)recipes.get("AltMossyCobble")), new ResearchPage((CrucibleRecipe)recipes.get("AltIce"))).setParents("TALLOW").setSecondary().registerResearchItem();
        new ResearchItem("ENTROPICPROCESSING", "ALCHEMY", new AspectList().add(Aspect.WATER, 3).add(Aspect.ENTROPY, 6).add(Aspect.ENERGY, 3), -5, 0, 1, new ResourceLocation("thaumcraft", "textures/research/r_alchent.png")).setPages(new ResearchPage("tc.research_page.ENTROPICPROCESSING.1"), new ResearchPage((CrucibleRecipe)recipes.get("AltCrackedBrick")), new ResearchPage((CrucibleRecipe)recipes.get("AltBonemeal"))).setParents("TALLOW").setSecondary().registerResearchItem();
        new ResearchItem("LIQUIDDEATH", "ALCHEMY", new AspectList().add(Aspect.DEATH, 5).add(Aspect.ENTROPY, 5).add(Aspect.WATER, 1), -7, 3, 2, new ItemStack(ItemsTC.bucketDeath)).setPages(new ResearchPage("tc.research_page.LIQUIDDEATH.1"), new ResearchPage((CrucibleRecipe)recipes.get("LiquidDeath"))).setHidden().setParents("ENTROPICPROCESSING", "!mortuus").registerResearchItem();
        ThaumcraftApi.addWarpToResearch("LIQUIDDEATH", 3);
        ThaumcraftApi.addWarpToItem(new ItemStack(ItemsTC.bucketDeath), 1);
        new ResearchItem("BOTTLETAINT", "ALCHEMY", new AspectList().add(Aspect.FLUX, 5).add(Aspect.ENERGY, 3).add(Aspect.ENTROPY, 3).add(Aspect.WATER, 1), -8, 1, 2, new ItemStack(ItemsTC.bottleTaint)).setPages(new ResearchPage("tc.research_page.BOTTLETAINT.1"), new ResearchPage((CrucibleRecipe)recipes.get("BottleTaint"))).setHidden().setParents("ENTROPICPROCESSING", "!vitium").registerResearchItem();
        ThaumcraftApi.addWarpToResearch("BOTTLETAINT", 2);
        ThaumcraftApi.addWarpToItem(new ItemStack(ItemsTC.bottleTaint), 1);
        new ResearchItem("METALLURGY", "ALCHEMY", new AspectList().add(Aspect.METAL, 3).add(Aspect.MECHANISM, 3), 0, 2, 1, new ItemStack(ItemsTC.ingots)).setPages(new ResearchPage("tc.research_page.METALLURGY.1"), new ResearchPage("tc.research_page.METALLURGY.2"), new ResearchPage((CrucibleRecipe)recipes.get("Thaumium")), new ResearchPage((CrucibleRecipe)recipes.get("AlchemicalBrass")), new ResearchPage((IRecipe)recipes.get("BrassGear")), new ResearchPage((IRecipe)recipes.get("BrassPlate")), new ResearchPage((IRecipe)recipes.get("ThaumiumGear")), new ResearchPage((IRecipe)recipes.get("ThaumiumPlate")), new ResearchPage((IRecipe)recipes.get("ThaumiumAxe")), new ResearchPage((IRecipe)recipes.get("ThaumiumSword")), new ResearchPage((IRecipe)recipes.get("ThaumiumPick")), new ResearchPage((IRecipe)recipes.get("ThaumiumShovel")), new ResearchPage((IRecipe)recipes.get("ThaumiumHoe")), new ResearchPage((IRecipe)recipes.get("ThaumiumHelm")), new ResearchPage((IRecipe)recipes.get("ThaumiumChest")), new ResearchPage((IRecipe)recipes.get("ThaumiumLegs")), new ResearchPage((IRecipe)recipes.get("ThaumiumBoots"))).setParents("CRUCIBLE").registerResearchItem();
        ArrayList<ResearchPage> purepages = new ArrayList<ResearchPage>();
        ArrayList<ResearchPage> transpages = new ArrayList<ResearchPage>();
        purepages.add(new ResearchPage("tc.research_page.PUREMETAL.1"));
        purepages.add(new ResearchPage((CrucibleRecipe)recipes.get("PureIron")));
        purepages.add(new ResearchPage((CrucibleRecipe)recipes.get("PureGold")));
        purepages.add(new ResearchPage((CrucibleRecipe)recipes.get("PureCinnabar")));
        transpages.add(new ResearchPage("tc.research_page.TRANSMETAL.1"));
        transpages.add(new ResearchPage((CrucibleRecipe)recipes.get("TransIron")));
        transpages.add(new ResearchPage((CrucibleRecipe)recipes.get("TransGold")));
        if (Config.foundCopperOre && Config.foundCopperIngot) {
            purepages.add(new ResearchPage((CrucibleRecipe)recipes.get("PureCopper")));
            transpages.add(new ResearchPage((CrucibleRecipe)recipes.get("TransCopper")));
        }
        if (Config.foundTinOre && Config.foundTinIngot) {
            purepages.add(new ResearchPage((CrucibleRecipe)recipes.get("PureTin")));
            transpages.add(new ResearchPage((CrucibleRecipe)recipes.get("TransTin")));
        }
        if (Config.foundSilverOre && Config.foundSilverIngot) {
            purepages.add(new ResearchPage((CrucibleRecipe)recipes.get("PureSilver")));
            transpages.add(new ResearchPage((CrucibleRecipe)recipes.get("TransSilver")));
        }
        if (Config.foundLeadOre && Config.foundLeadIngot) {
            purepages.add(new ResearchPage((CrucibleRecipe)recipes.get("PureLead")));
            transpages.add(new ResearchPage((CrucibleRecipe)recipes.get("TransLead")));
        }
        new ResearchItem("PUREMETAL", "ALCHEMY", new AspectList().add(Aspect.METAL, 3).add(Aspect.ORDER, 3), -1, 4, 1, new ItemStack(ItemsTC.clusters)).setPages(purepages.toArray(new ResearchPage[1])).setParents("METALLURGY").registerResearchItem();
        new ResearchItem("TRANSMETAL", "ALCHEMY", new AspectList().add(Aspect.METAL, 3).add(Aspect.EXCHANGE, 3).add(Aspect.FLUX, 3), 1, 4, 1, new ItemStack(Items.field_151074_bl)).setPages(transpages.toArray(new ResearchPage[1])).setParents("METALLURGY").registerResearchItem();
        new ResearchItem("TALLOW", "ALCHEMY", new AspectList().add(Aspect.BEAST, 3).add(Aspect.FIRE, 1), -2, 0, 1, new ItemStack(ItemsTC.tallow)).setPages(new ResearchPage("tc.research_page.TALLOW.1"), new ResearchPage((CrucibleRecipe)recipes.get("Tallow")), new ResearchPage((IRecipe)recipes.get("TallowCandle"))).setParents("CRUCIBLE").registerResearchItem();
        new ResearchItem("ETHEREALBLOOM", "ALCHEMY", new AspectList().add(Aspect.LIGHT, 1).add(Aspect.PLANT, 6).add(Aspect.LIFE, 3).add(Aspect.FLUX, 6), -6, -3, 2, new ItemStack(BlocksTC.bloom)).setPages(new ResearchPage("tc.research_page.ETHEREALBLOOM.1"), new ResearchPage((CrucibleRecipe)recipes.get("EtherealBloom")), new ResearchPage("tc.research_page.ETHEREALBLOOM.2")).setHidden().setParents("ALCHEMICALMANUFACTURE", "!vitium").registerResearchItem();
        new ResearchItem("BATHSALTS", "ALCHEMY", new AspectList().add(Aspect.MIND, 3).add(Aspect.AURA, 3).add(Aspect.ORDER, 3).add(Aspect.LIFE, 3), -4, -4, 2, new ItemStack(ItemsTC.bathSalts)).setPages(new ResearchPage("tc.research_page.BATHSALTS.1"), new ResearchPage((CrucibleRecipe)recipes.get("BathSalts"))).setHidden().setParents("ALCHEMICALMANUFACTURE", "@BATHSALTS").registerResearchItem();
        new ResearchItem("SANESOAP", "ALCHEMY", new AspectList().add(Aspect.MIND, 5).add(Aspect.ORDER, 5).add(Aspect.LIFE, 5).add(Aspect.ELDRITCH, 5), -3, -6, 1, new ItemStack(ItemsTC.sanitySoap)).setPages(new ResearchPage("tc.research_page.SANESOAP.1"), new ResearchPage((CrucibleRecipe)recipes.get("SaneSoap"))).setParents("BATHSALTS").registerResearchItem();
        new ResearchItem("ARCANESPA", "ALCHEMY", new AspectList().add(Aspect.WATER, 3).add(Aspect.MECHANISM, 3).add(Aspect.ORDER, 3), -5, -6, 1, new ItemStack(BlocksTC.spa)).setPages(new ResearchPage("tc.research_page.ARCANESPA.1"), new ResearchPage((IArcaneRecipe)recipes.get("ArcaneSpa"))).setSecondary().setParents("BATHSALTS").registerResearchItem();
        new ResearchItem("DISTILESSENTIA", "ALCHEMY", new AspectList().add(Aspect.FIRE, 3).add(Aspect.WATER, 3).add(Aspect.CRAFT, 3), 4, 0, 1, new ItemStack(BlocksTC.smelterBasic, 1, 0)).setPages(new ResearchPage("tc.research_page.DISTILESSENTIA.1"), new ResearchPage((IArcaneRecipe)recipes.get("EssentiaSmelter")), new ResearchPage("tc.research_page.DISTILESSENTIA.2"), new ResearchPage((IArcaneRecipe)recipes.get("Alembic")), new ResearchPage("tc.research_page.DISTILESSENTIA.3"), new ResearchPage("tc.research_page.DISTILESSENTIA.4").setRequisite("BELLOWS")).setSiblings("JARLABEL").setParents("NITOR", "ALUMENTUM").registerResearchItem();
        new ResearchItem("DISTILESSENTIA2", "ALCHEMY", new AspectList().add(Aspect.FIRE, 3).add(Aspect.WATER, 3).add(Aspect.CRAFT, 3), 5, -2, 1, new ItemStack(BlocksTC.smelterThaumium)).setPages(new ResearchPage("tc.research_page.DISTILESSENTIA2.1"), new ResearchPage((IArcaneRecipe)recipes.get("EssentiaSmelter2"))).setParents("DISTILESSENTIA", "IMPROVED_DISTILLATION").registerResearchItem();
        new ResearchItem("DISTILESSENTIA3", "ALCHEMY", new AspectList().add(Aspect.FIRE, 3).add(Aspect.WATER, 3).add(Aspect.CRAFT, 3), 5, -4, 1, new ItemStack(BlocksTC.smelterVoid)).setPages(new ResearchPage("tc.research_page.DISTILESSENTIA3.1"), new ResearchPage((IArcaneRecipe)recipes.get("AdvAlchemyConstruct")), new ResearchPage((IArcaneRecipe)recipes.get("EssentiaSmelter3"))).setHidden().setParents("DISTILESSENTIA2", "PRIMPEARL").setParentsHidden("VOIDMETAL").registerResearchItem();
        new ResearchItem("IMPROVED_DISTILLATION", "ALCHEMY", new AspectList().add(Aspect.FIRE, 5).add(Aspect.TOOL, 3).add(Aspect.WATER, 5).add(Aspect.CRAFT, 5), 7, -2, 2, new ItemStack(BlocksTC.smelterAux)).setPages(new ResearchPage("tc.research_page.IMPROVED_DISTILLATION.1"), new ResearchPage((IArcaneRecipe)recipes.get("SmelterAux"))).setParents("TUBEFILTER").setFlipped().registerResearchItem();
        ArrayList<IRecipe> rc = new ArrayList<IRecipe>();
        for (int a = 0; a < Aspect.aspects.values().size(); ++a) {
            rc.add((IRecipe)recipes.get("JarLabel" + a));
        }
        new ResearchItem("JARLABEL", "ALCHEMY", new AspectList(), 5, 1, 0, new ItemStack(BlocksTC.jar)).setPages(new ResearchPage("tc.research_page.JARLABEL.1"), new ResearchPage((IArcaneRecipe)recipes.get("WardedJar")), new ResearchPage("tc.research_page.JARLABEL.2"), new ResearchPage((IRecipe)recipes.get("JarLabel")), new ResearchPage("tc.research_page.JARLABEL.3"), new ResearchPage(rc.toArray(new IRecipe[0])), new ResearchPage((IRecipe)recipes.get("JarLabelNull"))).setParents("DISTILESSENTIA").setHidden().setStub().setRound().registerResearchItem();
        new ResearchItem("JARVOID", "ALCHEMY", new AspectList().add(Aspect.WATER, 3).add(Aspect.VOID, 6), 6, 3, 1, new ItemStack(BlocksTC.jar, 1, 1)).setPages(new ResearchPage("tc.research_page.JARVOID.1"), new ResearchPage((IArcaneRecipe)recipes.get("JarVoid"))).setParents("JARLABEL").setSecondary().registerResearchItem();
        new ResearchItem("TUBES", "ALCHEMY", new AspectList().add(Aspect.WATER, 3).add(Aspect.EXCHANGE, 6), 7, 0, 1, new ItemStack(BlocksTC.tube)).setPages(new ResearchPage("tc.research_page.TUBES.1"), new ResearchPage((IArcaneRecipe)recipes.get("Tube")), new ResearchPage("tc.research_page.TUBES.2"), new ResearchPage((IArcaneRecipe)recipes.get("TubeValve")), new ResearchPage("tc.research_page.TUBES.3"), new ResearchPage((IArcaneRecipe)recipes.get("Resonator")), new ResearchPage("tc.research_page.TUBES.4")).setParents("DISTILESSENTIA").setSecondary().registerResearchItem();
        new ResearchItem("TUBEFILTER", "ALCHEMY", new AspectList().add(Aspect.WATER, 3).add(Aspect.EXCHANGE, 6).add(Aspect.ORDER, 3), 9, -1, 1, new ItemStack(BlocksTC.tube, 1, 4)).setPages(new ResearchPage("tc.research_page.TUBEFILTER.1"), new ResearchPage((IArcaneRecipe)recipes.get("TubeFilter")), new ResearchPage("tc.research_page.TUBEFILTER.2"), new ResearchPage((IArcaneRecipe)recipes.get("TubeRestrict")), new ResearchPage((IArcaneRecipe)recipes.get("TubeOneway")), new ResearchPage("tc.research_page.TUBEFILTER.3"), new ResearchPage("tc.research_page.TUBEFILTER.4"), new ResearchPage((IArcaneRecipe)recipes.get("TubeBuffer")), new ResearchPage((IArcaneRecipe)recipes.get("AlchemicalConstruct"))).setParents("TUBES").setSecondary().registerResearchItem();
        new ResearchItem("ESSENTIACRYSTAL", "ALCHEMY", new AspectList().add(Aspect.WATER, 5).add(Aspect.CRYSTAL, 5).add(Aspect.EXCHANGE, 3).add(Aspect.ENERGY, 5), 10, -2, 1, new ItemStack(BlocksTC.crystallizer)).setPages(new ResearchPage("tc.research_page.ESSENTIACRYSTAL.1"), new ResearchPage((IArcaneRecipe)recipes.get("EssentiaCrystalizer"))).setParents("TUBEFILTER").registerResearchItem();
        new ResearchItem("CENTRIFUGE", "ALCHEMY", new AspectList().add(Aspect.FLUX, 3).add(Aspect.ENERGY, 3).add(Aspect.EXCHANGE, 3).add(Aspect.CRAFT, 3), 10, 0, 2, new ItemStack(BlocksTC.centrifuge)).setPages(new ResearchPage("tc.research_page.CENTRIFUGE.1"), new ResearchPage((IArcaneRecipe)recipes.get("Centrifuge"))).setParents("TUBEFILTER").registerResearchItem();
        new ResearchItem("THAUMATORIUM", "ALCHEMY", new AspectList().add(Aspect.WATER, 3).add(Aspect.ENERGY, 6).add(Aspect.EXCHANGE, 3).add(Aspect.CRAFT, 3), 9, -4, 3, new ItemStack(BlocksTC.metal, 1, 2)).setPages(new ResearchPage("tc.research_page.THAUMATORIUM.1"), new ResearchPage((List)recipes.get("Thaumatorium")), new ResearchPage("tc.research_page.THAUMATORIUM.2"), new ResearchPage("tc.research_page.THAUMATORIUM.3").setRequisite("MINDCLOCKWORK"), new ResearchPage((IArcaneRecipe)recipes.get("MnemonicMatrix")).setRequisite("MINDCLOCKWORK")).setParents("IMPROVED_DISTILLATION").setFlipped().registerResearchItem();
        new ResearchItem("WATERJUG", "ALCHEMY", new AspectList().add(Aspect.WATER, 6).add(Aspect.EARTH, 3).add(Aspect.CRAFT, 3), -5, 4, 1, new ItemStack(BlocksTC.waterJug)).setPages(new ResearchPage("tc.research_page.WATERJUG.1"), new ResearchPage((InfusionRecipe)recipes.get("WaterJug"))).setParents("INFUSION", "ALCHEMICALDUPLICATION").registerResearchItem();
    }

    private static void initGolemancyResearch() {
        ScanningManager.addScannableThing(new ScanEntity("BASICGOLEMANCY", EntityGolem.class, true));
        ScanningManager.addScannableThing(new ScanEntity("BASICGOLEMANCY", EntityOwnedConstruct.class, true));
        new ResearchItem("BASICGOLEMANCY", "GOLEMANCY", new AspectList(), 0, 0, 0, new ResourceLocation("thaumcraft", "textures/research/r_golemancy.png")).setPages(new ResearchPage("tc.research_page.BASICGOLEMANCY.1")).setSiblings("MATSTUDWOOD").setStub().setRound().registerResearchItem();
        new ResearchItem("HUNGRYCHEST", "GOLEMANCY", new AspectList().add(Aspect.DESIRE, 3).add(Aspect.VOID, 3), 0, -3, 1, new ItemStack(BlocksTC.hungryChest)).setPages(new ResearchPage("tc.research_page.HUNGRYCHEST.1"), new ResearchPage((IArcaneRecipe)recipes.get("HungryChest"))).setSecondary().setParents("BASICGOLEMANCY").registerResearchItem();
        new ResearchItem("MATSTUDWOOD", "GOLEMANCY", new AspectList(), -2, 0, 0, new ItemStack(BlocksTC.plank)).setPages(new ResearchPage("tc.research_page.MATSTUDWOOD.1")).setRound().registerResearchItem();
        new ResearchItem("MINDCLOCKWORK", "GOLEMANCY", new AspectList().add(Aspect.MECHANISM, 3).add(Aspect.MIND, 3).add(Aspect.SENSES, 3), 0, 2, 1, new ItemStack(ItemsTC.mind, 1, 0)).setPages(new ResearchPage("tc.research_page.MINDCLOCKWORK.1"), new ResearchPage((IArcaneRecipe)recipes.get("MindClockwork"))).setParents("BASICGOLEMANCY", "!BRAIN").setHidden().registerResearchItem();
        new ResearchItem("MINDBIOTHAUMIC", "GOLEMANCY", new AspectList().add(Aspect.MECHANISM, 3).add(Aspect.MIND, 3).add(Aspect.SENSES, 3).add(Aspect.UNDEAD, 3), 0, 6, 2, new ItemStack(ItemsTC.mind, 1, 1)).setPages(new ResearchPage("tc.research_page.MINDBIOTHAUMIC.1"), new ResearchPage((InfusionRecipe)recipes.get("MindBiothaumic"))).setParents("MINDCLOCKWORK", "INFUSION", "!BRAIN").setSpecial().registerResearchItem();
        ThaumcraftApi.addWarpToResearch("MINDBIOTHAUMIC", 3);
        new ResearchItem("ARCANEBORE", "GOLEMANCY", new AspectList().add(Aspect.EARTH, 6).add(Aspect.MOTION, 3).add(Aspect.MECHANISM, 3).add(Aspect.TOOL, 3), 4, 4, 2, new ItemStack(BlocksTC.arcaneBore)).setPages(new ResearchPage("tc.research_page.ARCANEBORE.1"), new ResearchPage((InfusionRecipe)recipes.get("ArcaneBore")), new ResearchPage("tc.research_page.ARCANEBORE.2"), new ResearchPage((IArcaneRecipe)recipes.get("ArcaneBoreBase")), new ResearchPage("tc.research_page.ARCANEBORE.3")).setParents("INFUSION", "BASICTURRET", "FOCUSEXCAVATION").registerResearchItem();
        new ResearchItem("BASICTURRET", "GOLEMANCY", new AspectList().add(Aspect.MECHANISM, 3).add(Aspect.AVERSION, 3).add(Aspect.SENSES, 3).add(Aspect.MIND, 3), 2, 2, 1, new ItemStack(ItemsTC.turretPlacer, 1, 0)).setPages(new ResearchPage("tc.research_page.BASICTURRET.1"), new ResearchPage((IArcaneRecipe)recipes.get("AutomatedCrossbow"))).setHidden().setParents("MINDCLOCKWORK", "!DISPENSER").registerResearchItem();
        ScanningManager.addScannableThing(new ScanBlock("!DISPENSER", Blocks.field_150367_z));
        ScanningManager.addScannableThing(new ScanItem("!DISPENSER", new ItemStack(Blocks.field_150367_z)));
        new ResearchItem("FOCUSTURRET", "GOLEMANCY", new AspectList().add(Aspect.MECHANISM, 3).add(Aspect.AVERSION, 3).add(Aspect.SENSES, 3).add(Aspect.MIND, 3).add(Aspect.AURA, 3), 2, 6, 2, new ItemStack(ItemsTC.turretPlacer, 1, 1)).setPages(new ResearchPage("tc.research_page.FOCUSTURRET.1"), new ResearchPage((InfusionRecipe)recipes.get("AutoCaster"))).setParents("MINDBIOTHAUMIC", "ARCANEBORE").setFlipped().registerResearchItem();
    }

    private static void initBasicResearch() {
        new ResearchItem("ASPECTS", "BASICS", new AspectList(), 0, 0, 0, new ResourceLocation("thaumcraft", "textures/research/r_aspects.png")).setPages(new ResearchPage("tc.research_page.ASPECTS.1"), new ResearchPage("tc.research_page.ASPECTS.2"), new ResearchPage("tc.research_page.ASPECTS.3")).setStub().setRound().setAutoUnlock().registerResearchItem();
        new ResearchItem("PECH", "BASICS", new AspectList(), -4, -4, 0, new ResourceLocation("thaumcraft", "textures/research/r_pech.png")).setPages(new ResearchPage("tc.research_page.PECH.1"), new ResearchPage("tc.research_page.PECH.2")).setStub().setRound().setAutoUnlock().registerResearchItem();
        new ResearchItem("NODES", "BASICS", new AspectList(), -2, 0, 0, new ResourceLocation("thaumcraft", "textures/research/r_nodes.png")).setPages(new ResearchPage("tc.research_page.NODES.1"), new ResearchPage("tc.research_page.NODES.2"), new ResearchPage("tc.research_page.NODES.3"), new ResearchPage("tc.research_page.NODES.4"), new ResearchPage("tc.research_page.NODES.A").setRequisite("!NODE_ASTRAL"), new ResearchPage("tc.research_page.NODES.D").setRequisite("!NODE_DARK"), new ResearchPage("tc.research_page.NODES.H").setRequisite("!NODE_HUNGRY"), new ResearchPage("tc.research_page.NODES.P").setRequisite("!NODE_PURE"), new ResearchPage("tc.research_page.NODES.T").setRequisite("!NODE_TAINT"), new ResearchPage("tc.research_page.NODES.U").setRequisite("!NODE_UNSTABLE")).setStub().setRound().setAutoUnlock().setSiblings("ASPECTS").registerResearchItem();
        ScanningManager.addScannableThing(new ScanEntity("!NODE_DARK", EntityAuraNode.class, true, new ThaumcraftApi.EntityTagsNBT("type", (byte)1)));
        ScanningManager.addScannableThing(new ScanEntity("!NODE_HUNGRY", EntityAuraNode.class, true, new ThaumcraftApi.EntityTagsNBT("type", (byte)2)));
        ScanningManager.addScannableThing(new ScanEntity("!NODE_PURE", EntityAuraNode.class, true, new ThaumcraftApi.EntityTagsNBT("type", (byte)3)));
        ScanningManager.addScannableThing(new ScanEntity("!NODE_TAINT", EntityAuraNode.class, true, new ThaumcraftApi.EntityTagsNBT("type", (byte)4)));
        ScanningManager.addScannableThing(new ScanEntity("!NODE_UNSTABLE", EntityAuraNode.class, true, new ThaumcraftApi.EntityTagsNBT("type", (byte)5)));
        ScanningManager.addScannableThing(new ScanEntity("!NODE_ASTRAL", EntityAuraNode.class, true, new ThaumcraftApi.EntityTagsNBT("type", (byte)6)));
        new ResearchItem("WARP", "BASICS", new AspectList(), 0, 2, 0, new ResourceLocation("thaumcraft", "textures/research/r_warp.png")).setPages(new ResearchPage("tc.research_page.WARP.1"), new ResearchPage("tc.research_page.WARP.2"), new ResearchPage("tc.research_page.WARP.3")).setStub().setRound().setAutoUnlock().setSiblings("ASPECTS").registerResearchItem();
        new ResearchItem("RESEARCH", "BASICS", new AspectList(), 2, 0, 0, new ItemStack(ItemsTC.scribingTools)).setPages(new ResearchPage("tc.research_page.RESEARCH.1"), new ResearchPage("tc.research_page.RESEARCH.2"), new ResearchPage("tc.research_page.RESEARCH.3"), new ResearchPage("tc.research_page.RESEARCH.4"), new ResearchPage("tc.research_page.RESEARCH.5"), new ResearchPage("tc.research_page.RESEARCH.6"), new ResearchPage("tc.research_page.RESEARCH.7"), new ResearchPage("tc.research_page.RESEARCH.8"), new ResearchPage("tc.research_page.RESEARCH.9"), new ResearchPage("tc.research_page.RESEARCH.10"), new ResearchPage("tc.research_page.RESEARCH.11"), new ResearchPage((IRecipe)recipes.get("Thaumometer")), new ResearchPage("tc.research_page.RESEARCH.12"), new ResearchPage((IRecipe)recipes.get("Scribe1")), new ResearchPage((IRecipe)recipes.get("Scribe2")), new ResearchPage((IRecipe)recipes.get("Scribe3"))).setAutoUnlock().setStub().setRound().setSiblings("ASPECTS").registerResearchItem();
        new ResearchItem("KNOWFRAG", "BASICS", new AspectList(), 3, -2, 0, new ItemStack(ItemsTC.knowledgeFragment)).setPages(new ResearchPage("tc.research_page.KNOWFRAG.1")).setStub().setRound().setAutoUnlock().setSiblings("RESEARCH").registerResearchItem();
        new ResearchItem("THAUMONOMICON", "BASICS", new AspectList(), 1, -2, 0, new ItemStack(ItemsTC.thaumonomicon)).setPages(new ResearchPage("tc.research_page.THAUMONOMICON.1"), new ResearchPage((List)recipes.get("Thaumonomicon"))).setStub().setRound().setAutoUnlock().setSiblings("RESEARCH").registerResearchItem();
        new ResearchItem("ORE", "BASICS", new AspectList(), -2, -4, 0, new ItemStack(BlocksTC.oreCinnabar)).setPages(new ResearchPage("tc.research_page.ORE.1"), new ResearchPage("tc.research_page.ORE.2"), new ResearchPage("tc.research_page.ORE.3"), new ResearchPage("tc.research_page.ORE.4")).setStub().setRound().setAutoUnlock().registerResearchItem();
        ArrayList<InfusionRecipe> rc = new ArrayList<InfusionRecipe>();
        rc.add((InfusionRecipe)recipes.get("ClusterAir"));
        rc.add((InfusionRecipe)recipes.get("ClusterFire"));
        rc.add((InfusionRecipe)recipes.get("ClusterWater"));
        rc.add((InfusionRecipe)recipes.get("ClusterEarth"));
        rc.add((InfusionRecipe)recipes.get("ClusterOrder"));
        rc.add((InfusionRecipe)recipes.get("ClusterEntropy"));
        rc.add((InfusionRecipe)recipes.get("ClusterFlux"));
        new ResearchItem("CRYSTALFARMER", "BASICS", new AspectList().add(Aspect.CRYSTAL, 3).add(Aspect.FLUX, 3).add(Aspect.AIR, 3).add(Aspect.FIRE, 3).add(Aspect.WATER, 3).add(Aspect.EARTH, 3).add(Aspect.ORDER, 3).add(Aspect.ENTROPY, 3), -1, -5, 2, new ItemStack(BlocksTC.crystalAir), new ItemStack(BlocksTC.crystalFire), new ItemStack(BlocksTC.crystalWater), new ItemStack(BlocksTC.crystalEarth), new ItemStack(BlocksTC.crystalOrder), new ItemStack(BlocksTC.crystalEntropy)).setPages(new ResearchPage("tc.research_page.CRYSTALFARMER.1"), new ResearchPage(rc.toArray(new InfusionRecipe[0]))).setHidden().setParents("INFUSION", "ORE", "!vitreus").registerResearchItem();
        new ResearchItem("PLANTS", "BASICS", new AspectList(), -2, -2, 0, new ItemStack(BlocksTC.shimmerleaf, 1, 0)).setPages(new ResearchPage("tc.research_page.PLANTS.1"), new ResearchPage((IRecipe)recipes.get("PlankGreatwood")), new ResearchPage("tc.research_page.PLANTS.2"), new ResearchPage((IRecipe)recipes.get("PlankSilverwood")), new ResearchPage("tc.research_page.PLANTS.3"), new ResearchPage("tc.research_page.PLANTS.4"), new ResearchPage("tc.research_page.PLANTS.5")).setStub().setRound().setAutoUnlock().registerResearchItem();
        new ResearchItem("ENCHANT", "BASICS", new AspectList(), -4, -2, 0, new ResourceLocation("thaumcraft", "textures/research/r_enchant.png")).setPages(new ResearchPage("tc.research_page.ENCHANT.1"), new ResearchPage("tc.research_page.ENCHANT.2")).setStub().setRound().setAutoUnlock().registerResearchItem();
        new ResearchItem("RESEARCHER1", "BASICS", new AspectList().add(Aspect.MIND, 3).add(Aspect.SENSES, 3).add(Aspect.ORDER, 3), 4, 1, 1, new ResourceLocation("thaumcraft", "textures/research/r_researcher1.png")).setPages(new ResearchPage("tc.research_page.RESEARCHER1.1")).setRound().setParents("RESEARCH").registerResearchItem();
        new ResearchItem("RESEARCHER2", "BASICS", new AspectList().add(Aspect.MIND, 6).add(Aspect.ORDER, 3).add(Aspect.SENSES, 3).add(Aspect.ENERGY, 3), 3, 3, 2, new ResourceLocation("thaumcraft", "textures/research/r_researcher2.png")).setPages(new ResearchPage("tc.research_page.RESEARCHER2.1")).setRound().setSpecial().setParents("RESEARCHER1").registerResearchItem();
        ThaumcraftApi.addWarpToResearch("RESEARCHER2", 1);
    }

    private static void initEldritchResearch() {
        new ResearchItem("CRIMSON", "ELDRITCH", new AspectList(), 0, 2, 0, new ItemStack(ItemsTC.crimsonRites)).setPages(new ResearchPage("tc.research_page.CRIMSON.1")).setStub().setHidden().setRound().setSiblings("ELDRITCHMINOR").registerResearchItem();
        ThaumcraftApi.addWarpToResearch("CRIMSON", 3);
        new ResearchItem("ELDRITCHMINOR", "ELDRITCH", new AspectList(), 1, 0, 0, new ResourceLocation("thaumcraft", "textures/research/r_eldritchminor.png")).setPages(new ResearchPage("tc.research_page.ELDRITCHMINOR.1"), new ResearchPage((CrucibleRecipe)recipes.get("VoidSeed"))).setStub().setHidden().setRound().setSpecial().registerResearchItem();
        new ResearchItem("ELDRITCHMAJOR", "ELDRITCH", new AspectList(), -1, 0, 0, new ResourceLocation("thaumcraft", "textures/research/r_eldritchmajor.png")).setPages(new ResearchPage("tc.research_page.ELDRITCHMAJOR.1"), new ResearchPage("tc.research_page.ELDRITCHMAJOR.2")).setStub().setHidden().setRound().setSpecial().registerResearchItem();
        new ResearchItem("OCULUS", "ELDRITCH", new AspectList().add(Aspect.MIND, 3).add(Aspect.DARKNESS, 3).add(Aspect.EXCHANGE, 3).add(Aspect.MOTION, 6).add(Aspect.ELDRITCH, 6), -2, 3, 1, new ItemStack(ItemsTC.eldritchEye)).setPages(new ResearchPage("tc.research_page.OCULUS.1"), new ResearchPage((InfusionRecipe)recipes.get("EldritchEye")), new ResearchPage("tc.research_page.OCULUS.2")).setRound().setHidden().setParents("CRIMSON", "ELDRITCHMAJOR").registerResearchItem();
        ThaumcraftApi.addWarpToResearch("OCULUS", 6);
        new ResearchItem("SINSTONE", "ELDRITCH", new AspectList().add(Aspect.SENSES, 3).add(Aspect.DARKNESS, 3).add(Aspect.ELDRITCH, 3).add(Aspect.AURA, 3), -1, 4, 1, new ItemStack(ItemsTC.sinisterStone)).setPages(new ResearchPage("tc.research_page.SINSTONE.1"), new ResearchPage((InfusionRecipe)recipes.get("SinStone"))).setParents("GOGGLES", "INFUSION", "OCULUS").setHidden().registerResearchItem();
        ThaumcraftApi.addWarpToResearch("SINSTONE", 2);
        ThaumcraftApi.addWarpToItem(new ItemStack(ItemsTC.sinisterStone), 1);
        new ResearchItem("ENTEROUTER", "ELDRITCH", new AspectList(), -3, 4, 1, new ResourceLocation("thaumcraft", "textures/research/r_outer.png")).setPages(new ResearchPage("tc.research_page.ENTEROUTER.1")).setStub().setHidden().setRound().setParents("OCULUS").registerResearchItem();
        new ResearchItem("OUTERREV", "ELDRITCH", new AspectList(), -4, 5, 0, new ItemStack(ItemsTC.runedTablet)).setPages(new ResearchPage("tc.research_page.OUTERREV.1")).setRound().setHidden().setSpecial().setParents("ENTEROUTER", "!ORBOSS", "!ORMOB", "!ORBLOCK1", "!ORBLOCK2").registerResearchItem();
        ScanningManager.addScannableThing(new ScanEntity("!ORMOB", IEldritchMob.class, true));
        ScanningManager.addScannableThing(new ScanEntity("!ORBOSS", EntityThaumcraftBoss.class, true));
        ScanningManager.addScannableThing(new ScanEntity("OUTERREV", EntityThaumcraftBoss.class, true));
        ScanningManager.addScannableThing(new ScanBlockState("!ORBLOCK1", BlocksTC.stone.func_176203_a(2), true));
        ScanningManager.addScannableThing(new ScanBlockState("!ORBLOCK2", BlocksTC.stone.func_176203_a(4), true));
        ScanningManager.addScannableThing(new ScanBlockState("OUTERREV", BlocksTC.stone.func_176203_a(11), true));
        new ResearchItem("PRIMPEARL", "ELDRITCH", new AspectList().add(Aspect.ENERGY, 9).add(Aspect.ELDRITCH, 9).add(Aspect.ORDER, 9), 2, 3, 2, new ItemStack(ItemsTC.primordialPearl)).setPages(new ResearchPage("tc.research_page.PRIMPEARL.1"), new ResearchPage("tc.research_page.PRIMPEARL.2")).setHidden().setParents("ELDRITCHMINOR", "!PRIMPEARL").registerResearchItem();
        ScanningManager.addScannableThing(new ScanItem("!PRIMPEARL", new ItemStack(ItemsTC.primordialPearl)));
        new ResearchItem("PRIMALCRUSHER", "ELDRITCH", new AspectList().add(Aspect.EARTH, 6).add(Aspect.TOOL, 6).add(Aspect.ENTROPY, 6).add(Aspect.VOID, 6).add(Aspect.AVERSION, 6).add(Aspect.ELDRITCH, 6).add(Aspect.DESIRE, 6), 1, 5, 2, new ItemStack(ItemsTC.primalCrusher)).setPages(new ResearchPage("tc.research_page.PRIMALCRUSHER.1"), new ResearchPage((InfusionRecipe)recipes.get("PrimalCrusher")), new ResearchPage("tc.research_page.PRIMALCRUSHER.2")).setHidden().setParents("PRIMPEARL").setParentsHidden("VOIDMETAL", "ELEMENTALTOOLS").registerResearchItem();
        new ResearchItem("SANITYCHECK", "ELDRITCH", new AspectList().add(Aspect.MIND, 5).add(Aspect.ELDRITCH, 3).add(Aspect.SENSES, 5), 3, -1, 1, new ItemStack(ItemsTC.sanityChecker)).setPages(new ResearchPage("tc.research_page.SANITYCHECK.1"), new ResearchPage((InfusionRecipe)recipes.get("SanityCheck"))).setParents("ELDRITCHMINOR").registerResearchItem();
        new ResearchItem("VOIDMETAL", "ELDRITCH", new AspectList().add(Aspect.METAL, 3).add(Aspect.ELDRITCH, 3).add(Aspect.VOID, 5).merge(Aspect.FLUX, 3), 1, -2, 2, new ItemStack(ItemsTC.ingots, 1, 1)).setPages(new ResearchPage("tc.research_page.VOIDMETAL.1"), new ResearchPage((CrucibleRecipe)recipes.get("VoidMetal")), new ResearchPage("tc.research_page.VOIDMETAL.2"), new ResearchPage((IRecipe)recipes.get("VoidGear")), new ResearchPage((IRecipe)recipes.get("VoidPlate")), new ResearchPage((IRecipe)recipes.get("VoidAxe")), new ResearchPage((IRecipe)recipes.get("VoidSword")), new ResearchPage((IRecipe)recipes.get("VoidPick")), new ResearchPage((IRecipe)recipes.get("VoidShovel")), new ResearchPage((IRecipe)recipes.get("VoidHoe")), new ResearchPage((IRecipe)recipes.get("VoidHelm")), new ResearchPage((IRecipe)recipes.get("VoidChest")), new ResearchPage((IRecipe)recipes.get("VoidLegs")), new ResearchPage((IRecipe)recipes.get("VoidBoots"))).setParents("METALLURGY", "ELDRITCHMINOR").registerResearchItem();
        new ResearchItem("CAP_void", "ELDRITCH", new AspectList().add(Aspect.VOID, 5).add(Aspect.ELDRITCH, 5).add(Aspect.TOOL, 3).add(Aspect.ENERGY, 3).add(Aspect.AURA, 3), 3, -3, 3, new ItemStack(ItemsTC.wandCaps, 1, 6)).setPages(new ResearchPage("tc.research_page.CAP_void.1"), new ResearchPage((IArcaneRecipe)recipes.get("WandCapVoidInert")), new ResearchPage((InfusionRecipe)recipes.get("WandCapVoid"))).setHidden().setParents("CAP_thaumium", "VOIDMETAL").registerResearchItem();
        ThaumcraftApi.addWarpToResearch("CAP_void", 1);
        new ResearchItem("ARMORVOIDFORTRESS", "ELDRITCH", new AspectList().add(Aspect.PROTECT, 3).add(Aspect.VOID, 6).add(Aspect.ELDRITCH, 9).add(Aspect.SOUL, 6), -1, -3, 2, new ItemStack(ItemsTC.voidRobeHelm)).setPages(new ResearchPage("tc.research_page.ARMORVOIDFORTRESS.1"), new ResearchPage((InfusionRecipe)recipes.get("VoidRobeHelm")), new ResearchPage((InfusionRecipe)recipes.get("VoidRobeChest")), new ResearchPage((InfusionRecipe)recipes.get("VoidRobeLegs"))).setParents("VOIDMETAL", "ENCHFABRIC", "ELDRITCHMAJOR").setHidden().registerResearchItem();
        new ResearchItem("FOCUSPRIMAL", "ELDRITCH", new AspectList().add(Aspect.AIR, 6).add(Aspect.WATER, 6).add(Aspect.FIRE, 6).add(Aspect.EARTH, 6).add(Aspect.ORDER, 6).add(Aspect.ENTROPY, 6).add(Aspect.ENERGY, 6), 4, 1, 2, new ItemStack(ItemsTC.focusPrimal)).setPages(new ResearchPage("tc.research_page.FOCUSPRIMAL.1"), new ResearchPage((IArcaneRecipe)recipes.get("FocusPrimal"))).setHidden().setParents("ELDRITCHMINOR").registerResearchItem();
        ThaumcraftApi.addWarpToResearch("FOCUSPRIMAL", 2);
        ThaumcraftApi.addWarpToItem(new ItemStack(ItemsTC.focusPrimal), 1);
        new ResearchItem("ROD_primal_staff", "ELDRITCH", new AspectList().add(Aspect.AIR, 9).add(Aspect.EARTH, 9).add(Aspect.FIRE, 9).add(Aspect.WATER, 9).add(Aspect.ORDER, 9).add(Aspect.ENTROPY, 9).add(Aspect.TOOL, 9).add(Aspect.ENERGY, 12), 6, 2, 3, new ItemStack(ItemsTC.wandRods, 1, 16)).setPages(new ResearchPage("tc.research_page.ROD_primal_staff.1"), new ResearchPage((InfusionRecipe)recipes.get("WandRodPrimalStaff"))).setParents("FOCUSPRIMAL").setParentsHidden("ROD_silverwood_staff", "ROD_bone_staff", "ROD_greatwood_staff", "ROD_blaze_staff", "ROD_reed_staff", "ROD_obsidian_staff", "ROD_quartz_staff", "ROD_ice_staff").registerResearchItem();
        ThaumcraftApi.addWarpToResearch("ROD_primal_staff", 3);
        ThaumcraftApi.addWarpToItem(new ItemStack(ItemsTC.wandRods, 1, 16), 1);
    }
}

