/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.construct.golem;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import thaumcraft.common.entities.construct.golem.TaskHandler;
import thaumcraft.common.entities.construct.golem.seals.SealEntity;

public class Task {
    private UUID golemUUID;
    private int id;
    private byte type;
    private BlockPos pos;
    private Entity entity;
    private UUID entityUUID;
    private boolean reserved;
    private boolean waitOnSuspension;
    private boolean suspended;
    private boolean completed;
    private long expireTime;

    public static Task readNBT(NBTTagCompound nbt) {
        Task task = new Task();
        task.id = nbt.func_74762_e("id");
        task.type = nbt.func_74771_c("type");
        if (nbt.func_150297_b("pos", 4)) {
            task.pos = BlockPos.func_177969_a((long)nbt.func_74763_f("pos"));
        }
        if (nbt.func_150297_b("GUUIDMost", 4) && nbt.func_150297_b("GUUIDLeast", 4)) {
            task.golemUUID = new UUID(nbt.func_74763_f("GUUIDMost"), nbt.func_74763_f("GUUIDLeast"));
        }
        if (nbt.func_150297_b("EUUIDMost", 4) && nbt.func_150297_b("EUUIDLeast", 4)) {
            task.entityUUID = new UUID(nbt.func_74763_f("EUUIDMost"), nbt.func_74763_f("EUUIDLeast"));
        }
        if (task.pos == null && task.entityUUID == null) {
            return null;
        }
        task.reserved = nbt.func_74767_n("reserved");
        task.waitOnSuspension = nbt.func_74767_n("wos");
        task.suspended = false;
        task.completed = nbt.func_74767_n("completed");
        task.expireTime = System.currentTimeMillis() + 300000L;
        if (nbt.func_150297_b("sealpos", 10)) {
            NBTTagCompound sealpos = nbt.func_74775_l("sealpos");
            SealEntity.SealPos sp = new SealEntity.SealPos(BlockPos.func_177969_a((long)nbt.func_74763_f("pos")), EnumFacing.field_82609_l[nbt.func_74771_c("face")]);
            TaskHandler.sealTaskCrossRef.put(task.id, sp);
        }
        return task;
    }

    public static NBTTagCompound writeNBT(Task task) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("id", task.id);
        nbt.func_74774_a("type", task.type);
        if (task.pos != null) {
            nbt.func_74772_a("pos", task.pos.func_177986_g());
        }
        if (task.entity != null) {
            nbt.func_74772_a("EUUIDMost", task.entity.func_110124_au().getMostSignificantBits());
            nbt.func_74772_a("EUUIDLeast", task.entity.func_110124_au().getLeastSignificantBits());
        }
        if (task.golemUUID != null) {
            nbt.func_74772_a("GUUIDMost", task.golemUUID.getMostSignificantBits());
            nbt.func_74772_a("GUUIDLeast", task.golemUUID.getLeastSignificantBits());
        }
        nbt.func_74757_a("reserved", task.reserved);
        nbt.func_74757_a("wos", task.waitOnSuspension);
        nbt.func_74757_a("completed", task.completed);
        SealEntity.SealPos sp = TaskHandler.sealTaskCrossRef.get(task.getId());
        if (sp != null) {
            NBTTagCompound sealpos = new NBTTagCompound();
            sealpos.func_74772_a("pos", sp.pos.func_177986_g());
            sealpos.func_74774_a("face", (byte)sp.face.ordinal());
            nbt.func_74782_a("sealpos", (NBTBase)sealpos);
        }
        return nbt;
    }

    private Task() {
    }

    public Task(int id, BlockPos pos, boolean wait) {
        this.pos = pos;
        this.id = id;
        this.type = 0;
        this.waitOnSuspension = wait;
        this.expireTime = System.currentTimeMillis() + 300000L;
    }

    public Task(int id, Entity entity, boolean wait) {
        this.entity = entity;
        this.entityUUID = entity.func_110124_au();
        this.id = id;
        this.type = 1;
        this.waitOnSuspension = wait;
        this.expireTime = System.currentTimeMillis() + 300000L;
    }

    public UUID getEntityUUID() {
        return this.entityUUID;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompletion(boolean fulfilled) {
        this.completed = fulfilled;
        this.expireTime += 60000L;
    }

    public boolean waitOnSuspension() {
        return this.waitOnSuspension;
    }

    public UUID getGolemUUID() {
        return this.golemUUID;
    }

    public void setGolemUUID(UUID golemUUID) {
        this.golemUUID = golemUUID;
    }

    public BlockPos getPos() {
        return this.type == 1 ? this.entity.func_180425_c() : this.pos;
    }

    public byte getType() {
        return this.type;
    }

    public Entity getEntity() {
        if (this.entity != null || this.entityUUID != null) {
            // empty if block
        }
        return this.entity;
    }

    public int getId() {
        return this.id;
    }

    public boolean isReserved() {
        return this.reserved;
    }

    public void setReserved(boolean res) {
        this.reserved = res;
        this.expireTime += 60000L;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void setSuspended(boolean suspended) {
        this.suspended = suspended;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Task)) {
            return false;
        }
        Task t = (Task)o;
        return t.id == this.id;
    }

    public long getExpireTime() {
        return this.expireTime;
    }
}

