/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.construct.golem;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import thaumcraft.common.entities.construct.golem.EntityThaumcraftGolem;
import thaumcraft.common.entities.construct.golem.Task;
import thaumcraft.common.entities.construct.golem.seals.SealEntity;
import thaumcraft.common.entities.construct.golem.seals.SealHandler;

public class TaskHandler {
    public static ConcurrentHashMap<Integer, ConcurrentHashMap<Integer, Task>> tasks = new ConcurrentHashMap();
    public static ConcurrentHashMap<Integer, SealEntity.SealPos> sealTaskCrossRef = new ConcurrentHashMap();

    public static void addTask(int dim, Task ticket) {
        TaskHandler.addTask(dim, null, ticket);
    }

    public static void addTask(int dim, SealEntity.SealPos sealPos, Task ticket) {
        if (!tasks.containsKey(dim)) {
            tasks.put(dim, new ConcurrentHashMap());
        }
        ConcurrentHashMap<Integer, Task> dc = tasks.get(dim);
        dc.put(ticket.getId(), ticket);
        if (sealPos != null) {
            sealTaskCrossRef.put(ticket.getId(), sealPos);
        }
    }

    public static Task getTask(int dim, int id) {
        return TaskHandler.getTasks(dim).get(id);
    }

    public static ConcurrentHashMap<Integer, Task> getTasks(int dim) {
        if (!tasks.containsKey(dim)) {
            tasks.put(dim, new ConcurrentHashMap());
        }
        return tasks.get(dim);
    }

    public static ArrayList<Task> getBlockTasksSorted(int dim, UUID uuid, Entity target) {
        ConcurrentHashMap<Integer, Task> tickets = TaskHandler.getTasks(dim);
        ArrayList<Task> out = new ArrayList<Task>();
        block0: for (Task ticket : tickets.values()) {
            if (ticket.isReserved() || ticket.getType() != 0 || uuid != null && ticket.getGolemUUID() != null && !uuid.equals(ticket.getGolemUUID())) continue;
            if (out.size() == 0) {
                out.add(ticket);
                continue;
            }
            double d = ticket.getPos().func_177957_d(target.field_70165_t, target.field_70163_u, target.field_70161_v);
            for (int a = 0; a < out.size(); ++a) {
                double d1 = out.get(a).getPos().func_177957_d(target.field_70165_t, target.field_70163_u, target.field_70161_v);
                if (!(d < d1)) continue;
                out.add(a, ticket);
                continue block0;
            }
            out.add(ticket);
        }
        return out;
    }

    public static ArrayList<Task> getEntityTasksSorted(int dim, UUID uuid, Entity target) {
        ConcurrentHashMap<Integer, Task> tickets = TaskHandler.getTasks(dim);
        ArrayList<Task> out = new ArrayList<Task>();
        block0: for (Task ticket : tickets.values()) {
            if (ticket.isReserved() || ticket.getType() != 1 || uuid != null && ticket.getGolemUUID() != null && !uuid.equals(ticket.getGolemUUID())) continue;
            if (out.size() == 0) {
                out.add(ticket);
                continue;
            }
            double d = ticket.getPos().func_177957_d(target.field_70165_t, target.field_70163_u, target.field_70161_v);
            for (int a = 0; a < out.size(); ++a) {
                double d1 = out.get(a).getPos().func_177957_d(target.field_70165_t, target.field_70163_u, target.field_70161_v);
                if (!(d < d1)) continue;
                out.add(a, ticket);
                continue block0;
            }
            out.add(ticket);
        }
        return out;
    }

    public static void completeTask(Task task, EntityThaumcraftGolem golem) {
        if (task.isCompleted() || task.isSuspended()) {
            return;
        }
        SealEntity.SealPos sp = sealTaskCrossRef.get(task.getId());
        if (sp != null) {
            SealEntity se = SealHandler.getSealEntity(golem.field_70170_p.field_73011_w.func_177502_q(), sp);
            if (se != null) {
                task.setCompletion(se.getSeal().onTaskCompletion(golem.field_70170_p, sp, golem, task));
            }
        } else {
            task.setCompletion(true);
        }
    }

    public static void clearSuspendedOrExpiredTasks(World world) {
        long time = System.currentTimeMillis();
        ConcurrentHashMap<Integer, Task> tickets = TaskHandler.getTasks(world.field_73011_w.func_177502_q());
        ConcurrentHashMap<Integer, Task> temp = new ConcurrentHashMap<Integer, Task>();
        for (Task ticket : tickets.values()) {
            if (!ticket.isSuspended() && ticket.getExpireTime() > time) {
                temp.put(ticket.getId(), ticket);
                continue;
            }
            if (!sealTaskCrossRef.containsKey(ticket.getId())) continue;
            SealEntity.SealPos sp = sealTaskCrossRef.get(ticket.getId());
            try {
                SealHandler.getSealEntity(world.field_73011_w.func_177502_q(), sp).getSeal().onTaskSuspension(world, sp, ticket);
            }
            catch (Exception e) {
                // empty catch block
            }
            sealTaskCrossRef.remove(ticket.getId());
        }
        tasks.put(world.field_73011_w.func_177502_q(), temp);
    }

    public static void loadTasks(World world) {
        tasks.remove(world.field_73011_w.func_177502_q());
        File file1 = new File(world.func_72860_G().func_75765_b(), "golem_tasks_" + world.field_73011_w.func_177502_q() + ".dat");
        if (file1.exists()) {
            try {
                NBTTagCompound nbttagcompound = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file1));
                NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("Data");
                TaskHandler.readNBT(nbttagcompound1, world.field_73011_w.func_177502_q());
                return;
            }
            catch (Exception exception1) {
                exception1.printStackTrace();
            }
        }
        if ((file1 = new File(world.func_72860_G().func_75765_b(), "golem_tasks_" + world.field_73011_w.func_177502_q() + ".dat_old")).exists()) {
            try {
                NBTTagCompound nbttagcompound = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file1));
                NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("Data");
                TaskHandler.readNBT(nbttagcompound1, world.field_73011_w.func_177502_q());
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void saveTasks(World world) {
        NBTTagCompound nbttagcompound = TaskHandler.writeNBT(world.field_73011_w.func_177502_q());
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        nbttagcompound1.func_74782_a("Data", (NBTBase)nbttagcompound);
        try {
            File file1 = new File(world.func_72860_G().func_75765_b(), "golem_tasks_" + world.field_73011_w.func_177502_q() + ".dat_new");
            File file2 = new File(world.func_72860_G().func_75765_b(), "golem_tasks_" + world.field_73011_w.func_177502_q() + ".dat_old");
            File file3 = new File(world.func_72860_G().func_75765_b(), "golem_tasks_" + world.field_73011_w.func_177502_q() + ".dat");
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbttagcompound1, (OutputStream)new FileOutputStream(file1));
            if (file2.exists()) {
                file2.delete();
            }
            file3.renameTo(file2);
            if (file3.exists()) {
                file3.delete();
            }
            file1.renameTo(file3);
            if (file1.exists()) {
                file1.delete();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void readNBT(NBTTagCompound nbt, int dim) {
        NBTTagList tagList = nbt.func_150295_c("tasks", 10);
        for (int a = 0; a < tagList.func_74745_c(); ++a) {
            NBTTagCompound tasknbt = tagList.func_150305_b(a);
            Task task = Task.readNBT(tasknbt);
            TaskHandler.addTask(dim, task);
        }
        System.out.println("Loaded " + tagList.func_74745_c() + " tasks for dim " + dim);
    }

    private static NBTTagCompound writeNBT(int dim) {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList tagList = new NBTTagList();
        for (Task task : TaskHandler.getTasks(dim).values()) {
            if (task.isSuspended()) continue;
            NBTTagCompound tn = Task.writeNBT(task);
            tagList.func_74742_a((NBTBase)tn);
        }
        nbt.func_74782_a("tasks", (NBTBase)tagList);
        System.out.println("Saving " + tagList.func_74745_c() + " tasks for dim " + dim);
        return nbt;
    }
}

