/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.baubles;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.items.IRechargable;
import thaumcraft.api.items.IRunicArmor;
import thaumcraft.api.wands.IWand;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.items.IVariantItems;
import thaumcraft.common.lib.aura.AuraHandler;
import thaumcraft.common.lib.events.PlayerEvents;

public class ItemAmuletVis
extends Item
implements IBauble,
IRunicArmor,
IVariantItems,
IRechargable {
    public ItemAmuletVis() {
        this.field_77777_bU = 1;
        this.canRepair = false;
        this.func_77656_e(0);
        this.func_77637_a(Thaumcraft.tabTC);
        this.func_77627_a(true);
    }

    @Override
    public String[] getVariantNames() {
        return new String[]{"found", "crafted"};
    }

    @Override
    public int[] getVariantMeta() {
        return new int[]{0, 1};
    }

    public EnumRarity func_77613_e(ItemStack itemstack) {
        return itemstack.func_77952_i() == 0 ? EnumRarity.UNCOMMON : EnumRarity.RARE;
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + stack.func_77952_i();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack((Item)this, 1, 0));
        par3List.add(new ItemStack((Item)this, 1, 1));
    }

    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.AMULET;
    }

    @Override
    public Aspect handleRecharge(World world, ItemStack itemstack, BlockPos pos, EntityPlayer player, int amount) {
        AspectList al = this.getAspectsWithRoom(itemstack);
        for (Aspect aspect : al.getAspectsSortedByAmount()) {
            int amt;
            int drained;
            if (aspect == null || (drained = AuraHandler.drainAuraAvailable(world, pos, aspect, amt = Math.min(amount, al.getAmount(aspect)))) <= 0) continue;
            this.addVis(itemstack, aspect, drained, true);
            if ((amount -= drained) > 0) continue;
            return aspect;
        }
        return null;
    }

    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
        if (player instanceof EntityPlayer && !player.field_70170_p.field_72995_K && player.field_70173_aa % 5 == 0) {
            ItemStack[] inv = ((EntityPlayer)player).field_71071_by.field_70462_a;
            int a = 0;
            while (true) {
                EntityPlayer entityPlayer = (EntityPlayer)player;
                if (a >= entityPlayer.field_71071_by.func_70451_h()) break;
                if (inv[a] != null && inv[a].func_77973_b() instanceof IWand) {
                    IWand wand = (IWand)inv[a].func_77973_b();
                    AspectList al = wand.getAspectsWithRoom(inv[a]);
                    for (Aspect aspect : al.getAspects()) {
                        if (aspect == null || this.getVis(itemstack, aspect) <= 0) continue;
                        this.storeVis(itemstack, aspect, this.getVis(itemstack, aspect) - 1);
                        wand.addVis(inv[a], aspect, 1, true);
                    }
                }
                ++a;
            }
            this.handleRecharge(player.field_70170_p, itemstack, new BlockPos((Entity)player), (EntityPlayer)player, 1);
        }
    }

    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
        PlayerEvents.markRunicDirty((Entity)player);
    }

    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
        PlayerEvents.markRunicDirty((Entity)player);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        if (stack.func_77952_i() == 0) {
            list.add(EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"item.amulet_vis.text"));
        }
        list.add(EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"item.capacity.text") + " " + this.getMaxVis(stack));
        if (stack.func_77942_o()) {
            for (Aspect aspect : Aspect.getPrimalAspects()) {
                if (!stack.func_77978_p().func_74764_b(aspect.getTag())) continue;
                String amount = "" + stack.func_77978_p().func_74762_e(aspect.getTag());
                list.add(" \u00a7" + aspect.getChatcolor() + aspect.getName() + "\u00a7r x " + amount);
            }
        }
    }

    public int getMaxVis(ItemStack stack) {
        return stack.func_77952_i() == 1 ? 1000 : 100;
    }

    public int getVis(ItemStack is, Aspect aspect) {
        int out = 0;
        if (is.func_77942_o() && is.func_77978_p().func_74764_b(aspect.getTag())) {
            out = is.func_77978_p().func_74762_e(aspect.getTag());
        }
        return out;
    }

    public void storeVis(ItemStack is, Aspect aspect, int amount) {
        is.func_77983_a(aspect.getTag(), (NBTBase)new NBTTagInt(amount));
    }

    public AspectList getAspectsWithRoom(ItemStack wandstack) {
        AspectList out = new AspectList();
        AspectList cur = this.getAllVis(wandstack);
        for (Aspect aspect : cur.getAspects()) {
            if (cur.getAmount(aspect) >= this.getMaxVis(wandstack)) continue;
            out.add(aspect, this.getMaxVis(wandstack) - cur.getAmount(aspect));
        }
        return out;
    }

    @Override
    public AspectList getAspectsInChargable(ItemStack is) {
        return this.getAllVis(is);
    }

    public AspectList getAllVis(ItemStack is) {
        AspectList out = new AspectList();
        for (Aspect aspect : Aspect.getPrimalAspects()) {
            if (is.func_77942_o() && is.func_77978_p().func_74764_b(aspect.getTag())) {
                out.merge(aspect, is.func_77978_p().func_74762_e(aspect.getTag()));
                continue;
            }
            out.merge(aspect, 0);
        }
        return out;
    }

    public boolean consumeAllVis(ItemStack is, EntityPlayer player, AspectList aspects, boolean doit, boolean crafting) {
        if (aspects == null || aspects.size() == 0) {
            return false;
        }
        for (Aspect aspect : aspects.getAspects()) {
            if (this.getVis(is, aspect) >= aspects.getAmount(aspect)) continue;
            return false;
        }
        if (doit) {
            for (Aspect aspect : aspects.getAspects()) {
                this.storeVis(is, aspect, this.getVis(is, aspect) - aspects.getAmount(aspect));
            }
        }
        return true;
    }

    public int addVis(ItemStack is, Aspect aspect, int amount, boolean doit) {
        if (!aspect.isPrimal()) {
            return 0;
        }
        int storeAmount = this.getVis(is, aspect) + amount;
        int leftover = Math.max(storeAmount - this.getMaxVis(is), 0);
        if (doit) {
            this.storeVis(is, aspect, Math.min(storeAmount, this.getMaxVis(is)));
        }
        return leftover;
    }

    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Override
    public int getRunicCharge(ItemStack itemstack) {
        return 0;
    }
}

