/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.wands;

import baubles.api.BaublesApi;
import java.util.HashMap;
import java.util.TreeMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.items.IArchitect;
import thaumcraft.api.items.IVisDiscountGear;
import thaumcraft.api.research.ResearchHelper;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.IWand;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.config.Config;
import thaumcraft.common.items.baubles.ItemAmuletVis;
import thaumcraft.common.items.wands.ItemFocusPouch;
import thaumcraft.common.items.wands.WandTriggers;
import thaumcraft.common.items.wands.foci.ItemFocusTrade;

public class WandManager {
    public WandTriggers triggers = new WandTriggers();
    static HashMap<Integer, Long> cooldownServer = new HashMap();
    static HashMap<Integer, Long> cooldownClient = new HashMap();

    public static int getBaseChargeRate(EntityPlayer player, boolean currentItem, int slot) {
        return ResearchHelper.isResearchComplete(player.func_70005_c_(), "NODETAPPER2") ? 3 : (ResearchHelper.isResearchComplete(player.func_70005_c_(), "NODETAPPER1") && slot < 9 ? 2 : (currentItem ? 1 : 0));
    }

    public static float getTotalVisDiscount(EntityPlayer player, Aspect aspect) {
        int a;
        int total = 0;
        if (player == null) {
            return 0.0f;
        }
        IInventory baubles = BaublesApi.getBaubles((EntityPlayer)player);
        for (a = 0; a < 4; ++a) {
            if (baubles.func_70301_a(a) == null || !(baubles.func_70301_a(a).func_77973_b() instanceof IVisDiscountGear)) continue;
            total += ((IVisDiscountGear)baubles.func_70301_a(a).func_77973_b()).getVisDiscount(baubles.func_70301_a(a), player, aspect);
        }
        for (a = 0; a < 4; ++a) {
            if (player.field_71071_by.func_70440_f(a) == null || !(player.field_71071_by.func_70440_f(a).func_77973_b() instanceof IVisDiscountGear)) continue;
            total += ((IVisDiscountGear)player.field_71071_by.func_70440_f(a).func_77973_b()).getVisDiscount(player.field_71071_by.func_70440_f(a), player, aspect);
        }
        if (player.func_82165_m(Config.potionVisExhaustID) || player.func_82165_m(Config.potionInfVisExhaustID)) {
            int level1 = 0;
            int level2 = 0;
            if (player.func_82165_m(Config.potionVisExhaustID)) {
                level1 = player.func_70660_b(Potion.field_76425_a[Config.potionVisExhaustID]).func_76458_c();
            }
            if (player.func_82165_m(Config.potionInfVisExhaustID)) {
                level2 = player.func_70660_b(Potion.field_76425_a[Config.potionInfVisExhaustID]).func_76458_c();
            }
            total -= (Math.max(level1, level2) + 1) * 10;
        }
        return (float)total / 100.0f;
    }

    public static boolean consumeVisFromInventory(EntityPlayer player, AspectList cost) {
        int a;
        IInventory baubles = BaublesApi.getBaubles((EntityPlayer)player);
        for (a = 0; a < 4; ++a) {
            boolean done;
            if (baubles.func_70301_a(a) == null || !(baubles.func_70301_a(a).func_77973_b() instanceof ItemAmuletVis) || !(done = ((ItemAmuletVis)baubles.func_70301_a(a).func_77973_b()).consumeAllVis(baubles.func_70301_a(a), player, cost, true, true))) continue;
            return true;
        }
        for (a = player.field_71071_by.field_70462_a.length - 1; a >= 0; --a) {
            boolean done;
            ItemStack item = player.field_71071_by.field_70462_a[a];
            if (item == null || !(item.func_77973_b() instanceof IWand) || !(done = ((IWand)item.func_77973_b()).consumeAllVis(item, player, cost, true, true))) continue;
            return true;
        }
        return false;
    }

    public static void changeFocus(ItemStack is, World w, EntityPlayer player, String focus) {
        int q;
        ItemStack[] inv;
        int a;
        IWand wand = (IWand)is.func_77973_b();
        TreeMap<String, Integer> foci = new TreeMap<String, Integer>();
        HashMap<Integer, Integer> pouches = new HashMap<Integer, Integer>();
        int pouchcount = 0;
        ItemStack item = null;
        IInventory baubles = BaublesApi.getBaubles((EntityPlayer)player);
        for (a = 0; a < 4; ++a) {
            if (baubles.func_70301_a(a) == null || !(baubles.func_70301_a(a).func_77973_b() instanceof ItemFocusPouch)) continue;
            item = baubles.func_70301_a(a);
            pouches.put(++pouchcount, a - 4);
            inv = ((ItemFocusPouch)item.func_77973_b()).getInventory(item);
            for (q = 0; q < inv.length; ++q) {
                item = inv[q];
                if (item == null || !(item.func_77973_b() instanceof ItemFocusBasic)) continue;
                foci.put(((ItemFocusBasic)item.func_77973_b()).getSortingHelper(item), q + pouchcount * 1000);
            }
        }
        for (a = 0; a < 36; ++a) {
            item = player.field_71071_by.field_70462_a[a];
            if (item != null && item.func_77973_b() instanceof ItemFocusBasic) {
                foci.put(((ItemFocusBasic)item.func_77973_b()).getSortingHelper(item), a);
            }
            if (item == null || !(item.func_77973_b() instanceof ItemFocusPouch)) continue;
            pouches.put(++pouchcount, a);
            inv = ((ItemFocusPouch)item.func_77973_b()).getInventory(item);
            for (q = 0; q < inv.length; ++q) {
                item = inv[q];
                if (item == null || !(item.func_77973_b() instanceof ItemFocusBasic)) continue;
                foci.put(((ItemFocusBasic)item.func_77973_b()).getSortingHelper(item), q + pouchcount * 1000);
            }
        }
        if (focus.equals("REMOVE") || foci.size() == 0) {
            if (wand.getFocus(is) != null && (WandManager.addFocusToPouch(player, wand.getFocusStack(is).func_77946_l(), pouches) || player.field_71071_by.func_70441_a(wand.getFocusStack(is).func_77946_l()))) {
                wand.setFocus(is, null);
                w.func_72956_a((Entity)player, "thaumcraft:cameraticks", 0.3f, 0.9f);
            }
            return;
        }
        if (foci != null && foci.size() > 0 && focus != null) {
            String newkey = focus;
            if (foci.get(newkey) == null) {
                newkey = foci.higherKey(newkey);
            }
            if (newkey == null || foci.get(newkey) == null) {
                newkey = (String)foci.firstKey();
            }
            if ((Integer)foci.get(newkey) < 1000 && (Integer)foci.get(newkey) >= 0) {
                item = player.field_71071_by.field_70462_a[(Integer)foci.get(newkey)].func_77946_l();
            } else {
                int pid = (Integer)foci.get(newkey) / 1000;
                if (pouches.containsKey(pid)) {
                    int pouchslot = pouches.get(pid);
                    int focusslot = (Integer)foci.get(newkey) - pid * 1000;
                    ItemStack tmp = null;
                    tmp = pouchslot >= 0 ? player.field_71071_by.field_70462_a[pouchslot].func_77946_l() : baubles.func_70301_a(pouchslot + 4).func_77946_l();
                    item = WandManager.fetchFocusFromPouch(player, focusslot, tmp, pouchslot);
                }
            }
            if (item != null) {
                if ((Integer)foci.get(newkey) < 1000 && (Integer)foci.get(newkey) >= 0) {
                    player.field_71071_by.func_70299_a(((Integer)foci.get(newkey)).intValue(), null);
                }
            } else {
                return;
            }
            w.func_72956_a((Entity)player, "thaumcraft:cameraticks", 0.3f, 1.0f);
            if (wand.getFocus(is) != null && (WandManager.addFocusToPouch(player, wand.getFocusStack(is).func_77946_l(), pouches) || player.field_71071_by.func_70441_a(wand.getFocusStack(is).func_77946_l()))) {
                wand.setFocus(is, null);
            }
            if (wand.getFocus(is) == null) {
                wand.setFocus(is, item);
            } else if (!WandManager.addFocusToPouch(player, item, pouches)) {
                player.field_71071_by.func_70441_a(item);
            }
        }
    }

    private static ItemStack fetchFocusFromPouch(EntityPlayer player, int focusid, ItemStack pouch, int pouchslot) {
        ItemStack focus = null;
        ItemStack[] inv = ((ItemFocusPouch)pouch.func_77973_b()).getInventory(pouch);
        ItemStack contents = inv[focusid];
        if (contents != null && contents.func_77973_b() instanceof ItemFocusBasic) {
            focus = contents.func_77946_l();
            inv[focusid] = null;
            ((ItemFocusPouch)pouch.func_77973_b()).setInventory(pouch, inv);
            if (pouchslot >= 0) {
                player.field_71071_by.func_70299_a(pouchslot, pouch);
                player.field_71071_by.func_70296_d();
            } else {
                IInventory baubles = BaublesApi.getBaubles((EntityPlayer)player);
                baubles.func_70299_a(pouchslot + 4, pouch);
                baubles.func_70296_d();
            }
        }
        return focus;
    }

    private static boolean addFocusToPouch(EntityPlayer player, ItemStack focus, HashMap<Integer, Integer> pouches) {
        IInventory baubles = BaublesApi.getBaubles((EntityPlayer)player);
        for (Integer pouchslot : pouches.values()) {
            ItemStack pouch = pouchslot >= 0 ? player.field_71071_by.field_70462_a[pouchslot] : baubles.func_70301_a(pouchslot + 4);
            ItemStack[] inv = ((ItemFocusPouch)pouch.func_77973_b()).getInventory(pouch);
            for (int q = 0; q < inv.length; ++q) {
                ItemStack contents = inv[q];
                if (contents != null) continue;
                inv[q] = focus.func_77946_l();
                ((ItemFocusPouch)pouch.func_77973_b()).setInventory(pouch, inv);
                if (pouchslot >= 0) {
                    player.field_71071_by.func_70299_a(pouchslot.intValue(), pouch);
                    player.field_71071_by.func_70296_d();
                } else {
                    baubles.func_70299_a(pouchslot + 4, pouch);
                    baubles.func_70296_d();
                }
                return true;
            }
        }
        return false;
    }

    public static void toggleMisc(ItemStack itemstack, World world, EntityPlayer player) {
        if (!(itemstack.func_77973_b() instanceof IWand)) {
            return;
        }
        IWand wand = (IWand)itemstack.func_77973_b();
        if (wand.getFocus(itemstack) != null && wand.getFocus(itemstack) instanceof IArchitect && wand.getFocus(itemstack).isUpgradedWith(wand.getFocusStack(itemstack), FocusUpgradeType.architect)) {
            int dim = WandManager.getAreaDim(itemstack);
            IArchitect fa = (IArchitect)((Object)wand.getFocus(itemstack));
            if (player.func_70093_af()) {
                if (++dim > (wand.getFocusStack(itemstack).func_77973_b() instanceof ItemFocusTrade ? 2 : 3)) {
                    dim = 0;
                }
                WandManager.setAreaDim(itemstack, dim);
            } else {
                int areax = WandManager.getAreaX(itemstack);
                int areay = WandManager.getAreaY(itemstack);
                int areaz = WandManager.getAreaZ(itemstack);
                if (dim == 0) {
                    ++areax;
                    ++areaz;
                    ++areay;
                } else if (dim == 1) {
                    ++areax;
                } else if (dim == 2) {
                    ++areaz;
                } else if (dim == 3) {
                    ++areay;
                }
                if (areax > wand.getFocus(itemstack).getMaxAreaSize(wand.getFocusStack(itemstack))) {
                    areax = 0;
                }
                if (areaz > wand.getFocus(itemstack).getMaxAreaSize(wand.getFocusStack(itemstack))) {
                    areaz = 0;
                }
                if (areay > wand.getFocus(itemstack).getMaxAreaSize(wand.getFocusStack(itemstack))) {
                    areay = 0;
                }
                WandManager.setAreaX(itemstack, areax);
                WandManager.setAreaY(itemstack, areay);
                WandManager.setAreaZ(itemstack, areaz);
            }
        }
    }

    public static int getAreaDim(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("aread")) {
            return stack.func_77978_p().func_74762_e("aread");
        }
        return 0;
    }

    public static int getAreaX(ItemStack stack) {
        IWand wand = (IWand)stack.func_77973_b();
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("areax")) {
            int a = stack.func_77978_p().func_74762_e("areax");
            if (a > wand.getFocus(stack).getMaxAreaSize(wand.getFocusStack(stack))) {
                a = wand.getFocus(stack).getMaxAreaSize(wand.getFocusStack(stack));
            }
            return a;
        }
        return wand.getFocus(stack).getMaxAreaSize(wand.getFocusStack(stack));
    }

    public static int getAreaY(ItemStack stack) {
        IWand wand = (IWand)stack.func_77973_b();
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("areay")) {
            int a = stack.func_77978_p().func_74762_e("areay");
            if (a > wand.getFocus(stack).getMaxAreaSize(wand.getFocusStack(stack))) {
                a = wand.getFocus(stack).getMaxAreaSize(wand.getFocusStack(stack));
            }
            return a;
        }
        return wand.getFocus(stack).getMaxAreaSize(wand.getFocusStack(stack));
    }

    public static int getAreaZ(ItemStack stack) {
        IWand wand = (IWand)stack.func_77973_b();
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("areaz")) {
            int a = stack.func_77978_p().func_74762_e("areaz");
            if (a > wand.getFocus(stack).getMaxAreaSize(wand.getFocusStack(stack))) {
                a = wand.getFocus(stack).getMaxAreaSize(wand.getFocusStack(stack));
            }
            return a;
        }
        return wand.getFocus(stack).getMaxAreaSize(wand.getFocusStack(stack));
    }

    public static void setAreaX(ItemStack stack, int area) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74768_a("areax", area);
        }
    }

    public static void setAreaY(ItemStack stack, int area) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74768_a("areay", area);
        }
    }

    public static void setAreaZ(ItemStack stack, int area) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74768_a("areaz", area);
        }
    }

    public static void setAreaDim(ItemStack stack, int dim) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74768_a("aread", dim);
        }
    }

    static boolean isOnCooldown(EntityLivingBase entityLiving) {
        if (entityLiving.field_70170_p.field_72995_K && cooldownClient.containsKey(entityLiving.func_145782_y())) {
            return cooldownClient.get(entityLiving.func_145782_y()) > System.currentTimeMillis();
        }
        if (!entityLiving.field_70170_p.field_72995_K && cooldownServer.containsKey(entityLiving.func_145782_y())) {
            return cooldownServer.get(entityLiving.func_145782_y()) > System.currentTimeMillis();
        }
        return false;
    }

    public static float getCooldown(EntityLivingBase entityLiving) {
        if (entityLiving.field_70170_p.field_72995_K && cooldownClient.containsKey(entityLiving.func_145782_y())) {
            return (float)(cooldownClient.get(entityLiving.func_145782_y()) - System.currentTimeMillis()) / 1000.0f;
        }
        return 0.0f;
    }

    public static void setCooldown(EntityLivingBase entityLiving, int cd) {
        if (cd == 0) {
            cooldownClient.remove(entityLiving.func_145782_y());
            cooldownServer.remove(entityLiving.func_145782_y());
        } else if (entityLiving.field_70170_p.field_72995_K) {
            cooldownClient.put(entityLiving.func_145782_y(), System.currentTimeMillis() + (long)cd);
        } else {
            cooldownServer.put(entityLiving.func_145782_y(), System.currentTimeMillis() + (long)cd);
        }
    }
}

