/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.wands.foci;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.IWand;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.entities.projectile.EntityEmber;
import thaumcraft.common.entities.projectile.EntityExplosiveOrb;

public class ItemFocusFire
extends ItemFocusBasic {
    private static final AspectList costBase = new AspectList().add(Aspect.FIRE, 2);
    private static final AspectList costBeam = new AspectList().add(Aspect.FIRE, 2).add(Aspect.ORDER, 2);
    private static final AspectList costBall = new AspectList().add(Aspect.FIRE, 8).add(Aspect.ENTROPY, 8);
    long soundDelay = 0L;
    public static FocusUpgradeType fireball = new FocusUpgradeType(new ResourceLocation("thaumcraft", "textures/foci/fireball.png"), "focus.upgrade.fireball.name", "focus.upgrade.fireball.text", new AspectList().add(Aspect.DARKNESS, 1));
    public static FocusUpgradeType firebeam = new FocusUpgradeType(new ResourceLocation("thaumcraft", "textures/foci/firebeam.png"), "focus.upgrade.firebeam.name", "focus.upgrade.firebeam.text", new AspectList().add(Aspect.ENERGY, 1).add(Aspect.AIR, 1));

    public ItemFocusFire() {
        super("fire", 15028484);
    }

    @Override
    public AspectList getVisCost(ItemStack itemstack) {
        return this.isUpgradedWith(itemstack, firebeam) ? costBeam : (this.isUpgradedWith(itemstack, fireball) ? costBall : costBase);
    }

    @Override
    public boolean canBePlacedInTurret() {
        return true;
    }

    @Override
    public int getActivationCooldown(ItemStack focusstack) {
        return this.isUpgradedWith(focusstack, fireball) ? 1000 : 0;
    }

    @Override
    public boolean isVisCostPerTick(ItemStack itemstack) {
        return !this.isUpgradedWith(itemstack, fireball);
    }

    @Override
    public float getTurretCorrection(ItemStack focusstack) {
        return this.isUpgradedWith(focusstack, fireball) ? 3.0f : 0.0f;
    }

    @Override
    public float getTurretRange(ItemStack focusstack) {
        return this.isUpgradedWith(focusstack, fireball) ? 32.0f : (this.isUpgradedWith(focusstack, firebeam) ? 16.0f : 12.0f);
    }

    @Override
    public ItemFocusBasic.WandFocusAnimation getAnimation(ItemStack itemstack) {
        return this.isUpgradedWith(itemstack, fireball) ? ItemFocusBasic.WandFocusAnimation.WAVE : ItemFocusBasic.WandFocusAnimation.CHARGE;
    }

    @Override
    public boolean onFocusActivation(ItemStack wandstack, World world, EntityLivingBase player, MovingObjectPosition movingobjectposition, int count) {
        IWand wand = (IWand)wandstack.func_77973_b();
        if (this.isUpgradedWith(wand.getFocusStack(wandstack), fireball)) {
            if (!world.field_72995_K) {
                EntityExplosiveOrb orb = new EntityExplosiveOrb(world, player);
                orb.strength += (float)wand.getFocusPotency(wandstack) * 0.4f;
                orb.onFire = this.isUpgradedWith(wand.getFocusStack(wandstack), FocusUpgradeType.alchemistsfire);
                world.func_72838_d((Entity)orb);
                world.func_180498_a((EntityPlayer)null, 1009, new BlockPos((Entity)player), 0);
            }
            player.func_71038_i();
        } else {
            int range = 17;
            Vec3 vec3d = player.func_70676_i((float)range);
            if (!world.field_72995_K && this.soundDelay < System.currentTimeMillis()) {
                world.func_72956_a((Entity)player, "thaumcraft:fireloop", 0.33f, 2.0f);
                this.soundDelay = System.currentTimeMillis() + 500L;
            }
            if (!world.field_72995_K) {
                float scatter = this.isUpgradedWith(wand.getFocusStack(wandstack), firebeam) ? 0.25f : 15.0f;
                for (int a = 0; a < 2 + wand.getFocusPotency(wandstack); ++a) {
                    EntityEmber orb = new EntityEmber(world, player, scatter);
                    orb.damage = 2 + wand.getFocusPotency(wandstack);
                    if (this.isUpgradedWith(wand.getFocusStack(wandstack), firebeam)) {
                        orb.damage += 0.5f;
                        orb.damage *= 1.5f;
                        orb.duration = 30;
                    }
                    orb.firey = this.getUpgradeLevel(wand.getFocusStack(wandstack), FocusUpgradeType.alchemistsfire);
                    orb.field_70165_t += orb.field_70159_w;
                    orb.field_70163_u += orb.field_70181_x;
                    orb.field_70161_v += orb.field_70179_y;
                    world.func_72838_d((Entity)orb);
                }
            }
        }
        return true;
    }

    @Override
    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack itemstack, int rank) {
        switch (rank) {
            case 1: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
            case 2: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, FocusUpgradeType.alchemistsfire};
            }
            case 3: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, fireball, firebeam};
            }
            case 4: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, FocusUpgradeType.alchemistsfire};
            }
            case 5: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
        }
        return null;
    }

    @Override
    public boolean canApplyUpgrade(ItemStack focusstack, EntityPlayer player, FocusUpgradeType type, int rank) {
        return !type.equals(FocusUpgradeType.alchemistsfire) || !this.isUpgradedWith(focusstack, fireball) || !this.isUpgradedWith(focusstack, FocusUpgradeType.alchemistsfire);
    }
}

