/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.aura;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.Config;
import thaumcraft.common.lib.aura.AuraChunk;
import thaumcraft.common.lib.aura.AuraHandler;
import thaumcraft.common.lib.aura.AuraWorld;
import thaumcraft.common.lib.utils.PosXY;

public class AuraThread
implements Runnable {
    private final long INTERVAL = 250L;
    private boolean stop = false;
    Random rand = new Random(System.currentTimeMillis());

    @Override
    public void run() {
        Thaumcraft.log.info("Starting aura thread");
        while (!this.stop) {
            if (AuraHandler.auras.isEmpty()) {
                Thaumcraft.log.warn("No auras found!");
                break;
            }
            long startTime = System.currentTimeMillis();
            for (AuraWorld auraWorld : AuraHandler.auras.values()) {
                for (AuraChunk auraChunk : auraWorld.auraChunks.values()) {
                    this.processAuraChunk(auraWorld, auraChunk);
                }
            }
            long executionTime = System.currentTimeMillis() - startTime;
            try {
                if (executionTime > 250L) {
                    Thaumcraft.log.warn("AURAS TAKING " + (executionTime - 250L) + " ms LONGER THAN NORMAL");
                }
                Thread.sleep(Math.max(1L, 250L - executionTime));
            }
            catch (InterruptedException e) {}
        }
        Thaumcraft.log.info("Stopping aura thread");
        Thaumcraft.proxy.setAuraThread(null);
    }

    private void processAuraChunk(AuraWorld auraWorld, AuraChunk auraChunk) {
        List<Integer> directions = Arrays.asList(0, 1, 2, 3);
        Collections.shuffle(directions, this.rand);
        int x = auraChunk.loc.x;
        int y = auraChunk.loc.y;
        short base = auraChunk.getBase();
        AspectList current = auraChunk.getCurrentAspects();
        AspectList al = auraWorld.getNodeTickets().get(auraChunk.loc);
        if (al != null) {
            for (Aspect aspect : al.copy().getAspects()) {
                while (al.getAmount(aspect) > 0) {
                    al.reduce(aspect, 1);
                    if (current.getAmount(aspect) > base) {
                        float f = (float)(current.getAmount(aspect) - base) / ((float)base * 0.1f);
                        if (aspect == Aspect.FLUX) {
                            f /= 2.0f;
                        }
                        if (this.rand.nextFloat() > f) {
                            current.add(aspect, 1);
                        } else if ((double)this.rand.nextFloat() > 0.33) {
                            EnumFacing rd = EnumFacing.field_176754_o[this.rand.nextInt(4)];
                            PosXY p = new PosXY(auraChunk.loc);
                            p.x += rd.func_82601_c() * MathHelper.func_76136_a((Random)this.rand, (int)1, (int)3);
                            p.y += rd.func_82599_e() * MathHelper.func_76136_a((Random)this.rand, (int)1, (int)3);
                            AuraHandler.addRechargeTicket(auraWorld.dim, p, aspect, 1);
                        }
                    } else {
                        current.add(aspect, 1);
                    }
                    this.markChunkAsDirty(auraChunk, auraWorld.dim);
                }
            }
        }
        for (Aspect aspect : current.getAspects()) {
            AuraChunk neighbour = null;
            int lowest = Integer.MAX_VALUE;
            for (Integer a : directions) {
                EnumFacing dir = EnumFacing.func_176731_b((int)a);
                AuraChunk n = auraWorld.getAuraChunkAt(x + dir.func_82601_c(), y + dir.func_82599_e());
                if (n == null || neighbour != null && lowest <= n.getCurrentAspects().getAmount(aspect) || current.getAmount(aspect) <= n.getCurrentAspects().getAmount(aspect) || n.getCurrentAspects().getAmount(aspect) >= n.getBase()) continue;
                neighbour = n;
                lowest = n.getCurrentAspects().getAmount(aspect);
            }
            if (neighbour != null) {
                AspectList neighbourCurrent = neighbour.getCurrentAspects();
                int m = (int)Math.max((double)(Config.AURABASE / 20), Math.min((double)(Config.AURABASE / 5), (double)neighbourCurrent.getAmount(aspect) * (aspect == Aspect.FLUX ? 0.75 : 0.25)));
                if (neighbourCurrent.getAmount(aspect) < current.getAmount(aspect) - m && neighbourCurrent.getAmount(aspect) < neighbour.getBase()) {
                    neighbourCurrent.add(aspect, 1);
                    current.reduce(aspect, 1);
                    this.markChunkAsDirty(auraChunk, auraWorld.dim);
                    this.markChunkAsDirty(neighbour, auraWorld.dim);
                }
            }
            if (aspect == Aspect.FLUX || !((float)current.getAmount(aspect) < (float)base / 15.0f) || !(this.rand.nextFloat() < ((float)base / 15.0f - (float)current.getAmount(aspect)) / (float)(base * 15))) continue;
            current.add(Aspect.FLUX, 1);
            this.markChunkAsDirty(auraChunk, auraWorld.dim);
        }
        if (current.getAmount(Aspect.FLUX) > Config.AURABASE / 2 && this.rand.nextFloat() < (float)current.getAmount(Aspect.FLUX) / (float)(Config.AURABASE * 40)) {
            AuraHandler.taintTrigger.put(auraWorld.dim, new BlockPos(auraChunk.getLoc().x * 16, 0, auraChunk.getLoc().y * 16));
        }
    }

    private void markChunkAsDirty(AuraChunk chunk, int dim) {
        CopyOnWriteArrayList<PosXY> dc;
        if (chunk.isModified()) {
            return;
        }
        PosXY pos = new PosXY(chunk.loc.x, chunk.loc.y);
        if (!AuraHandler.dirtyChunks.containsKey(dim)) {
            AuraHandler.dirtyChunks.put(dim, new CopyOnWriteArrayList());
        }
        if (!(dc = AuraHandler.dirtyChunks.get(dim)).contains(pos)) {
            dc.add(pos);
        }
    }

    public void stop() {
        this.stop = true;
    }
}

