/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.events;

import java.util.ArrayList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.Config;
import thaumcraft.common.lib.aura.AuraChunk;
import thaumcraft.common.lib.aura.AuraHandler;
import thaumcraft.common.lib.events.ServerTickEventsFML;
import thaumcraft.common.lib.world.ChunkLoc;

public class ChunkEvents {
    @SubscribeEvent
    public void chunkSave(ChunkDataEvent.Save event) {
        int dim = event.world.field_73011_w.func_177502_q();
        ChunkCoordIntPair loc = event.getChunk().func_76632_l();
        NBTTagCompound nbt = new NBTTagCompound();
        event.getData().func_74782_a("Thaumcraft", (NBTBase)nbt);
        nbt.func_74757_a(Config.regenKey, true);
        AuraChunk ac = AuraHandler.getAuraChunk(dim, loc.field_77276_a, loc.field_77275_b);
        if (ac != null) {
            nbt.func_74777_a("base", ac.getBase());
            ac.getCurrentAspects().writeToNBT(nbt, "current");
            if (!event.getChunk().func_177410_o()) {
                AuraHandler.removeAuraChunk(dim, loc.field_77276_a, loc.field_77275_b);
            }
        }
    }

    @SubscribeEvent
    public void chunkLoad(ChunkDataEvent.Load event) {
        int dim = event.world.field_73011_w.func_177502_q();
        ChunkCoordIntPair loc = event.getChunk().func_76632_l();
        if (event.getData().func_74775_l("Thaumcraft").func_74764_b("base")) {
            NBTTagCompound nbt = event.getData().func_74775_l("Thaumcraft");
            short base = nbt.func_74765_d("base");
            AspectList current = new AspectList();
            current.readFromNBT(nbt, "current");
            AuraHandler.addAuraChunk(dim, event.getChunk(), base, current);
        } else {
            AuraHandler.generateAura(event.getChunk(), event.world.field_73012_v);
        }
        if (!event.getData().func_74775_l("Thaumcraft").func_74764_b(Config.regenKey) && (Config.regenAmber || Config.regenAura || Config.regenCinnibar || Config.regenCrystals || Config.regenStructure || Config.regenTrees)) {
            Thaumcraft.log.warn("World gen was never run for chunk at " + event.getChunk().func_76632_l() + ". Adding to queue for regeneration.");
            ArrayList<ChunkLoc> chunks = ServerTickEventsFML.chunksToGenerate.get(dim);
            if (chunks == null) {
                ServerTickEventsFML.chunksToGenerate.put(dim, new ArrayList());
                chunks = ServerTickEventsFML.chunksToGenerate.get(dim);
            }
            if (chunks != null) {
                chunks.add(new ChunkLoc(loc.field_77276_a, loc.field_77275_b));
                ServerTickEventsFML.chunksToGenerate.put(dim, chunks);
            }
        }
    }
}

