/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.network.misc;

import io.netty.buffer.ByteBuf;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.entities.construct.golem.seals.SealEntity;
import thaumcraft.common.entities.construct.golem.seals.SealHandler;

public class PacketSealToClient
implements IMessage,
IMessageHandler<PacketSealToClient, IMessage> {
    BlockPos pos;
    EnumFacing face;
    String type;

    public PacketSealToClient() {
    }

    public PacketSealToClient(SealEntity se) {
        this.pos = se.getSealPos().pos;
        this.face = se.getSealPos().face;
        this.type = se.getSeal() == null ? "REMOVE" : se.getSeal().getKey();
    }

    public void toBytes(ByteBuf dos) {
        dos.writeLong(this.pos.func_177986_g());
        dos.writeByte(this.face.ordinal());
        ByteBufUtils.writeUTF8String((ByteBuf)dos, (String)this.type);
    }

    public void fromBytes(ByteBuf dat) {
        this.pos = BlockPos.func_177969_a((long)dat.readLong());
        this.face = EnumFacing.field_82609_l[dat.readByte()];
        this.type = ByteBufUtils.readUTF8String((ByteBuf)dat);
    }

    public IMessage onMessage(PacketSealToClient message, MessageContext ctx) {
        if (message.type.equals("REMOVE")) {
            SealHandler.removeSealEntity(Thaumcraft.proxy.getClientWorld(), new SealEntity.SealPos(message.pos, message.face));
        } else {
            SealHandler.addSealEntity(Thaumcraft.proxy.getClientWorld(), new SealEntity(Thaumcraft.proxy.getClientWorld(), new SealEntity.SealPos(message.pos, message.face), SealHandler.getSeal(message.type)));
        }
        return null;
    }
}

