/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.world.biomes;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;
import net.minecraft.world.gen.feature.WorldGenBlockBlob;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.common.config.Config;
import thaumcraft.common.entities.monster.EntityPech;
import thaumcraft.common.entities.monster.EntityWisp;
import thaumcraft.common.lib.utils.Utils;
import thaumcraft.common.lib.world.objects.WorldGenBigMagicTree;
import thaumcraft.common.lib.world.objects.WorldGenGreatwoodTrees;
import thaumcraft.common.lib.world.objects.WorldGenSilverwoodTrees;

public class BiomeGenMagicalForest
extends BiomeGenBase {
    protected WorldGenBigMagicTree bigTree = new WorldGenBigMagicTree(false);
    private static final WorldGenBlockBlob blobs = new WorldGenBlockBlob(Blocks.field_150341_Y, 0);

    public BiomeGenMagicalForest(int par1) {
        super(par1);
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityWolf.class, 2, 1, 3));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityHorse.class, 2, 1, 3));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityWitch.class, 3, 1, 1));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityEnderman.class, 3, 1, 1));
        if (Config.spawnPech) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityPech.class, 10, 1, 2));
        }
        if (Config.spawnWisp) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityWisp.class, 10, 1, 2));
        }
        this.field_76760_I.field_76832_z = 2;
        this.field_76760_I.field_76802_A = 10;
        this.field_76760_I.field_76803_B = 12;
        this.field_76760_I.field_76833_y = 6;
        this.field_76760_I.field_76798_D = 6;
        this.func_76732_a(0.7f, 0.6f);
        this.func_150570_a(new BiomeGenBase.Height(0.2f, 0.2f));
        this.func_76735_a("Magical Forest");
        this.func_76739_b(Config.blueBiome ? 0x66AACC : 6747307);
    }

    public WorldGenAbstractTree func_150567_a(Random par1Random) {
        return par1Random.nextInt(14) == 0 ? new WorldGenSilverwoodTrees(false, 8, 5) : (par1Random.nextInt(10) == 0 ? new WorldGenGreatwoodTrees(false, par1Random.nextInt(8) == 0) : this.bigTree);
    }

    public WorldGenerator func_76730_b(Random par1Random) {
        return par1Random.nextInt(4) == 0 ? new WorldGenTallGrass(BlockTallGrass.EnumType.FERN) : new WorldGenTallGrass(BlockTallGrass.EnumType.GRASS);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180627_b(BlockPos p_180627_1_) {
        return Config.blueBiome ? 0x66AACC : 5635969;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180625_c(BlockPos p_180625_1_) {
        return Config.blueBiome ? 0x77CCEE : 6750149;
    }

    public int getWaterColorMultiplier() {
        return 30702;
    }

    public void func_180624_a(World world, Random random, BlockPos pos) {
        BlockPos p2;
        int l;
        int k = random.nextInt(3);
        for (l = 0; l < k; ++l) {
            p2 = new BlockPos((Vec3i)pos);
            p2 = p2.func_177982_a(random.nextInt(16) + 8, 0, random.nextInt(16) + 8);
            p2 = world.func_175645_m(p2);
            blobs.func_180709_b(world, random, p2);
        }
        for (k = 0; k < 4; ++k) {
            for (l = 0; l < 4; ++l) {
                if (random.nextInt(40) != 0) continue;
                p2 = new BlockPos((Vec3i)pos);
                p2 = p2.func_177982_a(k * 4 + 1 + 8 + random.nextInt(3), 0, l * 4 + 1 + 8 + random.nextInt(3));
                p2 = world.func_175645_m(p2);
                WorldGenBigMushroom worldgenbigmushroom = new WorldGenBigMushroom();
                worldgenbigmushroom.func_180709_b(world, random, p2);
            }
        }
        try {
            super.func_180624_a(world, random, pos);
        }
        catch (Exception e) {
            // empty catch block
        }
        for (int a = 0; a < 8; ++a) {
            BlockPos p22 = new BlockPos((Vec3i)pos);
            p22 = p22.func_177982_a(random.nextInt(16), 0, random.nextInt(16));
            p22 = world.func_175645_m(p22);
            while (p22.func_177956_o() > 50 && world.func_180495_p(p22).func_177230_c() != Blocks.field_150349_c) {
                p22 = p22.func_177977_b();
            }
            Block l1 = world.func_180495_p(p22).func_177230_c();
            if (l1 != Blocks.field_150349_c || !world.func_180495_p(p22.func_177984_a()).func_177230_c().func_176200_f(world, p22.func_177984_a()) || !this.isBlockAdjacentToWood((IBlockAccess)world, p22.func_177984_a())) continue;
            world.func_180501_a(p22.func_177984_a(), BlocksTC.vishroom.func_176223_P(), 2);
        }
    }

    private boolean isBlockAdjacentToWood(IBlockAccess world, BlockPos pos) {
        boolean count = false;
        for (int xx = -1; xx <= 1; ++xx) {
            for (int yy = -1; yy <= 1; ++yy) {
                for (int zz = -1; zz <= 1; ++zz) {
                    if (xx == 0 && yy == 0 && zz == 0 || !Utils.isWoodLog(world, pos.func_177982_a(xx, yy, zz))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public BiomeGenBase func_150566_k() {
        return null;
    }

    public BlockFlower.EnumFlowerType func_180623_a(Random rand, BlockPos pos) {
        double d0 = MathHelper.func_151237_a((double)((1.0 + field_180281_af.func_151601_a((double)pos.func_177958_n() / 48.0, (double)pos.func_177952_p() / 48.0)) / 2.0), (double)0.0, (double)0.9999);
        return BlockFlower.EnumFlowerType.values()[(int)(d0 * (double)BlockFlower.EnumFlowerType.values().length)];
    }
}

