/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.world.dim;

import java.util.Random;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import thaumcraft.common.lib.world.dim.Cell;
import thaumcraft.common.lib.world.dim.Gen2x2;
import thaumcraft.common.lib.world.dim.GenCommon;
import thaumcraft.common.tiles.misc.TileEldritchLock;

public class GenBossRoom
extends GenCommon {
    static final int[][] PAT_DOORWAY = new int[][]{{0, 2, 2, 2, 2, 2, 0}, {2, 2, 9, 9, 9, 2, 2}, {2, 9, 9, 9, 9, 9, 2}, {2, 9, 9, 1, 9, 9, 2}, {2, 9, 9, 9, 9, 9, 2}, {2, 2, 9, 9, 9, 2, 2}, {0, 2, 2, 2, 2, 2, 0}};

    static void generateRoom(World world, Random random, int cx, int cz, int y, Cell cell) {
        int x = cx * 16;
        int z = cz * 16;
        switch (cell.feature) {
            case 2: {
                Gen2x2.generateUpperLeft(world, random, cx, cz, 50, cell);
                break;
            }
            case 3: {
                Gen2x2.generateUpperRight(world, random, cx, cz, 50, cell);
                break;
            }
            case 4: {
                Gen2x2.generateLowerLeft(world, random, cx, cz, 50, cell);
                break;
            }
            case 5: {
                Gen2x2.generateLowerRight(world, random, cx, cz, 50, cell);
            }
        }
        for (int a = 0; a < 7; ++a) {
            block12: for (int b = 0; b < 7; ++b) {
                int xx = 0;
                int zz = 0;
                EnumFacing dir = EnumFacing.UP;
                if (cell.north) {
                    xx = x + 5 + a;
                    zz = z + 3;
                    dir = EnumFacing.NORTH;
                }
                if (cell.south) {
                    xx = x + 5 + a;
                    zz = z + 13;
                    dir = EnumFacing.SOUTH;
                }
                if (cell.east) {
                    xx = x + 13;
                    zz = z + 5 + a;
                    dir = EnumFacing.EAST;
                }
                if (cell.west) {
                    xx = x + 3;
                    zz = z + 5 + a;
                    dir = EnumFacing.WEST;
                }
                BlockPos pos = new BlockPos(xx, y + 2 + b, zz);
                switch (PAT_DOORWAY[a][b]) {
                    case 1: {
                        GenBossRoom.placeBlock(world, xx, y + 2 + b, zz, 16, cell);
                        TileEntity t = world.func_175625_s(pos);
                        if (t == null || !(t instanceof TileEldritchLock)) continue block12;
                        ((TileEldritchLock)t).setLockFacing((byte)dir.ordinal());
                        continue block12;
                    }
                    case 2: {
                        GenBossRoom.placeBlock(world, xx, y + 2 + b, zz, 15, cell);
                        continue block12;
                    }
                    case 9: {
                        GenBossRoom.placeBlock(world, xx, y + 2 + b, zz, 17, cell);
                    }
                }
            }
        }
    }
}

