/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.world.dim;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.common.blocks.basic.BlockStoneTC;
import thaumcraft.common.blocks.world.eldritch.BlockEldritch;
import thaumcraft.common.items.resources.ItemShard;
import thaumcraft.common.lib.utils.BlockUtils;
import thaumcraft.common.lib.world.dim.Cell;
import thaumcraft.common.tiles.misc.TileEldritchCrabSpawner;

public class GenCommon {
    static ArrayList<BlockPos> decoCommon = new ArrayList();
    static ArrayList<BlockPos> crabSpawner = new ArrayList();
    static ArrayList<BlockPos> decoUrn = new ArrayList();
    static ArrayList<BlockPos> punctureLoc = new ArrayList();
    static final int PUNCTURE = 1;
    static final int STONE = 2;
    static final int BASE_ROCK = 8;
    static final int AIR_REPL = 9;
    static final int STAIR_DIRECTIONAL = 10;
    static final int STAIR_DIRECTIONAL_INV = 11;
    static final int SLAB = 12;
    static final int DOOR_BLOCK = 15;
    static final int DOOR_LOCK = 16;
    static final int VOID_DOOR = 17;
    static final int ROCK = 18;
    static final int STONE_NOSPAWN = 19;
    static final int CRUST = 21;
    static final int[][] PAT_CONNECT = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 8, 8, 8, 8, 8, 8, 8, 0, 0}, {0, 8, 8, 2, 2, 2, 2, 2, 8, 8, 0}, {0, 8, 2, 5, 9, 9, 9, 6, 2, 8, 0}, {0, 8, 2, 9, 9, 9, 9, 9, 2, 8, 0}, {0, 8, 2, 9, 9, 9, 9, 9, 2, 8, 0}, {0, 8, 2, 9, 9, 9, 9, 9, 2, 8, 0}, {0, 8, 2, 3, 9, 9, 9, 4, 2, 8, 0}, {0, 8, 8, 2, 2, 2, 2, 2, 8, 8, 0}, {0, 0, 8, 8, 8, 8, 8, 8, 8, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};

    static void placeBlock(World world, int i, int j, int k, int l, Cell cell) {
        GenCommon.placeBlock(world, i, j, k, l, null, cell);
    }

    static void placeBlock(World world, int x, int y, int z, int b, EnumFacing dir, Cell cell) {
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState block = null;
        switch (b) {
            case 15: {
                block = BlocksTC.stone.func_176223_P().func_177226_a((IProperty)BlockStoneTC.VARIANT, (Comparable)((Object)BlockStoneTC.StoneType.ANCIENT_DOORWAY));
                decoCommon.remove(pos);
                crabSpawner.remove(pos);
                decoUrn.remove(pos);
                break;
            }
            case 16: {
                block = BlocksTC.eldritch.func_176223_P().func_177226_a((IProperty)BlockEldritch.TYPE, (Comparable)((Object)BlockEldritch.EldritchType.LOCK));
                decoCommon.remove(pos);
                crabSpawner.remove(pos);
                decoUrn.remove(pos);
                break;
            }
            case 8: {
                block = BlocksTC.stone.func_176223_P().func_177226_a((IProperty)BlockStoneTC.VARIANT, (Comparable)((Object)BlockStoneTC.StoneType.ANCIENT_ROCK));
                break;
            }
            case 17: {
                block = BlocksTC.eldritch.func_176223_P().func_177226_a((IProperty)BlockEldritch.TYPE, (Comparable)((Object)BlockEldritch.EldritchType.DOOR));
                break;
            }
            case 9: {
                block = Blocks.field_150350_a.func_176223_P();
                decoCommon.remove(pos);
                crabSpawner.remove(pos);
                decoUrn.remove(pos);
                break;
            }
            case 1: {
                block = Blocks.field_150350_a.func_176223_P();
                decoCommon.remove(pos);
                crabSpawner.remove(pos);
                decoUrn.remove(pos);
                punctureLoc.add(pos);
                break;
            }
            case 2: {
                if (cell.feature != 7 || world.field_73012_v.nextInt(3) != 0) {
                    if (world.field_73012_v.nextInt(25) == 0) {
                        boolean crab;
                        boolean bl = cell.feature == 7 ? true : (crab = world.field_73012_v.nextInt(50) == 0);
                        if (crab && cell.feature == 0 || crab && cell.feature == 7) {
                            crabSpawner.add(pos);
                        } else {
                            decoCommon.add(pos);
                        }
                    }
                    block = BlocksTC.stone.func_176223_P().func_177226_a((IProperty)BlockStoneTC.VARIANT, (Comparable)((Object)BlockStoneTC.StoneType.ANCIENT));
                    break;
                }
            }
            case 21: {
                boolean crab;
                block = BlocksTC.stone.func_176203_a(6);
                if (world.field_73012_v.nextInt(25) == 0) {
                    block = BlocksTC.stone.func_176203_a(7);
                    break;
                }
                if (world.field_73012_v.nextInt(25) != 0) break;
                boolean bl = cell.feature == 7 ? true : (cell.feature == 12 && world.field_73012_v.nextBoolean() ? true : (crab = world.field_73012_v.nextInt(25) == 0));
                if (!(crab && cell.feature == 0 || crab && cell.feature == 7) && (!crab || cell.feature != 12)) break;
                crabSpawner.add(pos);
                break;
            }
            case 18: {
                block = BlocksTC.stone.func_176223_P().func_177226_a((IProperty)BlockStoneTC.VARIANT, (Comparable)((Object)BlockStoneTC.StoneType.ANCIENT_ROCK));
                break;
            }
            case 19: {
                if (world.func_180495_p(pos) == BlocksTC.stone.func_176223_P().func_177226_a((IProperty)BlockStoneTC.VARIANT, (Comparable)((Object)BlockStoneTC.StoneType.ANCIENT_ROCK))) break;
                block = BlocksTC.stone.func_176223_P().func_177226_a((IProperty)BlockStoneTC.VARIANT, (Comparable)((Object)BlockStoneTC.StoneType.ANCIENT_TILE));
                break;
            }
            case 10: {
                int meta = 0;
                switch (dir) {
                    case NORTH: {
                        meta = 3;
                        break;
                    }
                    case SOUTH: {
                        meta = 2;
                        break;
                    }
                    case EAST: {
                        meta = 0;
                        break;
                    }
                    case WEST: {
                        meta = 1;
                        break;
                    }
                }
                block = BlocksTC.stairsAncient.func_176203_a(meta);
                break;
            }
            case 11: {
                int meta = 0;
                switch (dir) {
                    case NORTH: {
                        meta = 7;
                        break;
                    }
                    case SOUTH: {
                        meta = 6;
                        break;
                    }
                    case EAST: {
                        meta = 4;
                        break;
                    }
                    case WEST: {
                        meta = 5;
                        break;
                    }
                }
                block = BlocksTC.stairsAncient.func_176203_a(meta);
                break;
            }
            case 3: {
                if ((double)world.field_73012_v.nextFloat() < 0.005) {
                    decoUrn.add(pos);
                }
                int meta = 0;
                switch (dir.ordinal()) {
                    case 2: 
                    case 3: {
                        meta = 1;
                        break;
                    }
                    case 4: 
                    case 5: {
                        meta = 3;
                    }
                }
                block = BlocksTC.stairsAncient.func_176203_a(meta);
                break;
            }
            case 4: {
                if ((double)world.field_73012_v.nextFloat() < 0.005) {
                    decoUrn.add(pos);
                }
                int meta = 0;
                switch (dir.ordinal()) {
                    case 2: 
                    case 3: {
                        meta = 0;
                        break;
                    }
                    case 4: 
                    case 5: {
                        meta = 2;
                    }
                }
                block = BlocksTC.stairsAncient.func_176203_a(meta);
                break;
            }
            case 5: {
                int meta = 0;
                switch (dir.ordinal()) {
                    case 2: 
                    case 3: {
                        meta = 5;
                        break;
                    }
                    case 4: 
                    case 5: {
                        meta = 7;
                    }
                }
                block = BlocksTC.stairsAncient.func_176203_a(meta);
                break;
            }
            case 6: {
                int meta = 0;
                switch (dir.ordinal()) {
                    case 2: 
                    case 3: {
                        meta = 4;
                        break;
                    }
                    case 4: 
                    case 5: {
                        meta = 6;
                    }
                }
                block = BlocksTC.stairsAncient.func_176203_a(meta);
                break;
            }
            case 7: {
                block = BlocksTC.stone.func_176203_a(7);
            }
        }
        if (block != null) {
            world.func_180501_a(pos, block, block == BlocksTC.stone.func_176223_P().func_177226_a((IProperty)BlockStoneTC.VARIANT, (Comparable)((Object)BlockStoneTC.StoneType.ANCIENT_ROCK)) || block.func_177230_c() == Blocks.field_150350_a ? 0 : 3);
        }
    }

    public static void genObelisk(World world, BlockPos pos) {
        world.func_175656_a(pos, BlocksTC.eldritch.func_176203_a(2));
        world.func_175656_a(pos.func_177981_b(1), BlocksTC.eldritch.func_176203_a(3));
        world.func_175656_a(pos.func_177981_b(2), BlocksTC.eldritch.func_176203_a(3));
        world.func_175656_a(pos.func_177981_b(3), BlocksTC.eldritch.func_176203_a(3));
        world.func_175656_a(pos.func_177981_b(4), BlocksTC.eldritch.func_176203_a(3));
    }

    static void processDecorations(World world) {
        for (BlockPos cc : decoUrn) {
            if (!world.func_175623_d(cc.func_177984_a())) continue;
            world.func_175656_a(cc, BlocksTC.stone.func_176203_a(5));
            float rr = world.field_73012_v.nextFloat();
            int meta = rr < 0.025f ? 2 : (rr < 0.1f ? 1 : 0);
            world.func_175656_a(cc.func_177984_a(), BlocksTC.lootUrn.func_176203_a(meta));
        }
        for (BlockPos cc : decoCommon) {
            int exp = BlockUtils.countExposedSides(world, cc);
            if (exp <= 0 || exp != 1 && GenCommon.isVacuumVisible(world, cc) || !BlockUtils.isBlockTouching((IBlockAccess)world, cc, BlocksTC.stone)) continue;
            int type = world.field_73012_v.nextInt(3) != 0 ? 0 : (world.field_73012_v.nextInt(8) != 0 ? 1 : 2);
            block0 : switch (type) {
                case 0: {
                    world.func_175656_a(cc, BlocksTC.stone.func_176203_a(4));
                    break;
                }
                case 1: {
                    world.func_175656_a(cc, BlocksTC.stone.func_176203_a(11));
                    break;
                }
                case 2: {
                    for (EnumFacing dir : EnumFacing.field_82609_l) {
                        if (!world.func_175623_d(cc.func_177972_a(dir))) continue;
                        Block oreBlock = ItemShard.ShardType.byMetadata(world.field_73012_v.nextInt(7)).getOre();
                        world.func_180501_a(cc.func_177972_a(dir), oreBlock.func_176203_a(1 + world.field_73012_v.nextInt(3)), 0);
                        break block0;
                    }
                    break;
                }
            }
        }
        block8: for (BlockPos cc : crabSpawner) {
            int exp = BlockUtils.countExposedSides(world, cc);
            if (exp != 1 || !BlockUtils.isBlockTouching((IBlockAccess)world, cc, BlocksTC.stone)) continue;
            world.func_175656_a(cc, BlocksTC.eldritch.func_176203_a(7));
            TileEntity te = world.func_175625_s(cc);
            if (te == null || !(te instanceof TileEldritchCrabSpawner)) continue;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (!world.func_175623_d(cc.func_177972_a(dir))) continue;
                ((TileEldritchCrabSpawner)te).setVentFacing((byte)dir.ordinal());
                continue block8;
            }
        }
        block10: for (BlockPos cc : punctureLoc) {
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (world.func_180495_p(cc.func_177972_a(dir)) != BlocksTC.stone.func_176203_a(3) || world.func_180495_p(cc.func_177967_a(dir, 2)) != BlocksTC.stone.func_176203_a(12)) continue;
                world.func_175698_g(cc.func_177972_a(dir));
                continue block10;
            }
        }
        decoCommon.clear();
        crabSpawner.clear();
        decoUrn.clear();
        punctureLoc.clear();
    }

    static boolean isVacuumVisible(World world, BlockPos pos) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (world.func_180495_p(pos.func_177972_a(dir)).func_177230_c().func_149662_c() || world.func_180495_p(pos.func_177972_a(dir.func_176734_d())).func_177230_c() != BlocksTC.vacuum) continue;
            return true;
        }
        return false;
    }

    static void generateConnections(World world, Random random, int cx, int cz, int y, Cell cell, int depth, boolean justthetip) {
        int h;
        int w;
        int d;
        int x = cx * 16;
        int z = cz * 16;
        if (cell.north) {
            for (d = 0; d <= depth; ++d) {
                int n = d == depth && justthetip ? 2 : (w = d == depth - 1 && justthetip ? 1 : 0);
                while (w < (d == depth && justthetip ? 9 : (d == depth - 1 && justthetip ? 10 : 11))) {
                    int n2 = d == depth && justthetip ? 2 : (h = d == depth - 1 && justthetip ? 1 : 0);
                    while (h < (d == depth && justthetip ? 9 : (d == depth - 1 && justthetip ? 10 : 11))) {
                        if (d != depth || !justthetip || PAT_CONNECT[h][w] != 8) {
                            GenCommon.placeBlock(world, x + 3 + w, y + 10 - h, z + d, PAT_CONNECT[h][w], EnumFacing.NORTH, cell);
                        }
                        ++h;
                    }
                    ++w;
                }
            }
        }
        if (cell.south) {
            for (d = 0; d <= depth; ++d) {
                int n = d == depth && justthetip ? 2 : (w = d == depth - 1 && justthetip ? 1 : 0);
                while (w < (d == depth && justthetip ? 9 : (d == depth - 1 && justthetip ? 10 : 11))) {
                    int n3 = d == depth && justthetip ? 2 : (h = d == depth - 1 && justthetip ? 1 : 0);
                    while (h < (d == depth && justthetip ? 9 : (d == depth - 1 && justthetip ? 10 : 11))) {
                        if (d != depth || !justthetip || PAT_CONNECT[h][w] != 8) {
                            GenCommon.placeBlock(world, x + 3 + w, y + 10 - h, z + 16 - d, PAT_CONNECT[h][w], EnumFacing.SOUTH, cell);
                        }
                        ++h;
                    }
                    ++w;
                }
            }
        }
        if (cell.east) {
            for (d = 0; d <= depth; ++d) {
                int n = d == depth && justthetip ? 2 : (w = d == depth - 1 && justthetip ? 1 : 0);
                while (w < (d == depth && justthetip ? 9 : (d == depth - 1 && justthetip ? 10 : 11))) {
                    int n4 = d == depth && justthetip ? 2 : (h = d == depth - 1 && justthetip ? 1 : 0);
                    while (h < (d == depth && justthetip ? 9 : (d == depth - 1 && justthetip ? 10 : 11))) {
                        if (d != depth || !justthetip || PAT_CONNECT[h][w] != 8) {
                            GenCommon.placeBlock(world, x + 16 - d, y + 10 - h, z + 3 + w, PAT_CONNECT[h][w], EnumFacing.EAST, cell);
                        }
                        ++h;
                    }
                    ++w;
                }
            }
        }
        if (cell.west) {
            for (d = 0; d <= depth; ++d) {
                int n = d == depth && justthetip ? 2 : (w = d == depth - 1 && justthetip ? 1 : 0);
                while (w < (d == depth && justthetip ? 9 : (d == depth - 1 && justthetip ? 10 : 11))) {
                    int n5 = d == depth && justthetip ? 2 : (h = d == depth - 1 && justthetip ? 1 : 0);
                    while (h < (d == depth && justthetip ? 9 : (d == depth - 1 && justthetip ? 10 : 11))) {
                        if (d != depth || !justthetip || PAT_CONNECT[h][w] != 8) {
                            GenCommon.placeBlock(world, x + d, y + 10 - h, z + 3 + w, PAT_CONNECT[h][w], EnumFacing.WEST, cell);
                        }
                        ++h;
                    }
                    ++w;
                }
            }
        }
    }

    static void generateChamberA(World world, Random random, int cx, int cz, int y, Cell cell) {
        int c;
        int b;
        int a;
        int x = cx * 16;
        int z = cz * 16;
        for (a = 2; a <= 14; ++a) {
            for (b = 2; b <= 14; ++b) {
                for (c = 1; c < 12; ++c) {
                    GenCommon.placeBlock(world, x + a, y + c, z + b, 9, cell);
                }
            }
        }
        for (a = 2; a <= 14; ++a) {
            for (b = 2; b <= 14; ++b) {
                for (c = 1; c < 12; ++c) {
                    if (a != 2 && a != 14 && b != 2 && b != 14 || a == 2 && b > 3 && b < 12 && cell.west && c < 10 || a == 14 && b > 3 && b < 12 && cell.east && c < 10 || b == 2 && a > 3 && a < 12 && cell.north && c < 10 || b == 14 && a > 3 && a < 12 && cell.south && c < 10) continue;
                    GenCommon.placeBlock(world, x + a, y + c, z + b, 8, cell);
                }
            }
        }
        for (a = 3; a <= 13; ++a) {
            for (b = 3; b <= 13; ++b) {
                for (c = 2; c < 11; ++c) {
                    if (a != 3 && a != 13 && b != 3 && b != 13) continue;
                    if (c > 3 && c < 9 && (a == 8 || b == 8) || c > 4 && c < 8 && (a == 7 || b == 7 || a == 9 || b == 9)) {
                        if ((a == 8 || b == 8) && c == 6) continue;
                        GenCommon.placeBlock(world, x + a, y + c, z + b, 19, cell);
                        continue;
                    }
                    GenCommon.placeBlock(world, x + a, y + c, z + b, 18, cell);
                }
            }
        }
        for (a = 2; a <= 14; ++a) {
            for (b = 2; b <= 14; ++b) {
                int g;
                int q;
                GenCommon.placeBlock(world, x + a, y, z + b, 8, cell);
                GenCommon.placeBlock(world, x + a, y + 1, z + b, 2, cell);
                GenCommon.placeBlock(world, x + a, y + 12, z + b, 8, cell);
                GenCommon.placeBlock(world, x + a, y + 11, z + b, 2, cell);
                if (a > 1 && a < 15 && b > 1 && b < 15) {
                    q = Math.min(Math.abs(8 - a), Math.abs(8 - b));
                    for (g = 0; g < q - 1; ++g) {
                        GenCommon.placeBlock(world, x + a, y + 1 + g, z + b, 2, cell);
                    }
                }
                if (a <= 3 || a >= 13 || b <= 3 || b >= 13) continue;
                q = Math.min(Math.abs(8 - a), Math.abs(8 - b));
                for (g = 0; g < q; ++g) {
                    GenCommon.placeBlock(world, x + a, y + 11 - g, z + b, 2, cell);
                }
            }
        }
        for (int g = 0; g < 5; ++g) {
            GenCommon.placeBlock(world, x + 6 + g, y + 2, z + 4, 10, EnumFacing.NORTH, cell);
            GenCommon.placeBlock(world, x + 6 + g, y + 2, z + 12, 10, EnumFacing.SOUTH, cell);
            GenCommon.placeBlock(world, x + 12, y + 2, z + 6 + g, 10, EnumFacing.EAST, cell);
            GenCommon.placeBlock(world, x + 4, y + 2, z + 6 + g, 10, EnumFacing.WEST, cell);
        }
    }

    static void generateChamberB(World world, Random random, int cx, int cz, int y, Cell cell) {
        int c;
        int b;
        int a;
        int x = cx * 16;
        int z = cz * 16;
        for (a = 2; a <= 14; ++a) {
            for (b = 2; b <= 14; ++b) {
                for (c = 1; c < 12; ++c) {
                    GenCommon.placeBlock(world, x + a, y + c, z + b, 9, cell);
                }
            }
        }
        for (a = 2; a <= 14; ++a) {
            for (b = 2; b <= 14; ++b) {
                for (c = 1; c < 12; ++c) {
                    if (a != 2 && a != 14 && b != 2 && b != 14 || a == 2 && b > 3 && b < 12 && cell.west && c < 10 || a == 14 && b > 3 && b < 12 && cell.east && c < 10 || b == 2 && a > 3 && a < 12 && cell.north && c < 10 || b == 14 && a > 3 && a < 12 && cell.south && c < 10) continue;
                    GenCommon.placeBlock(world, x + a, y + c, z + b, 8, cell);
                }
            }
        }
        for (a = 3; a <= 13; ++a) {
            for (b = 3; b <= 13; ++b) {
                for (c = 2; c < 11; ++c) {
                    if (a != 3 && a != 13 && b != 3 && b != 13) continue;
                    GenCommon.placeBlock(world, x + a, y + c, z + b, 2, cell);
                }
            }
        }
        for (a = 2; a <= 14; ++a) {
            for (b = 2; b <= 14; ++b) {
                GenCommon.placeBlock(world, x + a, y, z + b, 8, cell);
                GenCommon.placeBlock(world, x + a, y + 1, z + b, 2, cell);
                GenCommon.placeBlock(world, x + a, y + 11, z + b, 8, cell);
                GenCommon.placeBlock(world, x + a, y + 10, z + b, 2, cell);
                if (a <= 3 || a >= 13 || b <= 3 || b >= 13) continue;
                if (a <= 5 && b <= 5 || a <= 5 && b >= 11 || a >= 11 && b <= 5 || a >= 11 && b >= 11) {
                    GenCommon.placeBlock(world, x + a, y + 2, z + b, 2, cell);
                    GenCommon.placeBlock(world, x + a, y + 9, z + b, 2, cell);
                }
                if (!(a == 5 && b == 5 || a == 5 && b == 11 || a == 11 && b == 5) && (a != 11 || b != 11)) continue;
                world.func_175656_a(new BlockPos(x + a, y + 3, z + b), BlocksTC.stone.func_176203_a(5));
                world.func_175656_a(new BlockPos(x + a, y + 8, z + b), BlocksTC.stone.func_176203_a(5));
            }
        }
        for (int g = 0; g < 5; ++g) {
            GenCommon.placeBlock(world, x + 6 + g, y + 2, z + 4, 10, EnumFacing.NORTH, cell);
            GenCommon.placeBlock(world, x + 6 + g, y + 2, z + 12, 10, EnumFacing.SOUTH, cell);
            GenCommon.placeBlock(world, x + 12, y + 2, z + 6 + g, 10, EnumFacing.EAST, cell);
            GenCommon.placeBlock(world, x + 4, y + 2, z + 6 + g, 10, EnumFacing.WEST, cell);
            GenCommon.placeBlock(world, x + 6 + g, y + 9, z + 4, 11, EnumFacing.NORTH, cell);
            GenCommon.placeBlock(world, x + 6 + g, y + 9, z + 12, 11, EnumFacing.SOUTH, cell);
            GenCommon.placeBlock(world, x + 12, y + 9, z + 6 + g, 11, EnumFacing.EAST, cell);
            GenCommon.placeBlock(world, x + 4, y + 9, z + 6 + g, 11, EnumFacing.WEST, cell);
        }
    }
}

