/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.tiles.devices;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.gui.IUpdatePlayerListBox;
import net.minecraft.util.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXSpark;
import thaumcraft.common.blocks.devices.BlockAuraTotem;
import thaumcraft.common.tiles.TileThaumcraftInventory;

public class TileAuraTotem
extends TileThaumcraftInventory
implements IUpdatePlayerListBox {
    public byte type = (byte)-1;
    public int time;
    public int maxTime = 450;
    private int count = 0;
    protected int zoneOuter = -1;
    protected int zoneInner = -1;
    protected int zonePure = -1;

    @Override
    public void readCustomNBT(NBTTagCompound nbt) {
        super.readCustomNBT(nbt);
        this.type = nbt.func_74771_c("type");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt) {
        super.writeCustomNBT(nbt);
        nbt.func_74774_a("type", this.type);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtCompound) {
        super.func_145839_a(nbtCompound);
        this.time = nbtCompound.func_74762_e("time");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtCompound) {
        super.func_145841_b(nbtCompound);
        nbtCompound.func_74768_a("time", this.time);
    }

    @SideOnly(value=Side.CLIENT)
    public int getTimeScaled(int par1) {
        return this.time * par1 / this.maxTime;
    }

    public void func_73660_a() {
        ++this.count;
        if (this.zoneOuter < 0) {
            this.checkPoles();
        }
        if (!this.field_145850_b.field_72995_K && this.count % 10 == 0) {
            if (this.time > 0) {
                --this.time;
                this.performMagnet();
            } else {
                if (this.type >= 0) {
                    this.func_70296_d();
                    this.field_145850_b.func_175689_h(this.func_174877_v());
                    this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 2, -1);
                }
                this.type = (byte)-1;
                if (this.func_70301_a(0) != null && this.func_70301_a(0).func_77973_b() == ItemsTC.shard) {
                    switch (this.func_70301_a(0).func_77952_i()) {
                        case 0: {
                            this.type = 1;
                            break;
                        }
                        case 1: {
                            this.type = (byte)2;
                            break;
                        }
                        case 2: {
                            this.type = (byte)3;
                            break;
                        }
                        case 3: {
                            this.type = (byte)4;
                            break;
                        }
                        case 4: {
                            this.type = (byte)5;
                            break;
                        }
                        case 5: {
                            this.type = (byte)6;
                            break;
                        }
                        case 7: {
                            this.type = 0;
                            break;
                        }
                        case 6: {
                            this.type = (byte)7;
                        }
                    }
                    if (this.type >= 0) {
                        this.func_70298_a(0, 1);
                        this.time = this.maxTime;
                        this.func_70296_d();
                        this.field_145850_b.func_175689_h(this.func_174877_v());
                        this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 2, (int)this.type);
                    }
                }
            }
        }
        if (this.field_145850_b.field_72995_K && this.type >= 0 && this.count % 20 == 0) {
            this.drawEffect();
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void drawEffect() {
        int a = this.func_145831_w().field_73012_v.nextInt(this.zoneOuter + this.zoneInner + 1);
        FXSpark ef = new FXSpark(this.func_145831_w(), (float)this.func_174877_v().func_177958_n() + this.func_145831_w().field_73012_v.nextFloat(), (float)(this.func_174877_v().func_177956_o() - a) + this.func_145831_w().field_73012_v.nextFloat(), (float)this.func_174877_v().func_177952_p() + this.func_145831_w().field_73012_v.nextFloat(), 0.5f);
        ef.func_70538_b(0.65f + this.func_145831_w().field_73012_v.nextFloat() * 0.1f, 1.0f, 1.0f);
        ef.func_82338_g(0.8f);
        ParticleEngine.instance.addEffect(this.func_145831_w(), ef);
    }

    protected void performMagnet() {
    }

    @Override
    public boolean func_94041_b(int par1, ItemStack stack) {
        return stack != null && stack.func_77973_b() == ItemsTC.shard;
    }

    public Aspect getAspect() {
        switch (this.type) {
            default: {
                return null;
            }
            case 1: {
                return Aspect.AIR;
            }
            case 2: {
                return Aspect.FIRE;
            }
            case 3: {
                return Aspect.WATER;
            }
            case 4: {
                return Aspect.EARTH;
            }
            case 5: {
                return Aspect.ORDER;
            }
            case 6: {
                return Aspect.ENTROPY;
            }
            case 7: 
        }
        return Aspect.FLUX;
    }

    public void checkPoles() {
        this.zoneOuter = 0;
        this.zoneInner = 0;
        this.zonePure = 0;
        BlockPos p = this.func_174877_v().func_177977_b();
        IBlockState bs = this.func_145831_w().func_180495_p(p);
        int c = 0;
        while (bs.func_177230_c() == BlocksTC.auraTotem && c < 5) {
            if (bs.func_177229_b((IProperty)BlockAuraTotem.TYPE) == BlockAuraTotem.TotemType.POLE_OUTER) {
                ++this.zoneOuter;
                ++c;
            }
            if (bs.func_177229_b((IProperty)BlockAuraTotem.TYPE) == BlockAuraTotem.TotemType.POLE_INNER) {
                ++this.zoneInner;
                ++c;
            }
            if (bs.func_177229_b((IProperty)BlockAuraTotem.TYPE) == BlockAuraTotem.TotemType.POLE_PURE) {
                ++this.zonePure;
                ++c;
            }
            p = p.func_177977_b();
            bs = this.func_145831_w().func_180495_p(p);
        }
    }

    public boolean func_145842_c(int i, int j) {
        if (i == 1) {
            if (this.field_145850_b.field_72995_K) {
                this.checkPoles();
            }
            return true;
        }
        if (i == 2) {
            if (this.field_145850_b.field_72995_K) {
                this.type = (byte)j;
                this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
            }
            return true;
        }
        return super.func_145842_c(i, j);
    }
}

