/*
 * Decompiled with CFR 0.152.
 */
package thehippomaster.MutantCreatures.ai;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import thehippomaster.MutantCreatures.MutantZombie;
import thehippomaster.MutantCreatures.ZombieChunk;
import thehippomaster.MutantCreatures.ZombieResurrect;

public class MCAIZombieMelee
extends EntityAIBase {
    private double dirX = -1.0;
    private double dirZ = -1.0;
    private MutantZombie mutantZombie;
    private EntityLivingBase attackTarget;

    public MCAIZombieMelee(MutantZombie zombie) {
        this.mutantZombie = zombie;
        this.attackTarget = null;
        this.func_75248_a(7);
    }

    public boolean func_75250_a() {
        this.attackTarget = this.mutantZombie.func_70638_az();
        if (this.attackTarget == null || !this.mutantZombie.field_70122_E) {
            return false;
        }
        return this.mutantZombie.currentAttackID == 1;
    }

    public void func_75249_e() {
        this.mutantZombie.animTick = 0;
        this.mutantZombie.func_70661_as().func_75499_g();
        this.mutantZombie.field_70170_p.func_72956_a((Entity)this.mutantZombie, "MutantCreatures:mutantzombie.gruntA", 0.3f, 0.8f + this.mutantZombie.func_70681_au().nextFloat() * 0.4f);
    }

    public boolean func_75253_b() {
        return this.mutantZombie.deathTick <= 0 && this.mutantZombie.animTick < 25;
    }

    public void func_75246_d() {
        if (this.mutantZombie.animTick < 8) {
            this.mutantZombie.func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
        }
        if (this.mutantZombie.animTick == 8) {
            double x = this.attackTarget.field_70165_t - this.mutantZombie.field_70165_t;
            double z = this.attackTarget.field_70161_v - this.mutantZombie.field_70161_v;
            double d = Math.sqrt(x * x + z * z);
            this.dirX = x / d;
            this.dirZ = z / d;
        }
        if (this.mutantZombie.animTick == 12) {
            int x = MathHelper.func_76128_c((double)(this.mutantZombie.field_70165_t + this.dirX * 2.0));
            int y = MathHelper.func_76128_c((double)this.mutantZombie.field_70121_D.field_72338_b);
            int z = MathHelper.func_76128_c((double)(this.mutantZombie.field_70161_v + this.dirZ * 2.0));
            int x1 = MathHelper.func_76128_c((double)(this.mutantZombie.field_70165_t + this.dirX * 8.0));
            int z1 = MathHelper.func_76128_c((double)(this.mutantZombie.field_70161_v + this.dirZ * 8.0));
            MCAIZombieMelee.addLinePositions(this.mutantZombie.field_70170_p, this.mutantZombie.meleeGroundList, x, z, x1, z1, y);
            this.mutantZombie.field_70170_p.func_72956_a((Entity)this.mutantZombie, "random.explode", 0.5f, 0.8f + this.mutantZombie.func_70681_au().nextFloat() * 0.4f);
        }
    }

    public void func_75251_c() {
        this.mutantZombie.sendAttackPacket(0);
        this.dirX = -1.0;
        this.dirZ = -1.0;
    }

    public static void addLinePositions(World world, ArrayList<ZombieChunk> list, int x1, int z1, int x2, int z2, int y) {
        int deltaX = x2 - x1;
        int deltaZ = z2 - z1;
        int xStep = deltaX < 0 ? -1 : 1;
        int zStep = deltaZ < 0 ? -1 : 1;
        deltaX = Math.abs(deltaX);
        deltaZ = Math.abs(deltaZ);
        int x = x1;
        int z = z1;
        int deltaX2 = deltaX * 2;
        int deltaZ2 = deltaZ * 2;
        ZombieChunk chunk = MCAIZombieMelee.addPoint(world, list, x, y, z);
        if (chunk != null) {
            chunk.setFirst(true);
        }
        if (deltaX2 >= deltaZ2) {
            int error;
            int preError = error = deltaX;
            for (int i = 0; i < deltaX; ++i) {
                x += xStep;
                if ((error += deltaZ2) > deltaX2) {
                    z += zStep;
                    error -= deltaX2;
                }
                MCAIZombieMelee.addPoint(world, list, x, y, z);
                preError = error;
            }
        } else {
            int error;
            int preError = error = deltaZ;
            for (int i = 0; i < deltaZ; ++i) {
                z += zStep;
                if ((error += deltaX2) > deltaZ2) {
                    x += xStep;
                    error -= deltaZ2;
                }
                MCAIZombieMelee.addPoint(world, list, x, y, z);
                preError = error;
            }
        }
    }

    public static ZombieChunk addPoint(World world, ArrayList<ZombieChunk> list, int x, int y, int z) {
        y = ZombieResurrect.getSuitableGround(world, x, y, z, 3, false);
        ZombieChunk chunk = null;
        if (y != -1) {
            chunk = new ZombieChunk(x, y, z);
            list.add(chunk);
        }
        if (world.field_73012_v.nextInt(2) == 0) {
            list.add(new ZombieChunk(x, y + 1, z).setParticles(false));
        }
        return chunk;
    }
}

