/*
 * Decompiled with CFR 0.152.
 */
package thehippomaster.MutantCreatures.client;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import thehippomaster.MutantCreatures.MutantCreatures;
import thehippomaster.MutantCreatures.MutantEnderman;
import thehippomaster.MutantCreatures.client.EndermanArm;

@SideOnly(value=Side.CLIENT)
public class ModelMutantEnderman
extends ModelBase {
    public ModelRenderer pelvis;
    public ModelRenderer abdomen;
    public ModelRenderer chest;
    public ModelRenderer neck;
    public ModelRenderer head;
    public ModelRenderer mouth;
    public EndermanArm rightArm;
    public EndermanArm leftArm;
    public EndermanArm lowerRightArm;
    public EndermanArm lowerLeftArm;
    public ModelRenderer legjoint1;
    public ModelRenderer legjoint2;
    public ModelRenderer leg1;
    public ModelRenderer leg2;
    public ModelRenderer foreleg1;
    public ModelRenderer foreleg2;
    private float animTick;
    public static final float PI = (float)Math.PI;

    public ModelMutantEnderman() {
        this.field_78090_t = 128;
        this.field_78089_u = 64;
        this.animTick = 0.0f;
        this.pelvis = new ModelRenderer((ModelBase)this);
        this.pelvis.func_78793_a(0.0f, -15.5f, 8.0f);
        this.abdomen = new ModelRenderer((ModelBase)this, 32, 0);
        this.abdomen.func_78789_a(-4.0f, -10.0f, -2.0f, 8, 10, 4);
        this.pelvis.func_78792_a(this.abdomen);
        this.chest = new ModelRenderer((ModelBase)this, 50, 8);
        this.chest.func_78789_a(-5.0f, -16.0f, -3.0f, 10, 16, 6);
        this.chest.func_78793_a(0.0f, -8.0f, 0.0f);
        this.abdomen.func_78792_a(this.chest);
        this.neck = new ModelRenderer((ModelBase)this, 32, 14);
        this.neck.func_78789_a(-1.5f, -4.0f, -1.5f, 3, 4, 3);
        this.neck.func_78793_a(0.0f, -15.0f, 0.0f);
        this.chest.func_78792_a(this.neck);
        this.head = new ModelRenderer((ModelBase)this);
        this.head.func_78784_a(0, 0).func_78790_a(-4.0f, -4.0f, -8.0f, 8, 6, 8, 0.5f);
        this.head.func_78784_a(0, 14).func_78790_a(-4.0f, 3.0f, -8.0f, 8, 2, 8, 0.5f);
        this.head.func_78793_a(0.0f, -5.0f, 3.0f);
        this.neck.func_78792_a(this.head);
        this.mouth = new ModelRenderer((ModelBase)this, 0, 24);
        this.mouth.func_78789_a(-4.0f, 3.0f, -8.0f, 8, 2, 8);
        this.head.func_78792_a(this.mouth);
        this.rightArm = new EndermanArm(true);
        this.rightArm.init(this, this.chest);
        this.leftArm = new EndermanArm(false);
        this.leftArm.init(this, this.chest);
        this.lowerRightArm = new EndermanArm(true);
        this.lowerRightArm.init(this, this.chest);
        this.lowerRightArm.arm.field_78797_d += 6.0f;
        this.lowerLeftArm = new EndermanArm(false);
        this.lowerLeftArm.init(this, this.chest);
        this.lowerLeftArm.arm.field_78797_d += 6.0f;
        this.legjoint1 = new ModelRenderer((ModelBase)this);
        this.legjoint1.func_78793_a(-1.5f, 0.0f, 0.75f);
        this.abdomen.func_78792_a(this.legjoint1);
        this.legjoint2 = new ModelRenderer((ModelBase)this);
        this.legjoint2.func_78793_a(1.5f, 0.0f, 0.75f);
        this.abdomen.func_78792_a(this.legjoint2);
        this.leg1 = new ModelRenderer((ModelBase)this, 0, 34);
        this.leg1.func_78790_a(-1.5f, 0.0f, -1.5f, 3, 24, 3, 0.5f);
        this.leg1.func_78793_a(0.0f, -2.0f, 0.0f);
        this.legjoint1.func_78792_a(this.leg1);
        this.leg2 = new ModelRenderer((ModelBase)this, 0, 34);
        this.leg2.field_78809_i = true;
        this.leg2.func_78790_a(-1.5f, 0.0f, -1.5f, 3, 24, 3, 0.5f);
        this.leg2.func_78793_a(0.0f, -2.0f, 0.0f);
        this.legjoint2.func_78792_a(this.leg2);
        this.foreleg1 = new ModelRenderer((ModelBase)this, 12, 34);
        this.foreleg1.func_78790_a(-1.5f, 0.0f, -1.5f, 3, 24, 3, 0.5f);
        this.foreleg1.func_78793_a(0.0f, 23.0f, 0.0f);
        this.leg1.func_78792_a(this.foreleg1);
        this.foreleg2 = new ModelRenderer((ModelBase)this, 12, 34);
        this.foreleg2.field_78809_i = true;
        this.foreleg2.func_78790_a(-1.5f, 0.0f, -1.5f, 3, 24, 3, 0.5f);
        this.foreleg2.func_78793_a(0.0f, 23.0f, 0.0f);
        this.leg2.func_78792_a(this.foreleg2);
    }

    public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
        MutantEnderman enderman = (MutantEnderman)entity;
        this.setAngles();
        this.animTick = MutantCreatures.proxy.getPartialTicks();
        this.animate(enderman, f, f1, f2, f3, f4, f5);
        this.lowerRightArm.arm.animTick = this.animTick;
        this.lowerRightArm.arm.enderman = enderman;
        this.lowerLeftArm.arm.animTick = this.animTick;
        this.lowerLeftArm.arm.enderman = enderman;
        this.pelvis.func_78785_a(f5);
    }

    public void setAngles() {
        this.pelvis.field_78797_d = -15.5f;
        this.abdomen.field_78795_f = 0.31415927f;
        this.chest.field_78795_f = 0.3926991f;
        this.chest.field_78796_g = 0.0f;
        this.chest.field_78808_h = 0.0f;
        this.neck.field_78795_f = 0.19634955f;
        this.neck.field_78808_h = 0.0f;
        this.head.field_78795_f = -0.7853982f;
        this.head.field_78796_g = 0.0f;
        this.head.field_78808_h = 0.0f;
        this.mouth.field_78795_f = 0.0f;
        this.rightArm.setAngles();
        this.leftArm.setAngles();
        this.lowerRightArm.setAngles();
        this.lowerRightArm.arm.field_78795_f += 0.1f;
        this.lowerRightArm.arm.field_78808_h -= 0.2f;
        this.lowerLeftArm.setAngles();
        this.lowerLeftArm.arm.field_78795_f += 0.1f;
        this.lowerLeftArm.arm.field_78808_h += 0.2f;
        this.legjoint1.field_78795_f = 0.0f;
        this.legjoint2.field_78795_f = 0.0f;
        this.leg1.field_78795_f = -0.8975979f;
        this.leg1.field_78796_g = 0.0f;
        this.leg1.field_78808_h = 0.2617994f;
        this.leg2.field_78795_f = -0.8975979f;
        this.leg2.field_78796_g = 0.0f;
        this.leg2.field_78808_h = -0.2617994f;
        this.foreleg1.field_78795_f = 0.7853982f;
        this.foreleg1.field_78808_h = -0.1308997f;
        this.foreleg2.field_78795_f = 0.7853982f;
        this.foreleg2.field_78808_h = 0.1308997f;
    }

    public void animate(MutantEnderman enderman, float f, float f1, float f2, float f3, float f4, float f5) {
        int arm;
        float walkSpeed = 0.3f;
        float walkAnim1 = (MathHelper.func_76126_a((float)((f - 0.8f) * walkSpeed)) + 0.8f) * f1;
        float walkAnim2 = -(MathHelper.func_76126_a((float)((f + 0.8f) * walkSpeed)) - 0.8f) * f1;
        float walkAnim3 = (MathHelper.func_76126_a((float)((f + 0.8f) * walkSpeed)) - 0.8f) * f1;
        float walkAnim4 = -(MathHelper.func_76126_a((float)((f - 0.8f) * walkSpeed)) + 0.8f) * f1;
        float[] walkAnim = new float[5];
        Arrays.fill(walkAnim, MathHelper.func_76126_a((float)(f * walkSpeed)) * f1);
        float breatheAnim = MathHelper.func_76126_a((float)(f2 * 0.15f));
        float faceYaw = f3 * (float)Math.PI / 180.0f;
        float facePitch = f4 * (float)Math.PI / 180.0f;
        for (int i = 1; i < enderman.heldBlock.length; ++i) {
            if (enderman.heldBlock[i] == 0) continue;
            this.animateHoldBlock(enderman.heldBlockTick[i], i, enderman.hasTarget > 0);
            int n = i;
            walkAnim[n] = walkAnim[n] * 0.4f;
        }
        if (enderman.currentAttackID == 1) {
            arm = enderman.getMeleeArm();
            this.animateMelee(enderman.animTick, arm);
            walkAnim[arm] = 0.0f;
        }
        if (enderman.currentAttackID == 2) {
            arm = enderman.getThrownBlock();
            this.animateThrowBlock(enderman.animTick, arm);
        }
        if (enderman.currentAttackID == 5) {
            this.animateScream(enderman.animTick);
            float scale = 1.0f - MathHelper.func_76131_a((float)((float)enderman.deathTick / 6.0f), (float)0.0f, (float)1.0f);
            faceYaw *= scale;
            facePitch *= scale;
            walkAnim1 *= scale;
            walkAnim2 *= scale;
            walkAnim3 *= scale;
            walkAnim4 *= scale;
            Arrays.fill(walkAnim, 0.0f);
        }
        if (enderman.currentAttackID == 7) {
            this.animateTeleSmash(enderman.animTick);
        }
        if (enderman.currentAttackID == 10) {
            this.animateDeath(enderman.deathTick);
            float scale = 1.0f - MathHelper.func_76131_a((float)((float)enderman.deathTick / 6.0f), (float)0.0f, (float)1.0f);
            faceYaw *= scale;
            facePitch *= scale;
            walkAnim1 *= scale;
            walkAnim2 *= scale;
            walkAnim3 *= scale;
            walkAnim4 *= scale;
            Arrays.fill(walkAnim, 0.0f);
        }
        this.head.field_78795_f += facePitch * 0.5f;
        this.head.field_78796_g += faceYaw * 0.7f;
        this.head.field_78808_h -= faceYaw * 0.7f;
        this.neck.field_78795_f += facePitch * 0.3f;
        this.chest.field_78795_f += facePitch * 0.2f;
        this.mouth.field_78795_f += breatheAnim * 0.02f + 0.02f;
        this.neck.field_78795_f -= breatheAnim * 0.02f;
        this.rightArm.arm.field_78808_h += breatheAnim * 0.004f;
        this.leftArm.arm.field_78808_h -= breatheAnim * 0.004f;
        for (ModelRenderer finger : this.rightArm.finger) {
            finger.field_78808_h += breatheAnim * 0.05f;
        }
        this.rightArm.thumb.field_78808_h -= breatheAnim * 0.05f;
        for (ModelRenderer finger : this.leftArm.finger) {
            finger.field_78808_h -= breatheAnim * 0.05f;
        }
        this.leftArm.thumb.field_78808_h += breatheAnim * 0.05f;
        this.lowerRightArm.arm.field_78808_h += breatheAnim * 0.002f;
        this.lowerLeftArm.arm.field_78808_h -= breatheAnim * 0.002f;
        for (ModelRenderer finger : this.lowerRightArm.finger) {
            finger.field_78808_h += breatheAnim * 0.02f;
        }
        this.lowerRightArm.thumb.field_78808_h -= breatheAnim * 0.02f;
        for (ModelRenderer finger : this.lowerLeftArm.finger) {
            finger.field_78808_h -= breatheAnim * 0.02f;
        }
        this.lowerLeftArm.thumb.field_78808_h += breatheAnim * 0.02f;
        this.pelvis.field_78797_d -= Math.abs(walkAnim[0]);
        this.chest.field_78796_g -= walkAnim[0] * 0.06f;
        this.rightArm.arm.field_78795_f -= walkAnim[1] * 0.6f;
        this.leftArm.arm.field_78795_f += walkAnim[2] * 0.6f;
        this.rightArm.forearm.field_78795_f -= walkAnim[1] * 0.2f;
        this.leftArm.forearm.field_78795_f += walkAnim[2] * 0.2f;
        this.lowerRightArm.arm.field_78795_f -= walkAnim[3] * 0.3f;
        this.lowerLeftArm.arm.field_78795_f += walkAnim[4] * 0.3f;
        this.lowerRightArm.forearm.field_78795_f -= walkAnim[3] * 0.1f;
        this.lowerLeftArm.forearm.field_78795_f += walkAnim[4] * 0.1f;
        this.legjoint1.field_78795_f += walkAnim1 * 0.6f;
        this.legjoint2.field_78795_f += walkAnim2 * 0.6f;
        this.foreleg1.field_78795_f += walkAnim3 * 0.3f;
        this.foreleg2.field_78795_f += walkAnim4 * 0.3f;
    }

    private void animateHoldBlock(int fullTick, int armID, boolean hasTarget) {
        float tick = ((float)fullTick + this.animTick) / 10.0f;
        if (!hasTarget) {
            tick = fullTick == 0 ? 0.0f : ((float)fullTick - this.animTick) / 10.0f;
        }
        float f = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
        if (armID == 1) {
            this.rightArm.arm.field_78808_h += f * 0.8f;
            this.rightArm.forearm.field_78808_h += f * 0.6f;
            this.rightArm.hand.field_78796_g += f * 0.8f;
            this.rightArm.finger[0].field_78795_f += -f * 0.2f;
            this.rightArm.finger[2].field_78795_f += f * 0.2f;
            for (int i = 0; i < this.rightArm.finger.length; ++i) {
                this.rightArm.finger[i].field_78808_h += f * 0.6f;
            }
            this.rightArm.thumb.field_78808_h += -f * 0.4f;
        } else if (armID == 2) {
            this.leftArm.arm.field_78808_h += -f * 0.8f;
            this.leftArm.forearm.field_78808_h += -f * 0.6f;
            this.leftArm.hand.field_78796_g += -f * 0.8f;
            this.leftArm.finger[0].field_78795_f += -f * 0.2f;
            this.leftArm.finger[2].field_78795_f += f * 0.2f;
            for (int i = 0; i < this.leftArm.finger.length; ++i) {
                this.leftArm.finger[i].field_78808_h += -f * 0.6f;
            }
            this.leftArm.thumb.field_78808_h += f * 0.4f;
        } else if (armID == 3) {
            this.lowerRightArm.arm.field_78808_h += f * 0.5f;
            this.lowerRightArm.forearm.field_78808_h += f * 0.4f;
            this.lowerRightArm.hand.field_78796_g += f * 0.4f;
            this.lowerRightArm.finger[0].field_78795_f += -f * 0.2f;
            this.lowerRightArm.finger[2].field_78795_f += f * 0.2f;
            for (int i = 0; i < this.lowerRightArm.finger.length; ++i) {
                this.lowerRightArm.finger[i].field_78808_h += f * 0.6f;
            }
            this.lowerRightArm.thumb.field_78808_h += -f * 0.4f;
        } else if (armID == 4) {
            this.lowerLeftArm.arm.field_78808_h += -f * 0.5f;
            this.lowerLeftArm.forearm.field_78808_h += -f * 0.4f;
            this.lowerLeftArm.hand.field_78796_g += -f * 0.4f;
            this.lowerLeftArm.finger[0].field_78795_f += -f * 0.2f;
            this.lowerLeftArm.finger[2].field_78795_f += f * 0.2f;
            for (int i = 0; i < this.lowerLeftArm.finger.length; ++i) {
                this.lowerLeftArm.finger[i].field_78808_h += -f * 0.6f;
            }
            this.lowerLeftArm.thumb.field_78808_h += f * 0.4f;
        }
    }

    private void animateMelee(int fullTick, int armID) {
        int right = (armID & 1) == 1 ? 1 : -1;
        boolean lower = armID >= 3;
        EndermanArm arm = this.getArmFromID(armID);
        if (fullTick < 2) {
            float tick = ((float)fullTick + this.animTick) / 2.0f;
            float f = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            arm.arm.field_78795_f += f * 0.2f;
            arm.finger[0].field_78808_h += f * 0.3f * (float)right;
            arm.finger[1].field_78808_h += f * 0.3f * (float)right;
            arm.finger[2].field_78808_h += f * 0.3f * (float)right;
            arm.foreFinger[0].field_78808_h += -f * 0.5f * (float)right;
            arm.foreFinger[1].field_78808_h += -f * 0.5f * (float)right;
            arm.foreFinger[2].field_78808_h += -f * 0.5f * (float)right;
        } else if (fullTick < 5) {
            float tick = ((float)(fullTick - 2) + this.animTick) / 3.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            float f1 = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            this.chest.field_78796_g += -f1 * 0.1f * (float)right;
            arm.arm.field_78795_f += f * 1.1f - 1.1f;
            arm.forearm.field_78795_f += -f * 0.4f;
            arm.finger[0].field_78808_h += 0.3f * (float)right;
            arm.finger[1].field_78808_h += 0.3f * (float)right;
            arm.finger[2].field_78808_h += 0.3f * (float)right;
            arm.foreFinger[0].field_78808_h += -0.5f * (float)right;
            arm.foreFinger[1].field_78808_h += -0.5f * (float)right;
            arm.foreFinger[2].field_78808_h += -0.5f * (float)right;
        } else if (fullTick < 6) {
            this.chest.field_78796_g += -0.1f * (float)right;
            arm.arm.field_78795_f += -1.1f;
            arm.forearm.field_78795_f += -0.4f;
            arm.finger[0].field_78808_h += 0.3f * (float)right;
            arm.finger[1].field_78808_h += 0.3f * (float)right;
            arm.finger[2].field_78808_h += 0.3f * (float)right;
            arm.foreFinger[0].field_78808_h += -0.5f * (float)right;
            arm.foreFinger[1].field_78808_h += -0.5f * (float)right;
            arm.foreFinger[2].field_78808_h += -0.5f * (float)right;
        } else if (fullTick < 10) {
            float tick = ((float)(fullTick - 6) + this.animTick) / 4.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            this.chest.field_78796_g += -f * 0.1f * (float)right;
            arm.arm.field_78795_f += -f * 1.1f;
            arm.forearm.field_78795_f += -f * 0.4f;
            arm.finger[0].field_78808_h += f * 0.3f * (float)right;
            arm.finger[1].field_78808_h += f * 0.3f * (float)right;
            arm.finger[2].field_78808_h += f * 0.3f * (float)right;
            arm.foreFinger[0].field_78808_h += -f * 0.5f * (float)right;
            arm.foreFinger[1].field_78808_h += -f * 0.5f * (float)right;
            arm.foreFinger[2].field_78808_h += -f * 0.5f * (float)right;
        }
    }

    private void animateThrowBlock(int fullTick, int armID) {
        if (armID == 1) {
            if (fullTick < 4) {
                float tick = ((float)fullTick + this.animTick) / 4.0f;
                float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
                float f1 = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
                this.rightArm.arm.field_78795_f += -f1 * 1.5f;
                this.rightArm.arm.field_78808_h += f * 0.8f;
                this.rightArm.forearm.field_78808_h += f * 0.6f;
                this.rightArm.hand.field_78796_g += f * 0.8f;
                this.rightArm.finger[0].field_78795_f += -f * 0.2f;
                this.rightArm.finger[2].field_78795_f += f * 0.2f;
                for (int i = 0; i < this.rightArm.finger.length; ++i) {
                    this.rightArm.finger[i].field_78808_h += f * 0.6f;
                }
                this.rightArm.thumb.field_78808_h += -f * 0.4f;
            } else if (fullTick < 7) {
                this.rightArm.arm.field_78795_f += -1.5f;
            } else if (fullTick < 14) {
                float tick = ((float)(fullTick - 7) + this.animTick) / 7.0f;
                float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
                this.rightArm.arm.field_78795_f += -f * 1.5f;
            }
        } else if (armID == 2) {
            if (fullTick < 4) {
                float tick = ((float)fullTick + this.animTick) / 4.0f;
                float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
                float f1 = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
                this.leftArm.arm.field_78795_f += -f1 * 1.5f;
                this.leftArm.arm.field_78808_h += -f * 0.8f;
                this.leftArm.forearm.field_78808_h += -f * 0.6f;
                this.leftArm.hand.field_78796_g += -f * 0.8f;
                this.leftArm.finger[0].field_78795_f += -f * 0.2f;
                this.leftArm.finger[2].field_78795_f += f * 0.2f;
                for (int i = 0; i < this.leftArm.finger.length; ++i) {
                    this.leftArm.finger[i].field_78808_h += -f * 0.6f;
                }
                this.leftArm.thumb.field_78808_h += f * 0.4f;
            } else if (fullTick < 7) {
                this.leftArm.arm.field_78795_f += -1.5f;
            } else if (fullTick < 14) {
                float tick = ((float)(fullTick - 7) + this.animTick) / 7.0f;
                float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
                this.leftArm.arm.field_78795_f += -f * 1.5f;
            }
        } else if (armID == 3) {
            if (fullTick < 4) {
                float tick = ((float)fullTick + this.animTick) / 4.0f;
                float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
                float f1 = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
                this.lowerRightArm.arm.field_78795_f += -f1 * 1.5f;
                this.lowerRightArm.arm.field_78808_h += f * 0.5f;
                this.lowerRightArm.forearm.field_78808_h += f * 0.4f;
                this.lowerRightArm.hand.field_78796_g += f * 0.4f;
                this.lowerRightArm.finger[0].field_78795_f += -f * 0.2f;
                this.lowerRightArm.finger[2].field_78795_f += f * 0.2f;
                for (int i = 0; i < this.lowerRightArm.finger.length; ++i) {
                    this.lowerRightArm.finger[i].field_78808_h += f * 0.6f;
                }
                this.lowerRightArm.thumb.field_78808_h += -f * 0.4f;
            } else if (fullTick < 7) {
                this.lowerRightArm.arm.field_78795_f += -1.5f;
            } else if (fullTick < 14) {
                float tick = ((float)(fullTick - 7) + this.animTick) / 7.0f;
                float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
                this.lowerRightArm.arm.field_78795_f += -f * 1.5f;
            }
        } else if (armID == 4) {
            if (fullTick < 4) {
                float tick = ((float)fullTick + this.animTick) / 4.0f;
                float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
                float f1 = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
                this.lowerLeftArm.arm.field_78795_f += -f1 * 1.5f;
                this.lowerLeftArm.arm.field_78808_h += -f * 0.5f;
                this.lowerLeftArm.forearm.field_78808_h += -f * 0.4f;
                this.lowerLeftArm.hand.field_78796_g += -f * 0.4f;
                this.lowerLeftArm.finger[0].field_78795_f += -f * 0.2f;
                this.lowerLeftArm.finger[2].field_78795_f += f * 0.2f;
                for (int i = 0; i < this.lowerLeftArm.finger.length; ++i) {
                    this.lowerLeftArm.finger[i].field_78808_h += -f * 0.6f;
                }
                this.lowerLeftArm.thumb.field_78808_h += f * 0.4f;
            } else if (fullTick < 7) {
                this.lowerLeftArm.arm.field_78795_f += -1.5f;
            } else if (fullTick < 14) {
                float tick = ((float)(fullTick - 7) + this.animTick) / 7.0f;
                float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
                this.lowerLeftArm.arm.field_78795_f += -f * 1.5f;
            }
        }
    }

    private void animateScream(int fullTick) {
        if (fullTick < 35) {
            int i;
            float tick = ((float)fullTick + this.animTick) / 35.0f;
            float f = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            this.abdomen.field_78795_f += f * 0.3f;
            this.chest.field_78795_f += f * 0.4f;
            this.neck.field_78795_f += f * 0.2f;
            this.head.field_78795_f += f * 0.3f;
            this.rightArm.arm.field_78795_f += -f * 0.6f;
            this.rightArm.arm.field_78796_g += f * 0.4f;
            this.rightArm.forearm.field_78795_f += -f * 0.8f;
            this.rightArm.hand.field_78808_h += -f * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.rightArm.finger[i].field_78808_h += f * 0.3f;
                this.rightArm.foreFinger[i].field_78808_h += -f * 0.5f;
            }
            this.leftArm.arm.field_78795_f += -f * 0.6f;
            this.leftArm.arm.field_78796_g += -f * 0.4f;
            this.leftArm.forearm.field_78795_f += -f * 0.8f;
            this.leftArm.hand.field_78808_h += f * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.leftArm.finger[i].field_78808_h += -f * 0.3f;
                this.leftArm.foreFinger[i].field_78808_h += f * 0.5f;
            }
            this.lowerRightArm.arm.field_78795_f += -f * 0.4f;
            this.lowerRightArm.arm.field_78796_g += f * 0.2f;
            this.lowerRightArm.forearm.field_78795_f += -f * 0.8f;
            this.lowerRightArm.hand.field_78808_h += -f * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.lowerRightArm.finger[i].field_78808_h += f * 0.3f;
                this.lowerRightArm.foreFinger[i].field_78808_h += -f * 0.5f;
            }
            this.lowerLeftArm.arm.field_78795_f += -f * 0.4f;
            this.lowerLeftArm.arm.field_78796_g += -f * 0.2f;
            this.lowerLeftArm.forearm.field_78795_f += -f * 0.8f;
            this.lowerLeftArm.hand.field_78808_h += f * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.lowerLeftArm.finger[i].field_78808_h += -f * 0.3f;
                this.lowerLeftArm.foreFinger[i].field_78808_h += f * 0.5f;
            }
        } else if (fullTick < 40) {
            int i;
            this.abdomen.field_78795_f += 0.3f;
            this.chest.field_78795_f += 0.4f;
            this.neck.field_78795_f += 0.2f;
            this.head.field_78795_f += 0.3f;
            this.rightArm.arm.field_78795_f += -0.6f;
            this.rightArm.arm.field_78796_g += 0.4f;
            this.rightArm.forearm.field_78795_f += -0.8f;
            this.rightArm.hand.field_78808_h += -0.4f;
            for (i = 0; i < 3; ++i) {
                this.rightArm.finger[i].field_78808_h += 0.3f;
                this.rightArm.foreFinger[i].field_78808_h += -0.5f;
            }
            this.leftArm.arm.field_78795_f += -0.6f;
            this.leftArm.arm.field_78796_g += -0.4f;
            this.leftArm.forearm.field_78795_f += -0.8f;
            this.leftArm.hand.field_78808_h += 0.4f;
            for (i = 0; i < 3; ++i) {
                this.leftArm.finger[i].field_78808_h += -0.3f;
                this.leftArm.foreFinger[i].field_78808_h += 0.5f;
            }
            this.lowerRightArm.arm.field_78795_f += -0.4f;
            this.lowerRightArm.arm.field_78796_g += 0.2f;
            this.lowerRightArm.forearm.field_78795_f += -0.8f;
            this.lowerRightArm.hand.field_78808_h += -0.4f;
            for (i = 0; i < 3; ++i) {
                this.lowerRightArm.finger[i].field_78808_h += 0.3f;
                this.lowerRightArm.foreFinger[i].field_78808_h += -0.5f;
            }
            this.lowerLeftArm.arm.field_78795_f += -0.4f;
            this.lowerLeftArm.arm.field_78796_g += -0.2f;
            this.lowerLeftArm.forearm.field_78795_f += -0.8f;
            this.lowerLeftArm.hand.field_78808_h += 0.4f;
            for (i = 0; i < 3; ++i) {
                this.lowerLeftArm.finger[i].field_78808_h += -0.3f;
                this.lowerLeftArm.foreFinger[i].field_78808_h += 0.5f;
            }
        } else if (fullTick < 44) {
            int i;
            float tick = ((float)(fullTick - 40) + this.animTick) / 4.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            float f1 = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            this.abdomen.field_78795_f += -f * 0.1f + 0.4f;
            this.chest.field_78795_f += f * 0.1f + 0.3f;
            this.chest.field_78808_h += f1 * 0.5f;
            this.neck.field_78795_f += f * 0.2f;
            this.neck.field_78808_h += f1 * 0.2f;
            this.head.field_78795_f += f * 1.2f - 0.8f;
            this.head.field_78808_h += f1 * 0.4f;
            this.mouth.field_78795_f += f1 * 0.6f;
            this.rightArm.arm.field_78795_f += -f * 0.6f;
            this.rightArm.arm.field_78796_g += 0.4f;
            this.rightArm.forearm.field_78795_f += -f * 0.8f;
            this.rightArm.hand.field_78808_h += -f * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.rightArm.finger[i].field_78808_h += f * 0.3f;
                this.rightArm.foreFinger[i].field_78808_h += -f * 0.5f;
            }
            this.leftArm.arm.field_78795_f += -f * 0.6f;
            this.leftArm.arm.field_78796_g += -0.4f;
            this.leftArm.forearm.field_78795_f += -f * 0.8f;
            this.leftArm.hand.field_78808_h += f * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.leftArm.finger[i].field_78808_h += -f * 0.3f;
                this.leftArm.foreFinger[i].field_78808_h += f * 0.5f;
            }
            this.lowerRightArm.arm.field_78795_f += -f * 0.4f;
            this.lowerRightArm.arm.field_78796_g += -f * 0.1f + 0.3f;
            this.lowerRightArm.forearm.field_78795_f += -f * 0.8f;
            this.lowerRightArm.hand.field_78808_h += -f * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.lowerRightArm.finger[i].field_78808_h += f * 0.3f;
                this.lowerRightArm.foreFinger[i].field_78808_h += -f * 0.5f;
            }
            this.lowerLeftArm.arm.field_78795_f += -f * 0.4f;
            this.lowerLeftArm.arm.field_78796_g += f * 0.1f - 0.3f;
            this.lowerLeftArm.forearm.field_78795_f += -f * 0.8f;
            this.lowerLeftArm.hand.field_78808_h += f * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.lowerLeftArm.finger[i].field_78808_h += -f * 0.3f;
                this.lowerLeftArm.foreFinger[i].field_78808_h += f * 0.5f;
            }
            this.leg1.field_78808_h += f1 * 0.1f;
            this.leg2.field_78808_h += -f1 * 0.1f;
        } else if (fullTick < 155) {
            float tick = ((float)(fullTick - 44) + this.animTick) / 111.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            this.abdomen.field_78795_f += 0.4f;
            this.chest.field_78795_f += 0.3f;
            this.chest.field_78808_h += f * 1.0f - 0.5f;
            this.neck.field_78808_h += f * 0.4f - 0.2f;
            this.head.field_78795_f += -0.8f;
            this.head.field_78808_h += f * 0.8f - 0.4f;
            this.mouth.field_78795_f += 0.6f;
            this.rightArm.arm.field_78796_g += 0.4f;
            this.leftArm.arm.field_78796_g += -0.4f;
            this.lowerRightArm.arm.field_78796_g += 0.3f;
            this.lowerLeftArm.arm.field_78796_g += -0.3f;
            this.leg1.field_78808_h += 0.1f;
            this.leg2.field_78808_h += -0.1f;
        } else if (fullTick < 160) {
            float tick = ((float)(fullTick - 155) + this.animTick) / 5.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            this.abdomen.field_78795_f += f * 0.4f;
            this.chest.field_78795_f += f * 0.3f;
            this.chest.field_78808_h += -f * 0.5f;
            this.neck.field_78808_h += -f * 0.2f;
            this.head.field_78795_f += -f * 0.8f;
            this.head.field_78808_h += -f * 0.4f;
            this.mouth.field_78795_f += f * 0.6f;
            this.rightArm.arm.field_78796_g += f * 0.4f;
            this.leftArm.arm.field_78796_g += -f * 0.4f;
            this.lowerRightArm.arm.field_78796_g += f * 0.3f;
            this.lowerLeftArm.arm.field_78796_g += -f * 0.3f;
            this.leg1.field_78808_h += f * 0.1f;
            this.leg2.field_78808_h += -f * 0.1f;
        }
    }

    private void animateTeleSmash(int fullTick) {
        if (fullTick < 18) {
            float tick = ((float)fullTick + this.animTick) / 18.0f;
            float f = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            this.chest.field_78795_f += -f * 0.3f;
            this.rightArm.arm.field_78796_g += f * 0.2f;
            this.rightArm.arm.field_78808_h += f * 0.8f;
            this.rightArm.hand.field_78796_g += f * 1.7f;
            this.leftArm.arm.field_78796_g += -f * 0.2f;
            this.leftArm.arm.field_78808_h += -f * 0.8f;
            this.leftArm.hand.field_78796_g += -f * 1.7f;
            this.lowerRightArm.arm.field_78796_g += f * 0.2f;
            this.lowerRightArm.arm.field_78808_h += f * 0.6f;
            this.lowerRightArm.hand.field_78796_g += f * 1.7f;
            this.lowerLeftArm.arm.field_78796_g += -f * 0.2f;
            this.lowerLeftArm.arm.field_78808_h += -f * 0.6f;
            this.lowerLeftArm.hand.field_78796_g += -f * 1.7f;
        } else if (fullTick < 20) {
            float tick = ((float)(fullTick - 18) + this.animTick) / 2.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            float f1 = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            this.chest.field_78795_f += -f * 0.3f;
            this.rightArm.arm.field_78795_f += -f1 * 0.8f;
            this.rightArm.arm.field_78796_g += 0.2f;
            this.rightArm.arm.field_78808_h += 0.8f;
            this.rightArm.hand.field_78796_g += 1.7f;
            this.leftArm.arm.field_78795_f += -f1 * 0.8f;
            this.leftArm.arm.field_78796_g += -0.2f;
            this.leftArm.arm.field_78808_h += -0.8f;
            this.leftArm.hand.field_78796_g += -1.7f;
            this.lowerRightArm.arm.field_78795_f += -f1 * 0.9f;
            this.lowerRightArm.arm.field_78796_g += 0.2f;
            this.lowerRightArm.arm.field_78808_h += 0.6f;
            this.lowerRightArm.hand.field_78796_g += 1.7f;
            this.lowerLeftArm.arm.field_78795_f += -f1 * 0.9f;
            this.lowerLeftArm.arm.field_78796_g += -0.2f;
            this.lowerLeftArm.arm.field_78808_h += -0.6f;
            this.lowerLeftArm.hand.field_78796_g += -1.7f;
        } else if (fullTick < 24) {
            this.rightArm.arm.field_78795_f += -0.8f;
            this.rightArm.arm.field_78796_g += 0.2f;
            this.rightArm.arm.field_78808_h += 0.8f;
            this.rightArm.hand.field_78796_g += 1.7f;
            this.leftArm.arm.field_78795_f += -0.8f;
            this.leftArm.arm.field_78796_g += -0.2f;
            this.leftArm.arm.field_78808_h += -0.8f;
            this.leftArm.hand.field_78796_g += -1.7f;
            this.lowerRightArm.arm.field_78795_f += -0.9f;
            this.lowerRightArm.arm.field_78796_g += 0.2f;
            this.lowerRightArm.arm.field_78808_h += 0.6f;
            this.lowerRightArm.hand.field_78796_g += 1.7f;
            this.lowerLeftArm.arm.field_78795_f += -0.9f;
            this.lowerLeftArm.arm.field_78796_g += -0.2f;
            this.lowerLeftArm.arm.field_78808_h += -0.6f;
            this.lowerLeftArm.hand.field_78796_g += -1.7f;
        } else if (fullTick < 30) {
            float tick = ((float)(fullTick - 24) + this.animTick) / 6.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            this.rightArm.arm.field_78795_f += -f * 0.8f;
            this.rightArm.arm.field_78796_g += f * 0.2f;
            this.rightArm.arm.field_78808_h += f * 0.8f;
            this.rightArm.hand.field_78796_g += f * 1.7f;
            this.leftArm.arm.field_78795_f += -f * 0.8f;
            this.leftArm.arm.field_78796_g += -f * 0.2f;
            this.leftArm.arm.field_78808_h += -f * 0.8f;
            this.leftArm.hand.field_78796_g += -f * 1.7f;
            this.lowerRightArm.arm.field_78795_f += -f * 0.9f;
            this.lowerRightArm.arm.field_78796_g += f * 0.2f;
            this.lowerRightArm.arm.field_78808_h += f * 0.6f;
            this.lowerRightArm.hand.field_78796_g += f * 1.7f;
            this.lowerLeftArm.arm.field_78795_f += -f * 0.9f;
            this.lowerLeftArm.arm.field_78796_g += -f * 0.2f;
            this.lowerLeftArm.arm.field_78808_h += -f * 0.6f;
            this.lowerLeftArm.hand.field_78796_g += -f * 1.7f;
        }
    }

    private void animateDeath(int deathTick) {
        if (deathTick < 80) {
            float tick = ((float)deathTick + this.animTick) / 80.0f;
            float f = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            this.head.field_78795_f += f * 0.4f;
            this.neck.field_78795_f += f * 0.3f;
            this.pelvis.field_78797_d += -f * 12.0f;
            this.rightArm.arm.field_78795_f += -f * 0.4f;
            this.rightArm.arm.field_78796_g += f * 0.4f;
            this.rightArm.arm.field_78808_h += f * 0.6f;
            this.rightArm.forearm.field_78795_f += -f * 1.2f;
            this.leftArm.arm.field_78795_f += -f * 0.4f;
            this.leftArm.arm.field_78796_g += -f * 0.2f;
            this.leftArm.arm.field_78808_h += -f * 0.6f;
            this.leftArm.forearm.field_78795_f += -f * 1.2f;
            this.lowerRightArm.arm.field_78795_f += -f * 0.4f;
            this.lowerRightArm.arm.field_78796_g += f * 0.4f;
            this.lowerRightArm.arm.field_78808_h += f * 0.6f;
            this.lowerRightArm.forearm.field_78795_f += -f * 1.2f;
            this.lowerLeftArm.arm.field_78795_f += -f * 0.4f;
            this.lowerLeftArm.arm.field_78796_g += -f * 0.2f;
            this.lowerLeftArm.arm.field_78808_h += -f * 0.6f;
            this.lowerLeftArm.forearm.field_78795_f += -f * 1.2f;
            this.leg1.field_78795_f += -f * 0.9f;
            this.leg1.field_78796_g += f * 0.3f;
            this.leg2.field_78795_f += -f * 0.9f;
            this.leg2.field_78796_g += -f * 0.3f;
            this.foreleg1.field_78795_f += f * 1.6f;
            this.foreleg2.field_78795_f += f * 1.6f;
        } else if (deathTick < 84) {
            float tick = ((float)(deathTick - 80) + this.animTick) / 4.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            float f1 = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            this.head.field_78795_f += f * 0.4f;
            this.neck.field_78795_f += f * 0.4f - 0.1f;
            this.chest.field_78795_f += -f1 * 0.8f;
            this.abdomen.field_78795_f += -f1 * 0.2f;
            this.pelvis.field_78797_d += -12.0f;
            this.rightArm.arm.field_78795_f += -f * 0.4f;
            this.rightArm.arm.field_78796_g += -f * 1.4f + 1.8f;
            this.rightArm.arm.field_78808_h += f * 0.6f;
            this.rightArm.forearm.field_78795_f += -f * 1.2f;
            this.leftArm.arm.field_78795_f += -f * 0.4f;
            this.leftArm.arm.field_78796_g += f * 1.6f - 1.8f;
            this.leftArm.arm.field_78808_h += -f * 0.6f;
            this.leftArm.forearm.field_78795_f += -f * 1.2f;
            this.lowerRightArm.arm.field_78795_f += -f * 0.5f + 0.1f;
            this.lowerRightArm.arm.field_78796_g += -f * 1.1f + 1.5f;
            this.lowerRightArm.arm.field_78808_h += f * 0.6f;
            this.lowerRightArm.forearm.field_78795_f += -f * 1.2f;
            this.lowerLeftArm.arm.field_78795_f += -f * 0.5f + 0.1f;
            this.lowerLeftArm.arm.field_78796_g += f * 1.1f - 1.5f;
            this.lowerLeftArm.arm.field_78808_h += -f * 0.6f;
            this.lowerLeftArm.forearm.field_78795_f += -f * 1.2f;
            this.leg1.field_78795_f += -f * 1.7f + 0.8f;
            this.leg1.field_78796_g += f * 0.3f;
            this.leg1.field_78808_h += f1 * 0.2f;
            this.leg2.field_78795_f += -f * 1.7f + 0.8f;
            this.leg2.field_78796_g += -f * 0.3f;
            this.leg2.field_78808_h += -f1 * 0.2f;
            this.foreleg1.field_78795_f += f * 1.6f;
            this.foreleg2.field_78795_f += f * 1.6f;
        } else {
            this.neck.field_78795_f += -0.1f;
            this.chest.field_78795_f += -0.8f;
            this.abdomen.field_78795_f += -0.2f;
            this.pelvis.field_78797_d += -12.0f;
            this.rightArm.arm.field_78796_g += 1.8f;
            this.leftArm.arm.field_78796_g += -1.8f;
            this.lowerRightArm.arm.field_78795_f += 0.1f;
            this.lowerRightArm.arm.field_78796_g += 1.5f;
            this.lowerLeftArm.arm.field_78795_f += 0.1f;
            this.lowerLeftArm.arm.field_78796_g += -1.5f;
            this.leg1.field_78795_f += 0.8f;
            this.leg1.field_78808_h += 0.2f;
            this.leg2.field_78795_f += 0.8f;
            this.leg2.field_78808_h += -0.2f;
        }
    }

    public EndermanArm getArmFromID(int armID) {
        return armID == 1 ? this.rightArm : (armID == 2 ? this.leftArm : (armID == 3 ? this.lowerRightArm : this.lowerLeftArm));
    }
}

