/*
 * Decompiled with CFR 0.152.
 */
package thehippomaster.MutantCreatures.client;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import thehippomaster.AnimationAPI.IAnimatedEntity;
import thehippomaster.AnimationAPI.client.Animator;
import thehippomaster.AnimationAPI.client.ModelJoint;
import thehippomaster.MutantCreatures.MutantCreatures;
import thehippomaster.MutantCreatures.MutantSkeleton;
import thehippomaster.MutantCreatures.client.ModelRendererScalable;
import thehippomaster.MutantCreatures.client.SkeletonBow;
import thehippomaster.MutantCreatures.client.SkeletonSpine;

@SideOnly(value=Side.CLIENT)
public class ModelMutantSkeleton
extends ModelBase {
    public ModelRenderer skeleBase;
    public ModelRenderer pelvis;
    public ModelRenderer waist;
    public SkeletonSpine[] spine;
    public ModelRenderer neck;
    public ModelJoint head;
    public ModelRenderer jaw;
    public ModelRenderer shoulder1;
    public ModelRenderer shoulder2;
    public ModelJoint arm1;
    public ModelJoint arm2;
    public ModelJoint forearm1;
    public ModelJoint forearm2;
    public ModelJoint leg1;
    public ModelJoint leg2;
    public ModelJoint foreleg1;
    public ModelJoint foreleg2;
    public SkeletonBow bow;
    protected float partialTick;
    private Animator animator;
    public static final float PI = (float)Math.PI;

    public ModelMutantSkeleton() {
        this.field_78090_t = 128;
        this.field_78089_u = 128;
        this.partialTick = 0.0f;
        this.skeleBase = new ModelRenderer((ModelBase)this);
        this.skeleBase.func_78793_a(0.0f, 3.0f, 0.0f);
        this.pelvis = new ModelRenderer((ModelBase)this, 0, 16);
        this.pelvis.func_78789_a(-4.0f, -6.0f, -3.0f, 8, 6, 6);
        this.skeleBase.func_78792_a(this.pelvis);
        this.waist = new ModelRenderer((ModelBase)this, 32, 0);
        this.waist.func_78789_a(-2.5f, -8.0f, -2.0f, 5, 8, 4);
        this.waist.func_78793_a(0.0f, -5.0f, 0.0f);
        this.pelvis.func_78792_a(this.waist);
        this.spine = new SkeletonSpine[3];
        this.spine[0] = new SkeletonSpine(this);
        this.spine[0].middle.func_78793_a(0.0f, -7.0f, 0.0f);
        this.waist.func_78792_a(this.spine[0].middle);
        for (int i = 1; i < this.spine.length; ++i) {
            this.spine[i] = new SkeletonSpine(this);
            this.spine[i].middle.func_78793_a(0.0f, -5.0f, 0.0f);
            this.spine[i - 1].middle.func_78792_a(this.spine[i].middle);
        }
        this.neck = new ModelRenderer((ModelBase)this, 64, 0);
        this.neck.func_78789_a(-1.5f, -4.0f, -1.5f, 3, 4, 3);
        this.neck.func_78793_a(0.0f, -4.0f, 0.0f);
        this.spine[2].middle.func_78792_a(this.neck);
        this.head = new ModelJoint((ModelBase)this, 0, 0);
        this.head.func_78790_a(-4.0f, -8.0f, -4.0f, 8, 8, 8, 0.4f);
        this.head.func_78793_a(0.0f, -4.0f, -1.0f);
        this.neck.func_78792_a((ModelRenderer)this.head);
        this.jaw = new ModelRenderer((ModelBase)this, 72, 0);
        this.jaw.func_78790_a(-4.0f, -3.0f, -8.0f, 8, 3, 8, 0.7f);
        this.jaw.func_78793_a(0.0f, -0.2f, 3.5f);
        this.head.func_78792_a(this.jaw);
        this.shoulder1 = new ModelRenderer((ModelBase)this, 28, 16);
        this.shoulder1.func_78789_a(-4.0f, -3.0f, -3.0f, 8, 3, 6);
        this.shoulder1.func_78793_a(-7.0f, -3.0f, -1.0f);
        this.spine[2].middle.func_78792_a(this.shoulder1);
        this.shoulder2 = new ModelRenderer((ModelBase)this, 28, 16);
        this.shoulder2.field_78809_i = true;
        this.shoulder2.func_78789_a(-4.0f, -3.0f, -3.0f, 8, 3, 6);
        this.shoulder2.func_78793_a(7.0f, -3.0f, -1.0f);
        this.spine[2].middle.func_78792_a(this.shoulder2);
        this.arm1 = new ModelJoint((ModelBase)this, 0, 28);
        this.arm1.func_78789_a(-2.0f, 0.0f, -2.0f, 4, 12, 4);
        this.arm1.func_78793_a(-1.0f, -1.0f, 0.0f);
        this.shoulder1.func_78792_a((ModelRenderer)this.arm1);
        this.arm2 = new ModelJoint((ModelBase)this, 0, 28);
        this.arm2.field_78809_i = true;
        this.arm2.func_78789_a(-2.0f, 0.0f, -2.0f, 4, 12, 4);
        this.arm2.func_78793_a(1.0f, -1.0f, 0.0f);
        this.shoulder2.func_78792_a((ModelRenderer)this.arm2);
        this.forearm1 = new ModelJoint((ModelBase)this, 16, 28);
        this.forearm1.func_78790_a(-2.0f, 0.0f, -2.0f, 4, 14, 4, -0.01f);
        this.forearm1.func_78793_a(0.0f, 11.0f, 0.0f);
        this.arm1.func_78792_a((ModelRenderer)this.forearm1);
        this.forearm2 = new ModelJoint((ModelBase)this, 16, 28);
        this.forearm2.field_78809_i = true;
        this.forearm2.func_78790_a(-2.0f, 0.0f, -2.0f, 4, 14, 4, -0.01f);
        this.forearm2.func_78793_a(0.0f, 11.0f, 0.0f);
        this.arm2.func_78792_a((ModelRenderer)this.forearm2);
        this.leg1 = new ModelJoint((ModelBase)this, 0, 28);
        this.leg1.func_78789_a(-2.0f, 0.0f, -2.0f, 4, 12, 4);
        this.leg1.func_78793_a(-2.5f, -2.5f, 0.0f);
        this.pelvis.func_78792_a((ModelRenderer)this.leg1);
        this.leg2 = new ModelJoint((ModelBase)this, 0, 28);
        this.leg2.field_78809_i = true;
        this.leg2.func_78789_a(-2.0f, 0.0f, -2.0f, 4, 12, 4);
        this.leg2.func_78793_a(2.5f, -2.5f, 0.0f);
        this.pelvis.func_78792_a((ModelRenderer)this.leg2);
        this.foreleg1 = new ModelJoint((ModelBase)this, 32, 28);
        this.foreleg1.func_78789_a(-2.0f, 0.0f, -2.0f, 4, 12, 4);
        this.foreleg1.func_78793_a(0.0f, 12.0f, 0.0f);
        this.leg1.func_78792_a((ModelRenderer)this.foreleg1);
        this.foreleg2 = new ModelJoint((ModelBase)this, 32, 28);
        this.foreleg2.field_78809_i = true;
        this.foreleg2.func_78789_a(-2.0f, 0.0f, -2.0f, 4, 12, 4);
        this.foreleg2.func_78793_a(0.0f, 12.0f, 0.0f);
        this.leg2.func_78792_a((ModelRenderer)this.foreleg2);
        this.bow = new SkeletonBow(this);
        this.bow.armwear.func_78793_a(0.0f, 8.0f, 0.0f);
        this.forearm1.func_78792_a(this.bow.armwear);
        this.animator = new Animator((ModelBase)this);
    }

    public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
        this.animator.update((IAnimatedEntity)entity);
        this.setAngles();
        this.partialTick = MutantCreatures.proxy.getPartialTicks();
        this.animate((MutantSkeleton)entity, f, f1, f2, f3, f4, f5);
        this.skeleBase.func_78785_a(f5);
    }

    private void resetAngles(ModelRenderer ... boxes) {
        for (ModelRenderer box : boxes) {
            box.field_78795_f = 0.0f;
            box.field_78796_g = 0.0f;
            box.field_78808_h = 0.0f;
        }
    }

    public void setAngles() {
        this.skeleBase.field_78797_d = 3.0f;
        this.pelvis.field_78795_f = -0.31415927f;
        this.waist.field_78795_f = 0.22439948f;
        for (int i = 0; i < this.spine.length; ++i) {
            this.spine[i].setAngles((float)Math.PI, i == 1);
        }
        this.neck.field_78795_f = -0.1308997f;
        this.head.field_78795_f = -0.1308997f;
        this.jaw.field_78795_f = 0.09817477f;
        this.shoulder1.field_78795_f = -0.7853982f;
        this.shoulder2.field_78795_f = -0.7853982f;
        this.arm1.getModel().field_78795_f = 0.5235988f;
        this.arm1.getModel().field_78808_h = 0.31415927f;
        this.arm2.getModel().field_78795_f = 0.5235988f;
        this.arm2.getModel().field_78808_h = -0.31415927f;
        this.forearm1.getModel().field_78795_f = -0.5235988f;
        this.forearm2.getModel().field_78795_f = -0.5235988f;
        this.leg1.field_78795_f = -0.2617994f - this.pelvis.field_78795_f;
        this.leg1.field_78808_h = 0.19634955f;
        this.leg2.field_78795_f = -0.2617994f - this.pelvis.field_78795_f;
        this.leg2.field_78808_h = -0.19634955f;
        this.foreleg1.field_78808_h = -0.1308997f;
        this.foreleg1.getModel().field_78795_f = 0.31415927f;
        this.foreleg2.field_78808_h = 0.1308997f;
        this.foreleg2.getModel().field_78795_f = 0.31415927f;
        this.bow.setAngles((float)Math.PI);
    }

    public void animate(MutantSkeleton skele, float f, float f1, float f2, float f3, float f4, float f5) {
        float scale;
        float walkAnim1 = MathHelper.func_76126_a((float)(f * 0.5f));
        float walkAnim2 = MathHelper.func_76126_a((float)(f * 0.5f - 1.1f));
        float breatheAnim = MathHelper.func_76126_a((float)(f2 * 0.1f));
        float faceYaw = f3 * (float)Math.PI / 180.0f;
        float facePitch = f4 * (float)Math.PI / 180.0f;
        if (skele.currentAttackID == 1) {
            this.animateMelee(skele.animTick);
            this.bow.rotateRope();
            float walkScale = 1.0f - MathHelper.func_76131_a((float)((float)skele.animTick / 4.0f), (float)0.0f, (float)1.0f);
            walkAnim1 *= walkScale;
            walkAnim2 *= walkScale;
        } else if (skele.currentAttackID == 2) {
            this.animateShoot(skele.animTick, facePitch, faceYaw);
            scale = 1.0f - MathHelper.func_76131_a((float)((float)skele.animTick / 4.0f), (float)0.0f, (float)1.0f);
            walkAnim1 *= scale;
            walkAnim2 *= scale;
            facePitch *= scale;
            faceYaw *= scale;
        } else if (skele.currentAttackID == 3) {
            this.animateMultiShoot(skele.animTick, facePitch, faceYaw);
            scale = 1.0f - MathHelper.func_76131_a((float)((float)skele.animTick / 4.0f), (float)0.0f, (float)1.0f);
            walkAnim1 *= scale;
            walkAnim2 *= scale;
            facePitch *= scale;
            faceYaw *= scale;
        } else if (this.animator.setAnim(4)) {
            this.animateConstrict();
            this.bow.rotateRope();
            scale = 1.0f - MathHelper.func_76131_a((float)((float)skele.animTick / 6.0f), (float)0.0f, (float)1.0f);
            facePitch *= scale;
            faceYaw *= scale;
        } else {
            this.bow.rotateRope();
        }
        this.skeleBase.field_78797_d -= (-0.5f + Math.abs(walkAnim1)) * f1;
        this.spine[0].middle.field_78796_g -= walkAnim1 * 0.06f * f1;
        this.arm1.field_78795_f -= walkAnim1 * 0.9f * f1;
        this.arm2.field_78795_f += walkAnim1 * 0.9f * f1;
        this.leg1.field_78795_f += (0.2f + walkAnim1) * 1.0f * f1;
        this.leg2.field_78795_f -= (-0.2f + walkAnim1) * 1.0f * f1;
        this.foreleg1.getModel().field_78795_f += (0.6f + walkAnim2) * 0.6f * f1;
        this.foreleg2.getModel().field_78795_f -= (-0.6f + walkAnim2) * 0.6f * f1;
        for (int i = 0; i < this.spine.length; ++i) {
            this.spine[i].animate(breatheAnim);
        }
        this.head.field_78795_f -= breatheAnim * 0.02f;
        this.jaw.field_78795_f += breatheAnim * 0.04f + 0.04f;
        this.arm1.field_78808_h += breatheAnim * 0.025f;
        this.arm2.field_78808_h -= breatheAnim * 0.025f;
        this.head.getModel().field_78795_f += facePitch;
        this.head.getModel().field_78796_g += faceYaw;
    }

    protected void animateMelee(int fullTick) {
        if (fullTick < 3) {
            float tick = ((float)fullTick + this.partialTick) / 3.0f;
            float f = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            for (int i = 0; i < this.spine.length; ++i) {
                this.spine[i].middle.field_78796_g += f * (float)Math.PI / 16.0f;
            }
            this.arm1.field_78796_g += f * (float)Math.PI / 10.0f;
            this.arm1.field_78808_h += f * (float)Math.PI / 4.0f;
            this.arm2.field_78808_h += f * (float)(-Math.PI) / 16.0f;
        } else if (fullTick < 5) {
            float tick = ((float)(fullTick - 3) + this.partialTick) / 2.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            for (int i = 0; i < this.spine.length; ++i) {
                this.spine[i].middle.field_78796_g += f * 0.5890486f - 0.3926991f;
            }
            this.arm1.field_78796_g += f * 2.7307692f - 2.41661f;
            this.arm1.field_78808_h += f * 1.1780972f - 0.3926991f;
            this.arm2.field_78808_h += -0.19634955f;
        } else if (fullTick < 8) {
            for (int i = 0; i < this.spine.length; ++i) {
                this.spine[i].middle.field_78796_g += -0.3926991f;
            }
            this.arm1.field_78796_g += -2.41661f;
            this.arm1.field_78808_h += -0.3926991f;
            this.arm2.field_78808_h += -0.19634955f;
        } else if (fullTick < 14) {
            float tick = ((float)(fullTick - 8) + this.partialTick) / 6.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            for (int i = 0; i < this.spine.length; ++i) {
                this.spine[i].middle.field_78796_g += f * (float)(-Math.PI) / 8.0f;
            }
            this.arm1.field_78796_g += f * (float)(-Math.PI) / 1.3f;
            this.arm1.field_78808_h += f * (float)(-Math.PI) / 8.0f;
            this.arm2.field_78808_h += f * (float)(-Math.PI) / 16.0f;
        }
    }

    protected void animateShoot(int fullTick, float facePitch, float faceYaw) {
        if (fullTick < 5) {
            float tick = ((float)fullTick + this.partialTick) / 5.0f;
            float f = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            this.arm1.getModel().field_78795_f += -f * (float)Math.PI / 4.0f;
            this.arm1.field_78796_g += -f * (float)Math.PI / 2.0f;
            this.arm1.field_78808_h += f * (float)Math.PI / 16.0f;
            this.forearm1.field_78795_f += f * (float)Math.PI / 7.0f;
            this.arm2.getModel().field_78795_f += -f * (float)Math.PI / 4.0f;
            this.arm2.field_78796_g += f * (float)Math.PI / 2.0f;
            this.arm2.field_78808_h += -f * (float)Math.PI / 16.0f;
            this.arm2.getModel().field_78808_h += -f * (float)Math.PI / 8.0f;
            this.forearm2.field_78795_f += -f * (float)Math.PI / 6.0f;
            this.bow.rotateRope();
        } else if (fullTick < 12) {
            float tick = ((float)(fullTick - 5) + this.partialTick) / 7.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            float f1 = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            float f1s = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f * 0.4f));
            this.head.getModel().field_78796_g += f1 * (float)Math.PI / 4.0f;
            for (int i = 0; i < this.spine.length; ++i) {
                this.spine[i].middle.field_78796_g += -f1 * (float)Math.PI / 12.0f;
                this.spine[i].middle.field_78795_f += f1 * facePitch / 3.0f;
                this.spine[i].middle.field_78796_g += f1 * faceYaw / 3.0f;
            }
            this.arm1.getModel().field_78795_f += f * 0.2617994f - 1.0471976f;
            this.arm1.field_78796_g += f * -0.9424778f - 0.62831855f;
            this.arm1.field_78808_h += f * -0.850848f + 1.0471976f;
            this.forearm1.field_78795_f += 0.44879895f;
            this.arm2.getModel().field_78795_f += f * 1.8325956f - 2.6179938f;
            this.arm2.field_78796_g += f * 0.9424778f + 0.62831855f;
            this.arm2.field_78808_h += f * 0.850848f - 1.0471976f;
            this.arm2.getModel().field_78808_h += -f * (float)Math.PI / 8.0f;
            this.forearm2.field_78795_f += f * 0.10471976f - 0.62831855f;
            this.bow.middle1.field_78795_f += -f1s * (float)Math.PI / 16.0f;
            this.bow.side1.field_78795_f += -f1s * (float)Math.PI / 24.0f;
            this.bow.middle2.field_78795_f += f1s * (float)Math.PI / 16.0f;
            this.bow.side2.field_78795_f += f1s * (float)Math.PI / 24.0f;
            this.bow.rotateRope();
            this.bow.rope1.field_78795_f += f1s * (float)Math.PI / 6.0f;
            this.bow.rope2.field_78795_f += -f1s * (float)Math.PI / 6.0f;
        } else if (fullTick < 26) {
            this.head.getModel().field_78796_g += 0.7853982f;
            for (int i = 0; i < this.spine.length; ++i) {
                this.spine[i].middle.field_78796_g += -0.2617994f;
                this.spine[i].middle.field_78795_f += facePitch / 3.0f;
                this.spine[i].middle.field_78796_g += faceYaw / 3.0f;
            }
            this.arm1.getModel().field_78795_f += -1.0471976f;
            this.arm1.field_78796_g += -0.62831855f;
            this.arm1.field_78808_h += 1.0471976f;
            this.forearm1.field_78795_f += 0.44879895f;
            this.arm2.getModel().field_78795_f += -2.6179938f;
            this.arm2.field_78796_g += 0.62831855f;
            this.arm2.field_78808_h += -1.0471976f;
            this.forearm2.field_78795_f += -0.62831855f;
            float tick = MathHelper.func_76131_a((float)((float)(fullTick - 25) + this.partialTick), (float)0.0f, (float)1.0f);
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            this.bow.middle1.field_78795_f += -f * (float)Math.PI / 16.0f;
            this.bow.side1.field_78795_f += -f * (float)Math.PI / 24.0f;
            this.bow.middle2.field_78795_f += f * (float)Math.PI / 16.0f;
            this.bow.side2.field_78795_f += f * (float)Math.PI / 24.0f;
            this.bow.rotateRope();
            this.bow.rope1.field_78795_f += f * (float)Math.PI / 6.0f;
            this.bow.rope2.field_78795_f += -f * (float)Math.PI / 6.0f;
        } else if (fullTick < 30) {
            float tick = ((float)(fullTick - 26) + this.partialTick) / 4.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            this.head.getModel().field_78796_g += f * (float)Math.PI / 4.0f;
            for (int i = 0; i < this.spine.length; ++i) {
                this.spine[i].middle.field_78796_g += -f * (float)Math.PI / 12.0f;
                this.spine[i].middle.field_78795_f += f * facePitch / 3.0f;
                this.spine[i].middle.field_78796_g += f * faceYaw / 3.0f;
            }
            this.arm1.getModel().field_78795_f += -f * (float)Math.PI / 3.0f;
            this.arm1.field_78796_g += -f * (float)Math.PI / 5.0f;
            this.arm1.field_78808_h += f * (float)Math.PI / 3.0f;
            this.forearm1.field_78795_f += f * (float)Math.PI / 7.0f;
            this.arm2.getModel().field_78795_f += -f * (float)Math.PI / 1.2f;
            this.arm2.field_78796_g += f * (float)Math.PI / 5.0f;
            this.arm2.field_78808_h += -f * (float)Math.PI / 3.0f;
            this.forearm2.field_78795_f += -f * (float)Math.PI / 5.0f;
            this.bow.rotateRope();
        }
    }

    protected void animateMultiShoot(int fullTick, float facePitch, float faceYaw) {
        if (fullTick < 10) {
            float tick = ((float)fullTick + this.partialTick) / 10.0f;
            float f = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            this.skeleBase.field_78797_d += f * 3.5f;
            this.spine[0].middle.field_78795_f += f * (float)Math.PI / 6.0f;
            this.head.field_78795_f += -f * (float)Math.PI / 4.0f;
            this.arm1.field_78795_f += f * (float)Math.PI / 6.0f;
            this.arm1.field_78808_h += f * (float)Math.PI / 16.0f;
            this.arm2.field_78795_f += f * (float)Math.PI / 6.0f;
            this.arm2.field_78808_h += -f * (float)Math.PI / 16.0f;
            this.leg1.field_78795_f += -f * (float)Math.PI / 8.0f;
            this.leg2.field_78795_f += -f * (float)Math.PI / 8.0f;
            this.foreleg1.getModel().field_78795_f += f * (float)Math.PI / 4.0f;
            this.foreleg2.getModel().field_78795_f += f * (float)Math.PI / 4.0f;
            this.bow.rotateRope();
        } else if (fullTick < 12) {
            float tick = ((float)(fullTick - 10) + this.partialTick) / 2.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            float f1 = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            this.skeleBase.field_78797_d += f * 3.5f;
            this.spine[0].middle.field_78795_f += f * (float)Math.PI / 6.0f;
            this.head.field_78795_f += -f * (float)Math.PI / 4.0f;
            this.arm1.field_78795_f += f * (float)Math.PI / 6.0f;
            this.arm1.field_78808_h += f * (float)Math.PI / 16.0f;
            this.arm2.field_78795_f += f * (float)Math.PI / 6.0f;
            this.arm2.field_78808_h += -f * (float)Math.PI / 16.0f;
            this.leg1.field_78795_f += -f * (float)Math.PI / 8.0f;
            this.leg2.field_78795_f += -f * (float)Math.PI / 8.0f;
            this.foreleg1.getModel().field_78795_f += f * (float)Math.PI / 4.0f;
            this.foreleg2.getModel().field_78795_f += f * (float)Math.PI / 4.0f;
            this.arm1.field_78808_h += -f1 * (float)Math.PI / 14.0f;
            this.arm2.field_78808_h += f1 * (float)Math.PI / 14.0f;
            this.leg1.field_78808_h += -f1 * (float)Math.PI / 24.0f;
            this.leg2.field_78808_h += f1 * (float)Math.PI / 24.0f;
            this.foreleg1.field_78808_h += f1 * (float)Math.PI / 64.0f;
            this.foreleg2.field_78808_h += -f1 * (float)Math.PI / 64.0f;
            this.bow.rotateRope();
        } else if (fullTick < 14) {
            this.arm1.field_78808_h += -0.22439948f;
            this.arm2.field_78808_h += 0.22439948f;
            this.leg1.field_78808_h += -0.1308997f;
            this.leg2.field_78808_h += 0.1308997f;
            this.foreleg1.field_78808_h += 0.049087387f;
            this.foreleg2.field_78808_h += -0.049087387f;
            this.bow.rotateRope();
        } else if (fullTick < 17) {
            float tick = ((float)(fullTick - 14) + this.partialTick) / 3.0f;
            float f = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            float f1 = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            this.arm1.field_78808_h += -f1 * (float)Math.PI / 14.0f;
            this.arm2.field_78808_h += f1 * (float)Math.PI / 14.0f;
            this.leg1.field_78808_h += -f1 * (float)Math.PI / 24.0f;
            this.leg2.field_78808_h += f1 * (float)Math.PI / 24.0f;
            this.foreleg1.field_78808_h += f1 * (float)Math.PI / 64.0f;
            this.foreleg2.field_78808_h += -f1 * (float)Math.PI / 64.0f;
            this.arm1.getModel().field_78795_f += -f * (float)Math.PI / 4.0f;
            this.arm1.field_78796_g += -f * (float)Math.PI / 2.0f;
            this.arm1.field_78808_h += f * (float)Math.PI / 16.0f;
            this.forearm1.field_78795_f += f * (float)Math.PI / 7.0f;
            this.arm2.getModel().field_78795_f += -f * (float)Math.PI / 4.0f;
            this.arm2.field_78796_g += f * (float)Math.PI / 2.0f;
            this.arm2.field_78808_h += -f * (float)Math.PI / 16.0f;
            this.arm2.getModel().field_78808_h += -f * (float)Math.PI / 8.0f;
            this.forearm2.field_78795_f += -f * (float)Math.PI / 6.0f;
            this.bow.rotateRope();
        } else if (fullTick < 20) {
            float tick = ((float)(fullTick - 17) + this.partialTick) / 3.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            float f1 = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            float f1s = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f * 0.4f));
            this.head.getModel().field_78796_g += f1 * (float)Math.PI / 4.0f;
            for (int i = 0; i < this.spine.length; ++i) {
                this.spine[i].middle.field_78796_g += -f1 * (float)Math.PI / 12.0f;
                this.spine[i].middle.field_78795_f += f1 * facePitch / 3.0f;
                this.spine[i].middle.field_78796_g += f1 * faceYaw / 3.0f;
            }
            this.arm1.getModel().field_78795_f += f * 0.2617994f - 1.0471976f;
            this.arm1.field_78796_g += f * -0.9424778f - 0.62831855f;
            this.arm1.field_78808_h += f * -0.850848f + 1.0471976f;
            this.forearm1.field_78795_f += 0.44879895f;
            this.arm2.getModel().field_78795_f += f * 1.8325956f - 2.6179938f;
            this.arm2.field_78796_g += f * 0.9424778f + 0.62831855f;
            this.arm2.field_78808_h += f * 0.850848f - 1.0471976f;
            this.arm2.getModel().field_78808_h += -f * (float)Math.PI / 8.0f;
            this.forearm2.field_78795_f += f * 0.10471976f - 0.62831855f;
            this.bow.middle1.field_78795_f += -f1s * (float)Math.PI / 16.0f;
            this.bow.side1.field_78795_f += -f1s * (float)Math.PI / 24.0f;
            this.bow.middle2.field_78795_f += f1s * (float)Math.PI / 16.0f;
            this.bow.side2.field_78795_f += f1s * (float)Math.PI / 24.0f;
            this.bow.rotateRope();
            this.bow.rope1.field_78795_f += f1s * (float)Math.PI / 6.0f;
            this.bow.rope2.field_78795_f += -f1s * (float)Math.PI / 6.0f;
        } else if (fullTick < 24) {
            this.head.getModel().field_78796_g += 0.7853982f;
            for (int i = 0; i < this.spine.length; ++i) {
                this.spine[i].middle.field_78796_g += -0.2617994f;
                this.spine[i].middle.field_78795_f += facePitch / 3.0f;
                this.spine[i].middle.field_78796_g += faceYaw / 3.0f;
            }
            this.arm1.getModel().field_78795_f += -1.0471976f;
            this.arm1.field_78796_g += -0.62831855f;
            this.arm1.field_78808_h += 1.0471976f;
            this.forearm1.field_78795_f += 0.44879895f;
            this.arm2.getModel().field_78795_f += -2.6179938f;
            this.arm2.field_78796_g += 0.62831855f;
            this.arm2.field_78808_h += -1.0471976f;
            this.forearm2.field_78795_f += -0.62831855f;
            float tick = MathHelper.func_76131_a((float)((float)(fullTick - 25) + this.partialTick), (float)0.0f, (float)1.0f);
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            this.bow.middle1.field_78795_f += -f * (float)Math.PI / 16.0f;
            this.bow.side1.field_78795_f += -f * (float)Math.PI / 24.0f;
            this.bow.middle2.field_78795_f += f * (float)Math.PI / 16.0f;
            this.bow.side2.field_78795_f += f * (float)Math.PI / 24.0f;
            this.bow.rotateRope();
            this.bow.rope1.field_78795_f += f * (float)Math.PI / 6.0f;
            this.bow.rope2.field_78795_f += -f * (float)Math.PI / 6.0f;
        } else if (fullTick < 28) {
            float tick = ((float)(fullTick - 24) + this.partialTick) / 4.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            this.head.getModel().field_78796_g += f * (float)Math.PI / 4.0f;
            for (int i = 0; i < this.spine.length; ++i) {
                this.spine[i].middle.field_78796_g += -f * (float)Math.PI / 12.0f;
                this.spine[i].middle.field_78795_f += f * facePitch / 3.0f;
                this.spine[i].middle.field_78796_g += f * faceYaw / 3.0f;
            }
            this.arm1.getModel().field_78795_f += -f * (float)Math.PI / 3.0f;
            this.arm1.field_78796_g += -f * (float)Math.PI / 5.0f;
            this.arm1.field_78808_h += f * (float)Math.PI / 3.0f;
            this.forearm1.field_78795_f += f * (float)Math.PI / 7.0f;
            this.arm2.getModel().field_78795_f += -f * (float)Math.PI / 1.2f;
            this.arm2.field_78796_g += f * (float)Math.PI / 5.0f;
            this.arm2.field_78808_h += -f * (float)Math.PI / 3.0f;
            this.forearm2.field_78795_f += -f * (float)Math.PI / 5.0f;
            this.bow.rotateRope();
        }
    }

    protected void animateConstrict() {
        block6: {
            float f;
            float tick;
            int animTick;
            block7: {
                block5: {
                    float f1;
                    float f2;
                    int i;
                    this.animator.startPhase(5);
                    this.animator.rotate(this.waist, 0.1308997f, 0.0f, 0.0f);
                    for (i = 0; i < this.spine.length; ++i) {
                        f2 = i == 0 ? 0.3926991f : (i == 2 ? -0.3926991f : 0.0f);
                        f1 = i == 1 ? 0.3926991f : 0.31415927f;
                        this.animator.rotate(this.spine[i].side1[0], f2, f1, 0.0f);
                        this.animator.rotate(this.spine[i].side1[1], 0.0f, 0.15707964f, 0.0f);
                        this.animator.rotate(this.spine[i].side1[2], 0.0f, 0.2617994f, 0.0f);
                        this.animator.rotate(this.spine[i].side2[0], f2, -f1, 0.0f);
                        this.animator.rotate(this.spine[i].side2[1], 0.0f, -0.15707964f, 0.0f);
                        this.animator.rotate(this.spine[i].side2[2], 0.0f, -0.2617994f, 0.0f);
                    }
                    this.animator.rotate((ModelRenderer)this.arm1, 0.0f, 0.0f, 0.8975979f);
                    this.animator.rotate((ModelRenderer)this.arm2, 0.0f, 0.0f, -0.8975979f);
                    this.animator.move(this.skeleBase, 0.0f, 1.0f, 0.0f);
                    this.animator.rotate((ModelRenderer)this.leg1, -0.44879895f, 0.0f, 0.0f);
                    this.animator.rotate((ModelRenderer)this.leg2, -0.44879895f, 0.0f, 0.0f);
                    this.animator.rotate(this.foreleg1.getModel(), 0.5235988f, 0.0f, 0.0f);
                    this.animator.rotate(this.foreleg2.getModel(), 0.5235988f, 0.0f, 0.0f);
                    this.animator.endPhase();
                    this.animator.setStationaryPhase(2);
                    this.animator.startPhase(1);
                    this.animator.rotate(this.neck, 0.19634955f, 0.0f, 0.0f);
                    this.animator.rotate((ModelRenderer)this.head, 0.15707964f, 0.0f, 0.0f);
                    this.animator.rotate(this.waist, 0.31415927f, 0.0f, 0.0f);
                    this.animator.rotate(this.spine[0].middle, 0.2617994f, 0.0f, 0.0f);
                    for (i = 0; i < this.spine.length; ++i) {
                        f2 = i == 0 ? 0.1308997f : (i == 2 ? -0.1308997f : 0.0f);
                        f1 = i == 1 ? -0.17453294f : -0.22439948f;
                        this.animator.rotate(this.spine[i].side1[0], f2 - 0.08f, f1, 0.0f);
                        this.animator.rotate(this.spine[i].side1[1], 0.0f, 0.15707964f, 0.0f);
                        this.animator.rotate(this.spine[i].side1[2], 0.0f, 0.2617994f, 0.0f);
                        this.animator.rotate(this.spine[i].side2[0], f2 + 0.08f, -f1, 0.0f);
                        this.animator.rotate(this.spine[i].side2[1], 0.0f, -0.15707964f, 0.0f);
                        this.animator.rotate(this.spine[i].side2[2], 0.0f, -0.2617994f, 0.0f);
                    }
                    this.animator.move(this.skeleBase, 0.0f, 1.0f, 0.0f);
                    this.animator.rotate((ModelRenderer)this.leg1, -0.44879895f, 0.0f, 0.0f);
                    this.animator.rotate((ModelRenderer)this.leg2, -0.44879895f, 0.0f, 0.0f);
                    this.animator.rotate(this.foreleg1.getModel(), 0.5235988f, 0.0f, 0.0f);
                    this.animator.rotate(this.foreleg2.getModel(), 0.5235988f, 0.0f, 0.0f);
                    this.animator.endPhase();
                    this.animator.setStationaryPhase(4);
                    this.animator.resetPhase(8);
                    animTick = this.animator.getEntity().getAnimTick();
                    if (animTick >= 5) break block5;
                    tick = ((float)animTick + this.partialTick) / 5.0f;
                    f = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
                    for (int i2 = 0; i2 < this.spine.length; ++i2) {
                        ((ModelRendererScalable)this.spine[i2].side1[0]).setScale(1.0f + f * 0.6f);
                        ((ModelRendererScalable)this.spine[i2].side2[0]).setScale(1.0f + f * 0.6f);
                    }
                    break block6;
                }
                if (animTick >= 12) break block7;
                for (int i = 0; i < this.spine.length; ++i) {
                    ((ModelRendererScalable)this.spine[i].side1[0]).setScale(1.6f);
                    ((ModelRendererScalable)this.spine[i].side2[0]).setScale(1.6f);
                }
                break block6;
            }
            if (animTick >= 20) break block6;
            tick = ((float)(animTick - 12) + this.partialTick) / 8.0f;
            f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            for (int i = 0; i < this.spine.length; ++i) {
                ((ModelRendererScalable)this.spine[i].side1[0]).setScale(1.0f + f * 0.6f);
                ((ModelRendererScalable)this.spine[i].side2[0]).setScale(1.0f + f * 0.6f);
            }
        }
    }

    public static ModelRenderer createSkull(ModelBase base) {
        ModelRenderer head = new ModelRenderer(base, 0, 0);
        head.func_78790_a(-4.0f, -8.0f, -4.0f, 8, 8, 8, 0.4f);
        ModelRenderer jaw = new ModelRenderer(base, 32, 0);
        jaw.func_78790_a(-4.0f, -3.0f, -8.0f, 8, 3, 8, 0.7f);
        jaw.func_78793_a(0.0f, -0.2f, 3.5f);
        jaw.field_78795_f = 0.09817477f;
        head.func_78792_a(jaw);
        return head;
    }
}

