/*
 * Decompiled with CFR 0.152.
 */
package thehippomaster.MutantCreatures.item;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import thehippomaster.MutantCreatures.CreeperMinion;
import thehippomaster.MutantCreatures.MutantCreatures;

public class MCSpawnEgg
extends Item {
    @SideOnly(value=Side.CLIENT)
    private IIcon secondaryIcon;
    public static HashMap<Integer, EggColors> eggColorsMap = new HashMap();

    public MCSpawnEgg() {
        this.func_77627_a(true);
        this.func_77637_a(MutantCreatures.creativeTab);
    }

    public String func_77653_i(ItemStack stack) {
        ModContainer container = FMLCommonHandler.instance().findContainerFor((Object)MutantCreatures.instance);
        EntityRegistry.EntityRegistration registration = EntityRegistry.instance().lookupModSpawn(container, stack.func_77960_j());
        return "Spawn " + StatCollector.func_74838_a((String)("entity.MutantCreatures." + registration.getEntityName() + ".name"));
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int i) {
        EggColors colors = eggColorsMap.get(stack.func_77960_j());
        if (colors == null) {
            return 0xFFFFFF;
        }
        return i == 0 ? colors.primaryColor : colors.secondaryColor;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        EntityLiving living;
        if (world.field_72995_K) {
            return true;
        }
        Block block = world.func_147439_a(x, y, z);
        x += Facing.field_71586_b[side];
        y += Facing.field_71587_c[side];
        z += Facing.field_71585_d[side];
        double addY = 0.0;
        if (side == 1 && block != Blocks.field_150350_a && block.func_149645_b() == 11) {
            addY = 0.5;
        }
        if ((living = MCSpawnEgg.spawnMutantCreature(world, stack.func_77960_j(), (double)x + 0.5, (double)y + addY, (double)z + 0.5)) != null) {
            if (stack.func_82837_s()) {
                living.func_94058_c(stack.func_82833_r());
            }
            if (living instanceof CreeperMinion) {
                CreeperMinion minion = (CreeperMinion)living;
                minion.setOwner(player.func_70005_c_());
                minion.setSitting(true);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
        }
        return true;
    }

    public static EntityLiving spawnMutantCreature(World world, int id, double x, double y, double z) {
        if (world.field_72995_K) {
            return null;
        }
        ModContainer container = FMLCommonHandler.instance().findContainerFor((Object)MutantCreatures.instance);
        EntityRegistry.EntityRegistration registration = EntityRegistry.instance().lookupModSpawn(container, id);
        Entity entity = MCSpawnEgg.createEntity(registration.getEntityClass(), world);
        if (entity != null && entity instanceof EntityLiving) {
            EntityLiving living = (EntityLiving)entity;
            living.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            living.field_70759_as = living.field_70177_z;
            living.field_70761_aq = living.field_70177_z;
            living.func_110161_a(null);
            world.func_72838_d((Entity)living);
            living.func_70642_aH();
            return living;
        }
        return null;
    }

    public static Entity createEntity(Class<? extends Entity> clazz, World world) {
        if (clazz == null) {
            return null;
        }
        Entity entity = null;
        try {
            entity = clazz.getConstructor(World.class).newInstance(world);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return entity;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int par1, int par2) {
        return par2 > 0 ? this.secondaryIcon : Items.field_151063_bx.func_77618_c(par1, par2);
    }

    public void func_150895_a(Item par1, CreativeTabs creativeTabs, List list) {
        Iterator<Integer> iterator = eggColorsMap.keySet().iterator();
        while (iterator.hasNext()) {
            list.add(new ItemStack(par1, 1, iterator.next().intValue()));
        }
    }

    public void func_94581_a(IIconRegister iconRegister) {
        super.func_94581_a(iconRegister);
        this.secondaryIcon = iconRegister.func_94245_a("MutantCreatures:SpawnEgg");
    }

    public static void addEgg(Class<? extends Entity> clazz, int color1, int color2) {
        if (eggColorsMap.containsKey(clazz)) {
            throw new IllegalArgumentException("Mapping for that entity exists already!");
        }
        EntityRegistry.EntityRegistration registration = EntityRegistry.instance().lookupModSpawn(clazz, false);
        eggColorsMap.put(registration.getModEntityId(), new EggColors(color1, color2));
    }

    private static class EggColors {
        private int primaryColor;
        private int secondaryColor;

        public EggColors(int color1, int color2) {
            this.primaryColor = color1;
            this.secondaryColor = color2;
        }
    }
}

