/*
 * Decompiled with CFR 0.152.
 */
package thehippomaster.MutantCreatures;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import thehippomaster.MutantCreatures.MutantCreatures;
import thehippomaster.MutantCreatures.MutantSkeleton;

public class SkeletonShot
extends Entity {
    private int shotDamage;
    private EntityLivingBase shooter;
    private ArrayList<Entity> pointedEntities;
    private PotionEffect potionEffect;

    public SkeletonShot(World world) {
        super(world);
        this.shotDamage = 10 + this.field_70146_Z.nextInt(3);
        this.field_70158_ak = true;
        this.field_70145_X = true;
        this.shooter = null;
        this.pointedEntities = new ArrayList();
        this.potionEffect = null;
    }

    public SkeletonShot(World world, EntityLivingBase shooter, EntityLivingBase target) {
        this(world);
        this.shooter = shooter;
        if (!world.field_72995_K) {
            this.setTargetX(target.field_70165_t);
            this.setTargetY(target.field_70163_u);
            this.setTargetZ(target.field_70161_v);
        }
        double yPos = shooter.field_70163_u + (double)shooter.func_70047_e();
        if (shooter instanceof MutantSkeleton) {
            yPos = shooter.field_70163_u + (double)(shooter.field_70131_O * 0.4f);
        }
        this.func_70107_b(shooter.field_70165_t, yPos, shooter.field_70161_v);
        double x = this.getTargetX() - this.field_70165_t;
        double y = this.getTargetY() - this.field_70163_u;
        double z = this.getTargetZ() - this.field_70161_v;
        double d = Math.sqrt(x * x + z * z);
        this.field_70177_z = 180.0f + (float)Math.toDegrees(Math.atan2(x, z));
        this.field_70125_A = (float)Math.toDegrees(Math.atan2(y, d));
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(5, (Object)0);
        this.field_70180_af.func_75682_a(6, (Object)0);
        this.field_70180_af.func_75682_a(7, (Object)0);
        this.field_70180_af.func_75682_a(8, (Object)12);
        this.field_70180_af.func_75682_a(9, (Object)10);
    }

    public void setTargetX(double d) {
        this.field_70180_af.func_75692_b(5, (Object)((int)(d * 10000.0)));
    }

    public void setTargetY(double d) {
        this.field_70180_af.func_75692_b(6, (Object)((int)(d * 10000.0)));
    }

    public void setTargetZ(double d) {
        this.field_70180_af.func_75692_b(7, (Object)((int)(d * 10000.0)));
    }

    public void setSpeed(float f) {
        this.field_70180_af.func_75692_b(8, (Object)((int)(f * 10.0f)));
    }

    public void setClones(int i) {
        this.field_70180_af.func_75692_b(9, (Object)((byte)i));
    }

    public double getTargetX() {
        return (double)this.field_70180_af.func_75679_c(5) / 10000.0;
    }

    public double getTargetY() {
        return (double)this.field_70180_af.func_75679_c(6) / 10000.0;
    }

    public double getTargetZ() {
        return (double)this.field_70180_af.func_75679_c(7) / 10000.0;
    }

    public float getSpeed() {
        return (float)this.field_70180_af.func_75679_c(8) / 10.0f;
    }

    public int getClones() {
        return this.field_70180_af.func_75683_a(9);
    }

    public void randomize(float scale) {
        this.setTargetX(this.getTargetX() + (double)((this.field_70146_Z.nextFloat() - 0.5f) * scale * 2.0f));
        this.setTargetY(this.getTargetY() + (double)((this.field_70146_Z.nextFloat() - 0.5f) * scale * 2.0f));
        this.setTargetZ(this.getTargetZ() + (double)((this.field_70146_Z.nextFloat() - 0.5f) * scale * 2.0f));
    }

    public void setDamage(int i) {
        this.shotDamage = i;
    }

    public void setPotionEffect(PotionEffect effect) {
        this.potionEffect = effect;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        double x = this.getTargetX() - this.field_70165_t;
        double y = this.getTargetY() - this.field_70163_u;
        double z = this.getTargetZ() - this.field_70161_v;
        double d = Math.sqrt(x * x + z * z);
        this.field_70177_z = 180.0f + (float)Math.toDegrees(Math.atan2(x, z));
        if (this.field_70177_z > 360.0f) {
            this.field_70177_z -= 360.0f;
        }
        this.field_70125_A = (float)Math.toDegrees(Math.atan2(y, d));
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa == 2) {
                this.hitEntities(0);
            }
            if (this.field_70173_aa == 3) {
                this.hitEntities(32);
            }
            if (this.field_70173_aa == 4) {
                this.handleEntities();
            }
        }
        if (this.field_70173_aa > 10) {
            this.func_70106_y();
        }
    }

    protected void hitEntities(int offset) {
        double targetX = this.getTargetX();
        double targetY = this.getTargetY();
        double targetZ = this.getTargetZ();
        double dist = this.func_70011_f(targetX, targetY, targetZ);
        double dx = (targetX - this.field_70165_t) / dist;
        double dy = (targetY - this.field_70163_u) / dist;
        double dz = (targetZ - this.field_70161_v) / dist;
        for (int i = offset; i < offset + 32; ++i) {
            double x = this.field_70165_t + dx * (double)i * 0.5;
            double y = this.field_70163_u + dy * (double)i * 0.5;
            double z = this.field_70161_v + dz * (double)i * 0.5;
            AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)x, (double)y, (double)z).func_72314_b(0.3, 0.3, 0.3);
            this.pointedEntities.addAll(MutantCreatures.getCollidingEntities((Entity)this.shooter, this.field_70170_p, box));
        }
    }

    protected void handleEntities() {
        this.pointedEntities.remove(this.shooter);
        this.pointedEntities.remove((Object)this);
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (Entity entity : this.pointedEntities) {
            if (list.contains(entity)) continue;
            list.add(entity);
        }
        for (Entity entity : list) {
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.shooter), (float)this.shotDamage);
            if (this.potionEffect == null || !(entity instanceof EntityLivingBase)) continue;
            EntityLivingBase living = (EntityLivingBase)entity;
            living.func_70690_d(this.potionEffect);
        }
        this.pointedEntities.clear();
    }

    public void func_70037_a(NBTTagCompound tagcompound) {
    }

    public void func_70014_b(NBTTagCompound tagcompound) {
    }
}

