/*
 * Decompiled with CFR 0.152.
 */
package mickkay.scenter.client;

import java.awt.Color;
import mickkay.scenter.ScenterMod;
import mickkay.scenter.config.Target;
import mickkay.scenter.config.TargetPart;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BlockScanner {
    private MyTarget target = new MyTarget();

    public void setTarget(Target target) {
        this.target = new MyTarget(target);
    }

    public TargetPart getTargetPart() {
        if (this.target.hasFound()) {
            return this.target.foundTarget;
        }
        return this.target.target.getParts().get(0);
    }

    public Color getTargetColor() {
        return this.target.target.getColor();
    }

    public boolean hasFound() {
        return this.target.hasFound();
    }

    public int getFoundX() {
        return this.target.getX();
    }

    public int getFoundY() {
        return this.target.getY();
    }

    public int getFoundZ() {
        return this.target.getZ();
    }

    public double scan(World world, int chunkCoordX, int chunkCoordZ, int px, int py, int pz) {
        this.target.reset();
        int radius = ScenterMod.proxy.getDetectionRadius();
        int minX = -radius;
        int maxX = radius;
        int minZ = -radius;
        int maxZ = radius;
        Vec3i playerPos = new Vec3i(px, py, pz);
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                Chunk chunk = world.func_72964_e(chunkCoordX + x, chunkCoordZ + z);
                this.scan(world, chunk, playerPos);
            }
        }
        return this.target.getDistance();
    }

    private void scan(World world, Chunk chunk, Vec3i playerPos) {
        if (this.target != null) {
            int x1 = chunk.field_76635_g * 16;
            int y1 = 0;
            int z1 = chunk.field_76647_h * 16;
            int x2 = x1 + 16;
            int y2 = 255;
            int z2 = z1 + 16;
            for (BlockPos pos : BlockPos.func_177975_b((BlockPos)new BlockPos(x1, y1, z1), (BlockPos)new BlockPos(x2, y2, z2))) {
                double distSq;
                int metaData;
                Block blk = chunk.func_177428_a(pos);
                TargetPart part = this.target.target.getMatchingPart(blk, metaData = chunk.func_177418_c(pos));
                if (part == null || !((distSq = pos.func_177951_i(playerPos)) < this.target.distanceSquare)) continue;
                this.target.distanceSquare = distSq;
                this.target.x = pos.func_177958_n();
                this.target.y = pos.func_177956_o();
                this.target.z = pos.func_177952_p();
                this.target.foundTarget = part;
            }
        }
    }

    public static class MyTarget {
        public Target target;
        private TargetPart foundTarget;
        private int x = 0;
        private int y = 0;
        private int z = 0;
        private double distanceSquare = Double.MAX_VALUE;
        private Double distance = null;

        public MyTarget() {
        }

        public MyTarget(Target target) {
            this.target = target;
        }

        public boolean hasFound() {
            return this.foundTarget != null;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getZ() {
            return this.z;
        }

        public double getDistance() {
            if (this.distance == null) {
                this.distance = this.distanceSquare == Double.MAX_VALUE ? Double.valueOf(Double.MAX_VALUE) : Double.valueOf(Math.sqrt(this.distanceSquare));
            }
            return this.distance;
        }

        public void reset() {
            this.foundTarget = null;
            this.distance = null;
            this.distanceSquare = Double.MAX_VALUE;
            this.x = 0;
            this.y = 0;
            this.z = 0;
        }

        public ItemStack getItemStack() {
            return this.target.getParts().get((int)0).itemStack;
        }
    }
}

