/*
 * Decompiled with CFR 0.152.
 */
package mickkay.scenter.config;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.List;
import mickkay.scenter.ScenterMod;
import mickkay.scenter.config.BlockElement;
import mickkay.scenter.config.Entry;
import mickkay.scenter.config.Target;
import mickkay.scenter.config.TargetEntry;
import mickkay.scenter.config.TargetPart;
import mickkay.scenter.config.TargetsConfig;
import mickkay.scenter.config.TargetsConfigFile;
import mickkay.scenter.config.defaults.Defaults;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScenterModConfig {
    private static final String CFG_CATEGORY_GENERAL = "general";
    private static final String CFG_PROP_DETECTION_RANGE = "detectionRange";
    private static final String CFG_PROP_VERSION = "version";
    private static final String CFG_PROP_ENABLED = "enabled";
    private static final String CFG_CATEGORY_DISPLAY = "display";
    private static final String CFG_PROP_HUD_X = "hudX";
    private static final String CFG_PROP_HUD_Y = "hudY";
    private final Logger logger = LogManager.getLogger((String)ScenterMod.class.getName());
    private final Defaults defaults = new Defaults();
    private final File configFile;
    private final Configuration config;
    private final TargetsConfigFile targetsConfigFile;
    private TargetsConfig targetsConfig;
    private List<Target> targets;

    public ScenterModConfig(File aConfigFile) throws IOException {
        this.configFile = aConfigFile;
        this.config = new Configuration(aConfigFile);
        this.config.load();
        this.targetsConfigFile = new TargetsConfigFile(this.getTargetsConfigFile(this.configFile));
        this.targetsConfig = this.targetsConfigFile.getConfig();
        this.upgradeConfigsToCurrentVersion();
        this.config.save();
    }

    public void save() {
        this.config.save();
    }

    public boolean isEnabled() {
        return this.getEnabledProperty().getBoolean(true);
    }

    public double getHudX() {
        return this.getHudXProperty().getDouble(0.05);
    }

    public double getHudY() {
        return this.getHudYProperty().getDouble(0.05);
    }

    public int getDetectionRadius() {
        String detectionRange = this.getDetectionRangeProperty().getString();
        try {
            int result = DetectionRange.valueOf((String)new StringBuilder().append((String)"A").append((String)detectionRange).toString()).radius;
            return result;
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalStateException(String.format("Unsupported value for detection range: '%s'", detectionRange));
        }
    }

    public List<Target> getTargets() {
        if (this.targets == null) {
            this.targets = this.loadTargets();
        }
        return this.targets;
    }

    public void setTargetsConfig(TargetsConfig config) {
        this.targetsConfig = config;
        this.targets = null;
    }

    public String getTargetsConfigAsString() {
        StringWriter writer = new StringWriter();
        try {
            this.targetsConfig.save(writer);
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
        return writer.toString();
    }

    private List<Target> loadTargets() {
        ArrayList result = Lists.newArrayList();
        for (Entry entry : this.targetsConfig.getEntries()) {
            if (!(entry instanceof TargetEntry)) continue;
            TargetEntry targetEntry = (TargetEntry)entry;
            Target target = new Target();
            if (targetEntry.getColor() != null) {
                Color color = Color.decode("#" + targetEntry.getColor());
                target.setColor(color);
            }
            for (BlockElement blockElem : targetEntry.getBlocks()) {
                String blockName = blockElem.getName();
                Integer dmg = blockElem.getSubtype();
                Object obj = Block.field_149771_c.func_82594_a((Object)blockName);
                if (obj != null && obj instanceof Block) {
                    Block block = (Block)obj;
                    ItemStack stack = new ItemStack(block, 1, dmg == null ? 0 : dmg);
                    String idStr = blockName + (dmg == null ? "" : "/" + dmg);
                    this.logger.info(String.format("Scenter: Adding block %s.", idStr));
                    target.getParts().add(new TargetPart(block, dmg, stack));
                    continue;
                }
                this.logger.warn(String.format("Scenter: Error - block with name '%s' not found!", blockName));
            }
            if (!target.hasParts()) continue;
            result.add(target);
        }
        return result;
    }

    private void upgradeConfigsToCurrentVersion() throws IOException {
        if (this.isEmpty(this.config)) {
            this.makeStandardConfig(this.config);
        } else {
            this.setConfigVersion("1.8-3.3.0");
        }
        if (!this.targetsConfigFile.exists()) {
            this.makeStandardTargetsConfig(this.targetsConfig);
            this.targetsConfigFile.save();
        }
    }

    private void setConfigVersion(String aNewVersion) {
        Property val = this.getConfigVersionProperty();
        val.set(aNewVersion);
    }

    private boolean isCurrentVersion(Configuration config) {
        if (!this.hasConfigVersion()) {
            return false;
        }
        String configVersion = this.getConfigVersion();
        return configVersion != null && configVersion.equals("1.8-3.3.0");
    }

    private boolean hasConfigVersion() {
        return this.config.hasKey(CFG_CATEGORY_GENERAL, CFG_PROP_VERSION);
    }

    private String getConfigVersion() {
        Property val = this.getConfigVersionProperty();
        return val.getString();
    }

    private Property getConfigVersionProperty() {
        return this.config.get(CFG_CATEGORY_GENERAL, CFG_PROP_VERSION, "", "Syntax version. Do NOT manually change this value!");
    }

    private Property getEnabledProperty() {
        Property p = this.config.get(CFG_CATEGORY_GENERAL, CFG_PROP_ENABLED, true, "Set to 'true' to enable Scenter. Set to 'false' to disable Scenter.");
        return p;
    }

    private Property getHudXProperty() {
        Property p = this.config.get(CFG_CATEGORY_DISPLAY, CFG_PROP_HUD_X, 0.05, "The x coordinate of the HUD (Head-Up Display). Valid is anything between 0.0 (left) and 1.0 (right).");
        return p;
    }

    private Property getHudYProperty() {
        Property p = this.config.get(CFG_CATEGORY_DISPLAY, CFG_PROP_HUD_Y, 0.05, "The y coordinate of the HUD (Head-Up Display). Valid is anything between 0.0 (top) and 1.0 (bottom).");
        return p;
    }

    private Property getDetectionRangeProperty() {
        Property p = this.config.get(CFG_CATEGORY_GENERAL, CFG_PROP_DETECTION_RANGE, "3x3", "The number of chunks that are searched by Scenter. Valid values are 1, 3x3, 5x5, 7x7, 9x9, 11x11.");
        return p;
    }

    private void makeBackup(File fromFile) throws IOException {
        String backupName;
        File backupFile;
        if (!fromFile.exists()) {
            return;
        }
        int num = 0;
        do {
            backupName = fromFile.getName() + ".bak" + ++num;
        } while ((backupFile = new File(fromFile.getParentFile(), backupName)).exists());
        this.copyFile(fromFile, backupFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File fromFile, File toFile) throws IOException {
        FileInputStream fin = null;
        FileOutputStream fout = null;
        try {
            fin = new FileInputStream(fromFile);
            fout = new FileOutputStream(toFile);
            byte[] b = new byte[1024];
            int noOfBytes = 0;
            while ((noOfBytes = fin.read(b)) != -1) {
                fout.write(b, 0, noOfBytes);
            }
        }
        finally {
            if (fout != null) {
                fout.close();
            }
            if (fin != null) {
                fin.close();
            }
        }
    }

    private boolean isEmpty(TargetsConfigFile targetsConfigFile) {
        return targetsConfigFile.getConfig().isEmpty();
    }

    private File getTargetsConfigFile(File configFile) {
        String defaultConfigName = configFile.getName();
        String name = defaultConfigName.substring(0, defaultConfigName.indexOf(46));
        String targetsConfigName = name + "3.targets.cfg";
        return new File(configFile.getParentFile(), targetsConfigName);
    }

    private void makeStandardTargetsConfig(TargetsConfig targetsConfig) {
        this.addStandardHeaderComments(targetsConfig);
        for (Defaults.BlockDefault blockDef : this.defaults.getBlockDefaults()) {
            this.addTargetFor(targetsConfig, blockDef);
        }
    }

    private void addTargetFor(TargetsConfig cfg, Defaults.BlockDefault blockDef) {
        if (blockDef.block.length == 1) {
            cfg.addTarget(this.getName(blockDef.block[0]), blockDef.color);
        } else {
            TargetEntry target = cfg.addTarget(this.getName(blockDef.block[0]), blockDef.color);
            for (int i = 1; i < blockDef.block.length; ++i) {
                target.addBlockElement(this.getName(blockDef.block[i]));
            }
        }
    }

    private String getName(Block block) {
        String name = String.valueOf(Block.field_149771_c.func_177774_c((Object)block));
        if (name.startsWith("minecraft:")) {
            return name.substring("minecraft:".length());
        }
        return name;
    }

    private void addStandardHeaderComments(TargetsConfig cfg) {
        cfg.addComment("## Scenter Targets Definitions");
        cfg.addComment("# During game play you can toggle between all defined targets by pressing 'O'.");
        cfg.addComment("# With this file you can define these targets.");
        cfg.addComment("#");
        cfg.addComment("# Each line adds one target to Scenter.");
        cfg.addComment("# A target definition consists of one ore more blocks and an optional color (for tinting the particle trail).");
        cfg.addComment("#");
        cfg.addComment("# The line format is:");
        cfg.addComment("# <block-list> [<color (hexadecimal)>]");
        cfg.addComment("#   where <block-list> is <block>[, <block>] ... ");
        cfg.addComment("#   and where <block> is <block-name>[/<subtype>]");
        cfg.addComment("#");
        cfg.addComment("# Example 1:");
        cfg.addComment("#  obsidian 000000");
        cfg.addComment("#  adds a target for obsidian, with a black (000000) particle trail color");
        cfg.addComment("# Example 2:");
        cfg.addComment("#  lava, flowing_lava FF0000 ");
        cfg.addComment("#  adds a target for lava and flowing lava, with a red (FF0000) particle trail color");
        cfg.addComment("# Example 3:");
        cfg.addComment("#  wool/14, wool/4, wool/6 FFFFFF ");
        cfg.addComment("#  adds a target for red (/14), yellow (/4), and pink (/6) wool, with a white (FFFFFF) particle trail color");
        cfg.addComment("");
        cfg.addComment(" Use '#' for comments");
        cfg.addComment("");
    }

    private boolean isEmpty(Configuration config) {
        return config.getCategoryNames().isEmpty();
    }

    private void makeStandardConfig(Configuration config) {
        this.setConfigVersion("1.8-3.3.0");
    }

    static enum DetectionRange {
        A1(0),
        A3x3(1),
        A5x5(2),
        A7x7(3),
        A9x9(4),
        A11x11(5);

        public final int radius;

        private DetectionRange(int radius) {
            this.radius = radius;
        }
    }
}

