/*
 * Decompiled with CFR 0.152.
 */
package mickkay.scenter.config;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mickkay.scenter.config.BlockElement;
import mickkay.scenter.config.Entry;

public class TargetEntry
extends Entry {
    private static final String BLOCK_NAME = "(?:[^ /#]+|\"[^\"#]+\")";
    private static Pattern PATTERN = Pattern.compile("(\\s*)((?:[^ /#]+|\"[^\"#]+\")(?:/\\d+)?(?:\\s*,\\s*(?:[^ /#]+|\"[^\"#]+\")(?:/\\d+)?)*)((\\s+)([a-fA-F0-9]{6}))?((\\s*)#(.*))?");
    private static Pattern PATTERN_PART = Pattern.compile("((?:[^ /#]+|\"[^\"#]+\"))(/(\\d+))?");
    private String idIndent;
    private List<BlockElement> blocks = new ArrayList<BlockElement>();
    private String colorIndent;
    private String color;
    private String commentIndent;
    private String comment;

    public TargetEntry() {
        super("");
        this.blocks.add(new BlockElement("air", null));
    }

    public TargetEntry(String line) throws IllegalArgumentException {
        super(line);
        Matcher matcher = PATTERN.matcher(line);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Can't understand '%s'!", line));
        }
        this.idIndent = matcher.group(1);
        this.blocks = this.parseBlocks(matcher.group(2));
        this.colorIndent = matcher.group(4);
        this.color = matcher.group(5);
        this.commentIndent = matcher.group(7);
        this.comment = matcher.group(8);
    }

    private List<BlockElement> parseBlocks(String blocksStr) {
        String[] tokens = blocksStr.split(",");
        ArrayList<BlockElement> result = new ArrayList<BlockElement>();
        for (String token : tokens) {
            Matcher matcher = PATTERN_PART.matcher(token.trim());
            if (!matcher.matches()) continue;
            String name = matcher.group(1);
            if (name.startsWith("\"")) {
                name = name.replaceAll("\"", "");
            }
            Integer subtype = this.toInteger(matcher.group(3));
            result.add(new BlockElement(name, subtype));
        }
        if (result.isEmpty()) {
            throw new IllegalArgumentException(String.format("Can't find block data in token '%s'!", blocksStr));
        }
        return result;
    }

    private Integer toInteger(String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        return Integer.parseInt(text);
    }

    public List<BlockElement> getBlocks() {
        return this.blocks;
    }

    public boolean hasBlockElement(String blockName) {
        for (BlockElement elem : this.blocks) {
            if (!elem.getName().equals(blockName)) continue;
            return true;
        }
        return false;
    }

    public void addBlockElement(String blockName) {
        this.blocks.add(new BlockElement(blockName, null));
    }

    public String getName() {
        return this.blocks.get(0).getName();
    }

    public void setName(String name) {
        this.blocks.get(0).setName(name);
        this.idIndent = "";
    }

    public Integer getSubtype() {
        return this.blocks.get(0).getSubtype();
    }

    public void setSubtype(Integer subtype) {
        this.blocks.get(0).setSubtype(subtype);
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
        this.colorIndent = color == null ? null : " ";
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
        this.commentIndent = comment == null ? null : " ";
    }

    public String getCommentIndent() {
        return this.commentIndent;
    }

    public void setCommentIndent(String commentIndent) {
        this.commentIndent = commentIndent;
    }

    @Override
    public String getLine() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.idIndent);
        int count = 0;
        for (BlockElement elem : this.blocks) {
            String name;
            if (++count > 1) {
                builder.append(",");
            }
            if ((name = elem.getName()).contains(" ")) {
                name = "\"" + name + "\"";
            }
            builder.append(name);
            if (this.getSubtype() == null) continue;
            builder.append("/");
            builder.append(elem.getSubtype());
        }
        if (this.color != null) {
            builder.append(this.colorIndent);
            builder.append(this.color);
        }
        if (this.comment != null) {
            builder.append(this.commentIndent);
            builder.append("#");
            builder.append(this.comment);
        }
        return builder.toString();
    }
}

