/*
 * Decompiled with CFR 0.152.
 */
package proximitydetector;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Properties;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Keyboard;
import proximitydetector.ProximityDetector;
import proximitydetector.ProximityDetectorRenderer;
import proximitydetector.ProximityDetectorRunner;

public class ProximityDetectorConfiguration {
    private static String DISTANCE = "Distance";
    private static String DISTANCE_KEY = "DistanceKey";
    private static String ENTITYTYPE_KEY = "EntityTypeKey";
    private static String TYPEDISPLAYED = "TypeDisplayed";
    public static final String HOSTILE = "HOSTILE";
    public static final String NEUTRAL = "NEUTRAL";
    public static final String PASSIVE = "PASSIVE";
    public static HashMap<String, String> entityList = new HashMap();

    public static void loadDefaultEntities() {
        entityList.put("Enderman", NEUTRAL);
        entityList.put("Pigzombie", NEUTRAL);
        entityList.put("Wolf", NEUTRAL);
        entityList.put("Cat", PASSIVE);
        entityList.put("Chicken", PASSIVE);
        entityList.put("Cow", PASSIVE);
        entityList.put("Mooshroom", PASSIVE);
        entityList.put("Ocelot", PASSIVE);
        entityList.put("Pig", PASSIVE);
        entityList.put("Sheep", PASSIVE);
        entityList.put("Squid", PASSIVE);
        entityList.put("Villager", PASSIVE);
        entityList.put("Irongolem", PASSIVE);
        entityList.put("Snowgolem", PASSIVE);
        entityList.put("Bat", PASSIVE);
        entityList.put("Blaze", HOSTILE);
        entityList.put("Cave Spider", HOSTILE);
        entityList.put("Creeper", HOSTILE);
        entityList.put("Ghast", HOSTILE);
        entityList.put("Magma Cube", HOSTILE);
        entityList.put("Silverfish", HOSTILE);
        entityList.put("Skeleton", HOSTILE);
        entityList.put("Slime", HOSTILE);
        entityList.put("Spider", HOSTILE);
        entityList.put("Spider Jockey", HOSTILE);
        entityList.put("Witch", HOSTILE);
        entityList.put("Wither Skeleton", HOSTILE);
        entityList.put("Zombie", HOSTILE);
        entityList.put("Zombie Villager", HOSTILE);
    }

    public static File getAppDir(String app) {
        return Minecraft.a((String)app);
    }

    public static void loadEntities() {
        ProximityDetectorConfiguration.loadDefaultEntities();
        File settingsFile = new File(ProximityDetectorConfiguration.getAppDir("minecraft"), "config" + File.separator + "ProximityEntities.txt");
        try {
            if (settingsFile.exists()) {
                Properties settings = new Properties();
                settings.load(new BufferedReader(new FileReader(settingsFile)));
                for (String string : settings.keySet()) {
                    entityList.put(string, settings.getProperty(string));
                }
            } else {
                PrintWriter out = new PrintWriter(new FileWriter(settingsFile));
                for (String string : entityList.keySet()) {
                    out.println(String.valueOf(string) + "=" + entityList.get(string));
                }
                out.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void initDetector(ProximityDetectorRunner runner, ProximityDetector detector) {
        File settingsFile = new File(ProximityDetectorConfiguration.getAppDir("minecraft"), "config" + File.separator + "ProximityDetector.settings");
        try {
            if (settingsFile.exists()) {
                Properties settings = new Properties();
                settings.load(new BufferedReader(new FileReader(settingsFile)));
                if (settings.containsKey(DISTANCE_KEY)) {
                    runner.setDistanceKey(Keyboard.getKeyIndex((String)settings.getProperty(DISTANCE_KEY)));
                    settings.remove(DISTANCE_KEY);
                }
                if (settings.containsKey(ENTITYTYPE_KEY)) {
                    runner.setEntityTypeKey(Keyboard.getKeyIndex((String)settings.getProperty(ENTITYTYPE_KEY)));
                    settings.remove(ENTITYTYPE_KEY);
                }
            } else {
                PrintWriter out = new PrintWriter(new FileWriter(settingsFile));
                out.println(String.valueOf(DISTANCE_KEY) + "=F");
                out.println(String.valueOf(ENTITYTYPE_KEY) + "=G");
                out.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadCurrentConf(ProximityDetector detector) {
        File settingsFile = new File(ProximityDetectorConfiguration.getAppDir("minecraft"), "config" + File.separator + "ProximityDetector.current.settings");
        try {
            if (settingsFile.exists()) {
                Properties settings = new Properties();
                settings.load(new BufferedReader(new FileReader(settingsFile)));
                if (settings.containsKey(DISTANCE)) {
                    detector.setDistanceFilter(Integer.parseInt(settings.getProperty(DISTANCE)));
                }
                if (settings.containsKey(TYPEDISPLAYED)) {
                    ProximityDetectorRenderer.getInstance().setEntityTypeDisplayed(Integer.parseInt(settings.getProperty(TYPEDISPLAYED)));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeCurrentConf(ProximityDetector detector) {
        File settingsFile = new File(ProximityDetectorConfiguration.getAppDir("minecraft"), "config" + File.separator + "ProximityDetector.current.settings");
        try {
            PrintWriter out = new PrintWriter(new FileWriter(settingsFile));
            out.println(String.valueOf(DISTANCE) + "=" + detector.getDistanceFilter());
            out.println(String.valueOf(TYPEDISPLAYED) + "=" + ProximityDetectorRenderer.getInstance().getEntityTypeDisplayed());
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

