/*
 * Decompiled with CFR 0.152.
 */
package proximitydetector;

import net.minecraft.client.Minecraft;
import proximitydetector.ProximityDetector2MinecraftProxy;
import proximitydetector.ProximityDetectorConfiguration;
import proximitydetector.ProximityDetectorRenderer;

public class ProximityDetector {
    public static final int DISTANCE_ALL = 200;
    public static final int DISTANCE_CLOSE = 50;
    public static final int DISTANCE_FAR = 100;
    public static final int DISTANCE_HIDDEN = 0;
    public static final int DISTANCE_NEARBY = 30;
    public static Minecraft game = null;
    private float direction = 0.0f;
    private float directionV = 0.0f;
    private boolean directionChanged = false;
    private int distanceFilter = 200;
    private float oldDir = 0.0f;
    private float oldDirV = 0.0f;

    public ProximityDetector() {
        try {
            ProximityDetectorConfiguration.loadCurrentConf(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public float getDirection() {
        return this.direction;
    }

    public int getDistanceFilter() {
        return this.distanceFilter;
    }

    public boolean isDirectionChanged() {
        return this.directionChanged;
    }

    public void refreshDirection() {
        boolean hdirectionChanged = false;
        if (this.oldDir != ProximityDetector2MinecraftProxy.radius()) {
            this.direction += this.oldDir - ProximityDetector2MinecraftProxy.radius();
            this.oldDir = ProximityDetector2MinecraftProxy.radius();
            if (this.direction >= 360.0f) {
                while (this.direction >= 360.0f) {
                    this.direction -= 360.0f;
                }
            }
            if (this.direction < 0.0f) {
                while (this.direction < 0.0f) {
                    this.direction += 360.0f;
                }
            }
            ProximityDetectorRenderer.getInstance().setDirection(this.direction);
            hdirectionChanged = true;
        }
        boolean vdirectionChanged = false;
        if (this.oldDirV != ProximityDetector2MinecraftProxy.rotatioPitch()) {
            this.directionV += this.oldDirV - ProximityDetector2MinecraftProxy.rotatioPitch();
            this.oldDirV = ProximityDetector2MinecraftProxy.rotatioPitch();
            if (this.directionV >= 360.0f) {
                while (this.directionV >= 360.0f) {
                    this.directionV -= 360.0f;
                }
            }
            if (this.directionV < 0.0f) {
                while (this.directionV < 0.0f) {
                    this.directionV += 360.0f;
                }
            }
            ProximityDetectorRenderer.getInstance().setDirectionV(this.directionV);
            vdirectionChanged = true;
        }
        this.directionChanged = hdirectionChanged || vdirectionChanged;
    }

    public void setDistanceFilter(int distanceFilter) {
        this.distanceFilter = distanceFilter;
    }

    public boolean isHidden() {
        return this.distanceFilter == 0;
    }
}

