/*
 * Decompiled with CFR 0.152.
 */
package com.hea3ven.twintails;

import com.hea3ven.twintails.TwinTailsMod;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public class VersionCheck {
    private static boolean checkDone = false;
    private static Thread versionCheckThread;
    private static VersionInformer versionInformer;
    private static String latestVersion;

    public static void init() {
        if (!TwinTailsMod.config.versionCheck.booleanValue() || checkDone) {
            return;
        }
        versionCheckThread = new Thread(new Runnable(){

            @Override
            public void run() {
                VersionCheck.getVersion();
            }
        }, "TwinTails version check Thread");
        versionInformer = new VersionInformer();
        FMLCommonHandler.instance().bus().register((Object)versionInformer);
        versionCheckThread.start();
    }

    protected static void getVersion() {
        try {
            TwinTailsMod.logger.info("Looking for the latest version");
            URL url = new URL("https://raw.githubusercontent.com/hea3ven/TwinTails/master/VERSION");
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            String versionData = reader.readLine();
            if (versionData.indexOf(124) != -1) {
                versionData = versionData.substring(0, versionData.indexOf(124));
            }
            latestVersion = versionData;
            TwinTailsMod.logger.info("Latest version is {}", new Object[]{versionData});
        }
        catch (Exception e) {
            TwinTailsMod.logger.error("Could not get the latest version info", (Throwable)e);
        }
        checkDone = true;
    }

    static {
        latestVersion = null;
    }

    public static class VersionInformer {
        @SubscribeEvent
        public void onPlayerTick(TickEvent.PlayerTickEvent event) {
            if (checkDone) {
                if (latestVersion != null && !latestVersion.equals(TwinTailsMod.config.versionLatest)) {
                    TwinTailsMod.config.setLatestVersion(latestVersion);
                    if (!"1.0.3".equals(latestVersion)) {
                        event.player.func_145747_a((IChatComponent)new ChatComponentTranslation("twintails.update", new Object[]{latestVersion}));
                    }
                }
                FMLCommonHandler.instance().bus().unregister((Object)this);
            }
        }
    }
}

