/*
 * Decompiled with CFR 0.152.
 */
package com.hea3ven.twintails.item;

import com.hea3ven.twintails.TwinTailType;
import com.hea3ven.twintails.TwinTailsMod;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ItemHairBand
extends ItemArmor {
    public static final ItemArmor.ArmorMaterial hairBandArmorMaterial = ItemArmor.ArmorMaterial.CHAIN;
    private TwinTailType[] twinTailTypes = new TwinTailType[]{new TwinTailType(0, "white", new Potion[0], "dyeWhite", 0), new TwinTailType(1, "red", new Potion[]{Potion.field_76424_c, Potion.field_76430_j}, "dyeRed", 14), new TwinTailType(2, "blue", new Potion[]{Potion.field_76427_o, Potion.field_76420_g}, "dyeBlue", 11), new TwinTailType(3, "yellow", new Potion[]{Potion.field_76429_m, Potion.field_76426_n}, "dyeYellow", 4), new TwinTailType(4, "cyan", new Potion[0], "dyeCyan", 9), new TwinTailType(5, "pink", new Potion[0], "dyePink", 6)};

    public ItemHairBand() {
        super(hairBandArmorMaterial, 0, 0);
        this.func_77655_b("hairBand");
        this.func_77637_a(TwinTailsMod.creativeTab);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    private int getTypeOffset(ItemStack itemStack) {
        return this.getTypeOffset(itemStack.func_77960_j());
    }

    private int getTypeOffset(int meta) {
        return meta < this.twinTailTypes.length ? meta : 0;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (!world.field_72995_K && TwinTailsMod.config.twinTailsEffects.booleanValue()) {
            this.refreshPotionsEffects(player, this.twinTailTypes[this.getTypeOffset(itemStack)].getPotions());
        }
    }

    private void refreshPotionsEffects(EntityPlayer player, Potion[] potions) {
        for (Potion potion : potions) {
            PotionEffect effect = player.func_70660_b(potion);
            if (effect != null && effect.func_76459_b() >= 10) continue;
            player.func_70690_d(new PotionEffect(potion.field_76415_H, 80, 1));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        return this.twinTailTypes[this.getTypeOffset(itemStack)].getModel();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        for (TwinTailType twinTailType : this.twinTailTypes) {
            twinTailType.registerIcon(iconRegister);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        return this.twinTailTypes[this.getTypeOffset(meta)].getIcon();
    }

    public String func_77667_c(ItemStack itemStack) {
        return this.func_77658_a() + "." + this.twinTailTypes[this.getTypeOffset(itemStack)].getName();
    }

    public void func_150895_a(Item item, CreativeTabs creativeTabs, List itemList) {
        for (TwinTailType twinTailType : this.twinTailTypes) {
            itemList.add(new ItemStack(item, 1, twinTailType.getOrdinal()));
        }
    }

    public void AddRecipes() {
        ItemStack anyHairTie = new ItemStack((Item)this, 1, Short.MAX_VALUE);
        for (TwinTailType twinTailType : this.twinTailTypes) {
            ItemStack wool = new ItemStack(Blocks.field_150325_L, 1, twinTailType.getColorOrdinal());
            ItemStack typeHairTie = new ItemStack((Item)this, 1, twinTailType.getOrdinal());
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(typeHairTie, new Object[]{" s ", "sbs", " s ", Character.valueOf('s'), wool, Character.valueOf('b'), "slimeball"}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(typeHairTie, new Object[]{anyHairTie, twinTailType.getRecipeIngredient()}));
        }
    }
}

