/*
 * Decompiled with CFR 0.152.
 */
package com.w_angels.main;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.crash.CrashReport;
import net.minecraftforge.common.config.Configuration;

public class Config {
    public static int MAX_TICKS_ANGEL_WAITS;
    public static int MAX_ANGEL_HEALTH;
    public static int MIN_ANGEL_SPAWN_HEIGHT;
    public static int MAX_ANGEL_SPAWN_HEIGHT;
    public static int CHANCE_STATUE_BECOMES_ANGEL;
    public static int LOOKING_EYES_THRESHOLD;
    public static int INFECTION_DURATION;
    public static int POTION_ID_ANGEL;
    public static boolean CAN_BREAK_DOORS;
    public static boolean ALLOW_NATURAL_SPAWNING;
    public static ArrayList DIMENSION_BLACKLIST;
    public static ArrayList CATACOMBS_WHITELIST;

    public static void mainRegistry(Configuration config) {
        String[] whitelist;
        String[] blacklist;
        config.load();
        CAN_BREAK_DOORS = config.getBoolean("CAN_ANGEL_BREAK_DOORS", "general", true, "Whether the angel can break closed wooden doors.");
        ALLOW_NATURAL_SPAWNING = config.getBoolean("ALLOW_NATURAL_ANGEL_SPAWNING", "general", true, "Whether Weeping Angels can naturally spawn outside of Catacombs.");
        CHANCE_STATUE_BECOMES_ANGEL = config.getInt("CHANCE_STATUE_BECOMES_ANGEL", "general", 5, 0, 100, "Every 5-10 seconds, an Angel Statue has this percent chance to become a living angel.");
        MAX_ANGEL_HEALTH = config.getInt("MAX_ANGEL_HEALTH", "general", 24, 10, 200, "The maximum health for each angel.");
        MIN_ANGEL_SPAWN_HEIGHT = config.getInt("MIN_SPAWN_HEIGHT", "general", 1, 1, 128, "The minimum y-level at which angels can spawn. Must be less than MAX_SPAWN_HEIGHT.");
        MAX_ANGEL_SPAWN_HEIGHT = config.getInt("MAX_SPAWN_HEIGHT", "general", 64, 1, 256, "The maximum y-level at which angels can spawn. Must be more than MIN_SPAWN_HEIGHT.");
        if (MIN_ANGEL_SPAWN_HEIGHT > MAX_ANGEL_SPAWN_HEIGHT) {
            CrashReport report = new CrashReport("Config value for MIN_ANGEL_HEIGHT is more than the value for MAX_ANGEL_HEIGHT", (Throwable)new IllegalArgumentException());
            Minecraft.func_71410_x().func_71404_a(report);
        }
        MAX_TICKS_ANGEL_WAITS = config.getInt("MAX_TICKS_ANGEL_WAITS", "general", 4, 1, 20, "How many ticks the angel waits to make sure the player is not looking. Set higher for slow server connections.");
        LOOKING_EYES_THRESHOLD = config.getInt("LOOKING_AT_ANGELS_EYES_THRESHOLD", "general", 120, 20, 400, "Number of ticks a player can look at an angel's eyes before the player is infected (20 sec * 20 ticks/sec = 400 ticks).");
        INFECTION_DURATION = config.getInt("TICKS_BEFORE_KILLED_BY_INFECTION", "general", 4800, 600, 12000, "Number of ticks that a player can be infected before they become an angel (4 min = 240 sec * 20 ticks/sec = 4800 ticks).");
        POTION_ID_ANGEL = config.getInt("ANGEL_POTION_EFFECT_ID", "general", 95, 32, 255, "The ID for the InfectedByAngel PotionEffect.");
        DIMENSION_BLACKLIST = new ArrayList();
        for (String s : blacklist = config.getStringList("DIMENSION_BLACKLIST", "general", new String[]{"1"}, "IDs of dimensions that angels are not allowed to spawn in. List each ID on a new line. You cannot blacklist the Overworld (0).")) {
            try {
                int toAdd = Integer.parseInt(s);
                if (toAdd == 0) continue;
                DIMENSION_BLACKLIST.add(new Integer(toAdd));
            }
            catch (NumberFormatException e) {
                System.out.print("[w_angels.cfg]Config loading error: Found a non-integer String \"" + s + "\" in DIMENSION_BLACKLIST. Skipping invalid value.\n");
            }
        }
        CATACOMBS_WHITELIST = new ArrayList();
        for (String s : whitelist = config.getStringList("CATACOMBS_WHITELIST", "general", new String[]{"0"}, "IDs of dimensions other than the Overworld in which to allow Catacomb structures. List each ID on a new line.")) {
            try {
                int toAdd = Integer.parseInt(s);
                if (toAdd == 0) continue;
                CATACOMBS_WHITELIST.add(new Integer(toAdd));
            }
            catch (NumberFormatException e) {
                System.out.print("[w_angels.cfg]Config loading error: Found a non-integer String \"" + s + "\" in CATACOMBS_WHITELIST. Skipping invalid value.\n");
            }
        }
        config.save();
    }
}

