/*
 * Decompiled with CFR 0.152.
 */
package com.w_angels.worldgen;

import com.w_angels.entity.EntityAngel;
import com.w_angels.item.ItemRegistry;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class Catacombs
implements IWorldGenerator {
    private World worldObj;
    private Random rand;
    private int beginXPos;
    private int beginYPos;
    private int beginZPos;
    private int reflX;
    private int reflZ;
    public static final WeightedRandomChestContent[] catacombChestContents = new WeightedRandomChestContent[]{new WeightedRandomChestContent(Items.field_151042_j, 0, 1, 5, 20), new WeightedRandomChestContent(Item.func_150898_a((Block)Blocks.field_150340_R), 0, 1, 1, 5), new WeightedRandomChestContent(Items.field_151045_i, 0, 1, 2, 3), new WeightedRandomChestContent(Items.field_151166_bC, 0, 1, 3, 6), new WeightedRandomChestContent(Items.field_151061_bv, 0, 1, 1, 12), new WeightedRandomChestContent(Items.field_151153_ao, 0, 1, 1, 6), new WeightedRandomChestContent(Items.field_151083_be, 0, 1, 3, 15), new WeightedRandomChestContent(Items.field_151127_ba, 0, 2, 4, 10), new WeightedRandomChestContent(Items.field_151035_b, 0, 1, 1, 5), new WeightedRandomChestContent(Items.field_151062_by, 0, 2, 10, 5), new WeightedRandomChestContent(Items.field_151057_cb, 0, 1, 1, 5), new WeightedRandomChestContent(Items.field_151141_av, 0, 1, 1, 3), new WeightedRandomChestContent((Item)Items.field_151023_V, 0, 1, 1, 4), new WeightedRandomChestContent((Item)Items.field_151029_X, 0, 1, 1, 4), new WeightedRandomChestContent((Item)Items.field_151020_U, 0, 1, 1, 4), new WeightedRandomChestContent((Item)Items.field_151022_W, 0, 1, 1, 4), new WeightedRandomChestContent(Items.field_151125_bZ, 0, 1, 1, 1)};

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
    }

    public boolean generate(World worldIn, Random random, int x, int y, int z) {
        this.worldObj = worldIn;
        this.rand = random;
        this.reflX = this.getReflection();
        this.reflZ = this.getReflection();
        this.beginXPos = x;
        this.beginYPos = y;
        this.beginZPos = z;
        int[] pos = new int[3];
        int[] leftOff = new int[3];
        if (!this.getIsValidLocation(x, y, z)) {
            return false;
        }
        this.makeEntrance(0, 0, 0);
        int mapWest = this.rand.nextInt(2);
        int mapEast = this.rand.nextInt(2);
        pos = this.makeStairs(2, -1, 5, Direction.EAST, 20 + this.rand.nextInt(10));
        switch (mapEast) {
            case 0: {
                pos = this.makeCorridor(pos[0], pos[1], pos[2], Direction.EAST, 4 + this.rand.nextInt(4));
                pos = this.makeCorner(pos[0], pos[1], pos[2], Direction.EAST, Direction.NORTH);
                pos = this.makeCorridor(pos[0], pos[1], pos[2], Direction.NORTH, 3 + this.rand.nextInt(4));
                leftOff = this.make3Way(pos[0], pos[1], pos[2], Direction.NORTH);
                pos = leftOff;
                this.makeRoom(pos[0], pos[1], pos[2], Direction.WEST, 1 + this.rand.nextInt(4));
                pos = this.getRightPosOf3Way(leftOff[0], leftOff[1], leftOff[2], Direction.NORTH);
                pos = this.makeCorridor(pos[0], pos[1], pos[2], Direction.EAST, 5 + this.rand.nextInt(5));
                pos = this.makeCorner(pos[0], pos[1], pos[2], Direction.EAST, Direction.SOUTH);
                pos = this.makeCorridor(pos[0], pos[1], pos[2], Direction.SOUTH, 3 + this.rand.nextInt(3));
                leftOff = this.make3Way(pos[0], pos[1], pos[2], Direction.SOUTH);
                pos = leftOff;
                pos = this.makeCorridor(pos[0], pos[1], pos[2], Direction.EAST, 3);
                pos = this.makeCorner(pos[0], pos[1], pos[2], Direction.EAST, Direction.SOUTH);
                pos = this.makeCorridor(pos[0], pos[1], pos[2], Direction.SOUTH, 2);
                this.makeRoom(pos[0], pos[1], pos[2], Direction.SOUTH, 3 + this.rand.nextInt(2));
                pos = this.getRightPosOf3Way(leftOff[0], leftOff[1], leftOff[2], Direction.SOUTH);
                this.makeRoom(pos[0], pos[1], pos[2], Direction.WEST, 0);
                break;
            }
            case 1: {
                leftOff = this.makeCorridor(pos[0], pos[1], pos[2], Direction.EAST, 2 + this.rand.nextInt(4));
                pos = leftOff;
                pos = this.makeCorner(pos[0], pos[1], pos[2], Direction.EAST, Direction.NORTH);
                this.makeRoom(pos[0], pos[1], pos[2], Direction.NORTH, this.rand.nextInt(5));
                pos = this.makeCorridorFromCorner(leftOff[0], leftOff[1], leftOff[2], Direction.EAST, 5 + this.rand.nextInt(4));
                leftOff = this.make3Way(pos[0], pos[1], pos[2], Direction.EAST);
                pos = leftOff;
                pos = this.makeCorridor(pos[0], pos[1], pos[2], Direction.NORTH, 5 + this.rand.nextInt(4));
                pos = this.makeCorner(pos[0], pos[1], pos[2], Direction.NORTH, Direction.EAST);
                pos = this.makeCorridor(pos[0], pos[1], pos[2], Direction.EAST, 3 + this.rand.nextInt(10));
                this.makeRoom(pos[0], pos[1], pos[2], Direction.EAST, 3 + this.rand.nextInt(2));
                pos = this.getRightPosOf3Way(leftOff[0], leftOff[1], leftOff[2], Direction.EAST);
                pos = this.makeCorridor(pos[0], pos[1], pos[2], Direction.SOUTH, 3 + this.rand.nextInt(4));
                pos = this.makeCorner(pos[0], pos[1], pos[2], Direction.SOUTH, Direction.WEST);
                pos = this.makeCorridor(pos[0], pos[1], pos[2], Direction.WEST, 6 + this.rand.nextInt(5));
                pos = this.makeCorner(pos[0], pos[1], pos[2], Direction.WEST, Direction.SOUTH);
                pos = this.makeCorridor(pos[0], pos[1], pos[2], Direction.SOUTH, 3);
                pos = this.makeCorner(pos[0], pos[1], pos[2], Direction.SOUTH, Direction.EAST);
                leftOff = this.makeCorridor(pos[0], pos[1], pos[2], Direction.EAST, 14 + this.rand.nextInt(5));
                pos = leftOff;
                pos = this.makeCorner(pos[0], pos[1], pos[2], Direction.EAST, Direction.NORTH);
                pos = this.makeCorridor(pos[0], pos[1], pos[2], Direction.NORTH, 3);
                pos = this.makeCorner(pos[0], pos[1], pos[2], Direction.NORTH, Direction.EAST);
                this.makeRoom(pos[0], pos[1], pos[2], Direction.EAST, 0);
                pos = this.makeCorridorFromCorner(leftOff[0], leftOff[1], leftOff[2], Direction.EAST, 1 + this.rand.nextInt(5));
                pos = this.makeCorner(pos[0], pos[1], pos[2], Direction.EAST, Direction.SOUTH);
                pos = this.makeCorridor(pos[0], pos[1], pos[2], Direction.SOUTH, 3 + this.rand.nextInt(5));
                this.makeRoom(pos[0], pos[1], pos[2], Direction.SOUTH, 1 + this.rand.nextInt(2));
            }
        }
        pos = this.makeStairs(3, -1, 0, Direction.WEST, 20 + this.rand.nextInt(10));
        pos = this.makeCorridor(pos[0], pos[1], pos[2], Direction.WEST, 6 + this.rand.nextInt(4));
        pos = this.makeCorner(pos[0], pos[1], pos[2], Direction.WEST, Direction.SOUTH);
        pos = this.makeCorridor(pos[0], pos[1], pos[2], Direction.SOUTH, 3 + this.rand.nextInt(3));
        leftOff = this.make3Way(pos[0], pos[1], pos[2], Direction.SOUTH);
        pos = leftOff;
        pos = this.makeCorridor(pos[0], pos[1], pos[2], Direction.EAST, 3 + this.rand.nextInt(4));
        pos = this.makeCorner(pos[0], pos[1], pos[2], Direction.EAST, Direction.SOUTH);
        pos = this.makeCorner(pos[0], pos[1], pos[2], Direction.SOUTH, Direction.EAST);
        this.makeRoom(pos[0], pos[1], pos[2], Direction.EAST, 0);
        pos = this.getRightPosOf3Way(leftOff[0], leftOff[1], leftOff[2], Direction.SOUTH);
        leftOff = this.makeCorridor(pos[0], pos[1], pos[2], Direction.WEST, 3 + this.rand.nextInt(4));
        pos = leftOff;
        pos = this.makeCorner(pos[0], pos[1], pos[2], Direction.WEST, Direction.SOUTH);
        this.makeRoom(pos[0], pos[1], pos[2], Direction.SOUTH, 1 + this.rand.nextInt(2));
        pos = this.makeCorridorFromCorner(leftOff[0], leftOff[1], leftOff[2], Direction.WEST, 6 + this.rand.nextInt(4));
        pos = this.makeCorner(pos[0], pos[1], pos[2], Direction.WEST, Direction.NORTH);
        pos = this.makeCorridor(pos[0], pos[1], pos[2], Direction.NORTH, 3 + this.rand.nextInt(5));
        leftOff = this.make3Way(pos[0], pos[1], pos[2], Direction.NORTH);
        pos = leftOff;
        this.makeRoom(pos[0], pos[1], pos[2], Direction.WEST, 1 + this.rand.nextInt(2));
        pos = this.getRightPosOf3Way(leftOff[0], leftOff[1], leftOff[2], Direction.NORTH);
        pos = this.makeCorridor(pos[0], pos[1], pos[2], Direction.EAST, 1 + this.rand.nextInt(6));
        pos = this.makeCorner(pos[0], pos[1], pos[2], Direction.EAST, Direction.NORTH);
        this.makeRoom(pos[0], pos[1], pos[2], Direction.NORTH, 1 + this.rand.nextInt(3));
        return true;
    }

    private void set(int[] pos, Block b) {
        this.set(pos[0], pos[1], pos[2], b);
    }

    private void set(int dX, int dY, int dZ, Block b) {
        this.set(dX, dY, dZ, b, 0);
    }

    private void set(int dX, int dY, int dZ, Block b, int meta) {
        this.worldObj.func_147465_d(this.beginXPos + dX * this.reflX, this.beginYPos + dY, this.beginZPos + dZ * this.reflZ, b, meta, 2);
    }

    private void setBrick(int[] pos) {
        this.setBrick(pos[0], pos[1], pos[2]);
    }

    private void setBrick(int dX, int dY, int dZ) {
        this.set(dX, dY, dZ, Blocks.field_150417_aV, this.rand.nextInt(3));
    }

    private void setStair(int dX, int dY, int dZ, Direction dir) {
        switch (dir) {
            case NORTH: 
            case SOUTH: {
                if (this.reflX != -1) break;
                dir = dir.opposite();
                break;
            }
            case EAST: 
            case WEST: {
                if (this.reflZ != -1) break;
                dir = dir.opposite();
            }
        }
        int meta = 0;
        switch (dir) {
            case NORTH: {
                meta = 1;
                break;
            }
            case SOUTH: {
                meta = 0;
                break;
            }
            case EAST: {
                meta = 3;
                break;
            }
            case WEST: {
                meta = 2;
            }
        }
        this.set(dX, dY, dZ, this.getRandStair(), meta);
    }

    private void setChest(int dX, int dY, int dZ) {
        int[] pos = this.getAbsolutePos(new int[]{dX, dY, dZ});
        this.worldObj.func_147449_b(pos[0], pos[1], pos[2], (Block)Blocks.field_150486_ae);
        TileEntityChest tileentitychest = (TileEntityChest)this.worldObj.func_147438_o(pos[0], pos[1], pos[2]);
        int LOOT_SIZE = 4 + this.rand.nextInt(4);
        if (tileentitychest != null) {
            for (int i = 0; i < LOOT_SIZE; ++i) {
                WeightedRandomChestContent.func_76293_a((Random)this.rand, (WeightedRandomChestContent[])catacombChestContents, (IInventory)tileentitychest, (int)1);
            }
        }
    }

    private void setStatue(int dX, int dY, int dZ) {
        int CHANCE_IS_REAL = 6;
        int CHANCE_HAS_CHEST = 5;
        if (this.rand.nextInt(6) == 0) {
            this.spawnAngel(dX, dY, dZ);
        } else {
            int meta = this.rand.nextInt(4);
            this.set(dX, dY, dZ, ItemRegistry.statue, meta);
            if (this.rand.nextInt(5) == 0) {
                this.setChest(dX, dY - 1, dZ);
            }
        }
    }

    private void spawnAngel(int dX, int dY, int dZ) {
        if (!this.worldObj.field_72995_K) {
            int[] pos = this.getAbsolutePos(new int[]{dX, dY, dZ});
            EntityAngel angel = new EntityAngel(this.worldObj);
            angel.func_70012_b((double)pos[0] + 0.5, pos[1], (double)pos[2] + 0.5, 0.0f, 0.0f);
            this.worldObj.func_72838_d((Entity)angel);
        }
    }

    private int[] getAbsolutePos(int[] pos) {
        int x = this.beginXPos + pos[0] * this.reflX;
        int y = this.beginYPos + pos[1];
        int z = this.beginZPos + pos[2] * this.reflZ;
        return new int[]{x, y, z};
    }

    private int getReflection() {
        int[] ref = new int[]{-1, 1};
        return ref[(int)(Math.random() * 2.0)];
    }

    private boolean getIsValidLocation(int x, int y, int z) {
        if (y < 30 || y > 128) {
            return false;
        }
        int sqWidth = 14;
        Material m = this.worldObj.func_147439_a((x += 3 * this.reflX) - sqWidth / 2, y, (z += 3 * this.reflZ) + sqWidth / 2).func_149688_o();
        boolean isFlat = m == Material.field_151579_a || m == Material.field_151585_k;
        m = this.worldObj.func_147439_a(x + sqWidth / 2, y, z + sqWidth / 2).func_149688_o();
        isFlat = isFlat && (m == Material.field_151579_a || m == Material.field_151585_k);
        m = this.worldObj.func_147439_a(x - sqWidth / 2, y, z - sqWidth / 2).func_149688_o();
        isFlat = isFlat && (m == Material.field_151579_a || m == Material.field_151585_k);
        m = this.worldObj.func_147439_a(x + sqWidth / 2, y, z - sqWidth / 2).func_149688_o();
        isFlat = isFlat && (m == Material.field_151579_a || m == Material.field_151585_k);
        return isFlat;
    }

    private Block getRandStair() {
        Block[] blocks = new Block[]{Blocks.field_150390_bg, Blocks.field_150446_ar};
        return blocks[this.rand.nextInt(blocks.length)];
    }

    private int[] getPosLeft(int[] pos, Direction dir, int distance) {
        return this.getPosToLeft(pos[0], pos[1], pos[2], dir, distance);
    }

    private int[] getPosToLeft(int x, int y, int z, Direction dir, int distance) {
        switch (dir) {
            case NORTH: {
                z -= distance;
                break;
            }
            case SOUTH: {
                z += distance;
                break;
            }
            case EAST: {
                x += distance;
                break;
            }
            case WEST: {
                x -= distance;
            }
        }
        return new int[]{x, y, z};
    }

    private int[] getPosForward(int[] pos, Direction dir, int distance) {
        return this.getPosForward(pos[0], pos[1], pos[2], dir, distance);
    }

    private int[] getPosForward(int x, int y, int z, Direction dir, int distance) {
        switch (dir) {
            case NORTH: {
                x += distance;
                break;
            }
            case SOUTH: {
                x -= distance;
                break;
            }
            case EAST: {
                z += distance;
                break;
            }
            case WEST: {
                z -= distance;
            }
        }
        return new int[]{x, y, z};
    }

    private int[] getRightPosOf3Way(int x, int y, int z, Direction dirStart) {
        int[] pos = this.getPosToLeft(x, y, z, dirStart, -5);
        pos = this.getPosForward(pos, dirStart, -1);
        return pos;
    }

    private void makeEntrance(int beginDX, int beginDY, int beginDZ) {
        int[][] stairCoverRoof;
        int z;
        int y;
        int x;
        int HEIGHT = 6;
        int[][] base = new int[][]{{0, 0}, {0, 1}, {0, 2}, {0, 3}, {0, 4}, {0, 5}, {1, 0}, {2, 0}, {3, 0}, {4, 0}, {5, 0}, {1, 5}, {2, 5}, {3, 5}, {4, 5}, {5, 5}, {5, 1}, {5, 2}, {5, 3}, {5, 4}};
        for (int i = 0; i < 6; ++i) {
            for (int[] coord : base) {
                x = beginDX + coord[0];
                y = beginDY + i - 1;
                z = beginDY + coord[1];
                this.setBrick(x, y, z);
                int tmpY = -2;
                while (y + tmpY > 10 && (this.worldObj.func_147437_c(x, y + tmpY, z) || this.worldObj.func_147439_a(x, y + tmpY, z).func_149688_o() == Material.field_151586_h)) {
                    this.setBrick(x, y - tmpY, z);
                    --tmpY;
                }
            }
        }
        int[][] roof = new int[][]{{1, 1}, {1, 2}, {1, 3}, {1, 4}, {2, 1}, {2, 2}, {2, 3}, {2, 4}, {3, 1}, {3, 2}, {3, 3}, {3, 4}, {4, 1}, {4, 2}, {4, 3}, {4, 4}};
        for (int[] coord : roof) {
            x = beginDX + coord[0];
            y = beginDY + 6 - 2;
            z = beginDZ + coord[1];
            this.setBrick(x, y, z);
            this.setBrick(x, -1, z);
            for (int i = 1; i < 5; ++i) {
                this.set(x, y - i, z, Blocks.field_150350_a);
            }
        }
        for (int i = 0; i < 3; ++i) {
            this.set(beginDX, beginDY + i, beginDZ + 2, Blocks.field_150350_a);
            this.set(beginDX, beginDY + i, beginDZ + 3, Blocks.field_150350_a);
        }
        int[][] stairCover = new int[][]{{1, 6}, {1, 7}, {1, 8}, {1, 9}, {4, 6}, {4, 7}, {4, 8}, {4, 9}, {2, 9}, {3, 9}, {1, -1}, {1, -2}, {1, -3}, {1, -4}, {4, -1}, {4, -2}, {4, -3}, {4, -4}, {2, -4}, {3, -4}};
        for (int i = 0; i < 5; ++i) {
            int[][] nArrayArray = stairCover;
            int n = nArrayArray.length;
            for (int j = 0; j < n; ++j) {
                int[] coord = nArrayArray[j];
                x = beginDX + coord[0];
                y = beginDY + i;
                z = beginDZ + coord[1];
                this.setBrick(x, y, z);
            }
        }
        for (int[] coord : stairCoverRoof = new int[][]{{2, 6}, {2, 7}, {2, 8}, {3, 6}, {3, 7}, {3, 8}, {2, -1}, {2, -2}, {2, -3}, {3, -1}, {3, -2}, {3, -3}}) {
            x = beginDX + coord[0];
            y = beginDY + 6 - 2;
            z = beginDZ + coord[1];
            this.setBrick(x, y, z);
        }
    }

    private int[] makeStairs(int beginDX, int beginDY, int beginDZ, Direction dirForward, int depth) {
        int NUM_TURNS = 4;
        int[] pos = new int[]{beginDX, beginDY, beginDZ};
        int pieceLen = depth / 4;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < pieceLen; ++j) {
                this.makeCorridorPiece(pos[0], pos[1], pos[2], dirForward, true, true, false, false);
                this.setStair(pos[0], pos[1], pos[2], dirForward);
                pos = this.getPosLeft(pos, dirForward, 1);
                this.setStair(pos[0], pos[1], pos[2], dirForward);
                pos = this.getPosLeft(pos, dirForward, -1);
                pos = this.getPosForward(pos, dirForward, 1);
                pos[1] = pos[1] - 1;
            }
            pos = this.makeCorner(pos[0], pos[1], pos[2], dirForward, dirForward.getCCW());
            dirForward = dirForward.getCCW();
        }
        return pos;
    }

    private int[] makeCorridorPiece(int[] pos, Direction dirForward, boolean hasLeftWall, boolean hasRightWall, boolean hasAlcove, boolean hasBars) {
        return this.makeCorridorPiece(pos[0], pos[1], pos[2], dirForward, hasLeftWall, hasRightWall, hasAlcove, hasBars);
    }

    private int[] makeCorridorPiece(int dX, int dY, int dZ, Direction dirForward, boolean hasLeftWall, boolean hasRightWall, boolean hasAlcove, boolean hasBars) {
        int i;
        int[] pos = new int[]{dX, dY, dZ};
        if (hasRightWall) {
            pos = this.getPosLeft(pos, dirForward, -1);
            for (i = 1; i < 4; ++i) {
                if (hasAlcove && i == 2) {
                    this.set(pos[0], pos[1] + i, pos[2], Blocks.field_150350_a);
                    continue;
                }
                this.setBrick(pos[0], pos[1] + i, pos[2]);
            }
        }
        pos = new int[]{dX, dY, dZ};
        this.setBrick(pos[0], pos[1], pos[2]);
        this.set(pos[0], pos[1] + 1, pos[2], hasBars ? Blocks.field_150411_aY : Blocks.field_150350_a);
        this.set(pos[0], pos[1] + 2, pos[2], hasBars ? Blocks.field_150411_aY : Blocks.field_150350_a);
        this.set(pos[0], pos[1] + 3, pos[2], hasBars ? Blocks.field_150411_aY : Blocks.field_150350_a);
        this.setBrick(pos[0], pos[1] + 4, pos[2]);
        pos = this.getPosLeft(pos, dirForward, 1);
        this.setBrick(pos[0], pos[1], pos[2]);
        this.set(pos[0], pos[1] + 1, pos[2], hasBars ? Blocks.field_150411_aY : Blocks.field_150350_a);
        this.set(pos[0], pos[1] + 2, pos[2], hasBars ? Blocks.field_150411_aY : Blocks.field_150350_a);
        this.set(pos[0], pos[1] + 3, pos[2], hasBars ? Blocks.field_150411_aY : Blocks.field_150350_a);
        this.setBrick(pos[0], pos[1] + 4, pos[2]);
        pos = new int[]{dX, dY, dZ};
        if (hasLeftWall) {
            pos = this.getPosLeft(pos, dirForward, 2);
            for (i = 1; i < 4; ++i) {
                if (hasAlcove && i == 2) {
                    this.set(pos[0], pos[1] + i, pos[2], Blocks.field_150350_a);
                    continue;
                }
                this.setBrick(pos[0], pos[1] + i, pos[2]);
            }
        }
        return this.getPosForward(new int[]{dX, dY, dZ}, dirForward, 1);
    }

    private int[] makeCorridor(int dX, int dY, int dZ, Direction dirForward, int length) {
        int[] pos = new int[]{dX, dY, dZ};
        while (length % 3 != 0) {
            ++length;
        }
        for (int i = 0; i < length; ++i) {
            boolean alcove = i % 3 != 0;
            pos = this.makeCorridorPiece(pos, dirForward, true, true, alcove, false);
        }
        return pos;
    }

    private int[] makeCorner(int startDX, int startDY, int startDZ, Direction startDir, Direction endDir) {
        int[] pos = new int[]{startDX, startDY, startDZ};
        boolean isRightTurn = startDir == Direction.NORTH && endDir == Direction.EAST || startDir == Direction.SOUTH && endDir == Direction.WEST || startDir == Direction.WEST && endDir == Direction.NORTH || startDir == Direction.EAST && endDir == Direction.SOUTH;
        pos = this.makeCorridorPiece(pos, startDir, true, true, false, false);
        pos = this.makeCorridorPiece(pos, startDir, isRightTurn, !isRightTurn, true, false);
        pos = this.makeCorridorPiece(pos, startDir, isRightTurn, !isRightTurn, true, false);
        pos = this.getPosForward(pos, startDir, isRightTurn ? -2 : -1);
        if (isRightTurn) {
            pos = this.getPosLeft(pos, startDir, 1);
        }
        pos = this.makeCorridorPiece(pos, endDir, isRightTurn, !isRightTurn, true, false);
        pos = this.makeCorridorPiece(pos, endDir, isRightTurn, !isRightTurn, true, false);
        return pos;
    }

    private int[] makeCorridorFromCorner(int cornerStartDX, int cornerStartDY, int cornerStartDZ, Direction startDir, int length) {
        int[] pos = this.getPosForward(cornerStartDX, cornerStartDY, cornerStartDZ, startDir, 3);
        return this.makeCorridor(pos[0], pos[1], pos[2], startDir, length);
    }

    private int[] make3Way(int startDX, int startDY, int startDZ, Direction startDir) {
        int[] pos = new int[]{startDX, startDY, startDZ};
        pos = this.makeCorridorPiece(pos, startDir, true, true, false, false);
        pos = this.makeCorridorPiece(pos, startDir.getCW(), true, false, true, false);
        pos = this.makeCorridorPiece(pos, startDir.getCW(), true, false, false, false);
        pos = this.getPosForward(startDX, startDY, startDZ, startDir, 2);
        pos = this.getPosForward(pos, startDir.getCCW(), 1);
        pos = this.makeCorridorPiece(pos, startDir.getCCW(), false, true, true, false);
        pos = this.makeCorridorPiece(pos, startDir.getCCW(), false, true, false, false);
        return pos;
    }

    private int[] makeRoom(int dX, int dY, int dZ, Direction dirForward, int TYPE) {
        int i;
        int[] pos = new int[]{dX, dY, dZ};
        int NUM_BAR_LAYERS = 2;
        for (i = 0; TYPE != 0 && i < 2; ++i) {
            pos = this.makeCorridorPiece(pos, dirForward, true, true, false, true);
        }
        dX = pos[0];
        dY = pos[1];
        dZ = pos[2];
        if (TYPE == 0) {
            pos = this.makeCorridor(dX, dY, dZ, dirForward, 3);
            pos[1] = pos[1] + 1;
            for (i = 0; i < 2; ++i) {
                this.setBrick(pos[0], pos[1], pos[2]);
                this.set(pos[0], pos[1] + 1, pos[2], Blocks.field_150350_a);
                this.setBrick(pos[0], pos[1] + 2, pos[2]);
                pos = this.getPosLeft(pos, dirForward, 1);
            }
        } else if (TYPE < 3) {
            int[][] middle;
            int i2;
            pos = this.makeCorridorPiece(dX, dY, dZ, dirForward, true, true, false, false);
            this.makeCorridorPiece(pos, dirForward, false, false, false, false);
            pos = this.getPosForward(dX, dY, dZ, dirForward, 1);
            pos = this.getPosLeft(pos, dirForward, -1);
            pos = this.makeCorridorPiece(pos[0], pos[1], pos[2], dirForward.getCW(), false, true, false, false);
            pos = this.makeCorridorPiece(pos[0], pos[1], pos[2], dirForward.getCW(), false, true, false, false);
            pos = this.getPosForward(dX, dY, dZ, dirForward, 2);
            pos = this.getPosLeft(pos, dirForward, 2);
            pos = this.makeCorridorPiece(pos[0], pos[1], pos[2], dirForward.getCCW(), true, false, false, false);
            pos = this.makeCorridorPiece(pos[0], pos[1], pos[2], dirForward.getCCW(), true, false, false, false);
            boolean isRight = false;
            for (i2 = 0; i2 < 2; ++i2) {
                pos = this.getPosForward(dX, dY, dZ, dirForward, 1);
                pos = this.getPosLeft(pos, dirForward, isRight ? 2 : -2);
                for (int j = 0; j < 6; ++j) {
                    int alcove = j <= 1 || j >= 5 ? 1 : 0;
                    pos = this.makeCorridorPiece(pos[0], pos[1], pos[2], dirForward, isRight, !isRight, true, false);
                }
                isRight = true;
            }
            pos = this.getPosForward(dX, dY, dZ, dirForward, 6);
            pos = this.getPosLeft(pos, dirForward, -2);
            for (i2 = 0; i2 < 6; ++i2) {
                boolean isAlcove = i2 < 2 || i2 > 3;
                pos = this.makeCorridorPiece(pos[0], pos[1], pos[2], dirForward.getCCW(), false, true, isAlcove, false);
            }
            for (int[] coord : middle = new int[][]{{2, 0}, {3, 0}, {4, 0}, {2, 1}, {3, 1}, {4, 1}}) {
                pos = this.getPosForward(dX, dY, dZ, dirForward, coord[0]);
                pos = this.getPosLeft(pos, dirForward, coord[1]);
                this.setBrick(pos);
                pos[1] = pos[1] + 1;
                this.set(pos, Blocks.field_150350_a);
                pos[1] = pos[1] + 1;
                this.set(pos, Blocks.field_150350_a);
                pos[1] = pos[1] + 1;
                this.set(pos, Blocks.field_150350_a);
                pos[1] = pos[1] + 1;
                this.setBrick(pos);
            }
            if (TYPE == 1) {
                int[][] statuePos;
                for (int[] coord : statuePos = new int[][]{{6, -1}, {5, -2}, {6, 2}, {5, 3}, {1, -1}, {2, -2}, {1, 2}, {2, 3}}) {
                    pos = this.getPosForward(dX, dY + 1, dZ, dirForward, coord[0]);
                    pos = this.getPosLeft(pos, dirForward, coord[1]);
                    this.setStatue(pos[0], pos[1], pos[2]);
                }
            } else {
                int[][] bricksInBetweens;
                int[][] bricksCorners;
                for (int[] coord : bricksCorners = new int[][]{{2, 0, -1}, {2, 1, -1}, {2, 2, -1}, {5, 0, -1}, {5, 1, -1}, {5, 2, -1}, {5, 0, 2}, {5, 1, 2}, {5, 2, 2}, {2, 0, 2}, {2, 1, 2}, {2, 2, 2}}) {
                    pos = this.getPosForward(dX, dY + 1 + coord[1], dZ, dirForward, coord[0]);
                    pos = this.getPosLeft(pos, dirForward, coord[2]);
                    this.setBrick(pos);
                }
                for (int[] coord : bricksInBetweens = new int[][]{{2, 0}, {2, 1}, {3, 2}, {4, 2}, {5, 1}, {5, 0}, {4, -1}, {3, -1}}) {
                    pos = this.getPosForward(dX, dY + 1, dZ, dirForward, coord[0]);
                    pos = this.getPosLeft(pos, dirForward, coord[1]);
                    this.setBrick(pos[0], pos[1] + 0, pos[2]);
                    this.set(pos[0], pos[1] + 1, pos[2], Blocks.field_150350_a);
                    this.setBrick(pos[0], pos[1] + 2, pos[2]);
                }
                pos = this.getPosForward(dX, dY + 1, dZ, dirForward, 4);
                this.spawnAngel(pos[0], pos[1], pos[2]);
            }
        } else {
            pos = this.getPosToLeft(dX, dY, dZ, dirForward, -1);
            pos = this.makeCorridorPiece(pos, dirForward, false, true, false, false);
            pos = this.makeCorridorPiece(pos, dirForward, false, true, true, false);
            pos = this.makeCorridorPiece(pos, dirForward, false, true, true, false);
            pos = this.makeCorridorPiece(pos, dirForward, false, true, false, false);
            pos = this.getPosForward(dX, dY, dZ, dirForward, 3);
            pos = this.getPosLeft(pos, dirForward, -1);
            pos = this.makeCorridorPiece(pos, dirForward.getCCW(), false, true, false, false);
            pos = this.makeCorridorPiece(pos, dirForward.getCCW(), false, true, true, false);
            pos = this.makeCorridorPiece(pos, dirForward.getCCW(), false, true, true, false);
            pos = this.makeCorridorPiece(pos, dirForward.getCCW(), false, true, false, false);
            pos = this.getPosToLeft(dX, dY, dZ, dirForward, 1);
            pos = this.makeCorridorPiece(pos, dirForward, true, false, false, false);
            pos = this.makeCorridorPiece(pos, dirForward, true, false, true, false);
            pos = this.makeCorridorPiece(pos, dirForward, true, false, true, false);
            pos = this.makeCorridorPiece(pos, dirForward, true, false, false, false);
            if (TYPE == 3) {
                pos = this.getPosForward(dX, dY + 1, dZ, dirForward, 3);
                pos = this.getPosLeft(pos, dirForward, 2);
                this.setStatue(pos[0], pos[1], pos[2]);
                pos = this.getPosLeft(pos, dirForward, -3);
                this.setStatue(pos[0], pos[1], pos[2]);
                pos = this.getPosForward(pos, dirForward, -3);
                this.setStatue(pos[0], pos[1], pos[2]);
                pos = this.getPosLeft(pos, dirForward, 3);
                this.setStatue(pos[0], pos[1], pos[2]);
            } else {
                pos = this.getPosForward(dX, dY + 1, dZ, dirForward, 1);
                this.setStair(pos[0], pos[1], pos[2], dirForward.opposite());
                pos = this.getPosLeft(pos, dirForward, 1);
                this.setStair(pos[0], pos[1], pos[2], dirForward.opposite());
                pos = this.getPosForward(dX, dY + 1, dZ, dirForward, 2);
                this.setBrick(pos);
                this.setChest(pos[0], pos[1] + 1, pos[2]);
                pos = this.getPosLeft(pos, dirForward, 1);
                this.setBrick(pos);
                this.setChest(pos[0], pos[1] + 1, pos[2]);
                pos = this.getPosForward(dX, dY + 1, dZ, dirForward, 3);
                pos = this.getPosLeft(pos, dirForward, -1);
                this.setStatue(pos[0], pos[1], pos[2]);
                pos = this.getPosLeft(pos, dirForward, 3);
                this.setStatue(pos[0], pos[1], pos[2]);
            }
        }
        return new int[]{dX, dY, dZ};
    }

    private static enum Direction {
        NORTH,
        EAST,
        SOUTH,
        WEST;


        private Direction getCW() {
            return this.values()[(this.ordinal() + 1) % 4];
        }

        private Direction opposite() {
            return this.values()[(this.ordinal() + 2) % 4];
        }

        private Direction getCCW() {
            return this.values()[(this.ordinal() + 3) % 4];
        }
    }
}

