/*
 * Decompiled with CFR 0.152.
 */
package com.w_angels.entity;

import com.w_angels.item.ItemRegistry;
import com.w_angels.item.PotionEffectAngel;
import com.w_angels.item.PotionRegistry;
import com.w_angels.main.Config;
import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityAngel
extends EntityMob {
    private final double MOVE_SPEED = 0.8;
    private final double ATTACK_DAMAGE = 16.0;
    private final double FIND_PLAYER_RANGE = 48.0;
    private final int DATA_WATCHER_LOOKING = 13;
    private final int DATA_WATCHER_RENDERING = 14;
    private final int DATA_WATCHER_TIME = 15;
    private final int DATA_WATCHER_ARMS = 16;
    private final int DATA_WATCHER_WINGS = 17;
    private int ticksLookingEyes = 0;

    public EntityAngel(World world) {
        super(world);
        this.field_70138_W = 1.5f;
        this.field_70178_ae = true;
        this.func_70105_a(0.7f, 1.9f);
        this.field_70728_aV = 10;
        this.func_70661_as().func_75491_a(true);
        this.func_70661_as().func_75490_c(true);
        this.func_70661_as().func_75498_b(Config.CAN_BREAK_DOORS);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWanderWhenNotWatched((EntityCreature)this, 0.25));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIAttackWhenNotWatched((EntityCreature)this, EntityPlayer.class, 0, true));
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(13, (Object)new Byte(0));
        this.field_70180_af.func_75682_a(14, (Object)new Byte(0));
        this.field_70180_af.func_75682_a(16, (Object)new Byte(0));
        this.field_70180_af.func_75682_a(17, (Object)new Byte(0));
        this.field_70180_af.func_75682_a(15, (Object)new Integer(0));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)Config.MAX_ANGEL_HEALTH);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.8);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(16.0);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa < 10) {
                this.snapYaw();
                this.poseAsStatue();
                this.setIsPlayerLooking(true);
            }
            this.setTimeSinceRender(this.getTimeSinceRender() + 1);
        }
        if (this.field_70789_a == null) {
            this.field_70789_a = this.func_70782_k();
            if (this.getIsRendering()) {
                this.snapYaw();
            }
        }
        if (this.field_70173_aa > 10 && this.field_70170_p.func_72890_a((Entity)this, 48.0) == null && this.func_70660_b(Potion.field_76428_l) == null) {
            this.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 100, 1));
        }
        if (this.getIsPlayerLooking()) {
            this.poseAsStatue();
            if (this.getArmPos() > 0 && this.field_70789_a != null && this.field_70789_a instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)this.field_70789_a;
                if (this.getIsLookingInEyes(player)) {
                    if (++this.ticksLookingEyes >= Config.LOOKING_EYES_THRESHOLD) {
                        this.ticksLookingEyes = 0;
                        if (!player.func_70651_bq().contains(PotionRegistry.angelInfect)) {
                            player.func_70690_d((PotionEffect)new PotionEffectAngel());
                        }
                    }
                } else {
                    this.ticksLookingEyes = 0;
                }
            }
        } else if (this.field_70789_a != null) {
            float dis = this.func_70032_d(this.field_70789_a);
            if (dis <= 2.5f) {
                this.setArmPos((byte)2);
                this.setWingPos((byte)2);
            } else if (dis <= 4.0f) {
                this.setArmPos((byte)1);
                this.setWingPos((byte)1);
            } else {
                this.setArmPos((byte)0);
                this.setWingPos((byte)0);
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (Config.CAN_BREAK_DOORS && this.field_70173_aa % 40 == 30) {
            int x = (int)Math.floor(this.field_70165_t);
            int y = (int)Math.floor(this.field_70121_D.field_72338_b);
            int z = (int)Math.floor(this.field_70161_v);
            int[][] blocksToScan = new int[][]{{0, 1}, {1, 0}, {-1, 0}, {0, -1}};
            boolean foundDoor = false;
            for (int i = 0; i < 2; ++i) {
                for (int[] loc : blocksToScan) {
                    Block b = this.field_70170_p.func_147439_a(x + loc[0], y + i, z + loc[1]);
                    int meta = this.field_70170_p.func_72805_g(x + loc[0], y + i, z + loc[1]);
                    if (b != Blocks.field_150466_ao || meta >= 4 && meta <= 7 || this.getIsPlayerLooking()) continue;
                    foundDoor = true;
                    this.field_70170_p.func_147465_d(x + loc[0], y + i, z + loc[1], Blocks.field_150350_a, 0, 3);
                    if (this.field_70170_p.func_147439_a(x + loc[0], y + i + 1, z + loc[1]) == Blocks.field_150466_ao) {
                        this.field_70170_p.func_147468_f(x + loc[0], y + i + 1, z + loc[1]);
                    }
                    if (this.field_70170_p.func_147439_a(x + loc[0], y + i - 1, z + loc[1]) != Blocks.field_150466_ao) continue;
                    this.field_70170_p.func_147468_f(x + loc[0], y + i - 1, z + loc[1]);
                }
            }
            if (foundDoor) {
                this.func_145779_a(Items.field_151135_aq, 1);
                this.field_70170_p.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "mob.zombie.woodbreak", 1.0f, 0.95f);
            }
        }
    }

    protected void func_70626_be() {
        if (!this.getIsPlayerLooking()) {
            super.func_70626_be();
        } else {
            this.poseAsStatue();
        }
    }

    public boolean func_70097_a(DamageSource ds, float amnt) {
        if (ForgeHooks.onLivingAttack((EntityLivingBase)this, (DamageSource)ds, (float)(amnt /= 2.0f))) {
            return false;
        }
        if (this.func_85032_ar() || this.field_70170_p.field_72995_K) {
            return false;
        }
        if (ds == DamageSource.field_76368_d) {
            return false;
        }
        if (ds.func_76346_g() != null && ds.func_76346_g() instanceof EntityLivingBase) {
            ItemStack held = ((EntityLivingBase)ds.func_76346_g()).func_70694_bm();
            if (held != null && held.func_77973_b() instanceof ItemPickaxe) {
                return super.func_70097_a(ds, amnt);
            }
            return false;
        }
        return super.func_70097_a(ds, amnt);
    }

    public boolean func_70652_k(Entity entity) {
        return super.func_70652_k(entity);
    }

    protected Entity func_70782_k() {
        EntityPlayer entityplayer = this.field_70170_p.func_72856_b((Entity)this, 48.0);
        return entityplayer != null && this.func_70685_l((Entity)entityplayer) ? entityplayer : null;
    }

    protected void func_70628_a(boolean recentlyHit, int lootingLevel) {
        this.func_145779_a(ItemRegistry.itemStatue, 1);
    }

    public boolean func_70601_bi() {
        boolean properY = this.field_70163_u >= (double)Config.MIN_ANGEL_SPAWN_HEIGHT && this.field_70163_u <= (double)Config.MAX_ANGEL_SPAWN_HEIGHT;
        return properY && Config.ALLOW_NATURAL_SPAWNING && !Config.DIMENSION_BLACKLIST.contains(new Integer(this.field_70170_p.field_73011_w.field_76574_g)) && super.func_70601_bi();
    }

    public boolean func_70692_ba() {
        return !this.func_94056_bM();
    }

    protected void func_70623_bb() {
        Event.Result result = null;
        if ((this.field_70708_bq & 0x1F) == 31 && (result = ForgeEventFactory.canEntityDespawn((EntityLiving)this)) != Event.Result.DEFAULT) {
            if (result == Event.Result.DENY) {
                this.field_70708_bq = 0;
            } else {
                this.becomeStatue();
            }
        } else {
            EntityPlayer entityplayer = this.field_70170_p.func_72890_a((Entity)this, -1.0);
            if (entityplayer != null) {
                double d0 = entityplayer.field_70165_t - this.field_70165_t;
                double d1 = entityplayer.field_70163_u - this.field_70163_u;
                double d2 = entityplayer.field_70161_v - this.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (this.func_70692_ba() && d3 > 16384.0) {
                    this.becomeStatue();
                }
                if (this.field_70708_bq > 600 && this.field_70146_Z.nextInt(800) == 0 && d3 > 1024.0 && this.func_70692_ba()) {
                    this.becomeStatue();
                } else if (d3 < 1024.0) {
                    this.field_70708_bq = 0;
                }
            }
        }
    }

    public void func_70069_a(float f) {
    }

    public void func_70653_a(Entity attackingEntity, float amount, double x, double z) {
    }

    protected int func_70682_h(int i) {
        return i;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70650_aV() {
        return false;
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        this.snapYaw();
        return data;
    }

    protected void func_70664_aZ() {
        if (!this.func_70090_H()) {
            super.func_70664_aZ();
            this.field_70181_x += 0.24;
        }
    }

    private void snapYaw() {
        float roundedYaw;
        this.field_70177_z = roundedYaw = (float)Math.toRadians((float)Math.round(Math.toDegrees(this.field_70177_z) / 90.0) * 90.0f);
    }

    private void poseAsStatue() {
        this.field_70179_y = 0.0;
        this.field_70159_w = 0.0;
        this.field_70701_bs = 0.0f;
    }

    private void becomeStatue() {
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        this.field_70170_p.func_147449_b(x, y, z, ItemRegistry.statue);
        this.func_70106_y();
    }

    public void setIsPlayerLooking(boolean playerLooking) {
        boolean hasChanged;
        if (this.field_70170_p.field_72995_K) {
            // empty if block
        }
        boolean bl = hasChanged = playerLooking != this.getIsPlayerLooking();
        if (hasChanged) {
            byte b0 = this.field_70180_af.func_75683_a(13);
            if (playerLooking) {
                this.field_70180_af.func_75692_b(13, (Object)((byte)(b0 | 1)));
            } else {
                this.field_70180_af.func_75692_b(13, (Object)((byte)(b0 & 0xFFFFFFFE)));
            }
        }
    }

    public boolean getIsPlayerLooking() {
        return (this.field_70180_af.func_75683_a(13) & 1) != 0;
    }

    public void setIsRendering(boolean rendering) {
        boolean hasChanged;
        if (this.field_70170_p.field_72995_K) {
            // empty if block
        }
        boolean bl = hasChanged = rendering != this.getIsRendering();
        if (hasChanged) {
            byte b0 = this.field_70180_af.func_75683_a(14);
            if (rendering) {
                this.field_70180_af.func_75692_b(14, (Object)((byte)(b0 | 1)));
            } else {
                this.field_70180_af.func_75692_b(14, (Object)((byte)(b0 & 0xFFFFFFFE)));
            }
            EntityPlayer player = this.field_70170_p.func_72890_a((Entity)this, 48.0);
            this.setIsPlayerLooking(this.getIsRendering() && player != null);
        }
    }

    public boolean getIsRendering() {
        return (this.field_70180_af.func_75683_a(14) & 1) != 0;
    }

    public void setTimeSinceRender(int time) {
        if (this.field_70170_p.field_72995_K) {
            // empty if block
        }
        this.field_70180_af.func_75692_b(15, (Object)time);
        this.setIsRendering(time <= Config.MAX_TICKS_ANGEL_WAITS);
    }

    public int getTimeSinceRender() {
        return this.field_70180_af.func_75679_c(15);
    }

    public void setArmPos(byte toSet) {
        this.field_70180_af.func_75692_b(16, (Object)toSet);
    }

    public int getArmPos() {
        return this.field_70180_af.func_75683_a(16);
    }

    public void setWingPos(byte toSet) {
        this.field_70180_af.func_75692_b(17, (Object)toSet);
    }

    public int getWingPos() {
        return this.field_70180_af.func_75683_a(17);
    }

    private boolean getIsLookingInEyes(EntityPlayer toCheck) {
        Vec3 vec3 = toCheck.func_70676_i(1.0f).func_72432_b();
        Vec3 vec31 = Vec3.func_72443_a((double)(this.field_70165_t - toCheck.field_70165_t), (double)(this.field_70121_D.field_72338_b + (double)this.func_70047_e() + 0.25 - (toCheck.field_70163_u + (double)toCheck.func_70047_e())), (double)(this.field_70161_v - toCheck.field_70161_v));
        double d0 = vec31.func_72433_c();
        double d1 = vec3.func_72430_b(vec31 = vec31.func_72432_b());
        boolean isLookingEyes = d1 > 1.0 - 0.025 / d0 && toCheck.func_70685_l((Entity)this);
        double myDir = this.field_70177_z + 180.0f;
        double checkDir = toCheck.field_70177_z + 180.0f;
        double diff = Math.max(myDir, checkDir) - Math.min(myDir, checkDir);
        boolean isFacing = Math.abs(180.0 - diff) < 90.0;
        return isLookingEyes && isFacing;
    }

    private class EntityAIWanderWhenNotWatched
    extends EntityAIWander {
        public EntityAIWanderWhenNotWatched(EntityCreature e, double speed) {
            super(e, speed);
        }

        public boolean func_75250_a() {
            return EntityAngel.this.getIsPlayerLooking() ? false : super.func_75250_a();
        }
    }

    private class EntityAIAttackWhenNotWatched
    extends EntityAINearestAttackableTarget {
        public EntityAIAttackWhenNotWatched(EntityCreature e, Class clazz, int i, boolean b) {
            super(e, clazz, i, b);
        }

        public boolean func_75250_a() {
            return EntityAngel.this.getIsPlayerLooking() ? false : super.func_75250_a();
        }
    }
}

