/*
 * Decompiled with CFR 0.152.
 */
package com.w_angels.worldgen;

import com.w_angels.main.Config;
import com.w_angels.worldgen.Catacombs;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenBeach;
import net.minecraft.world.biome.BiomeGenForest;
import net.minecraft.world.biome.BiomeGenOcean;
import net.minecraft.world.biome.BiomeGenRiver;
import net.minecraft.world.chunk.IChunkProvider;

public class StructureGen
implements IWorldGenerator {
    private final int CHUNK_SIZE = 16;

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int dimID = world.field_73011_w.field_76574_g;
        if (dimID == 0 || Config.CATACOMBS_WHITELIST.contains(new Integer(dimID))) {
            this.generateCatacombs(world, rand, chunkX * 16, chunkZ * 16);
        }
    }

    private void generateCatacombs(World worldIn, Random rand, int chunkCornerX, int chunkCornerZ) {
        int z;
        int x;
        int y;
        BiomeGenBase biome = worldIn.func_72959_q().func_76935_a(chunkCornerX, chunkCornerZ);
        if (rand.nextInt(65) == 0 && this.isValidBiome(biome) && (y = this.getHighestY(worldIn, x = chunkCornerX + rand.nextInt(16), z = chunkCornerZ + rand.nextInt(16))) > 0) {
            new Catacombs().generate(worldIn, rand, x, y, z);
        }
    }

    private int getHighestY(World worldIn, int x, int z) {
        Material curMat;
        int y = 255;
        do {
            curMat = worldIn.func_147439_a(x, --y, z).func_149688_o();
        } while (y > 0 && curMat != Material.field_151576_e && curMat != Material.field_151577_b && curMat != Material.field_151578_c && curMat != Material.field_151595_p && curMat != Material.field_151586_h && curMat != Material.field_151587_i);
        return y > 0 ? y + 1 : -1;
    }

    private boolean isValidBiome(BiomeGenBase biome) {
        return biome != BiomeGenBase.field_150582_Q && biome != BiomeGenBase.field_76775_o && !(biome instanceof BiomeGenBeach) && !(biome instanceof BiomeGenRiver) && !(biome instanceof BiomeGenOcean) && !(biome instanceof BiomeGenForest);
    }
}

