/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft.block;

import com.fredtargaryen.floocraft.FloocraftBase;
import com.fredtargaryen.floocraft.client.gui.GuiTeleport;
import com.fredtargaryen.floocraft.proxy.ClientProxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GreenFlamesBusy
extends Block {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)9);

    public GreenFlamesBusy() {
        super(Material.field_151581_o);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(1)));
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{AGE});
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    public void func_180650_b(World w, BlockPos pos, IBlockState state, Random par5Random) {
        if (state.func_177229_b((IProperty)AGE).equals(0) || !this.isInFireplace(w, pos)) {
            w.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
        }
        if (w.func_72977_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 8.0) == null) {
            w.func_175656_a(pos, FloocraftBase.greenFlamesIdle.func_176223_P().func_177226_a((IProperty)AGE, state.func_177229_b((IProperty)AGE)));
        }
        w.func_175684_a(pos, (Block)this, this.func_149738_a(w) + par5Random.nextInt(10));
    }

    public AxisAlignedBB func_180640_a(World worldIn, BlockPos pos, IBlockState state) {
        return null;
    }

    public void func_180634_a(World w, BlockPos pos, IBlockState state, Entity e) {
        if (e instanceof EntityPlayer && this.isInFireplace(w, pos) && w.field_72995_K) {
            this.doClientGuiTings(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doClientGuiTings(int x, int y, int z) {
        ClientProxy proxy = (ClientProxy)FloocraftBase.proxy;
        if (Minecraft.func_71410_x().field_71462_r == null && !proxy.overrideTicker.isOverriding()) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiTeleport(x, y, z));
            proxy.overrideTicker.start();
        }
    }

    public int func_149738_a(World par1World) {
        return 30;
    }

    public void func_176213_c(World w, BlockPos pos, IBlockState state) {
        if (this.isInFireplace(w, pos)) {
            w.func_175684_a(pos, (Block)this, this.func_149738_a(w));
        } else {
            w.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT;
    }

    public void func_176204_a(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        if (!this.isInFireplace(worldIn, pos)) {
            worldIn.func_175718_b(1004, pos, 0);
            worldIn.func_175698_g(pos);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    private int getTopBlockY(World w, BlockPos oldpos) {
        BlockPos pos;
        Block b0;
        if (!w.func_175678_i(oldpos) && (b0 = w.func_180495_p(pos = oldpos.func_177967_a(EnumFacing.UP, 1)).func_177230_c()) == Blocks.field_150350_a) {
            pos = pos.func_177967_a(EnumFacing.UP, 1);
            while (w.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a && pos.func_177956_o() <= 255) {
                pos = pos.func_177967_a(EnumFacing.UP, 1);
            }
            if (w.func_180495_p(pos).func_177230_c().isNormalCube((IBlockAccess)w, pos)) {
                return pos.func_177956_o();
            }
        }
        return 0;
    }

    private boolean isWallColumn(World w, BlockPos oldbottom, int topY) {
        BlockPos bottom = oldbottom;
        if (topY == 0) {
            return false;
        }
        boolean valid = true;
        while (valid && bottom.func_177956_o() < topY) {
            if (w.func_180495_p(bottom).func_177230_c().isNormalCube((IBlockAccess)w, bottom)) {
                bottom = bottom.func_177967_a(EnumFacing.UP, 1);
                continue;
            }
            valid = false;
        }
        return valid;
    }

    private List<Integer> getWalls(World w, BlockPos oldbottom, int topY) {
        BlockPos bottom = oldbottom;
        ArrayList<Integer> walls = new ArrayList<Integer>();
        if (this.isWallColumn(w, bottom = bottom.func_177963_a(0.0, 0.0, 1.0), topY)) {
            walls.add(2);
        }
        if (this.isWallColumn(w, bottom = bottom.func_177963_a(-1.0, 0.0, -1.0), topY)) {
            walls.add(4);
        }
        if (this.isWallColumn(w, bottom = bottom.func_177963_a(2.0, 0.0, 0.0), topY)) {
            walls.add(6);
        }
        if (this.isWallColumn(w, bottom = bottom.func_177963_a(-1.0, 0.0, -1.0), topY)) {
            walls.add(8);
        }
        return walls;
    }

    private boolean canLoopToCorner(World w, BlockPos pos, int backWall, int sideWall, int top) {
        int oldZ;
        int oldX;
        int x = oldX = pos.func_177958_n();
        int z = oldZ = pos.func_177952_p();
        int y = pos.func_177956_o();
        boolean stop = false;
        block4: while (!stop) {
            if (backWall == 2 || backWall == 8) {
                x = sideWall == 4 ? --x : ++x;
            } else {
                z = sideWall == 2 ? ++z : --z;
            }
            BlockPos newPos = new BlockPos(x, y, z);
            int newTop = this.getTopBlockY(w, newPos);
            List<Integer> walls = this.getWalls(w, newPos, newTop);
            switch (walls.size()) {
                case 1: {
                    if (!walls.contains(backWall)) {
                        return false;
                    }
                    if (newTop > top++ ? !this.isWallColumn(w, new BlockPos(oldX, top, oldZ), newTop) : newTop < top-- && !this.isWallColumn(w, new BlockPos(x, newTop, z), top)) {
                        return false;
                    }
                    oldX = x;
                    top = newTop;
                    oldZ = z;
                    continue block4;
                }
                case 2: {
                    if (walls.contains(backWall) && walls.contains(sideWall)) {
                        stop = true;
                        continue block4;
                    }
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    boolean isInFireplace(World w, BlockPos pos) {
        Block blockBelow = w.func_180495_p(pos.func_177967_a(EnumFacing.DOWN, 1)).func_177230_c();
        if ((blockBelow.isFlammable((IBlockAccess)w, pos, EnumFacing.UP) || blockBelow.isFireSource(w, pos, EnumFacing.UP)) && pos.func_177956_o() < 254) {
            int t = this.getTopBlockY(w, pos);
            List<Integer> walls = this.getWalls(w, pos, t);
            switch (walls.size()) {
                case 3: {
                    return true;
                }
                case 2: {
                    if (walls.contains(2) && walls.contains(4)) {
                        return this.canLoopToCorner(w, pos, 2, 6, t) || this.canLoopToCorner(w, pos, 4, 8, t);
                    }
                    if (walls.contains(2) && walls.contains(6)) {
                        return this.canLoopToCorner(w, pos, 2, 4, t) || this.canLoopToCorner(w, pos, 6, 8, t);
                    }
                    if (walls.contains(6) && walls.contains(8)) {
                        return this.canLoopToCorner(w, pos, 6, 2, t) || this.canLoopToCorner(w, pos, 8, 4, t);
                    }
                    if (!walls.contains(4) || !walls.contains(8)) break;
                    return this.canLoopToCorner(w, pos, 4, 2, t) || this.canLoopToCorner(w, pos, 8, 6, t);
                }
                case 1: {
                    switch (walls.get(0)) {
                        case 2: {
                            return this.canLoopToCorner(w, pos, 2, 4, t) && this.canLoopToCorner(w, pos, 2, 6, t);
                        }
                        case 4: {
                            return this.canLoopToCorner(w, pos, 4, 8, t) && this.canLoopToCorner(w, pos, 4, 2, t);
                        }
                        case 6: {
                            return this.canLoopToCorner(w, pos, 6, 8, t) && this.canLoopToCorner(w, pos, 6, 2, t);
                        }
                        case 8: {
                            return this.canLoopToCorner(w, pos, 8, 4, t) && this.canLoopToCorner(w, pos, 8, 6, t);
                        }
                    }
                    break;
                }
            }
        }
        return false;
    }
}

