/*
 * Decompiled with CFR 0.152.
 */
package mmmlibx.lib;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mmmlibx.lib.MMMLib;
import net.blacklab.lib.FileClassUtil;
import net.blacklab.lmmnx.util.LMMNX_DevMode;
import net.minecraftforge.fml.relauncher.FMLInjectionData;

public class FileManager {
    public static File dirMinecraft;
    public static File dirMods;
    public static File dirModsVersion;
    public static File dirDevClasses;
    public static File dirDevClassAssets;
    public static List<File> dirDevIncludeClasses;
    public static List<File> files;
    public static String minecraftDir;
    public static String assetsDir;
    public static boolean isDevdir;
    public static Map<String, List<File>> fileList;
    public static CommonClassLoaderWrapper COMMON_CLASS_LOADER;

    public static List<File> getAllmodsFiles(ClassLoader pClassLoader, boolean pFlag) {
        ArrayList<File> llist = new ArrayList<File>();
        if (pClassLoader instanceof URLClassLoader) {
            for (Serializable serializable : ((URLClassLoader)pClassLoader).getURLs()) {
                try {
                    String ls = ((URL)serializable).toString();
                    if (!ls.endsWith("/bin/") && ls.indexOf("/mods/") <= -1) continue;
                    llist.add(new File(((URL)serializable).toURI()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (pFlag) {
            if (dirMods.exists()) {
                for (Serializable serializable : dirMods.listFiles()) {
                    FileManager.addList(llist, (File)serializable);
                }
            }
            if (dirModsVersion.exists()) {
                for (Serializable serializable : dirModsVersion.listFiles()) {
                    FileManager.addList(llist, (File)serializable);
                }
            }
        }
        files = llist;
        return llist;
    }

    protected static boolean addList(List<File> pList, File pFile) {
        for (File lf : pList) {
            try {
                if (pFile.getCanonicalPath().compareTo(lf.getCanonicalPath()) != 0) continue;
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        pList.add(pFile);
        return true;
    }

    public static List<File> getModFile(String pname, String pprefix) {
        List<Object> llist;
        if (fileList.containsKey(pname)) {
            llist = fileList.get(pname);
        } else {
            llist = new ArrayList();
            fileList.put(pname, llist);
        }
        MMMLib.Debug("getModFile:[%s]:%s", pname, dirMods.getAbsolutePath());
        if (LMMNX_DevMode.DEVMODE != LMMNX_DevMode.NOT_IN_DEV) {
            llist.add(dirDevClasses);
            if (LMMNX_DevMode.DEVMODE == LMMNX_DevMode.DEVMODE_NO_IDE) {
                llist.add(dirDevClassAssets);
            }
            if (LMMNX_DevMode.DEVMODE == LMMNX_DevMode.DEVMODE_ECLIPSE) {
                for (File f : dirDevIncludeClasses) {
                    llist.add(f);
                }
            }
        }
        try {
            if (dirMods.isDirectory()) {
                MMMLib.Debug("getModFile-get:%d.", dirMods.list().length);
                for (File t : dirMods.listFiles()) {
                    if (t.getName().indexOf(pprefix) == -1) continue;
                    if (t.getName().endsWith(".zip") || t.getName().endsWith(".jar")) {
                        llist.add(t);
                        MMMLib.Debug("getModFile-file:%s", t.getName());
                        continue;
                    }
                    if (!t.isDirectory()) continue;
                    llist.add(t);
                    MMMLib.Debug("getModFile-file:%s", t.getName());
                }
                MMMLib.Debug("getModFile-files:%d", llist.size());
            } else {
                MMMLib.Debug("getModFile-fail.", new Object[0]);
            }
        }
        catch (Exception exception) {
            MMMLib.Debug("getModFile-Exception.", new Object[0]);
        }
        return llist;
    }

    public static void debugPrintAllFileList() {
        for (String key : fileList.keySet()) {
            List<File> list = fileList.get(key);
            for (File f : list) {
                System.out.println("MMMLib-AllFileList ### " + key + " : " + f.getPath());
            }
        }
    }

    public static List<File> getFileList(String pname) {
        return fileList.get(pname);
    }

    static {
        dirDevIncludeClasses = new ArrayList<File>();
        minecraftDir = "";
        assetsDir = "";
        fileList = new HashMap<String, List<File>>();
        Object[] lo = FMLInjectionData.data();
        dirMinecraft = (File)lo[6];
        minecraftDir = dirMinecraft.getPath();
        dirMods = new File(dirMinecraft, "mods");
        if (LMMNX_DevMode.DEVMODE != LMMNX_DevMode.NOT_IN_DEV) {
            String path;
            String pathd = path = FileClassUtil.getLinuxAntiDotName((String)dirMods.getAbsolutePath());
            String tail = "/eclipse/mods";
            String tail2 = "/eclipse/server/mods";
            boolean serverFlag = false;
            if (path.endsWith(tail2)) {
                path = path.substring(0, path.indexOf(tail2)) + tail;
                serverFlag = true;
            }
            if (path.endsWith(tail)) {
                if (LMMNX_DevMode.DEVMODE == LMMNX_DevMode.DEVMODE_ECLIPSE) {
                    pathd = path.substring(0, path.indexOf(tail)) + "/bin";
                } else if (LMMNX_DevMode.DEVMODE == LMMNX_DevMode.DEVMODE_NO_IDE) {
                    pathd = path.substring(0, path.indexOf(tail)) + "/build/classes/main";
                    String patha = path.substring(0, path.indexOf(tail)) + "/build/resources/main";
                    dirDevClassAssets = new File(patha);
                }
                dirDevClasses = new File(pathd);
                if (!dirDevClasses.exists() || !dirDevClasses.isDirectory()) {
                    throw new IllegalStateException("Could not get dev class path: Maybe your source codes are out of src/main/java?");
                }
                for (int i = 0; i < LMMNX_DevMode.INCLUDEPROJECT.length && !serverFlag; ++i) {
                    if (LMMNX_DevMode.DEVMODE == LMMNX_DevMode.DEVMODE_ECLIPSE) {
                        String c = FileClassUtil.getParentDir((String)path.substring(0, path.indexOf(tail))) + "/" + LMMNX_DevMode.INCLUDEPROJECT[i] + "/bin";
                        dirDevIncludeClasses.add(new File(c));
                        continue;
                    }
                    if (LMMNX_DevMode.DEVMODE != LMMNX_DevMode.DEVMODE_NO_IDE) continue;
                }
            } else {
                throw new IllegalStateException("Run Directory is incorrect: You must run at \"<PROJECT>/eclipse\"!");
            }
        }
        dirModsVersion = new File(dirMods, (String)lo[4]);
        MMMLib.Debug("init FileManager.", new Object[0]);
    }

    public static class CommonClassLoaderWrapper
    extends URLClassLoader {
        public CommonClassLoaderWrapper(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        @Override
        public void addURL(URL url) {
            super.addURL(url);
        }
    }
}

