/*
 * Decompiled with CFR 0.152.
 */
package mmmlibx.lib;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import mmmlibx.lib.FileManager;
import mmmlibx.lib.MMMLib;
import net.blacklab.lib.FileClassUtil;
import net.blacklab.lmmnx.util.LMMNX_DevMode;

public abstract class MMM_ManagerBase {
    protected abstract String getPreFix();

    protected abstract boolean append(Class var1);

    protected void load() {
        Package lpackage = MMMLib.class.getPackage();
        String ls = "";
        if (lpackage != null) {
            ls = MMMLib.class.getPackage().getName().replace('.', File.separatorChar);
        }
        if (LMMNX_DevMode.DEVMODE != LMMNX_DevMode.NOT_IN_DEV) {
            this.startSearch(FileManager.dirDevClasses, true);
            if (LMMNX_DevMode.DEVMODE == LMMNX_DevMode.DEVMODE_ECLIPSE) {
                for (File f : FileManager.dirDevIncludeClasses) {
                    this.startSearch(f, true);
                }
            }
        }
        File lf1 = new File(FileManager.dirMods, ls);
        this.startSearch(lf1, false);
    }

    private void startSearch(File root, boolean dev) {
        if (dev) {
            if (root.isDirectory()) {
                this.decodeDirectory(root, root);
            } else {
                this.decodeZip(root);
            }
            return;
        }
        for (Map.Entry<String, List<File>> le : FileManager.fileList.entrySet()) {
            for (File lf : le.getValue()) {
                if (lf.isDirectory()) {
                    this.decodeDirectory(lf, root);
                    continue;
                }
                this.decodeZip(lf);
            }
        }
    }

    private void decodeDirectory(File pfile, File pRoot) {
        for (File lf : pfile.listFiles()) {
            if (lf.isFile()) {
                String lname = lf.getName();
                if (lname.indexOf(this.getPreFix()) < 0 || !lname.endsWith(".class")) continue;
                this.loadClass(FileClassUtil.getClassName((String)FileClassUtil.getLinuxAntiDotName((String)lf.getAbsolutePath()), (String)FileClassUtil.getLinuxAntiDotName((String)pRoot.getAbsolutePath())));
                continue;
            }
            this.decodeDirectory(lf, pRoot);
        }
    }

    private void decodeZip(File pfile) {
        try {
            ZipEntry zipentry;
            FileInputStream fileinputstream = new FileInputStream(pfile);
            ZipInputStream zipinputstream = new ZipInputStream(fileinputstream);
            while ((zipentry = zipinputstream.getNextEntry()) != null) {
                String lname;
                if (zipentry.isDirectory() || (lname = zipentry.getName()).indexOf(this.getPreFix()) < 0 || !lname.endsWith(".class")) continue;
                this.loadClass(zipentry.getName());
            }
            zipinputstream.close();
            fileinputstream.close();
        }
        catch (Exception exception) {
            MMMLib.Debug("add%sZip-Exception.", this.getPreFix());
        }
    }

    private void loadClass(String pname) {
        String lclassname = "";
        try {
            Class<?> lclass;
            Package lpackage = MMMLib.class.getPackage();
            String string = lclassname = pname.endsWith(".class") ? pname.substring(0, pname.lastIndexOf(".class")) : pname;
            if (lpackage != null) {
                lclassname = lclassname.replace("/", ".");
                lclass = FileManager.COMMON_CLASS_LOADER.loadClass(lclassname);
            } else {
                lclass = Class.forName(lclassname);
            }
            if (Modifier.isAbstract(lclass.getModifiers())) {
                return;
            }
            if (this.append(lclass)) {
                MMMLib.Debug("get%sClass-done: %s", this.getPreFix(), lclassname);
            } else {
                MMMLib.Debug("get%sClass-fail: %s", this.getPreFix(), lclassname);
            }
        }
        catch (Exception exception) {
            MMMLib.Debug("get%sClass-Exception.(%s)", this.getPreFix(), lclassname);
        }
        catch (Error error) {
            MMMLib.Debug("get%sClass-Error: %s", this.getPreFix(), lclassname);
        }
    }
}

