/*
 * Decompiled with CFR 0.152.
 */
package mmmlibx.lib;

import java.util.Map;
import java.util.TreeMap;
import mmmlibx.lib.FileManager;
import mmmlibx.lib.MMM_ManagerBase;
import mmmlibx.lib.multiModel.model.mc162.EquippedStabilizer;
import mmmlibx.lib.multiModel.model.mc162.ModelBase;
import mmmlibx.lib.multiModel.model.mc162.ModelStabilizerBase;

public class MMM_StabilizerManager
extends MMM_ManagerBase {
    public static final String preFix = "ModelStabilizer";
    public static Map<String, ModelStabilizerBase> stabilizerList = new TreeMap<String, ModelStabilizerBase>();

    public static void init() {
        FileManager.getModFile("Stabilizer", preFix);
    }

    public static void loadStabilizer() {
        new MMM_StabilizerManager().load();
    }

    @Override
    protected String getPreFix() {
        return preFix;
    }

    @Override
    protected boolean append(Class pclass) {
        if (!ModelStabilizerBase.class.isAssignableFrom(pclass)) {
            return false;
        }
        try {
            ModelStabilizerBase lms = (ModelStabilizerBase)pclass.newInstance();
            stabilizerList.put(lms.getName(), lms);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static EquippedStabilizer getStabilizer(String pname, String pequippoint) {
        if (!stabilizerList.containsKey(pname)) {
            return null;
        }
        EquippedStabilizer lequip = new EquippedStabilizer();
        lequip.stabilizer = stabilizerList.get(pname);
        lequip.stabilizer.init(lequip);
        lequip.equipPointName = pequippoint;
        return lequip;
    }

    public static void updateEquippedPoint(Map<String, EquippedStabilizer> pMap, ModelBase pModel) {
        for (Map.Entry<String, EquippedStabilizer> le : pMap.entrySet()) {
            le.getValue().updateEquippedPoint(pModel);
        }
    }
}

