/*
 * Decompiled with CFR 0.152.
 */
package littleMaidMobX;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import littleMaidMobX.LMM_EntityLittleMaid;
import littleMaidMobX.LMM_LittleMaidMobNX;
import littleMaidMobX.LMM_TriggerSelect;
import mmmlibx.lib.MMM_Helper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import wrapper.W_Common;

public class LMM_IFF {
    public static final int iff_Enemy = 0;
    public static final int iff_Unknown = 1;
    public static final int iff_Friendry = 2;
    public static Map<String, Integer> DefaultIFF = new TreeMap<String, Integer>();
    public static Map<String, Map<String, Integer>> UserIFF = new HashMap<String, Map<String, Integer>>();

    public static Map<String, Integer> getUserIFF(String pUsername) {
        if (pUsername == null) {
            return DefaultIFF;
        }
        if (MMM_Helper.isLocalPlay()) {
            pUsername = "";
        }
        if (!UserIFF.containsKey(pUsername)) {
            if (pUsername.isEmpty()) {
                UserIFF.put(pUsername, DefaultIFF);
            } else {
                HashMap<String, Integer> lmap = new HashMap<String, Integer>();
                lmap.putAll(DefaultIFF);
                UserIFF.put(pUsername, lmap);
            }
        }
        return UserIFF.get(pUsername);
    }

    public static void setIFFValue(String pUsername, String pName, int pValue) {
        Map<String, Integer> lmap = LMM_IFF.getUserIFF(pUsername);
        lmap.put(pName, pValue);
    }

    protected static int checkEntityStatic(String pName, Entity pEntity, int pIndex, Map<String, Entity> pMap) {
        int liff = 1;
        if (pEntity instanceof EntityLivingBase) {
            if (pEntity instanceof LMM_EntityLittleMaid) {
                switch (pIndex) {
                    case 0: {
                        liff = 1;
                        break;
                    }
                    case 1: {
                        pName = pName + ":Contract";
                        ((LMM_EntityLittleMaid)pEntity).setContract(true);
                        liff = 2;
                        break;
                    }
                    case 2: {
                        pName = pName + ":Others";
                        ((LMM_EntityLittleMaid)pEntity).setContract(true);
                        liff = 2;
                    }
                }
            } else if (pEntity instanceof IEntityOwnable) {
                switch (pIndex) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        pName = pName + ":Taim";
                        if (pEntity instanceof EntityTameable) {
                            ((EntityTameable)pEntity).func_70903_f(true);
                        }
                        liff = 2;
                        break;
                    }
                    case 2: {
                        pName = pName + ":Others";
                        if (pEntity instanceof EntityTameable) {
                            ((EntityTameable)pEntity).func_70903_f(true);
                        }
                        liff = 1;
                    }
                }
                if (pIndex != 0 && pEntity instanceof EntityOcelot) {
                    ((EntityOcelot)pEntity).func_70912_b(1 + new Random().nextInt(3));
                }
            }
            if (pMap != null) {
                pMap.put(pName, pEntity);
                LMM_LittleMaidMobNX.Debug(pName + " added.", new Object[0]);
            }
            if (!DefaultIFF.containsKey(pName)) {
                if (pEntity instanceof IMob) {
                    liff = 0;
                }
                DefaultIFF.put(pName, liff);
            }
        }
        return liff;
    }

    public static int getIFF(String pUsername, String entityname, World world) {
        if (entityname == null) {
            return LMM_LittleMaidMobNX.cfg_Aggressive ? 0 : 2;
        }
        int lt = 0;
        Map<String, Integer> lmap = LMM_IFF.getUserIFF(pUsername);
        if (lmap.containsKey(entityname)) {
            lt = lmap.get(entityname);
        } else if (lmap != DefaultIFF && DefaultIFF.containsKey(entityname)) {
            lt = DefaultIFF.get(entityname);
            lmap.put(entityname, lt);
        } else {
            int li = entityname.indexOf(":");
            String ls = li > -1 ? entityname.substring(0, li) : entityname;
            Entity lentity = EntityList.func_75620_a((String)ls, (World)world);
            li = 0;
            if (entityname.indexOf(":Contract") > -1) {
                li = 1;
            } else if (entityname.indexOf(":Taim") > -1) {
                li = 1;
            } else if (entityname.indexOf(":Others") > -1) {
                li = 2;
            }
            lt = LMM_IFF.checkEntityStatic(ls, lentity, li, null);
            lmap.put(entityname, lt);
        }
        return lt;
    }

    public static int getIFF(String pUsername, Entity entity) {
        String loname;
        String lename;
        if (entity == null || !(entity instanceof EntityLivingBase)) {
            return LMM_LittleMaidMobNX.cfg_Aggressive ? 0 : 2;
        }
        String lcname = lename = EntityList.func_75621_b((Entity)entity);
        if (lename == null) {
            return 2;
        }
        int li = 0;
        if (entity instanceof LMM_EntityLittleMaid) {
            if (((LMM_EntityLittleMaid)entity).isContract()) {
                if (((LMM_EntityLittleMaid)entity).getMaidMaster().contentEquals(pUsername)) {
                    lcname = lename + ":Contract";
                    li = 1;
                } else {
                    lcname = lename + ":Others";
                    li = 2;
                }
            }
        } else if (entity instanceof IEntityOwnable && !(loname = W_Common.getOwnerName((IEntityOwnable)entity)).isEmpty()) {
            if (loname.contentEquals(pUsername)) {
                lcname = lename + ":Taim";
                li = 1;
            } else {
                lcname = lename + ":Others";
                li = 2;
            }
        }
        if (!LMM_IFF.getUserIFF(pUsername).containsKey(lcname)) {
            LMM_IFF.checkEntityStatic(lename, entity, li, null);
        }
        return LMM_IFF.getIFF(pUsername, lcname, entity.field_70170_p);
    }

    public static void loadIFFs() {
        if (!MMM_Helper.isClient) {
            LMM_IFF.loadIFF("");
            File lfile = MinecraftServer.func_71276_C().func_71209_f("config");
            for (File lf : lfile.listFiles()) {
                LMM_LittleMaidMobNX.Debug("FIND FILE %s", lf.getName());
                if (!lf.getName().startsWith("littleMaidMob_") || !lf.getName().endsWith(".iff")) continue;
                String ls = lf.getName().substring(14, lf.getName().length() - 4);
                LMM_LittleMaidMobNX.Debug(ls, new Object[0]);
                LMM_IFF.loadIFF(ls);
            }
        } else {
            LMM_IFF.loadIFF(null);
        }
    }

    protected static File getFile(String pUsername) {
        File lfile;
        if (pUsername == null) {
            lfile = new File(MMM_Helper.mc.field_71412_D, "config/littleMaidMob.iff");
        } else {
            String lfilename = pUsername.isEmpty() ? "config/littleMaidMob.iff" : "config/littleMaidMob_".concat(pUsername).concat(".iff");
            lfile = MinecraftServer.func_71276_C().func_71209_f(lfilename);
        }
        LMM_LittleMaidMobNX.Debug(lfile.getAbsolutePath(), new Object[0]);
        return lfile;
    }

    public static void loadIFF(String pUsername) {
        File lfile = LMM_IFF.getFile(pUsername);
        if (!lfile.exists() || !lfile.canRead()) {
            return;
        }
        Map<String, Integer> lmap = LMM_IFF.getUserIFF(pUsername);
        try {
            String s;
            FileReader fr = new FileReader(lfile);
            BufferedReader br = new BufferedReader(fr);
            while ((s = br.readLine()) != null) {
                String[] t = s.split("=");
                if (t.length <= 1) continue;
                if (t[0].startsWith("triggerWeapon")) {
                    LMM_TriggerSelect.appendTriggerItem(pUsername, t[0].substring(13), t[1]);
                    continue;
                }
                int i = Integer.valueOf(t[1]);
                if (i > 2) {
                    i = 1;
                }
                lmap.put(t[0], i);
            }
            br.close();
            fr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveIFF(String pUsername) {
        File lfile = LMM_IFF.getFile(LMM_LittleMaidMobNX.proxy.isSinglePlayer() ? null : pUsername);
        Map<String, Integer> lmap = LMM_IFF.getUserIFF(pUsername);
        try {
            if ((lfile.exists() || lfile.createNewFile()) && lfile.canWrite()) {
                FileWriter fw = new FileWriter(lfile);
                BufferedWriter bw = new BufferedWriter(fw);
                for (Map.Entry<Integer, List<Item>> entry : LMM_TriggerSelect.getUserTrigger(pUsername).entrySet()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("triggerWeapon").append(LMM_TriggerSelect.selector.get(entry.getKey())).append("=");
                    if (!entry.getValue().isEmpty()) {
                        String itemName = Item.field_150901_e.func_177774_c((Object)entry.getValue().get(0)).toString();
                        sb.append(itemName);
                        for (int i = 1; i < entry.getValue().size(); ++i) {
                            itemName = Item.field_150901_e.func_177774_c((Object)entry.getValue().get(i)).toString();
                            sb.append(",").append(itemName);
                        }
                    }
                    sb.append("\r\n");
                    bw.write(sb.toString());
                }
                for (Map.Entry<Object, Object> entry : lmap.entrySet()) {
                    bw.write(String.format("%s=%d\r\n", entry.getKey(), entry.getValue()));
                }
                bw.close();
                fw.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

