/*
 * Decompiled with CFR 0.152.
 */
package mmmlibx.lib;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mmmlibx.lib.Client;
import mmmlibx.lib.MMMLib;
import mmmlibx.lib.MMM_Helper;
import mmmlibx.lib.MMM_IItemRenderManager;
import mmmlibx.lib.MMM_ItemRenderer;
import mmmlibx.lib.MMM_ItemRendererForge;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public class MMM_ItemRenderManager {
    protected static Map<Object, MMM_ItemRenderManager> classList = new HashMap<Object, MMM_ItemRenderManager>();
    protected static List<Object> checkList = new ArrayList<Object>();
    protected static MMM_ItemRendererForge forgeRender;
    protected Random random;
    protected Object fobject;
    protected Method frenderItem;
    protected Method frenderItemInFirstPerson;
    protected Method fgetRenderTexture;
    protected Method frenderItemWorld;
    protected MMM_IItemRenderManager exRender;

    private MMM_ItemRenderManager(Object pObject, Method prenderItem, Method prenderItemInFirstPerson, Method pgetRenderTexture, Method prenderItemWorld) {
        this.fobject = pObject;
        this.exRender = null;
        this.frenderItem = prenderItem;
        this.frenderItemInFirstPerson = prenderItemInFirstPerson;
        this.fgetRenderTexture = pgetRenderTexture;
        this.frenderItemWorld = prenderItemWorld;
        this.random = new Random();
    }

    private MMM_ItemRenderManager(Object pObject, MMM_IItemRenderManager pEXRender) {
        this.fobject = pObject;
        this.exRender = pEXRender;
        this.random = new Random();
        MMM_ItemRenderManager.registerForge((Item)pObject, pEXRender);
    }

    public static void registerForge(Item pItem, MMM_IItemRenderManager pEXRender) {
        if (forgeRender == null) {
            forgeRender = new MMM_ItemRendererForge();
        }
        MinecraftForgeClient.registerItemRenderer((Item)pItem, (IItemRenderer)forgeRender);
        MMMLib.Debug("registerForge:%s", pItem.getClass().getSimpleName());
    }

    public static boolean setEXRender(Item pItem, MMM_IItemRenderManager pEXRender) {
        if (pItem == null || pEXRender == null) {
            return false;
        }
        checkList.add(pItem);
        classList.put(pItem, new MMM_ItemRenderManager(pItem, pEXRender));
        return true;
    }

    public static boolean isEXRender(Item pItem) {
        if (checkList.contains(pItem)) {
            return classList.containsKey(pItem);
        }
        checkList.add(pItem);
        Method lrenderItem = null;
        Method lrenderItemInFirstPerson = null;
        Method lgetRenderTexture = null;
        Method lrenderItemWorld = null;
        Class<?> lc = pItem.getClass();
        try {
            lrenderItem = lc.getMethod("renderItem", EntityLivingBase.class, ItemStack.class, Integer.TYPE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            lrenderItemInFirstPerson = lc.getMethod("renderItemInFirstPerson", Float.TYPE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            lgetRenderTexture = lc.getMethod("getRenderTexture", new Class[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            lrenderItemWorld = lc.getMethod("isRenderItemWorld", new Class[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (lrenderItem != null || lrenderItemInFirstPerson != null || lgetRenderTexture != null) {
            classList.put(pItem, new MMM_ItemRenderManager(pItem, lrenderItem, lrenderItemInFirstPerson, lgetRenderTexture, lrenderItemWorld));
            return true;
        }
        return false;
    }

    public static MMM_ItemRenderManager getEXRender(Item pItem) {
        return classList.get(pItem);
    }

    public void renderItemLocal(EntityLivingBase entityliving, ItemStack itemstack, ItemCameraTransforms.TransformType par3) {
        Client.setTexture(this.getRenderTexture(itemstack));
        GL11.glPushMatrix();
        boolean lflag = this.renderItem((Entity)entityliving, itemstack, par3);
        GL11.glPopMatrix();
        if (lflag) {
            if (itemstack != null && itemstack.func_77962_s() && par3 == ItemCameraTransforms.TransformType.NONE) {
                GL11.glDepthFunc((int)514);
                GL11.glDisable((int)2896);
                Client.setTexture(MMM_ItemRenderer.texGlint);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)768, (int)1);
                float var14 = 0.76f;
                GL11.glColor4f((float)(0.5f * var14), (float)(0.25f * var14), (float)(0.8f * var14), (float)1.0f);
                float var15 = 0.125f;
                GL11.glPushMatrix();
                GL11.glMatrixMode((int)5890);
                GL11.glLoadIdentity();
                GL11.glScalef((float)var15, (float)var15, (float)var15);
                float var16 = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f * 8.0f;
                GL11.glTranslatef((float)var16, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glMatrixMode((int)5888);
                this.renderItem((Entity)entityliving, itemstack, ItemCameraTransforms.TransformType.NONE);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glMatrixMode((int)5890);
                GL11.glLoadIdentity();
                GL11.glScalef((float)var15, (float)var15, (float)var15);
                var16 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f * 8.0f;
                GL11.glTranslatef((float)(-var16), (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glMatrixMode((int)5888);
                this.renderItem((Entity)entityliving, itemstack, ItemCameraTransforms.TransformType.NONE);
                GL11.glPopMatrix();
                GL11.glMatrixMode((int)5890);
                GL11.glLoadIdentity();
                GL11.glMatrixMode((int)5888);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)2896);
                GL11.glDepthFunc((int)515);
            }
            return;
        }
    }

    public boolean renderItem(Entity pEntity, ItemStack pItemstack, ItemCameraTransforms.TransformType par3) {
        if (this.exRender != null) {
            return this.exRender.renderItem(pEntity, pItemstack, par3);
        }
        if (this.frenderItem != null) {
            try {
                return (Boolean)this.frenderItem.invoke(this.fobject, pEntity, pItemstack, par3);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean renderItemInFirstPerson(Entity pEntity, ItemStack pItemStack, float pDeltaTimepRenderPhatialTick) {
        if (this.exRender != null) {
            return this.exRender.renderItemInFirstPerson((Entity)MMM_Helper.mc.field_71439_g, pItemStack, pDeltaTimepRenderPhatialTick);
        }
        if (this.frenderItemInFirstPerson != null) {
            try {
                return (Boolean)this.frenderItemInFirstPerson.invoke(this.fobject, MMM_Helper.mc.field_71439_g, pItemStack, Float.valueOf(pDeltaTimepRenderPhatialTick));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean renderItemWorld(EntityItem entityitem, double d, double d1, double d2, float f, float f1) {
        ItemStack lis = entityitem.func_92059_d();
        MMM_ItemRenderManager lirm = MMM_ItemRenderManager.getEXRender(lis.func_77973_b());
        if (!lirm.isRenderItemWorld(lis)) {
            return false;
        }
        Client.setTexture(lirm.getRenderTexture(lis));
        this.random.setSeed(187L);
        GL11.glPushMatrix();
        float f2 = MathHelper.func_76126_a((float)(((float)entityitem.lifespan + f1) / 10.0f + entityitem.field_70290_d)) * 0.1f + 0.1f;
        float f3 = (((float)entityitem.lifespan + f1) / 20.0f + entityitem.field_70290_d) * 57.29578f;
        int byte0 = 1;
        if (lis.field_77994_a > 1) {
            byte0 = 2;
        }
        if (lis.field_77994_a > 5) {
            byte0 = 3;
        }
        if (lis.field_77994_a > 20) {
            byte0 = 4;
        }
        GL11.glTranslatef((float)((float)d), (float)((float)d1 + f2), (float)((float)d2));
        GL11.glEnable((int)32826);
        GL11.glRotatef((float)f3, (float)0.0f, (float)1.0f, (float)0.0f);
        float f4 = 1.0f;
        for (int j = 0; j < byte0; ++j) {
            GL11.glPushMatrix();
            if (j > 0) {
                float f5 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.2f / f4;
                float f7 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.2f / f4;
                float f9 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.2f / f4;
                GL11.glTranslatef((float)f5, (float)f7, (float)f9);
            }
            lirm.renderItem(null, lis, ItemCameraTransforms.TransformType.NONE);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        return true;
    }

    public ResourceLocation getRenderTexture(ItemStack pItemStack) {
        if (this.exRender != null) {
            return this.exRender.getRenderTexture(pItemStack);
        }
        if (this.fgetRenderTexture != null) {
            try {
                return (ResourceLocation)this.fgetRenderTexture.invoke(this.fobject, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public boolean isRenderItemWorld(ItemStack pItemStack) {
        if (this.exRender != null) {
            return this.exRender.isRenderItemWorld(pItemStack);
        }
        if (this.frenderItemWorld != null) {
            try {
                return (Boolean)this.frenderItemWorld.invoke(this.fobject, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean isRenderItemInFirstPerson(ItemStack pItemStack) {
        if (this.exRender != null) {
            return this.exRender.isRenderItemInFirstPerson(pItemStack);
        }
        return false;
    }

    public boolean isRenderItem(ItemStack pItemStack) {
        if (this.exRender != null) {
            return this.exRender.isRenderItem(pItemStack);
        }
        return false;
    }
}

