/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.powerinventory;

import com.lothrazar.powerinventory.inventory.InventoryOverpowered;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class PlayerPersistProperty
implements IExtendedEntityProperties {
    public static final String ID = "OPI";
    public static final int EPEARL_WATCHER = 20;
    public static final int ECHEST_WATCHER = 21;
    public static final int STORAGE_COUNT = 22;
    private int epearlOpen = 0;
    private int echestOpen = 0;
    private int storageCount = 0;
    private EntityPlayer player;
    public final InventoryOverpowered inventory;

    public PlayerPersistProperty(EntityPlayer p) {
        this.player = p;
        this.inventory = new InventoryOverpowered(this.player);
        this.player.func_70096_w().func_75682_a(20, (Object)this.epearlOpen);
        this.player.func_70096_w().func_75682_a(21, (Object)this.echestOpen);
        this.player.func_70096_w().func_75682_a(22, (Object)this.storageCount);
    }

    public static void register(EntityPlayer player) {
        player.registerExtendedProperties(ID, (IExtendedEntityProperties)new PlayerPersistProperty(player));
    }

    public static PlayerPersistProperty get(EntityPlayer player) {
        IExtendedEntityProperties property = player.getExtendedProperties(ID);
        if (property != null && property instanceof PlayerPersistProperty) {
            return (PlayerPersistProperty)property;
        }
        return null;
    }

    public void init(Entity entity, World world) {
        if (entity instanceof EntityPlayer) {
            this.player = (EntityPlayer)entity;
        }
    }

    public void setEPearlUnlocked(boolean c) {
        int val = c ? 1 : 0;
        this.player.func_70096_w().func_75692_b(20, (Object)val);
    }

    public boolean isEPearlUnlocked() {
        return this.player.func_70096_w().func_75679_c(20) == 1;
    }

    public void setEChestUnlocked(boolean c) {
        int val = c ? 1 : 0;
        this.player.func_70096_w().func_75692_b(21, (Object)val);
    }

    public boolean isEChestUnlocked() {
        return this.player.func_70096_w().func_75679_c(21) == 1;
    }

    public void incrementStorage() {
        this.player.func_70096_w().func_75692_b(22, (Object)(this.getStorageCount() + 1));
    }

    public void setStorageCount(int c) {
        this.player.func_70096_w().func_75692_b(22, (Object)c);
    }

    public int getStorageCount() {
        return this.player.func_70096_w().func_75679_c(22);
    }

    public boolean hasStorage(int count) {
        return this.player.func_70096_w().func_75679_c(22) >= count;
    }

    public void loadNBTData(NBTTagCompound compound) {
        this.inventory.readFromNBT(compound);
        this.player.func_70096_w().func_75692_b(20, (Object)compound.func_74762_e("OPI20"));
        this.player.func_70096_w().func_75692_b(21, (Object)compound.func_74762_e("OPI21"));
        this.player.func_70096_w().func_75692_b(22, (Object)compound.func_74762_e("OPI22"));
    }

    public void saveNBTData(NBTTagCompound compound) {
        this.inventory.writeToNBT(compound);
        compound.func_74768_a("OPI20", this.player.func_70096_w().func_75679_c(20));
        compound.func_74768_a("OPI21", this.player.func_70096_w().func_75679_c(21));
        compound.func_74768_a("OPI22", this.player.func_70096_w().func_75679_c(22));
    }

    public static void clonePlayerData(EntityPlayer original, EntityPlayer newPlayer) {
        PlayerPersistProperty.get(newPlayer).setEChestUnlocked(PlayerPersistProperty.get(original).isEChestUnlocked());
        PlayerPersistProperty.get(newPlayer).setEPearlUnlocked(PlayerPersistProperty.get(original).isEPearlUnlocked());
        PlayerPersistProperty.get(newPlayer).setStorageCount(PlayerPersistProperty.get(original).getStorageCount());
    }
}

