/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.xlib.api.wavefrontapi;

import com.arisux.xlib.XLib;
import com.arisux.xlib.api.wavefrontapi.Part;
import com.arisux.xlib.api.wavefrontapi.WavefrontModel;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;

public class WavefrontAPI {
    private HashMap<String, WavefrontModel> modelRegistry = new HashMap();
    private static WavefrontAPI instance = new WavefrontAPI();

    public static WavefrontAPI instance() {
        return instance;
    }

    public WavefrontModel loadModel(Class<?> c, String modid, String model, String assetsPath) {
        File baseDir = new File(WavefrontAPI.getModelsDirectory(), String.format("%s/", modid));
        File path = new File(baseDir, model);
        if (!WavefrontAPI.getModelsDirectory().exists()) {
            WavefrontAPI.getModelsDirectory().mkdirs();
        }
        if (!baseDir.exists()) {
            baseDir.mkdirs();
        }
        try {
            URL urlOBJ = c.getResource(assetsPath + ".obj");
            File fileOBJ = new File(path.getAbsolutePath() + ".obj");
            URL urlMTL = c.getResource(assetsPath + ".mtl");
            File fileMTL = new File(path.getAbsolutePath() + ".mtl");
            if (!fileOBJ.exists()) {
                FileUtils.copyURLToFile((URL)urlOBJ, (File)fileOBJ);
                XLib.logger().info("Extracted wavefront model: %s", fileOBJ.getAbsoluteFile().getPath());
            }
            if (!fileMTL.exists()) {
                FileUtils.copyURLToFile((URL)urlMTL, (File)fileMTL);
                XLib.logger().info("Extracted wavefront texture: %s", fileMTL.getAbsoluteFile().getPath());
            }
        }
        catch (Exception e) {
            XLib.logger().info("Error while extracting %s from %s: %s", path, assetsPath, e);
            e.printStackTrace();
        }
        return this.loadModel(modid, path);
    }

    public WavefrontModel loadModel(String modid, File path) {
        WavefrontModel model = new WavefrontModel();
        if (model.load(modid, path.getAbsolutePath())) {
            String tag = path.getAbsolutePath().replaceAll(".obj", "").replaceAll(".OBJ", "");
            tag = tag.substring(tag.lastIndexOf(47) + 1, tag.length());
            this.modelRegistry.put(tag, model);
            XLib.logger().info("[WavefrontAPI] Loaded wavefront model: " + path, new Object[0]);
        } else {
            XLib.logger().info("[WavefrontAPI] Unable to load wavefront model: " + path, new Object[0]);
        }
        return model;
    }

    public static WavefrontModel getModel(String modelName) {
        return WavefrontAPI.instance().modelRegistry.get(modelName);
    }

    public static Part getPart(String modelName, String partName) {
        WavefrontModel model = WavefrontAPI.getModel(modelName);
        return model != null ? model.getPart(partName) : null;
    }

    public static boolean renderPart(String modelName, String partName) {
        Part part = WavefrontAPI.getPart(modelName, partName);
        if (part != null) {
            part.draw();
            return true;
        }
        return false;
    }

    public HashMap<String, WavefrontModel> getModelRegistry() {
        return this.modelRegistry;
    }

    public static File getModelsDirectory() {
        return new File("models");
    }
}

