/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.xlib.api.wavefrontapi;

import com.arisux.xlib.XLib;
import com.arisux.xlib.api.wavefrontapi.Face;
import com.arisux.xlib.api.wavefrontapi.FaceGroup;
import com.arisux.xlib.api.wavefrontapi.Part;
import com.arisux.xlib.client.render.Color;
import com.arisux.xlib.client.render.Normal;
import com.arisux.xlib.client.render.UV;
import com.arisux.xlib.client.render.Vertex;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import net.minecraft.util.ResourceLocation;

public class WavefrontModel {
    private String pathName;
    private String mtlName;
    private String modid;
    private String directory;
    public ArrayList<Vertex> vertex = new ArrayList();
    public ArrayList<UV> uv = new ArrayList();
    public Hashtable<String, String> nameToStringHash = new Hashtable();
    public Hashtable<String, Part> nameToPartHash = new Hashtable();
    public float xDim;
    public float yDim;
    public float zDim;
    public float xMin;
    public float yMin;
    public float zMin;
    public float xMax;
    public float yMax;
    public float zMax;
    public float dimMax;
    public float dimMaxInv;

    public ResourceLocation getAlternativeTexture(String name) {
        ResourceLocation resource = new ResourceLocation(this.modid, this.directory.substring(1) + name);
        return resource;
    }

    public boolean load(String modid, String path) {
        File fileModel = new File(path + ".obj");
        File fileTexture = new File(path + ".mtl");
        File fileOrigins = new File(path + ".ori");
        int lastSlashId = path.lastIndexOf(47);
        this.modid = modid;
        this.directory = path.substring(0, lastSlashId + 1);
        this.pathName = path.substring(lastSlashId + 1, path.length());
        Part part = null;
        FaceGroup fg = null;
        try {
            this.loadOBJ(fileModel, path, part, fg);
            part = null;
            this.loadMTL(fileTexture, path);
            part = null;
        }
        catch (Exception e) {
            XLib.logger().warning("[WavefrontAPI] Error loading model for mod with id %s: %s", modid, path);
            e.printStackTrace();
            return false;
        }
        try {
            this.loadORI(fileOrigins, part);
        }
        catch (Exception e) {
            XLib.logger().warning("[WavefrontAPI] Error (%s) loading origins for model for mod with id %s: %s", e, modid, path);
        }
        this.xDim = this.xMax - this.xMin;
        this.yDim = this.yMax - this.yMin;
        this.zDim = this.zMax - this.zMin;
        this.dimMax = Math.max(Math.max(this.xMax, this.yMax), this.zMax);
        this.dimMaxInv = 1.0f / this.dimMax;
        XLib.logger().info("[WavefrontAPI] Loaded wavefront model for mod with id %s: %s", this.modid, this.pathName);
        return true;
    }

    private boolean loadOBJ(File fileModel, String path, Part part, FaceGroup fg) throws Exception {
        String line;
        FileInputStream stream = new FileInputStream(fileModel);
        if (stream == null || fileModel == null || path == null) {
            XLib.logger().bug("OBJ Loading Failed: " + path, new Object[0]);
            ((InputStream)stream).close();
            return false;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)stream, "UTF-8"));
        while ((line = bufferedReader.readLine()) != null) {
            String[] words = line.split(" ");
            String command = words[0];
            if (command.equals("o")) {
                part = new Part(this.vertex, this.uv);
                this.nameToPartHash.put(words[1], part);
                continue;
            }
            if (command.equals("v")) {
                Vertex v = new Vertex(Float.parseFloat(words[1]), Float.parseFloat(words[2]), Float.parseFloat(words[3]));
                part.addVertex(v);
                this.xMin = Math.min(this.xMin, v.x);
                this.yMin = Math.min(this.yMin, v.y);
                this.zMin = Math.min(this.zMin, v.z);
                this.xMax = Math.max(this.xMax, v.x);
                this.yMax = Math.max(this.yMax, v.y);
                this.zMax = Math.max(this.zMax, v.z);
                continue;
            }
            if (command.equals("vt")) {
                part.getUV().add(new UV(Float.parseFloat(words[1]), 1.0f - Float.parseFloat(words[2])));
                continue;
            }
            if (command.equals("f")) {
                int vertexNbr = words.length - 1;
                if (vertexNbr != 3) continue;
                Vertex[] verticeId = new Vertex[vertexNbr];
                UV[] uvId = new UV[vertexNbr];
                for (int idx = 0; idx < vertexNbr; ++idx) {
                    String[] id = words[idx + 1].split("/");
                    verticeId[idx] = part.getVertices().get(Integer.parseInt(id[0]) - 1);
                    uvId[idx] = id.length > 1 && !id[1].equals("") ? part.getUV().get(Integer.parseInt(id[1]) - 1) : null;
                }
                fg.faces.add(new Face(verticeId, uvId, new Normal(verticeId[0], verticeId[1], verticeId[2])));
                continue;
            }
            if (command.equals("mtllib")) {
                this.mtlName = words[1];
                continue;
            }
            if (!command.equals("usemtl")) continue;
            fg = new FaceGroup();
            fg.mtlName = words[1];
            if (part == null || part.faceGroup == null) continue;
            part.faceGroup.add(fg);
        }
        bufferedReader.close();
        return true;
    }

    private boolean loadMTL(File fileTexture, String path) throws Exception {
        String line;
        FileInputStream stream = new FileInputStream(fileTexture);
        System.out.println("Loading MTL: " + fileTexture);
        if (stream == null || fileTexture == null || path == null) {
            XLib.logger().bug("MTL Loading failed: " + path, new Object[0]);
            ((InputStream)stream).close();
            return false;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)stream, "UTF-8"));
        String mtlName = "";
        while ((line = bufferedReader.readLine()) != null) {
            String[] words = line.split(" ");
            String command = words[0];
            if (command.equals("newmtl")) {
                mtlName = words[1];
                continue;
            }
            if (command.equals("map_Kd")) {
                for (Part partPtr : this.nameToPartHash.values()) {
                    for (FaceGroup faceGroup : partPtr.faceGroup) {
                        if (faceGroup.mtlName == null || !faceGroup.mtlName.equals(mtlName)) continue;
                        faceGroup.resource = new ResourceLocation(this.modid, "models/" + this.directory + words[1]);
                    }
                }
                continue;
            }
            if (!command.equals("Kd")) continue;
            for (Part partPtr : this.nameToPartHash.values()) {
                for (FaceGroup faceGroup : partPtr.faceGroup) {
                    if (faceGroup.mtlName == null || !faceGroup.mtlName.equals(mtlName)) continue;
                    faceGroup.color = new Color(Float.parseFloat(words[1]), Float.parseFloat(words[2]), Float.parseFloat(words[3]), 1.0f);
                }
            }
        }
        bufferedReader.close();
        return true;
    }

    private void loadORI(File fileOrigins, Part part) throws Exception {
        FileInputStream stream = new FileInputStream(fileOrigins);
        if (stream != null) {
            String line;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)stream, "UTF-8"));
            while ((line = bufferedReader.readLine()) != null) {
                String[] words = line.split(" ");
                String command = words[0];
                if (command.equals("o")) {
                    part = this.nameToPartHash.get(words[1]);
                    continue;
                }
                if (command.equals("f")) {
                    String key = words[1];
                    float value = Float.valueOf(words[2]).floatValue();
                    if (key.equals("originX")) {
                        part.setOriginX(value);
                        continue;
                    }
                    if (key.equals("originY")) {
                        part.setOriginY(value);
                        continue;
                    }
                    if (key.equals("originZ")) {
                        part.setOriginZ(value);
                        continue;
                    }
                    if (key.equals("originX2")) {
                        part.setOriginX2(value);
                        continue;
                    }
                    if (key.equals("originY2")) {
                        part.setOriginY2(value);
                        continue;
                    }
                    if (key.equals("originZ2")) {
                        part.setOriginZ2(value);
                        continue;
                    }
                    part.nameToFloatHash.put(key, Float.valueOf(value));
                    continue;
                }
                if (!command.equals("s")) continue;
                this.nameToStringHash.put(words[1], words[2]);
            }
            bufferedReader.close();
        }
    }

    public void draw(String part) {
        Part partPtr = this.getPart(part);
        if (partPtr != null) {
            partPtr.draw();
        }
    }

    public Part getPart(String part) {
        return this.nameToPartHash.get(part);
    }

    public String getString(String name) {
        return this.nameToStringHash.get(name);
    }

    public String getMtlName() {
        return this.mtlName;
    }
}

