/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.xlib.client.render;

import com.arisux.xlib.XLib;
import com.arisux.xlib.client.render.Color;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class XLibRenderer {
    public static ArrayList<Framebuffer> frameBuffers = new ArrayList();

    public static Tessellator tessellator() {
        return Tessellator.func_178181_a();
    }

    public static TextureManager textureManager() {
        return XLib.game().func_110434_K();
    }

    public static WorldRenderer worldRenderer() {
        return XLibRenderer.tessellator().func_178180_c();
    }

    public static void translate(float x, float y, float z) {
        GlStateManager.func_179109_b((float)x, (float)y, (float)z);
    }

    public static void translate(double x, double y, double z) {
        XLibRenderer.translate((float)x, (float)y, (float)z);
    }

    public static void pushMatrix() {
        GlStateManager.func_179094_E();
    }

    public static void popMatrix() {
        GlStateManager.func_179121_F();
    }

    public static void scale(int x, int y, int z) {
        GlStateManager.func_179152_a((float)x, (float)y, (float)z);
    }

    public static void copyDownsizedRender(TextureManager manager, ResourceLocation renderTo, int x, int y, int w, int h, int index) {
        ITextureObject textureObject = manager.func_110581_b(renderTo);
        if (textureObject != null) {
            GL11.glBindTexture((int)3553, (int)textureObject.func_110552_b());
            GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)index, (int)index, (int)x, (int)y, (int)w, (int)h);
        }
    }

    public static Framebuffer bufferAdd(int width, int height, boolean useDepth) {
        Framebuffer render = new Framebuffer(width, height, useDepth);
        frameBuffers.add(render);
        return render;
    }

    public static void bufferClear(Framebuffer buffer) {
        GL11.glEnable((int)2929);
        if (buffer.field_147616_f >= 0) {
            buffer.func_147608_a();
        }
        frameBuffers.remove(buffer);
    }

    public static void lightmapDisable() {
        int c0 = 61680;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)1, (int)1);
        GL11.glDepthMask((boolean)true);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)c0 % 65536.0f / 1.0f), (float)((float)c0 / 65536.0f / 1.0f));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void lightmapEnable() {
        int c0 = 61680;
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)c0 % 65536.0f / 1.0f), (float)((float)c0 / 65536.0f / 1.0f));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void lightDisable() {
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        if (GL11.glGetBoolean((int)3553)) {
            GL11.glDisable((int)3553);
        }
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
        GL11.glDisable((int)2896);
    }

    public static void lightEnable() {
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        if (GL11.glGetBoolean((int)3553)) {
            GL11.glEnable((int)3553);
        }
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
        GL11.glEnable((int)2896);
    }

    public static void blendClear() {
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
    }

    public static void antiAlias2D() {
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
    }

    public static int getTexID(ResourceLocation resource) {
        ITextureObject object = XLib.game().func_110434_K().func_110581_b(resource);
        object = object == null ? new SimpleTexture(resource) : object;
        return object.func_110552_b();
    }

    public static void colorHex4(int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
    }

    public static void colorHex3(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GL11.glColor3f((float)r, (float)g, (float)b);
    }

    public static int createHexColor(int a, int r, int g, int b) {
        Color color = new Color(a, r, g, b);
        ByteBuffer buf = ByteBuffer.allocate(4);
        color.writeRGBA(buf);
        buf.rewind();
        return buf.getInt();
    }

    public static void bindResource(ResourceLocation resource) {
        XLibRenderer.textureManager().func_110577_a(resource);
    }

    public ITextureObject getTextureObject(ResourceLocation resource) {
        return XLibRenderer.textureManager().func_110581_b(resource);
    }

    public static void drawQuadColored(int x, int y, int w, int h, int color) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        XLibRenderer.colorHex4(color);
        XLibRenderer.drawQuad(x, y, w, h);
        XLibRenderer.colorHex4(-1);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawQuadRelative(int x, int y, int w, int h) {
        XLibRenderer.drawQuadRelative(x, y, x + w, y + h, 0);
    }

    public static void drawQuadRelative(int x, int y, int w, int h, int z) {
        XLibRenderer.drawQuad(x, y, x + w, y + h, z, 0.0f, 1.0f, 0.0f, 1.0f);
    }

    public static void drawQuad(int x1, int y1, int x2, int y2) {
        XLibRenderer.drawQuad(x1, y1, x2, y2, 0);
    }

    public static void drawQuad(int x1, int y1, int x2, int y2, int z) {
        XLibRenderer.drawQuad(x1, y1, x2, y2, z, 0.0f, 1.0f, 0.0f, 1.0f);
    }

    public static void drawQuad(int x1, int y1, int x2, int y2, int z, float minU, float maxU, float minV, float maxV) {
        XLibRenderer.worldRenderer().func_178970_b();
        XLibRenderer.worldRenderer().func_178985_a((double)x1, (double)y2, (double)z, (double)minU, (double)maxV);
        XLibRenderer.worldRenderer().func_178985_a((double)x2, (double)y2, (double)z, (double)maxU, (double)maxV);
        XLibRenderer.worldRenderer().func_178985_a((double)x2, (double)y1, (double)z, (double)maxU, (double)minV);
        XLibRenderer.worldRenderer().func_178985_a((double)x1, (double)y1, (double)z, (double)minU, (double)minV);
        XLibRenderer.tessellator().func_78381_a();
    }

    public static void bindTexture(ResourceLocation resource) {
        XLib.game().field_71446_o.func_110577_a(resource);
    }
}

