/*
 * Decompiled with CFR 0.152.
 */
package halocraft.entities.render;

import com.google.common.base.Function;
import halocraft.entities.EntityRocket;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.TRSRTransformation;
import net.minecraftforge.client.model.b3d.B3DLoader;
import org.lwjgl.opengl.GL11;

public class RenderRocketEntity
extends Render {
    private static final ResourceLocation rocketTextures = new ResourceLocation("halocraft:textures/entities/RocketRender.png");
    private static final ModelResourceLocation rocketModelFile = new ModelResourceLocation("halocraft:models/entity/Rocket.b3d");
    Function<ResourceLocation, TextureAtlasSprite> textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

        public TextureAtlasSprite apply(ResourceLocation location) {
            return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
        }
    };

    public RenderRocketEntity(RenderManager rendermanager) {
        super(rendermanager);
        this.field_76989_e = 0.5f;
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return rocketTextures;
    }

    public void render(EntityRocket rocket, double d, double d1, double d2, float f, float f1) {
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        if (rocket.field_70173_aa < 1) {
            return;
        }
        this.func_180548_c((Entity)rocket);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)d), (float)((float)d1), (float)((float)d2));
        GL11.glRotatef((float)rocket.field_70177_z, (float)0.0f, (float)1.0f, (float)0.0f);
        IModel rocketModel = null;
        try {
            rocketModel = B3DLoader.instance.loadModel((ResourceLocation)rocketModelFile);
        }
        catch (IOException e) {
            rocketModel = ModelLoaderRegistry.getMissingModel();
            e.printStackTrace();
        }
        IFlexibleBakedModel bakedRocket = rocketModel.bake((IModelState)TRSRTransformation.identity(), Attributes.DEFAULT_BAKED_FORMAT, this.textureGetter);
        worldrenderer.func_178970_b();
        List generalQuads = bakedRocket.func_177550_a();
        for (BakedQuad q : generalQuads) {
            int[] vd = q.func_178209_a();
            worldrenderer.func_178967_a(Attributes.DEFAULT_BAKED_FORMAT);
            worldrenderer.func_178981_a(vd);
        }
        for (EnumFacing face : EnumFacing.values()) {
            List faceQuads = bakedRocket.func_177551_a(face);
            for (BakedQuad q : faceQuads) {
                int[] vd = q.func_178209_a();
                worldrenderer.func_178967_a(Attributes.DEFAULT_BAKED_FORMAT);
                worldrenderer.func_178981_a(vd);
            }
        }
        tessellator.func_78381_a();
        GL11.glPopMatrix();
    }

    public void func_76986_a(Entity entity, double d, double d1, double d2, float f, float f1) {
        this.render((EntityRocket)entity, d, d1, d2, f, f1);
    }
}

